/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.RecordSetFactory;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.services.mapping.LatLonPlacemarkIFace;
import edu.ku.brc.services.mapping.LatLonPoint;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.ui.ClickAndGoSelectListener;
import edu.ku.brc.specify.ui.WorldWindPanel;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.examples.LineBuilder;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.MarkerLayer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.markers.BasicMarker;
import gov.nasa.worldwind.util.GeometryMath;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WorldWindSearchPanel
extends JPanel {
    protected static final int[] TABLE_IDS = new int[]{CollectionObject.getClassTableId(), Locality.getClassTableId(), CollectingEvent.getClassTableId(), Taxon.getClassTableId()};
    protected static final int MAP_WIDTH = 500;
    protected static final int MAP_HEIGHT = 500;
    protected static DBTableInfo[] TABLE_INFO;
    protected WorldWindPanel wwPanel;
    protected Vector<LatLonPoint> availPoints = new Vector();
    protected Vector<LatLonPoint> selectedPoints = new Vector();
    protected Vector<Position> containedWWPoints = new Vector();
    protected List<Position> polygonWWPoints = new Vector<Position>();
    protected HashSet<Integer> topIdHash = new HashSet();
    protected HashSet<Integer> botIdHash = new HashSet();
    protected JLabel topLbl;
    protected JList dbObjList;
    protected JList recSetList;
    protected JComboBox typeCBX;
    protected JButton searchBtn;
    protected JButton startBtn;
    protected JButton endBtn;
    protected JButton clearBtn;
    protected JButton dwnBtn;
    protected JButton upBtn;
    protected JButton selectAllBtn;
    protected JButton deselectAllBtn;
    protected JButton rsBtn;
    protected JButton fmBtn;
    protected boolean isCreatingPolygon = false;
    protected Point prevPoint = null;
    protected Position lastClickPos = null;
    protected LineBuilder lineBuilder;
    protected RenderableLayer lineLayer;
    protected Polyline polyline = new Polyline();

    public WorldWindSearchPanel() {
        TABLE_INFO = new DBTableInfo[TABLE_IDS.length];
        int i = 0;
        while (i < TABLE_IDS.length) {
            WorldWindSearchPanel.TABLE_INFO[i] = DBTableIdMgr.getInstance().getInfoById(TABLE_IDS[i]);
            ++i;
        }
        this.createUI();
    }

    protected void createUI() {
        CellConstraints cc = new CellConstraints();
        this.lineLayer = new RenderableLayer();
        this.upBtn = UIHelper.createIconBtn("Green Arrow Up", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldWindSearchPanel.this.moveItems(WorldWindSearchPanel.this.recSetList, WorldWindSearchPanel.this.botIdHash, WorldWindSearchPanel.this.dbObjList, WorldWindSearchPanel.this.topIdHash);
            }
        });
        this.dwnBtn = UIHelper.createIconBtn("Green Arrow Down", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldWindSearchPanel.this.moveItems(WorldWindSearchPanel.this.dbObjList, WorldWindSearchPanel.this.topIdHash, WorldWindSearchPanel.this.recSetList, WorldWindSearchPanel.this.botIdHash);
                boolean hasItems = WorldWindSearchPanel.this.recSetList.getModel().getSize() > 0;
                WorldWindSearchPanel.this.rsBtn.setEnabled(hasItems);
                WorldWindSearchPanel.this.fmBtn.setEnabled(hasItems);
            }
        });
        this.selectAllBtn = UIHelper.createI18NButton("SELECTALL");
        this.selectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldWindSearchPanel.this.dbObjList.clearSelection();
                WorldWindSearchPanel.this.dbObjList.getSelectionModel().setSelectionInterval(0, WorldWindSearchPanel.this.dbObjList.getModel().getSize());
            }
        });
        this.deselectAllBtn = UIHelper.createI18NButton("DESELECTALL");
        this.deselectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldWindSearchPanel.this.dbObjList.clearSelection();
            }
        });
        PanelBuilder upDwnPB = new PanelBuilder(new FormLayout("f:p:g,p,f:p:g,p,10px,p,f:p:g,p,f:p:g", "p"));
        upDwnPB.add((Component)this.dwnBtn, cc.xy(4, 1));
        upDwnPB.add((Component)this.upBtn, cc.xy(6, 1));
        this.dbObjList = new JList(new DefaultListModel());
        this.dbObjList.getSelectionModel().setSelectionMode(2);
        this.dbObjList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                WorldWindSearchPanel.this.upBtn.setEnabled(false);
                WorldWindSearchPanel.this.dwnBtn.setEnabled(WorldWindSearchPanel.this.dbObjList.getSelectedIndex() != -1);
            }
        });
        this.recSetList = new JList(new DefaultListModel());
        this.recSetList.getSelectionModel().setSelectionMode(2);
        this.recSetList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean isSel = WorldWindSearchPanel.this.recSetList.getSelectedIndex() != -1;
                WorldWindSearchPanel.this.dwnBtn.setEnabled(false);
                WorldWindSearchPanel.this.upBtn.setEnabled(isSel);
            }
        });
        this.rsBtn = UIHelper.createIconBtn("Record_Set", IconManager.IconSize.Std24, "", null);
        this.fmBtn = UIHelper.createIconBtn("FormEdit", IconManager.IconSize.Std24, "", null);
        PanelBuilder toolsBtnPB = new PanelBuilder(new FormLayout("f:p:g,2px,p,2px,p", "p"));
        toolsBtnPB.add((Component)this.fmBtn, cc.xy(3, 1));
        toolsBtnPB.add((Component)this.rsBtn, cc.xy(5, 1));
        PanelBuilder leftPB = new PanelBuilder(new FormLayout("min(p;250px),10px,f:p:g", "p,2px,f:p:g, 4px,p,4px, p,2px,f:p:g, 2px,p"));
        int y = 1;
        this.topLbl = UIHelper.createLabel("Available Points");
        leftPB.add((Component)this.topLbl, cc.xy(1, y));
        leftPB.add((Component)UIHelper.createScrollPane(this.dbObjList, true), cc.xy(1, y += 2));
        leftPB.add((Component)upDwnPB.getPanel(), cc.xy(1, y += 2));
        leftPB.add((Component)UIHelper.createLabel("Selected Objects"), cc.xy(1, y += 2));
        leftPB.add((Component)UIHelper.createScrollPane(this.recSetList, true), cc.xy(1, y += 2));
        leftPB.add((Component)toolsBtnPB.getPanel(), cc.xy(1, y += 2));
        y += 2;
        this.wwPanel = new WorldWindPanel();
        this.wwPanel.setPreferredSize(new Dimension(500, 500));
        this.wwPanel.getWorld().addSelectListener((SelectListener)new ClickAndGoSelectListener((WorldWindow)this.wwPanel.getWorld(), MarkerLayer.class));
        this.wwPanel.getWorld().addSelectListener(this.getWWSelectListener());
        this.wwPanel.getWorld().getInputHandler().addMouseListener((MouseListener)this.getWWMouseAdapter());
        PanelBuilder rightPB = new PanelBuilder(new FormLayout("f:p:g", "f:p:g"));
        this.lineBuilder = new LineBuilder((WorldWindow)this.wwPanel.getWorld(), this.lineLayer, this.polyline);
        rightPB.add((Component)this.wwPanel, cc.xy(1, 1));
        y += 2;
        this.polyline.setAntiAliasHint(4354);
        this.polyline.setLineWidth(1.5);
        this.polyline.setFollowTerrain(true);
        this.startBtn = UIHelper.createI18NButton("Start");
        this.endBtn = UIHelper.createI18NButton("End");
        this.searchBtn = UIHelper.createI18NButton("SEARCH");
        this.clearBtn = UIHelper.createI18NButton("Clear");
        this.typeCBX = UIHelper.createComboBox(TABLE_INFO);
        PanelBuilder btnPB = new PanelBuilder(new FormLayout("f:p:g,p,f:p:g,p,f:p:g,p,f:p:g,p,f:p:g,p,f:p:g", "p"));
        btnPB.add((Component)this.typeCBX, cc.xy(2, 1));
        btnPB.add((Component)this.startBtn, cc.xy(4, 1));
        btnPB.add((Component)this.endBtn, cc.xy(6, 1));
        btnPB.add((Component)this.searchBtn, cc.xy(8, 1));
        btnPB.add((Component)this.clearBtn, cc.xy(10, 1));
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,10px,f:p:g", "f:p:g, 4px, p"), (JPanel)this);
        pb.add((Component)leftPB.getPanel(), cc.xy(1, 1));
        pb.add((Component)rightPB.getPanel(), cc.xy(3, 1));
        pb.add((Component)btnPB.getPanel(), cc.xyw(1, 3, 3));
        pb.setDefaultDialogBorder();
        this.startBtn.setEnabled(true);
        this.endBtn.setEnabled(false);
        this.searchBtn.setEnabled(false);
        this.clearBtn.setEnabled(false);
        this.rsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordSetIFace rs = WorldWindSearchPanel.this.createRecordSet();
                if (rs != null) {
                    CommandDispatcher.dispatch(new CommandAction("Record_Set", "Save", null, null, rs));
                }
            }
        });
        this.fmBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordSetIFace rs = WorldWindSearchPanel.this.createRecordSet();
                if (rs != null) {
                    CommandDispatcher.dispatch(new CommandAction("Data_Entry", "Edit", rs));
                }
            }
        });
        this.searchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldWindSearchPanel.this.doSearch();
            }
        });
        this.startBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldWindSearchPanel.this.polygonWWPoints.clear();
                WorldWindSearchPanel.this.isCreatingPolygon = true;
                WorldWindSearchPanel.this.searchBtn.setEnabled(false);
                WorldWindSearchPanel.this.endBtn.setEnabled(true);
                WorldWindSearchPanel.this.startBtn.setEnabled(false);
                WorldWindSearchPanel.this.lineBuilder.setArmed(true);
            }
        });
        this.endBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldWindSearchPanel.this.polyline.setClosed(true);
                WorldWindSearchPanel.this.isCreatingPolygon = false;
                WorldWindSearchPanel.this.searchBtn.setEnabled(true);
                WorldWindSearchPanel.this.endBtn.setEnabled(false);
                WorldWindSearchPanel.this.startBtn.setEnabled(false);
                WorldWindSearchPanel.this.searchBtn.setEnabled(true);
                WorldWindSearchPanel.this.clearBtn.setEnabled(true);
                WorldWindSearchPanel.this.lineBuilder.setArmed(false);
            }
        });
        this.clearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldWindSearchPanel.this.doClear(true);
            }
        });
        this.typeCBX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldWindSearchPanel.this.doPickedNewObjType();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WorldWindSearchPanel.this.typeCBX.setSelectedIndex(0);
            }
        });
    }

    private RecordSetIFace createRecordSet() {
        RecordSetIFace rs = null;
        DefaultListModel model = (DefaultListModel)this.recSetList.getModel();
        if (model.getSize() > 0) {
            rs = RecordSetFactory.getInstance().createRecordSet();
            rs.setDbTableId(TABLE_IDS[this.typeCBX.getSelectedIndex()]);
            int i = 0;
            while (i < model.getSize()) {
                LatLonPoint llp = (LatLonPoint)model.get(i);
                rs.addItem(llp.getLocId());
                ++i;
            }
        }
        return rs;
    }

    private void moveItems(JList srcList, HashSet<Integer> srcHash, JList dstList, HashSet<Integer> dstHash) {
        int inx = srcList.getSelectedIndex();
        if (inx > -1) {
            DefaultListModel srcModel = (DefaultListModel)srcList.getModel();
            DefaultListModel dstModel = (DefaultListModel)dstList.getModel();
            int[] indexes = srcList.getSelectedIndices();
            ArrayList<LatLonPoint> llpList = new ArrayList<LatLonPoint>(indexes.length);
            int[] nArray = indexes;
            int n = indexes.length;
            int n2 = 0;
            while (n2 < n) {
                int selInx = nArray[n2];
                LatLonPoint llp = (LatLonPoint)srcModel.get(selInx);
                llpList.add(llp);
                if (!dstHash.contains(llp.getLocId())) {
                    dstModel.addElement(llp);
                    dstHash.add(llp.getLocId());
                }
                ++n2;
            }
            for (LatLonPoint llp : llpList) {
                srcModel.removeElement(llp);
                srcHash.remove(llp.getLocId());
            }
        }
    }

    private void doClear(boolean doClearPolygon) {
        if (doClearPolygon) {
            LayerList layers = this.wwPanel.getWorld().getModel().getLayers();
            int inx = layers.indexOf((Object)this.lineLayer);
            layers.remove(inx);
        }
        this.wwPanel.getMarkerLayer().clearList();
        this.wwPanel.getWorld().redrawNow();
        this.wwPanel.reset();
        if (doClearPolygon) {
            this.polyline = new Polyline();
            this.polyline.setAntiAliasHint(4354);
            this.polyline.setLineWidth(1.5);
            this.polyline.setFollowTerrain(true);
            this.lineLayer = new RenderableLayer();
            this.lineBuilder = new LineBuilder((WorldWindow)this.wwPanel.getWorld(), this.lineLayer, this.polyline);
        }
        ((DefaultListModel)this.dbObjList.getModel()).removeAllElements();
        this.topIdHash.clear();
        this.clearBtn.setEnabled(false);
        this.startBtn.setEnabled(true);
    }

    private void doPickedNewObjType() {
        boolean hadItems = this.dbObjList.getModel().getSize() > 0;
        this.doClear(false);
        this.topLbl.setText(this.typeCBX.getSelectedItem().toString());
        DefaultListModel model = (DefaultListModel)this.recSetList.getModel();
        model.removeAllElements();
        this.botIdHash.clear();
        this.rsBtn.setEnabled(false);
        this.fmBtn.setEnabled(false);
        if (hadItems) {
            this.searchBtn.setEnabled(true);
            this.startBtn.setEnabled(false);
        }
    }

    private void doSearch() {
        double topMin = Double.MAX_VALUE;
        double topMax = Double.MIN_VALUE;
        double botMin = Double.MAX_VALUE;
        double botMax = -1000.0;
        ArrayList<Position> pntList = new ArrayList<Position>();
        for (Position p : this.polyline.getPositions()) {
            double lat = p.getLatitude().getDegrees();
            double lon = p.getLongitude().getDegrees();
            if (lat <= topMin) {
                topMin = lat;
            }
            if (lat >= topMax) {
                topMax = lat;
            }
            if (lon <= botMin) {
                botMin = lon;
            }
            if (lon >= botMax) {
                botMax = lon;
            }
            pntList.add(p);
        }
        String orderBy = null;
        StringBuilder sb = new StringBuilder();
        switch (this.typeCBX.getSelectedIndex()) {
            case 0: {
                sb.append(this.doColObjSearchSQL());
                orderBy = "CatalogNumber";
                break;
            }
            case 1: {
                sb.append(this.getLocalitySearchSQL());
                orderBy = "LocalityName";
                break;
            }
            case 2: {
                sb.append(this.doCollEventSearchSQL());
                orderBy = "StartDate";
                break;
            }
            case 3: {
                sb.append(this.doTaxonSearchSQL());
                orderBy = "FullName";
            }
        }
        String whereSQL = " Latitude1 >= %10.5f AND Latitude1 <= %10.5f AND Longitude1 >= %10.5f AND Longitude1 <= %10.5f";
        sb.append(String.format(whereSQL, topMin, topMax, botMin, botMax));
        sb.append(orderBy != null ? " ORDER BY " + orderBy : "");
        this.availPoints.clear();
        DefaultListModel model = (DefaultListModel)this.dbObjList.getModel();
        model.removeAllElements();
        this.topIdHash.clear();
        Vector<LatLonPlacemarkIFace> markers = new Vector<LatLonPlacemarkIFace>();
        pntList.add((Position)pntList.get(0));
        Polyline polygon = new Polyline(pntList);
        polygon.setClosed(true);
        UIFieldFormatterIFace fldFmt = null;
        if (this.typeCBX.getSelectedIndex() == 0) {
            fldFmt = DBTableIdMgr.getFieldFormatterFor(CollectionObject.class, "catalogNumber");
        }
        int index = 0;
        Vector<Object[]> pnts = BasicSQLUtils.query(sb.toString());
        for (Object[] row : pnts) {
            double lon;
            double lat = ((BigDecimal)row[1]).doubleValue();
            Position pos = Position.fromDegrees((double)lat, (double)(lon = ((BigDecimal)row[2]).doubleValue()), (double)0.0);
            if (!GeometryMath.isLocationInside((LatLon)pos, (Iterable)polygon.getPositions())) continue;
            LatLonPoint llp = new LatLonPoint((Integer)row[0], (Double)lat, lon);
            String title = row[3] != null ? (fldFmt != null ? fldFmt.formatToUI(row[3]) : row[3]).toString() : "N/A";
            llp.setTitle(title);
            llp.setIndex(index++);
            this.availPoints.add(llp);
            markers.add(llp);
            model.addElement(llp);
            this.topIdHash.add(llp.getLocId());
        }
        if (markers.size() > 0) {
            this.wwPanel.placeMarkers(markers, null);
            this.clearBtn.setEnabled(true);
            this.searchBtn.setEnabled(false);
        } else {
            this.doClear(true);
            this.clearBtn.setEnabled(true);
            this.startBtn.setEnabled(false);
        }
    }

    private String getLocalitySearchSQL() {
        return "SELECT LocalityID, Latitude1, Longitude1, LocalityName FROM locality WHERE %s GROUP BY LocalityID ORDER BY LocalityName";
    }

    private String doColObjSearchSQL() {
        return "SELECT co.CollectionObjectID, l.Latitude1, l.Longitude1, co.CatalogNumber FROM locality l INNER JOIN collectingevent ce ON l.LocalityID = ce.LocalityID INNER JOIN collectionobject co ON ce.CollectingEventID = co.CollectingEventID WHERE %s ORDER BY CatalogNumber";
    }

    private String doCollEventSearchSQL() {
        return "SELECT ce.CollectingEventID, l.Latitude1, l.Longitude1, ce.StartDate FROM locality l INNER JOIN collectingevent ce ON l.LocalityID = ce.LocalityID WHERE %s GROUP BY ce.CollectingEventID ORDER BY StartDate";
    }

    private String doTaxonSearchSQL() {
        return "SELECT t.TaxonID, l.Latitude1, l.Longitude1, t.FullName FROM locality l INNER JOIN collectingevent ce ON l.LocalityID = ce.LocalityID INNER JOIN collectionobject co ON ce.CollectingEventID = co.CollectingEventID INNER JOIN determination d ON co.CollectionObjectID = d.CollectionObjectID INNER JOIN taxon t ON d.TaxonID = t.TaxonID WHERE d.IsCurrent = TRUE AND %s GROUP BY t.TaxonID ORDER BY FullName";
    }

    private SelectListener getWWSelectListener() {
        return new SelectListener(){

            public void selected(SelectEvent event) {
                if (event.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick") && event.hasObjects() && event.getTopPickedObject().hasPosition()) {
                    WorldWindSearchPanel.this.lastClickPos = WorldWindSearchPanel.this.wwPanel.getWorld().getCurrentPosition();
                    if (WorldWindSearchPanel.this.wwPanel.getWorld().getView() instanceof OrbitView) {
                        if (event.getTopObject().getClass().equals(BasicMarker.class)) {
                            int inx = WorldWindSearchPanel.this.wwPanel.getMarkers().indexOf(event.getTopObject());
                        } else if (event.getTopObject().getClass().equals(GlobeAnnotation.class)) {
                            int n = WorldWindSearchPanel.this.wwPanel.getAnnotations().indexOf(event.getTopObject());
                        }
                    }
                }
            }
        };
    }

    private MouseAdapter getWWMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).WorldWindSearchPanel.this.lineBuilder.isArmed()) {
                            Position pos = (this).WorldWindSearchPanel.this.wwPanel.getWorld().getCurrentPosition();
                            pos.equals((Object)(this).WorldWindSearchPanel.this.lastClickPos);
                        }
                    }
                });
            }
        };
    }

    protected List<Position> createPolygonFromPoints(Vector<LatLonPoint> pnts) {
        ArrayList<Position> polygonList = new ArrayList<Position>();
        for (LatLonPoint p : pnts) {
            Position pos = Position.fromDegrees((double)p.getLatitude(), (double)p.getLongitude(), (double)0.0);
            polygonList.add(pos);
        }
        return polygonList;
    }

    public static CustomDialog getDlg() {
        WorldWindSearchPanel panel = new WorldWindSearchPanel();
        CustomDialog dlg = new CustomDialog(null, "", true, panel);
        dlg.setVisible(true);
        return dlg;
    }
}

