/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui;

import edu.ku.brc.services.mapping.LatLonPlacemarkIFace;
import edu.ku.brc.util.Pair;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.ViewStateIterator;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.examples.GazetteerPanel;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.AnnotationLayer;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.MarkerLayer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.layers.placename.PlaceNameLayer;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.markers.BasicMarker;
import gov.nasa.worldwind.render.markers.BasicMarkerAttributes;
import gov.nasa.worldwind.render.markers.Marker;
import gov.nasa.worldwind.render.markers.MarkerAttributes;
import gov.nasa.worldwind.util.StatusBar;
import gov.nasa.worldwind.view.FlyToOrbitViewStateIterator;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class WorldWindPanel
extends JPanel {
    private static final int DEFAULT_RADIUS = 3;
    protected AnnotationLayer annoLayer;
    protected MarkerLayer markerLayer = new MarkerLayer();
    protected RenderableLayer lineLayer = new RenderableLayer();
    protected WorldWindowGLCanvas world = null;
    protected StatusBar statusBar;
    protected boolean includeGazetter;
    protected ArrayList<Marker> markers = new ArrayList();
    protected ArrayList<GlobeAnnotation> annotations = new ArrayList();
    protected AnnotationAttributes annoAttrs = new AnnotationAttributes();
    protected BasicMarkerAttributes markerAttrs;
    protected double zoomInMeters = 20000.0;

    public WorldWindPanel() throws HeadlessException {
        this(true);
    }

    public WorldWindPanel(boolean includeGazetter) throws HeadlessException {
        this.includeGazetter = includeGazetter;
        this.init();
    }

    protected void init() {
        if (this.world == null) {
            try {
                this.world = new WorldWindowGLCanvas();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.annoAttrs.setCornerRadius(3);
            this.annoAttrs.setInsets(new Insets(4, 4, 4, 4));
            this.annoAttrs.setBackgroundColor(new Color(0.0f, 0.0f, 0.0f, 0.5f));
            this.annoAttrs.setDrawOffset(new Point(0, 6));
            this.annoAttrs.setDistanceMinScale(0.5);
            this.annoAttrs.setDistanceMaxScale(2.0);
            this.annoAttrs.setDistanceMinOpacity(0.5);
            this.annoAttrs.setLeader("Render.FrameFactory.LeaderNone");
            this.annoAttrs.setFont(Font.decode("Arial-BOLD-10"));
            this.annoAttrs.setTextColor(Color.WHITE);
            this.annoAttrs.setBorderColor(new Color(0.75f, 0.75f, 0.75f, 0.75f));
            this.resetMarkerAttrs(3);
            this.markerLayer.setOverrideMarkerElevation(true);
            this.markerLayer.setKeepSeparated(false);
            this.markerLayer.setElevation(0.0);
            this.initWorldWindLayerModel();
        }
    }

    public void resetMarkerAttrs() {
        this.resetMarkerAttrs(3);
    }

    public void resetMarkerAttrs(Integer radius) {
        int rad = radius == null ? 3 : radius;
        Material material = new Material(new Color(1.0f, 0.1f, 0.1f, 0.75f));
        this.markerAttrs = new BasicMarkerAttributes(material, "gov.nasa.worldwind.render.markers.DirectionalSphere", 1.0, (double)rad, (double)rad);
    }

    public void setMarkerAttrs(BasicMarkerAttributes markerAttrs) {
        this.markerAttrs = markerAttrs;
    }

    protected void initWorldWindLayerModel() {
        Model m = (Model)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.ModelClassName");
        this.world.setModel(m);
        LayerList layers = this.world.getModel().getLayers();
        for (Object layer : layers) {
            if (!(layer instanceof AnnotationLayer)) continue;
            this.annoLayer = (AnnotationLayer)layer;
            break;
        }
        if (this.annoLayer == null) {
            this.annoLayer = new AnnotationLayer();
        }
        WorldWindPanel.insertBeforePlacenames((WorldWindow)this.world, (Layer)this.markerLayer);
        WorldWindPanel.insertBeforePlacenames((WorldWindow)this.world, (Layer)this.annoLayer);
        this.world.getModel().getLayers().add((Layer)this.lineLayer);
        this.setLayout(new BorderLayout());
        this.statusBar = new StatusBar();
        this.add((Component)this.statusBar, "South");
        this.statusBar.setEventSource((WorldWindow)this.world);
        this.add((Component)this.world, "Center");
        if (this.includeGazetter) {
            try {
                this.add((Component)new GazetteerPanel((WorldWindow)this.world, null), "North");
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void addPolyline(Polyline polyline) {
        this.lineLayer.addRenderable((Renderable)polyline);
    }

    public void placeMarkers(List<LatLonPlacemarkIFace> points, Integer flyToIndex, BasicMarkerAttributes attrs, boolean doReset) {
        this.placeMarkers(points, false, true, flyToIndex, attrs, doReset);
    }

    public void placeMarkers(List<LatLonPlacemarkIFace> points, Integer flyToIndex) {
        this.placeMarkers(points, flyToIndex, null, true);
    }

    public void reset() {
        this.init();
        this.annoLayer.clearList();
        this.annoLayer.removeAllAnnotations();
        this.markerLayer.clearList();
        this.lineLayer.clearList();
        this.world.getModel().getLayers().remove((Layer)this.lineLayer);
        this.lineLayer = new RenderableLayer();
        this.world.getModel().getLayers().add((Layer)this.lineLayer);
        this.markers.clear();
        this.annotations.clear();
    }

    public void placeMarkers(List<LatLonPlacemarkIFace> points, boolean doAddTitles, boolean doAddMarkCntText, Integer flyToIndex) {
        this.placeMarkers(points, doAddTitles, doAddMarkCntText, flyToIndex, null, true);
    }

    public void placeMarkers(List<LatLonPlacemarkIFace> points, boolean doAddTitles, boolean doAddMarkCntText, Integer flyToIndex, BasicMarkerAttributes attrs, boolean doReset) {
        Pair<Double, Double> latLon;
        if (doReset) {
            this.reset();
        }
        int i = 1;
        for (LatLonPlacemarkIFace pnt : points) {
            Pair<Double, Double> latLon2 = pnt.getLatLon();
            if (latLon2 == null || latLon2.first == null || latLon2.second == null) continue;
            Position pos = Position.fromDegrees((double)((Double)latLon2.first), (double)((Double)latLon2.second), (double)0.0);
            BasicMarker marker = new BasicMarker(pos, (MarkerAttributes)(attrs == null ? this.markerAttrs : attrs));
            marker.setPosition(Position.fromDegrees((double)((Double)latLon2.first), (double)((Double)latLon2.second), (double)0.0));
            this.markers.add((Marker)marker);
            if (!doAddTitles && !doAddMarkCntText) continue;
            String txt = doAddMarkCntText ? Integer.toString(i++) : (pnt.getTitle() != null ? pnt.getTitle() : "");
            GlobeAnnotation ga = new GlobeAnnotation(txt, pos, this.annoAttrs);
            if (txt.length() > 0) {
                this.annoLayer.addAnnotation((Annotation)ga);
            }
            this.annotations.add(ga);
        }
        this.markerLayer.setMarkers(this.markers);
        if (flyToIndex != null && flyToIndex > -1 && flyToIndex < points.size() && (latLon = points.get(0).getLatLon()) != null && latLon.first != null && latLon.second != null) {
            this.flyTo(LatLon.fromDegrees((double)((Double)latLon.first), (double)((Double)latLon.second)));
        }
    }

    public void flyToMarker(int markerIndex) {
        if (markerIndex > -1 && markerIndex < this.markers.size()) {
            Marker marker = this.markers.get(markerIndex);
            this.flyTo(marker.getPosition().getLatLon());
        }
    }

    public double getZoomInMeters() {
        return this.zoomInMeters;
    }

    public void setZoomInMeters(double zoomInMeters) {
        this.zoomInMeters = zoomInMeters;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public void setStatusBar(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    public AnnotationLayer getAnnoLayer() {
        return this.annoLayer;
    }

    public MarkerLayer getMarkerLayer() {
        return this.markerLayer;
    }

    public AnnotationAttributes getAnnoAttrs() {
        return this.annoAttrs;
    }

    public BasicMarkerAttributes getMarkerAttrs() {
        return this.markerAttrs;
    }

    public WorldWindowGLCanvas getWorld() {
        return this.world;
    }

    public ArrayList<Marker> getMarkers() {
        return this.markers;
    }

    public ArrayList<GlobeAnnotation> getAnnotations() {
        return this.annotations;
    }

    public void shutdown() {
    }

    public static void insertBeforeCompass(WorldWindow wwd, Layer layer) {
        int compassPosition = 0;
        LayerList layers = wwd.getModel().getLayers();
        for (Layer l : layers) {
            if (!(l instanceof CompassLayer)) continue;
            compassPosition = layers.indexOf((Object)l);
        }
        layers.add(compassPosition, layer);
    }

    public static void insertBeforePlacenames(WorldWindow wwd, Layer layer) {
        int compassPosition = 0;
        LayerList layers = wwd.getModel().getLayers();
        for (Layer l : layers) {
            if (!(l instanceof PlaceNameLayer)) continue;
            compassPosition = layers.indexOf((Object)l);
        }
        layers.add(compassPosition, layer);
    }

    public static void insertAfterPlacenames(WorldWindow wwd, Layer layer) {
        int compassPosition = 0;
        LayerList layers = wwd.getModel().getLayers();
        for (Layer l : layers) {
            if (!(l instanceof PlaceNameLayer)) continue;
            compassPosition = layers.indexOf((Object)l);
        }
        layers.add(compassPosition + 1, layer);
    }

    public static void insertBeforeLayerName(WorldWindow wwd, Layer layer, String targetName) {
        int targetPosition = 0;
        LayerList layers = wwd.getModel().getLayers();
        for (Layer l : layers) {
            if (l.getName().indexOf(targetName) == -1) continue;
            targetPosition = layers.indexOf((Object)l);
            break;
        }
        layers.add(targetPosition, layer);
    }

    public static void insertAfterLayerName(WorldWindow wwd, Layer layer, String targetName) {
        int targetPosition = 0;
        LayerList layers = wwd.getModel().getLayers();
        for (Layer l : layers) {
            System.out.println(l.getName());
            if (l.getName().indexOf(targetName) == -1) continue;
            targetPosition = layers.indexOf((Object)l);
            break;
        }
        layers.add(targetPosition + 1, layer);
    }

    public void flyTo(LatLon latlon) {
        Position pos = new Position(latlon.latitude, latlon.longitude, 3000.0);
        View view = this.world.getView();
        Globe globe = this.world.getModel().getGlobe();
        view.applyStateIterator((ViewStateIterator)FlyToOrbitViewStateIterator.createPanToIterator((OrbitView)((OrbitView)view), (Globe)globe, (Position)pos, (Angle)Angle.ZERO, (Angle)Angle.ZERO, (double)this.zoomInMeters));
    }
}

