/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.AutoNumberIFace;
import edu.ku.brc.af.ui.forms.formatters.GenericStringUIFieldFormatter;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.AutoNumberingScheme;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.SpAppResource;
import edu.ku.brc.specify.datamodel.SpAppResourceDir;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.dbsupport.AccessionAutoNumberAlphaNum;
import edu.ku.brc.specify.dbsupport.CollectionAutoNumber;
import edu.ku.brc.specify.dbsupport.CollectionAutoNumberAlphaNum;
import edu.ku.brc.specify.ui.CatalogNumberStringUIFieldFormatter;
import edu.ku.brc.specify.ui.CatalogNumberUIFieldFormatter;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import edu.ku.brc.ui.UIRegistry;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class SpecifyUIFieldFormatterMgr
extends UIFieldFormatterMgr
implements CommandListener {
    private static final Logger log = Logger.getLogger(SpecifyUIFieldFormatterMgr.class);
    protected static String DISCIPLINE = "Discipline";
    protected static String BACKSTOPDIR = "BackStop";
    protected static String UIFORMATTERS = "UIFormatters";
    private String localFilePath = null;
    private boolean pathWasSet = false;
    protected UIFieldFormatterIFace catalogNumberNumeric;
    protected UIFieldFormatterIFace catalogNumberString;

    public SpecifyUIFieldFormatterMgr() {
        CommandDispatcher.register(DISCIPLINE, this);
    }

    private String getLocalPath() {
        if (this.localFilePath == null) {
            this.localFilePath = "backstop/uiformatters.xml";
        }
        return this.localFilePath;
    }

    @Override
    public void load() {
        super.load();
        this.catalogNumberNumeric = super.getFormatterInternal("CatalogNumberNumeric");
        if (this.catalogNumberNumeric == null) {
            this.catalogNumberNumeric = new CatalogNumberUIFieldFormatter();
            this.catalogNumberNumeric.setAutoNumber(new CollectionAutoNumber());
        }
        this.catalogNumberString = super.getFormatterInternal("CatalogNumberString");
        if (this.catalogNumberString == null) {
            this.catalogNumberString = new CatalogNumberStringUIFieldFormatter();
        }
    }

    @Override
    protected Element getDOM() throws Exception {
        if (doingLocal) {
            return this.pathWasSet ? XMLHelper.readFileToDOM4J(new File(this.getLocalPath())) : XMLHelper.readDOMFromConfigDir(this.getLocalPath());
        }
        return this.getDisciplineDOMFromResource(this.getAppContextMgr(), UIFORMATTERS, this.getLocalPath());
    }

    protected Discipline getDiscipline(AppContextMgr contextMgr) {
        return contextMgr.getClassObject(Discipline.class);
    }

    public Element getDisciplineDOMFromResource(AppContextMgr contextMgr, String name, String localPath) {
        SpecifyAppContextMgr acMgr = (SpecifyAppContextMgr)contextMgr;
        DataProviderSessionIFace session = null;
        try {
            SpAppResource appRes;
            session = DataProviderFactory.getInstance().createSession();
            SpecifyUser user = contextMgr.getClassObject(SpecifyUser.class);
            Discipline discipline = this.getDiscipline(contextMgr);
            SpAppResourceDir appResDir = acMgr.getAppResDir(session, user, discipline, null, null, false, name, false);
            if (appResDir != null && (appRes = appResDir.getResourceByName(name)) != null) {
                session.close();
                session = null;
                Element element = acMgr.getResourceAsDOM(appRes);
                return element;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SpecifyUIFieldFormatterMgr.class, ex);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return XMLHelper.readDOMFromConfigDir(localPath);
    }

    protected Element getDOMForStringFmts() throws Exception {
        if (doingLocal) {
            return XMLHelper.readDOMFromConfigDir("backstop/uistrformatters.xml");
        }
        return this.getDisciplineDOMFromResource(this.getAppContextMgr(), String.valueOf(UIFORMATTERS) + "_STRS", "backstop/uistrformatters.xml");
    }

    public void setLocalFilePath(String localFilePath) {
        this.localFilePath = localFilePath;
        this.pathWasSet = true;
    }

    @Override
    public void reset() {
        instance = null;
    }

    public void loadStringFormatters() {
        block5: {
            try {
                Element root = this.getDOMForStringFmts();
                if (root == null) break block5;
                List formats = root.selectNodes("/formats/format");
                for (Object fObj : formats) {
                    Element formatElement = (Element)fObj;
                    String name = formatElement.attributeValue("name");
                    UIFieldFormatterIFace fmt = super.getFormatterInternal(name);
                    if (fmt != null) continue;
                    String fieldName = XMLHelper.getAttr(formatElement, "fieldname", null);
                    String dataClassName = formatElement.attributeValue("class");
                    String titleKey = XMLHelper.getAttr(formatElement, "titlekey", null);
                    int uiDisplayLen = XMLHelper.getAttr(formatElement, "uilen", 10);
                    Class<?> dataClass = null;
                    try {
                        dataClass = Class.forName(dataClassName);
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(SpecifyUIFieldFormatterMgr.class, ex);
                        log.error((Object)("Couldn't load class [" + dataClassName + "] for [" + name + "]"));
                    }
                    fmt = new GenericStringUIFieldFormatter(name, dataClass, fieldName, UIRegistry.getResourceString(titleKey), uiDisplayLen);
                    this.hash.put(name, fmt);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SpecifyUIFieldFormatterMgr.class, ex);
                log.error((Object)ex);
            }
        }
    }

    @Override
    public void saveXML(String xml) {
        if (doingLocal) {
            File outputFile = this.pathWasSet ? new File(this.getLocalPath()) : XMLHelper.getConfigDir(this.getLocalPath());
            try {
                FileUtils.writeStringToFile((File)outputFile, (String)xml);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SpecifyUIFieldFormatterMgr.class, ex);
                ex.printStackTrace();
            }
        } else {
            SpecifyUIFieldFormatterMgr.saveDisciplineResource(this.getAppContextMgr(), UIFORMATTERS, xml);
        }
    }

    public static void saveDisciplineResource(AppContextMgr contextMgr, String resName, String xml) {
        block12: {
            SpecifyAppContextMgr acMgr = (SpecifyAppContextMgr)contextMgr;
            DataProviderSessionIFace session = null;
            try {
                try {
                    SpAppResource appRes;
                    session = DataProviderFactory.getInstance().createSession();
                    SpecifyUser user = acMgr.getClassObject(SpecifyUser.class);
                    Discipline discipline = acMgr.getClassObject(Discipline.class);
                    boolean found = false;
                    SpAppResourceDir appResDir = acMgr.getAppResDir(session, user, discipline, null, null, false, resName, false);
                    if (appResDir != null && (appRes = appResDir.getResourceByName(resName)) != null) {
                        session.close();
                        session = null;
                        appRes.setDataAsString(xml);
                        contextMgr.saveResource(appRes);
                        found = true;
                    }
                    if (found) break block12;
                    appResDir = acMgr.getAppResDir(session, user, discipline, null, null, false, resName, true);
                    if (appResDir != null) {
                        SpAppResource diskAppRes = acMgr.getSpAppResourceDirByName(BACKSTOPDIR).getResourceByName(resName);
                        SpAppResource newAppRes = new SpAppResource();
                        newAppRes.initialize();
                        if (diskAppRes != null) {
                            newAppRes.setMetaData(diskAppRes.getMetaData());
                            newAppRes.setDescription(diskAppRes.getDescription());
                            newAppRes.setFileName(diskAppRes.getFileName());
                            newAppRes.setMimeType(diskAppRes.getMimeType());
                            newAppRes.setName(diskAppRes.getName());
                            newAppRes.setLevel(diskAppRes.getLevel());
                        } else {
                            newAppRes.setName(resName);
                            newAppRes.setLevel((short)0);
                            newAppRes.setMimeType("text/xml");
                        }
                        Agent agent = contextMgr.getClassObject(Agent.class);
                        newAppRes.setCreatedByAgent(agent);
                        newAppRes.setSpecifyUser(user);
                        newAppRes.setSpAppResourceDir(appResDir);
                        appResDir.getSpAppResources().add(newAppRes);
                        newAppRes.setDataAsString(xml);
                        if (session != null) {
                            session.close();
                            session = null;
                        }
                        ((SpecifyAppContextMgr)contextMgr).saveResource(newAppRes);
                        break block12;
                    }
                    contextMgr.putResourceAsXML(resName, xml);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(SpecifyUIFieldFormatterMgr.class, ex);
                    if (session != null) {
                        session.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
    }

    @Override
    public AutoNumberIFace createAutoNumber(String autoNumberClassName, String dataClassName, String fieldName, boolean isSingleField) {
        if (dataClassName.equals("edu.ku.brc.specify.datamodel.CollectionObject") && fieldName.equals("catalogNumber")) {
            return isSingleField ? new CollectionAutoNumber() : new CollectionAutoNumberAlphaNum();
        }
        if (dataClassName.equals("edu.ku.brc.specify.datamodel.Accession") && fieldName.equals("accessionNumber")) {
            return new AccessionAutoNumberAlphaNum();
        }
        return super.createAutoNumber(autoNumberClassName, dataClassName, fieldName, isSingleField);
    }

    @Override
    protected UIFieldFormatterIFace getFormatterInternal(String name) {
        if (StringUtils.isNotEmpty((String)name)) {
            if (!doingLocal) {
                if (!AppContextMgr.getInstance().hasContext() || AppContextMgr.getInstance().getClassObject(Collection.class) == null) {
                    return null;
                }
                if (name.equals("Date")) {
                    return super.getFormatterInternal(name);
                }
                if (name.equals("CatalogNumberString")) {
                    if (this.catalogNumberString != null) {
                        return this.catalogNumberString;
                    }
                } else {
                    AutoNumberingScheme cns;
                    Collection collection = AppContextMgr.getInstance().getClassObject(Collection.class);
                    AutoNumberingScheme autoNumberingScheme = cns = collection != null ? collection.getNumberingSchemesByType(CollectionObject.getClassTableId()) : null;
                    if (cns != null) {
                        if ((name.equals("CatalogNumberNumeric") || name.equals("CatalogNumber") && cns.getIsNumericOnly().booleanValue()) && this.catalogNumberNumeric != null) {
                            return this.catalogNumberNumeric;
                        }
                    } else {
                        log.error((Object)("The CatalogNumberingScheme is null for the current Collection [" + (AppContextMgr.getInstance().getClassObject(Collection.class) != null ? AppContextMgr.getInstance().getClassObject(Collection.class).getCollectionName() : "null") + "] and should be!"));
                    }
                }
            }
        } else {
            log.error((Object)"The name is empty!");
        }
        return super.getFormatterInternal(name);
    }

    @Override
    public List<UIFieldFormatterIFace> getFormatterList(Class<?> clazz, String fieldName) {
        List<UIFieldFormatterIFace> list = super.getFormatterList(clazz, fieldName);
        return list;
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isType(DISCIPLINE) && cmdAction.isAction("Changed")) {
            this.load();
        }
    }
}

