/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.db.ViewBasedDisplayDialog;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.Loan;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.busrules.AccessionBusRules;
import edu.ku.brc.specify.ui.ColObjInfo;
import edu.ku.brc.specify.ui.PrepInfo;
import edu.ku.brc.ui.ColorWrapper;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.StringUtils;

public class SelectPrepsDlg
extends CustomDialog {
    protected ColorWrapper requiredfieldcolor = AppPrefsCache.getColorWrapper("ui", "formatting", "requiredfieldcolor");
    protected List<CollectionObject> colObjs;
    protected List<ColObjPanel> colObjPanels = new Vector<ColObjPanel>();
    protected JLabel summaryLabel;
    protected Hashtable<Integer, String> prepTypeHash;
    protected Hashtable<Integer, ColObjInfo> coToPrepHash;
    protected static final Cursor handCursor = new Cursor(12);
    protected static final Cursor defCursor = new Cursor(0);

    public SelectPrepsDlg(Hashtable<Integer, ColObjInfo> coToPrepHash, Hashtable<Integer, String> prepTypeHash, String title) {
        super((Frame)UIRegistry.getTopWindow(), UIRegistry.getLocalizedMessage("LoanSelectPrepsDlg.CREATE_FR_PREP", title), true, 15, null);
        this.coToPrepHash = coToPrepHash;
        this.prepTypeHash = prepTypeHash;
    }

    @Override
    public void createUI() {
        this.applyLabel = UIRegistry.getResourceString("SELECTALL");
        super.createUI();
        Vector<ColObjInfo> coList = new Vector<ColObjInfo>(this.coToPrepHash.values());
        Collections.sort(coList, new Comparator<ColObjInfo>(){

            @Override
            public int compare(ColObjInfo o1, ColObjInfo o2) {
                return o1.getCatNo().compareTo(o2.getCatNo());
            }
        });
        int cnt = 0;
        Vector<ColObjInfo> coFilteredList = new Vector<ColObjInfo>();
        for (ColObjInfo colObjInfo : coList) {
            if (!StringUtils.isNotEmpty((String)colObjInfo.getCatNo()) || colObjInfo.getPreps() == null || colObjInfo.getPreps().size() <= 0) continue;
            coFilteredList.add(colObjInfo);
            cnt += colObjInfo.getPreps().size();
        }
        String rowDef = String.valueOf(UIHelper.createDuplicateJGoodiesDef("p", "1px,p,4px", cnt * 2 - 1)) + ",10px,p";
        PanelBuilder pbuilder = new PanelBuilder(new FormLayout("f:p:g", rowDef));
        CellConstraints cc = new CellConstraints();
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SelectPrepsDlg.this.doEnableOKBtn();
            }
        };
        ChangeListener cl = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ae) {
                SelectPrepsDlg.this.doEnableOKBtn();
            }
        };
        DBTableInfo colObjTI = DBTableIdMgr.getInstance().getInfoById(CollectionObject.getClassTableId());
        DBFieldInfo colObjFI = colObjTI.getFieldByColumnName("CatalogNumber");
        int i = 0;
        int y = 1;
        for (ColObjInfo colObjInfo : coFilteredList) {
            if (i > 0) {
                pbuilder.addSeparator("", cc.xy(1, y));
            }
            y += 2;
            colObjInfo.setCatNo((String)colObjFI.getFormatter().formatToUI(colObjInfo.getCatNo()));
            ColObjPanel panel = new ColObjPanel(this, colObjInfo);
            this.colObjPanels.add(panel);
            panel.addActionListener(al, cl);
            pbuilder.add((Component)panel, cc.xy(1, y));
            y += 2;
            ++i;
        }
        this.applyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SelectPrepsDlg.this.selectAllItems();
            }
        });
        JPanel tPanel = new JPanel(new BorderLayout());
        this.summaryLabel = UIHelper.createLabel("");
        tPanel.setBorder(BorderFactory.createEmptyBorder(5, 1, 5, 1));
        tPanel.add((Component)this.summaryLabel, "North");
        JScrollPane sp = new JScrollPane(pbuilder.getPanel(), 20, 31);
        tPanel.add((Component)sp, "Center");
        this.contentPanel = tPanel;
        this.mainPanel.add(this.contentPanel, "Center");
        this.pack();
        this.doEnableOKBtn();
        Dimension size = this.getPreferredSize();
        size.width += 20;
        size.height = size.height > 500 ? 500 : size.height;
        this.setSize(size);
    }

    protected void doEnableOKBtn() {
        int count = 0;
        for (ColObjPanel pp : this.colObjPanels) {
            if (!pp.isColObjEnabled()) continue;
            count += pp.getNewLoanCount();
        }
        this.okBtn.setEnabled(count > 0);
        this.summaryLabel.setText(String.format(UIRegistry.getResourceString("LoanSelectPrepsDlg.NUM_PREP_SEL"), count));
    }

    protected void selectAllItems() {
        for (ColObjPanel colObjPanel : this.colObjPanels) {
            for (PrepPanel pp : colObjPanel.getPanels()) {
                pp.selectAllItems();
            }
        }
    }

    public Hashtable<Integer, Integer> getPreparationCounts() {
        Hashtable<Integer, Integer> hash = new Hashtable<Integer, Integer>();
        for (ColObjPanel colObjPanel : this.colObjPanels) {
            if (!colObjPanel.isColObjEnabled()) continue;
            for (PrepPanel pp : colObjPanel.getPanels()) {
                if (pp.getCount() <= 0) continue;
                hash.put(pp.getPrepId(), pp.getCount());
            }
        }
        return hash;
    }

    class ColObjPanel
    extends JPanel {
        protected ColObjInfo colObjInfo;
        protected JCheckBox checkBox;
        protected Vector<PrepPanel> panels = new Vector();
        protected JDialog dlgParent;

        public ColObjPanel(JDialog dlgParent, ColObjInfo colObjInfo) {
            this.dlgParent = dlgParent;
            this.colObjInfo = colObjInfo;
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            PanelBuilder pbuilder = new PanelBuilder(new FormLayout("f:p:g", "p,5px,p"), (JPanel)this);
            CellConstraints cc = new CellConstraints();
            String taxonName = colObjInfo.getTaxonName();
            if (StringUtils.isEmpty((String)taxonName)) {
                taxonName = UIRegistry.getResourceString("LoanSelectPrepsDlg.UNDET");
            }
            String descr = String.format(UIRegistry.getResourceString("LoanSelectPrepsDlg.TITLE_PAIR"), colObjInfo.getCatNo(), taxonName);
            descr = StringUtils.stripToEmpty((String)descr);
            this.checkBox = UIHelper.createCheckBox(descr);
            pbuilder.add((Component)this.checkBox, cc.xy(1, 1));
            this.checkBox.setSelected(true);
            JPanel outerPanel = new JPanel();
            outerPanel.setLayout(new BoxLayout(outerPanel, 1));
            outerPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            JPanel containerPane = new JPanel();
            containerPane.setLayout(new BoxLayout(containerPane, 1));
            outerPanel.add(containerPane);
            Color[] colors = new Color[]{new Color(255, 255, 255), new Color(235, 235, 255)};
            int i = 0;
            for (PrepInfo prepInfo : colObjInfo.getPreps().values()) {
                PrepPanel pp = new PrepPanel(dlgParent, prepInfo);
                this.panels.add(pp);
                pp.setBackground(colors[i % 2]);
                containerPane.add(pp);
                ++i;
            }
            pbuilder.add((Component)outerPanel, cc.xy(1, 3));
            this.checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    for (PrepPanel pp : ColObjPanel.this.panels) {
                        pp.setEnabled(ColObjPanel.this.checkBox.isSelected());
                    }
                    ColObjPanel.this.repaint();
                }
            });
        }

        public String getTaxonName(Determination deter) {
            String taxonName = null;
            if (deter.getPreferredTaxon() != null) {
                if (deter.getPreferredTaxon().getFullName() == null) {
                    Taxon parent = deter.getPreferredTaxon().getParent();
                    String genus = parent.getFullName() == null ? parent.getName() : parent.getFullName();
                    taxonName = String.valueOf(genus) + " " + deter.getPreferredTaxon().getName();
                } else {
                    taxonName = deter.getPreferredTaxon().getFullName();
                }
            }
            return taxonName;
        }

        public void addActionListener(ActionListener al, ChangeListener cl) {
            this.checkBox.addActionListener(al);
            for (PrepPanel pp : this.panels) {
                pp.addChangeListener(cl);
            }
        }

        public boolean isColObjEnabled() {
            return this.checkBox.isSelected();
        }

        public int getNewLoanCount() {
            int count = 0;
            if (this.checkBox.isSelected()) {
                for (PrepPanel pp : this.panels) {
                    count += pp.getCount();
                }
            }
            return count;
        }

        public Vector<PrepPanel> getPanels() {
            return this.panels;
        }
    }

    class LinkLabelBtn
    extends JLabel {
        protected ActionListener al;

        public LinkLabelBtn(final ActionListener al, String label, ImageIcon imgIcon) {
            super(label, imgIcon, 2);
            this.setHorizontalTextPosition(2);
            this.al = al;
            UIHelper.setControlSize(this);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    al.actionPerformed(new ActionEvent(this, 0, ""));
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
        }
    }

    class LoanLoader
    extends SwingWorker<Integer, Integer> {
        private int prepId;
        private List<Loan> loans = null;
        private JDialog parent;

        public LoanLoader(JDialog parent, int prepId) {
            this.parent = parent;
            this.prepId = prepId;
        }

        @Override
        protected Integer doInBackground() throws Exception {
            block10: {
                String sql = "SELECT loan.LoanID FROM preparation p INNER JOIN loanpreparation lp ON p.PreparationID = lp.PreparationID INNER JOIN loan ON lp.LoanID = loan.LoanID WHERE p.PreparationID = " + this.prepId;
                StringBuilder sb = new StringBuilder();
                Vector<Object[]> rows = BasicSQLUtils.query(sql);
                for (Object[] cols : rows) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(cols[0]);
                }
                DataProviderSessionIFace session = null;
                try {
                    try {
                        session = DataProviderFactory.getInstance().createSession();
                        this.loans = session.getDataList("FROM Loan WHERE loanId in(" + sb.toString() + ")");
                    }
                    catch (Exception ex) {
                        ExceptionTracker.getInstance().capture(AccessionBusRules.class, ex);
                        ex.printStackTrace();
                        UsageTracker.incrNetworkUsageCount();
                        if (session != null) {
                            session.close();
                        }
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        session.close();
                    }
                    throw throwable;
                }
                if (session != null) {
                    session.close();
                }
            }
            return 0;
        }

        @Override
        protected void done() {
            FormViewObj formViewObj;
            Component comp;
            super.done();
            UIRegistry.getStatusBar().setProgressDone("LoanLoader");
            UIRegistry.clearSimpleGlassPaneMsg();
            ViewIFace view = AppContextMgr.getInstance().getView("Loan");
            ViewBasedDisplayDialog dlg = new ViewBasedDisplayDialog(this.parent, view.getViewSetName(), "Loan", null, UIRegistry.getResourceString("LoanSelectPrepsDlg.IAT_LOAN_REVIEW"), UIRegistry.getResourceString("CLOSE"), null, null, false, 1);
            dlg.setHelpContext("LOAN_REVIEW");
            MultiView mv = dlg.getMultiView();
            Viewable currentViewable = mv.getCurrentView();
            if (currentViewable != null && currentViewable instanceof FormViewObj && (comp = (formViewObj = (FormViewObj)currentViewable).getControlByName("generateInvoice")) instanceof JCheckBox) {
                comp.setVisible(false);
            }
            dlg.setModal(true);
            dlg.setData(this.loans);
            dlg.setVisible(true);
        }
    }

    class PrepPanel
    extends JPanel
    implements ActionListener {
        protected PrepInfo prepInfo;
        protected JLabel label = null;
        protected JLabel label2 = null;
        protected JComponent prepInfoBtn = null;
        protected JSpinner spinner;
        protected JDialog parent;
        protected int maxValue = 0;
        protected boolean unknownQuantity;

        public PrepPanel(JDialog parent, PrepInfo prepInfo) {
            this.prepInfo = prepInfo;
            this.parent = parent;
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            PanelBuilder pbuilder = new PanelBuilder(new FormLayout("max(120px;p),2px,max(50px;p),2px,p,2px,p:g", "c:p"), (JPanel)this);
            CellConstraints cc = new CellConstraints();
            this.label = UIHelper.createLabel(SelectPrepsDlg.this.prepTypeHash.get(prepInfo.getType()));
            pbuilder.add((Component)this.label, cc.xy(1, 1));
            this.label.setOpaque(false);
            int quantityAvailable = prepInfo.getAvailable();
            if (quantityAvailable > 0) {
                this.maxValue = quantityAvailable;
                SpinnerNumberModel model = new SpinnerNumberModel(0, 0, quantityAvailable, 1);
                this.spinner = new JSpinner(model);
                this.fixBGOfJSpinner(this.spinner);
                pbuilder.add((Component)this.spinner, cc.xy(3, 1));
                String fmtStr = UIRegistry.getLocalizedMessage("LoanSelectPrepsDlg.OF_QUANT_OUT", quantityAvailable);
                this.label2 = UIHelper.createLabel(fmtStr);
                pbuilder.add((Component)this.label2, cc.xy(5, 1));
                int onLoanQty = prepInfo.getQtyPrep() - quantityAvailable;
                if (onLoanQty > 0) {
                    fmtStr = UIRegistry.getLocalizedMessage("LoanSelectPrepsDlg.NUM_ON_LOAN", onLoanQty);
                    this.prepInfoBtn = new LinkLabelBtn(this, fmtStr, IconManager.getIcon("InfoIcon", IconManager.IconSize.Std16));
                    pbuilder.add((Component)this.prepInfoBtn, cc.xy(7, 1));
                }
            } else {
                this.label2 = UIHelper.createLabel(UIRegistry.getResourceString("LoanSelectPrepsDlg.NONE_AVAIL"));
                pbuilder.add((Component)this.label2, cc.xywh(3, 1, 5, 1));
            }
        }

        protected void fixBGOfJSpinner(JSpinner spin) {
            JComponent edComp = spin.getEditor();
            int i = 0;
            while (i < edComp.getComponentCount()) {
                Component c = edComp.getComponent(i);
                if (c instanceof JTextField) {
                    c.setBackground(SelectPrepsDlg.this.requiredfieldcolor.getColor());
                }
                ++i;
            }
        }

        public boolean isUnknownQuantity() {
            return this.unknownQuantity;
        }

        public void selectAllItems() {
            if (this.spinner != null) {
                this.spinner.setValue(this.maxValue);
            }
        }

        public Integer getPrepId() {
            return this.prepInfo.getPrepId();
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (this.label != null) {
                this.label.setEnabled(enabled);
            }
            if (this.label2 != null) {
                this.label2.setEnabled(enabled);
            }
            if (this.prepInfoBtn != null) {
                this.prepInfoBtn.setEnabled(enabled);
            }
            if (this.spinner != null) {
                this.spinner.setEnabled(enabled);
            }
        }

        public void addChangeListener(ChangeListener cl) {
            if (this.spinner != null) {
                this.spinner.addChangeListener(cl);
            }
        }

        public int getCount() {
            if (this.spinner != null) {
                Object valObj = this.spinner.getValue();
                return valObj == null ? 0 : (Integer)valObj;
            }
            return 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JStatusBar statusBar = UIRegistry.getStatusBar();
            statusBar.setIndeterminate("LoanLoader", true);
            UIRegistry.writeSimpleGlassPaneMsg(UIRegistry.getResourceString("NEW_INTER_LOADING_PREP"), 24);
            LoanLoader loanLoader = new LoanLoader(this.parent, this.prepInfo.getPrepId());
            loanLoader.execute();
        }
    }
}

