/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.ui.ObjectTextMapper;
import java.io.File;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RepresentativeTextFactory
implements ObjectTextMapper {
    private static final Logger log = Logger.getLogger(RepresentativeTextFactory.class);
    protected Hashtable<Class<?>, ObjectTextMapper> subMappers = new Hashtable();
    protected static RepresentativeTextFactory instance;

    protected RepresentativeTextFactory() {
    }

    public static synchronized RepresentativeTextFactory getInstance() {
        if (instance == null) {
            instance = new RepresentativeTextFactory();
            try {
                instance.readMappingFile();
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(RepresentativeTextFactory.class, e);
                e.printStackTrace();
                log.error((Object)"An error occurred while configuring RepresentativeTextFactory.");
            }
        }
        return instance;
    }

    @Override
    public Class<?>[] getMappedClasses() {
        return new Class[]{FormDataObjIFace.class};
    }

    @Override
    public String getString(Object o) {
        ObjectTextMapper subMapper = this.subMappers.get(o.getClass());
        if (subMapper != null) {
            return subMapper.getString(o);
        }
        for (Class<?> clazz : this.subMappers.keySet()) {
            if (!clazz.isAssignableFrom(o.getClass())) continue;
            return this.subMappers.get(clazz).getString(o);
        }
        if (o instanceof FormDataObjIFace) {
            FormDataObjIFace formDataObj = (FormDataObjIFace)o;
            return formDataObj.getIdentityTitle();
        }
        return o.toString();
    }

    protected void readMappingFile() throws Exception {
        File mappingFile = XMLHelper.getConfigDir("text_factory_mapping.xml");
        Document mappingDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(mappingFile);
        NodeList subMaps = mappingDoc.getElementsByTagName("SubMapper");
        int i = 0;
        while (i < subMaps.getLength()) {
            Class<?>[] handledClasses;
            Node entry = subMaps.item(i);
            String classname = entry.getAttributes().getNamedItem("class").getNodeValue();
            ObjectTextMapper subMapper = Class.forName(classname).asSubclass(ObjectTextMapper.class).newInstance();
            Class<?>[] classArray = handledClasses = subMapper.getMappedClasses();
            int n = handledClasses.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz = classArray[n2];
                if (clazz != null) {
                    this.subMappers.put(clazz, subMapper);
                }
                ++n2;
            }
            ++i;
        }
    }
}

