/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.ui.ObjectIconMapper;
import edu.ku.brc.ui.IconManager;
import java.io.File;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RepresentativeIconFactory
implements ObjectIconMapper {
    private static final Logger log = Logger.getLogger(RepresentativeIconFactory.class);
    protected Hashtable<Class<?>, ImageIcon> classToIconMap = new Hashtable();
    protected Hashtable<Class<?>, ObjectIconMapper> subMappers = new Hashtable();
    protected static RepresentativeIconFactory instance;

    protected RepresentativeIconFactory() {
    }

    public static synchronized RepresentativeIconFactory getInstance() {
        if (instance == null) {
            instance = new RepresentativeIconFactory();
            try {
                instance.readMappingFile();
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(RepresentativeIconFactory.class, e);
                e.printStackTrace();
                log.error((Object)"An error occurred while configuring RepresentativeIconFactory.");
            }
        }
        return instance;
    }

    @Override
    public synchronized ImageIcon getIcon(Object o) {
        ObjectIconMapper subMapper = this.subMappers.get(o.getClass());
        if (subMapper != null) {
            return subMapper.getIcon(o);
        }
        for (Class<?> clazz : this.subMappers.keySet()) {
            if (!clazz.isAssignableFrom(o.getClass())) continue;
            return this.subMappers.get(clazz).getIcon(o);
        }
        ImageIcon icon = this.classToIconMap.get(o.getClass());
        return icon;
    }

    @Override
    public Class<?>[] getMappedClasses() {
        return new Class[0];
    }

    protected void readMappingFile() throws Exception {
        File mappingFile = XMLHelper.getConfigDir("icon_factory_mapping.xml");
        Document mappingDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(mappingFile);
        NodeList mapEntries = mappingDoc.getElementsByTagName("ClassIcon");
        int i = 0;
        while (i < mapEntries.getLength()) {
            Node entry = mapEntries.item(i);
            String classname = entry.getAttributes().getNamedItem("class").getNodeValue();
            String iconname = entry.getAttributes().getNamedItem("iconname").getNodeValue();
            Class<?> clazz = Class.forName(classname);
            ImageIcon icon = IconManager.getIcon(iconname, IconManager.IconSize.Std24);
            this.classToIconMap.put(clazz, icon);
            ++i;
        }
        NodeList subMaps = mappingDoc.getElementsByTagName("SubMapper");
        int i2 = 0;
        while (i2 < subMaps.getLength()) {
            Class<?>[] handledClasses;
            Node entry = subMaps.item(i2);
            String classname = entry.getAttributes().getNamedItem("class").getNodeValue();
            ObjectIconMapper subMapper = Class.forName(classname).asSubclass(ObjectIconMapper.class).newInstance();
            Class<?>[] classArray = handledClasses = subMapper.getMappedClasses();
            int n = handledClasses.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz = classArray[n2];
                if (clazz != null) {
                    this.subMappers.put(clazz, subMapper);
                }
                ++n2;
            }
            ++i2;
        }
    }
}

