/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.AutoNumberingScheme;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.EditDeleteAddPanel;
import edu.ku.brc.ui.UIHelper;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class NumberingSchemeDlg
extends CustomDialog {
    private static final Logger log = Logger.getLogger(NumberingSchemeDlg.class);
    protected JList numSchemeList;
    protected JList nsCollList;
    protected JList availNSList;
    protected JButton mapToBtn;
    protected JButton unmapBtn;
    protected JComboBox typeCBX;
    protected boolean blockUpdate = false;
    protected EditDeleteAddPanel edaPanel;
    protected Hashtable<String, Vector<AutoNumberingScheme>> byFormatHash = new Hashtable();
    protected Hashtable<String, AutoNumberingScheme> byNameHash = new Hashtable();
    protected Hashtable<Integer, Division> allDivisions = new Hashtable();
    protected Hashtable<Integer, Collection> allCollections = new Hashtable();
    protected Vector<AutoNumberingScheme> ansToBeDeleted = new Vector();

    public NumberingSchemeDlg(Frame frame) throws HeadlessException {
        super(frame, "NS_NUM_SCHEME", true, 7, null);
    }

    @Override
    public void createUI() {
        block10: {
            super.createUI();
            this.mapToBtn = UIHelper.createIconBtn("Map", "WB_ADD_MAPPING_ITEM", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    NumberingSchemeDlg.this.removeFromCurrentANS();
                }
            });
            this.unmapBtn = UIHelper.createIconBtn("Unmap", "WB_REMOVE_MAPPING_ITEM", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    NumberingSchemeDlg.this.addToCurrentANS();
                }
            });
            this.typeCBX = UIHelper.createComboBox(new Object[]{"Catalog Numbers", "Acessions", "Other"});
            this.numSchemeList = UIHelper.createList(new DefaultListModel());
            this.nsCollList = UIHelper.createList(new DefaultListModel());
            this.availNSList = UIHelper.createList(new DefaultListModel());
            CellConstraints cc = new CellConstraints();
            PanelBuilder topPB = new PanelBuilder(new FormLayout("f:p:g", "f:p:g"));
            topPB.add((Component)UIHelper.createScrollPane(this.numSchemeList), cc.xy(1, 1));
            PanelBuilder middlePanel = new PanelBuilder(new FormLayout("c:p:g", "p, 2px, p"));
            middlePanel.add((Component)this.mapToBtn, cc.xy(1, 1));
            middlePanel.add((Component)this.unmapBtn, cc.xy(1, 3));
            JPanel btnPanel = middlePanel.getPanel();
            PanelBuilder outerMiddlePanel = new PanelBuilder(new FormLayout("c:p:g", "f:p:g, p, f:p:g"));
            outerMiddlePanel.add((Component)btnPanel, cc.xy(1, 2));
            PanelBuilder botPB = new PanelBuilder(new FormLayout("f:p:g,4px,p,4px,f:p:g", "p,2px,f:p:g"));
            botPB.add((Component)UIHelper.createLabel("Included in Auto Number Scheme"), cc.xy(1, 1));
            botPB.add((Component)UIHelper.createLabel("Available to be Added"), cc.xy(5, 1));
            botPB.add((Component)outerMiddlePanel.getPanel(), cc.xywh(3, 3, 1, 1));
            botPB.add((Component)UIHelper.createScrollPane(this.nsCollList), cc.xy(1, 3));
            botPB.add((Component)UIHelper.createScrollPane(this.availNSList), cc.xy(5, 3));
            PanelBuilder pb = new PanelBuilder(new FormLayout("p,f:p:g", "p,6px,p,2px,f:p:g,16px,f:p:g"));
            int y = 1;
            pb.add((Component)this.typeCBX, cc.xy(1, y));
            pb.add((Component)UIHelper.createLabel("Available Auto Numbering Schemes"), cc.xywh(1, y += 2, 1, 1));
            pb.add((Component)topPB.getPanel(), cc.xywh(1, y += 2, 2, 1));
            pb.add((Component)botPB.getPanel(), cc.xywh(1, y += 2, 2, 1));
            y += 2;
            pb.setDefaultDialogBorder();
            this.contentPanel = pb.getPanel();
            this.mainPanel.add(this.contentPanel, "Center");
            this.pack();
            this.numSchemeList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        NumberingSchemeDlg.this.ansSelected();
                        NumberingSchemeDlg.this.fillWithAvail();
                    }
                }
            });
            this.nsCollList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        NumberingSchemeDlg.this.updateMoveBtns(false);
                    }
                }
            });
            this.availNSList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        NumberingSchemeDlg.this.updateMoveBtns(true);
                    }
                }
            });
            this.typeCBX.setSelectedIndex(0);
            this.fillCatalogNumANS();
            this.typeCBX.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JComboBox cb = (JComboBox)e.getSource();
                    if (e.getStateChange() == 1) {
                        switch (cb.getSelectedIndex()) {
                            case -1: {
                                break;
                            }
                            case 0: {
                                NumberingSchemeDlg.this.fillCatalogNumANS();
                                break;
                            }
                            case 1: {
                                NumberingSchemeDlg.this.fillAccNumANS();
                                break;
                            }
                            case 2: {
                                NumberingSchemeDlg.this.fillOtherNumANS();
                            }
                        }
                    }
                }
            });
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            try {
                try {
                    for (Division div : session.getDataList("FROM Division")) {
                        div.forceLoad();
                        this.allDivisions.put(div.getId(), div);
                    }
                    for (Collection coll : session.getDataList("FROM Collection")) {
                        coll.forceLoad();
                        this.allCollections.put(coll.getId(), coll);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(NumberingSchemeDlg.class, ex);
                    if (session != null) {
                        session.close();
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (session != null) {
                    session.close();
                }
                throw throwable;
            }
            if (session != null) {
                session.close();
            }
        }
        this.okBtn.setEnabled(false);
    }

    private void updateMoveBtns(Boolean availSel) {
        if (!this.blockUpdate && availSel != null) {
            this.blockUpdate = true;
            if (availSel.booleanValue()) {
                if (this.availNSList.getSelectedIndex() > -1) {
                    this.unmapBtn.setEnabled(true);
                    this.nsCollList.clearSelection();
                } else {
                    this.unmapBtn.setEnabled(false);
                }
                this.mapToBtn.setEnabled(false);
            } else {
                if (this.nsCollList.getSelectedIndex() > -1) {
                    this.mapToBtn.setEnabled(true);
                    this.availNSList.clearSelection();
                } else {
                    this.mapToBtn.setEnabled(false);
                }
                this.unmapBtn.setEnabled(false);
            }
            this.blockUpdate = false;
        }
    }

    private void fillCatalogNumANS() {
        this.loadSchemes(CollectionObject.getClassTableId());
    }

    private void fillAccNumANS() {
        this.loadSchemes(Accession.getClassTableId());
    }

    private void fillOtherNumANS() {
        this.loadSchemes(0);
    }

    private void loadSchemes(int tableId) {
        DefaultListModel model = (DefaultListModel)this.numSchemeList.getModel();
        model.clear();
        this.byFormatHash.clear();
        this.byNameHash.clear();
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            try {
                String whereStr = tableId != 0 ? "tableNumber = " + tableId : "tableNumber <> " + Accession.getClassTableId() + " AND tableNumber <> " + CollectionObject.getClassTableId();
                List<?> schemes = session.getDataList("FROM AutoNumberingScheme WHERE " + whereStr);
                for (AutoNumberingScheme ans : schemes) {
                    model.addElement(ans);
                    ans.getCollections().size();
                    ans.getDivisions().size();
                    Vector<AutoNumberingScheme> list = this.byFormatHash.get(ans.getFormatName());
                    if (list == null) {
                        list = new Vector();
                        this.byFormatHash.put(ans.getFormatName(), list);
                    }
                    list.add(ans);
                    this.byNameHash.put(ans.getSchemeName(), ans);
                }
            }
            catch (Exception ex) {
                log.error((Object)ex);
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(NumberingSchemeDlg.class, ex);
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private void ansSelected() {
        Vector<AutoNumberingScheme> list;
        DefaultListModel model = (DefaultListModel)this.nsCollList.getModel();
        model.clear();
        int typeIndex = this.typeCBX.getSelectedIndex();
        AutoNumberingScheme ans = (AutoNumberingScheme)this.numSchemeList.getSelectedValue();
        if (ans != null) {
            if (typeIndex == 0) {
                for (Collection coll : ans.getCollections()) {
                    model.addElement(coll);
                }
            } else if (typeIndex == 1) {
                for (Division div : ans.getDivisions()) {
                    model.addElement(div);
                }
            }
        }
        model = (DefaultListModel)this.availNSList.getModel();
        model.clear();
        if (ans != null && (list = this.byFormatHash.get(ans.getFormatName())) != null) {
            for (AutoNumberingScheme availNS : list) {
                if (availNS == ans) continue;
                model.addElement(availNS);
            }
        }
    }

    private void fillWithAvail() {
        int typeIndex = this.typeCBX.getSelectedIndex();
        DefaultListModel model = (DefaultListModel)this.availNSList.getModel();
        model.clear();
        AutoNumberingScheme ans = (AutoNumberingScheme)this.numSchemeList.getSelectedValue();
        if (ans != null) {
            String ansFieldFormat = ans.getFormatName();
            HashSet<Integer> idSet = new HashSet<Integer>();
            if (typeIndex == 0) {
                for (Collection coll : ans.getCollections()) {
                    idSet.add(coll.getId());
                }
                for (Collection coll : this.allCollections.values()) {
                    AutoNumberingScheme othANS;
                    if (idSet.contains((int)coll.getId()) || coll.getNumberingSchemes().size() != 1 || !(othANS = coll.getNumberingSchemes().iterator().next()).getFormatName().equals(ansFieldFormat)) continue;
                    model.addElement(coll);
                }
            } else if (typeIndex == 1) {
                for (Division div : ans.getDivisions()) {
                    idSet.add(div.getId());
                }
                for (Division div : this.allDivisions.values()) {
                    AutoNumberingScheme othANS;
                    if (idSet.contains((int)div.getId()) || div.getNumberingSchemes().size() != 1 || !(othANS = div.getNumberingSchemes().iterator().next()).getFormatName().equals(ansFieldFormat)) continue;
                    model.addElement(div);
                }
            }
            idSet.clear();
        }
    }

    protected void removeFromCurrentANS() {
    }

    protected void addToCurrentANS() {
    }
}

