/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui;

import edu.ku.brc.af.ui.forms.formatters.DataObjDataField;
import edu.ku.brc.af.ui.forms.formatters.DataObjDataFieldFormatIFace;
import edu.ku.brc.af.ui.forms.formatters.DataObjSwitchFormatter;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.util.LatLonConverter;
import java.math.BigDecimal;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.StringUtils;

public class LocalityLatLonFormatter
implements DataObjDataFieldFormatIFace,
Cloneable {
    protected String name = null;
    protected LatLonConverter.LATLON latLonType = LatLonConverter.LATLON.Latitude;
    protected LatLonConverter.DEGREES_FORMAT degreesFMT = LatLonConverter.DEGREES_FORMAT.None;
    protected LatLonConverter.FORMAT format = LatLonConverter.FORMAT.DDDDDD;
    protected int which = 1;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init(String nameArg, Properties properties) {
        this.name = nameArg;
        String typeStr = properties.getProperty("type");
        if (!StringUtils.isNotEmpty((String)typeStr)) throw new RuntimeException("LocalityLatLonFormatter cannot be initialized without a 'type' param");
        if (typeStr.equals("Latitude")) {
            this.latLonType = LatLonConverter.LATLON.Latitude;
        } else {
            if (!typeStr.equals("Longitude")) throw new RuntimeException("LocalityLatLonFormatter must be initialized with 'type' as 'latitude' or 'longitude'");
            this.latLonType = LatLonConverter.LATLON.Longitude;
        }
        String dirStr = properties.getProperty("dir");
        this.degreesFMT = StringUtils.isNotEmpty((String)dirStr) ? (dirStr.equals("symbol") ? LatLonConverter.DEGREES_FORMAT.Symbol : (dirStr.equals("string") ? LatLonConverter.DEGREES_FORMAT.String : LatLonConverter.DEGREES_FORMAT.None)) : LatLonConverter.DEGREES_FORMAT.None;
        String formatStr = properties.getProperty("format");
        if (StringUtils.isNotEmpty((String)formatStr)) {
            if (formatStr.equals("DDMMMM")) {
                this.format = LatLonConverter.FORMAT.DDMMMM;
            } else if (formatStr.equals("DDMMSS")) {
                this.format = LatLonConverter.FORMAT.DDMMSS;
            }
            this.format = LatLonConverter.FORMAT.DDDDDD;
        } else {
            this.format = LatLonConverter.FORMAT.DDDDDD;
        }
        this.which = 1;
        String whichStr = properties.getProperty("which");
        if (!StringUtils.isNotEmpty((String)whichStr) || !whichStr.equals("2")) return;
        this.which = 2;
    }

    @Override
    public Class<?> getDataClass() {
        return Locality.class;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public boolean isDirectFormatter() {
        return true;
    }

    @Override
    public String getSingleField() {
        return null;
    }

    @Override
    public String format(Object dataValue) {
        int decimalFmtLen;
        BigDecimal value;
        if (dataValue == null) {
            return "";
        }
        if (!(dataValue instanceof Locality)) {
            throw new RuntimeException("The data value set into LocalityLatLonFormatter is not a Locality [" + dataValue.getClass().getSimpleName() + "]");
        }
        Locality locality = (Locality)dataValue;
        if (this.which == 1) {
            value = this.latLonType == LatLonConverter.LATLON.Latitude ? locality.getLatitude1() : locality.getLongitude1();
            decimalFmtLen = LatLonConverter.getDecimalLength(this.latLonType == LatLonConverter.LATLON.Latitude ? locality.getLat1text() : locality.getLong1text());
        } else {
            value = this.latLonType == LatLonConverter.LATLON.Latitude ? locality.getLatitude2() : locality.getLongitude2();
            decimalFmtLen = LatLonConverter.getDecimalLength(this.latLonType == LatLonConverter.LATLON.Latitude ? locality.getLat2text() : locality.getLong2text());
        }
        return LatLonConverter.format(value, this.latLonType, this.format, this.degreesFMT, decimalFmtLen);
    }

    @Override
    public String getValue() {
        return null;
    }

    @Override
    public void setValue(String value) {
    }

    @Override
    public DataObjDataField[] getFields() {
        return null;
    }

    @Override
    public void toXML(StringBuilder sb) {
        sb.append("          <external");
        XMLHelper.xmlAttr(sb, "class", this.getClass().getName());
        sb.append(">\n");
        sb.append("            <param");
        XMLHelper.xmlAttr(sb, "name", "type");
        sb.append(">");
        sb.append(this.latLonType.name());
        sb.append("</param>\n");
        sb.append("            <param");
        XMLHelper.xmlAttr(sb, "name", "dir");
        sb.append(">");
        sb.append("symbol");
        sb.append("</param>\n");
        sb.append("            <param");
        XMLHelper.xmlAttr(sb, "name", "dir");
        sb.append(">");
        sb.append(this.format.name());
        sb.append("</param>\n");
        sb.append("            <param");
        XMLHelper.xmlAttr(sb, "name", "which");
        sb.append(">");
        sb.append(this.which);
        sb.append("</param>\n");
        sb.append("          </external>\n");
    }

    @Override
    public void setTableAndFieldInfo() {
    }

    @Override
    public void setDataObjSwitchFormatter(DataObjSwitchFormatter objFormatter) {
    }

    @Override
    public JPanel getCustomEditor(ChangeListener l) {
        return null;
    }

    @Override
    public boolean isValid() {
        return false;
    }

    @Override
    public boolean isCustom() {
        return true;
    }

    @Override
    public boolean hasEditor() {
        return false;
    }

    @Override
    public String getLabel() {
        return "";
    }

    @Override
    public void doneEditting(boolean wasCancelled) {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

