/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.db.ViewBasedDisplayDialog;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.persist.FormCellField;
import edu.ku.brc.af.ui.forms.persist.FormCellFieldIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellIFace;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.af.ui.forms.validation.FormValidator;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.UIValidator;
import edu.ku.brc.af.ui.forms.validation.ValComboBoxFromQuery;
import edu.ku.brc.af.ui.forms.validation.ValFormattedTextFieldSingle;
import edu.ku.brc.af.ui.forms.validation.ValidationListener;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.Loan;
import edu.ku.brc.specify.datamodel.LoanPreparation;
import edu.ku.brc.specify.datamodel.LoanReturnPreparation;
import edu.ku.brc.specify.datamodel.Preparation;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.ui.LoanReturnInfo;
import edu.ku.brc.ui.ColorWrapper;
import edu.ku.brc.ui.DateWrapper;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.VerticalSeparator;
import edu.ku.brc.util.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.StringUtils;

public class LoanReturnDlg
extends JDialog {
    protected ColorWrapper requiredfieldcolor = AppPrefsCache.getColorWrapper("ui", "formatting", "requiredfieldcolor");
    protected DateWrapper scrDateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat");
    protected Loan loan;
    protected List<ColObjPanel> colObjPanels = new Vector<ColObjPanel>();
    protected JButton okBtn;
    protected JLabel summaryLabel;
    protected FormValidator validator = new FormValidator(null);
    protected ValComboBoxFromQuery agentCBX;
    protected boolean isCancelled = true;
    protected ValFormattedTextFieldSingle dateClosed;

    public LoanReturnDlg(Loan loan) {
        this.loan = loan;
        ImageIcon appIcon = IconManager.getIcon("AppIcon");
        if (appIcon != null) {
            this.setIconImage(appIcon.getImage());
        }
    }

    public boolean createUI() {
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            this.loan = session.merge(this.loan);
            this.setTitle(UIRegistry.getResourceString("LOANRET_TITLE"));
            this.validator.addValidationListener(new ValidationListener(){

                @Override
                public void wasValidated(UIValidator val) {
                    LoanReturnDlg.this.doEnableOKBtn();
                }
            });
            JPanel contentPanel = new JPanel(new BorderLayout());
            JPanel mainPanel = new JPanel();
            System.out.println("Num Loan Preps for Loan: " + this.loan.getLoanPreparations());
            HashMap<Integer, Pair<CollectionObject, Vector>> colObjHash = new HashMap<Integer, Pair<CollectionObject, Vector>>();
            for (LoanPreparation loanPrep : this.loan.getLoanPreparations()) {
                CollectionObject colObj = loanPrep.getPreparation().getCollectionObject();
                System.out.println("For LoanPrep ColObj Is: " + colObj.getIdentityTitle());
                Vector list = null;
                Pair pair = (Pair)colObjHash.get(colObj.getId());
                if (pair == null) {
                    list = new Vector();
                    colObjHash.put(colObj.getId(), new Pair<CollectionObject, Vector>(colObj, list));
                } else {
                    list = (Vector)pair.second;
                }
                list.add(loanPrep);
            }
            int colObjCnt = colObjHash.size();
            String rowDef = UIHelper.createDuplicateJGoodiesDef("p", "1px,p,4px", colObjCnt * 2 - 1);
            PanelBuilder pbuilder = new PanelBuilder(new FormLayout("f:p:g", rowDef), mainPanel);
            CellConstraints cc = new CellConstraints();
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    LoanReturnDlg.this.doEnableOKBtn();
                }
            };
            ChangeListener cl = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ae) {
                    LoanReturnDlg.this.doEnableOKBtn();
                }
            };
            int i = 0;
            int y = 1;
            Vector pairList = new Vector(colObjHash.values());
            Collections.sort(pairList, new Comparator<Pair<CollectionObject, Vector<LoanPreparation>>>(){

                @Override
                public int compare(Pair<CollectionObject, Vector<LoanPreparation>> o1, Pair<CollectionObject, Vector<LoanPreparation>> o2) {
                    return ((CollectionObject)o1.first).getIdentityTitle().compareTo(((CollectionObject)o2.first).getIdentityTitle());
                }
            });
            for (Pair pair : pairList) {
                CollectionObject co = (CollectionObject)pair.first;
                if (i > 0) {
                    pbuilder.addSeparator("", cc.xy(1, y));
                    y += 2;
                }
                ColObjPanel panel = new ColObjPanel(session, this, co, (List)((Pair)colObjHash.get((Object)co.getId())).second);
                this.colObjPanels.add(panel);
                panel.addActionListener(al, cl);
                pbuilder.add((Component)panel, cc.xy(1, y));
                y += 2;
                ++i;
            }
            JButton selectAllBtn = UIHelper.createButton(UIRegistry.getResourceString("SELECTALL"));
            this.okBtn = UIHelper.createButton(UIRegistry.getResourceString("SAVE"));
            JButton cancel = UIHelper.createButton(UIRegistry.getResourceString("CANCEL"));
            PanelBuilder pb = new PanelBuilder(new FormLayout("p,2px,p,2px,p,2px,p,2px,p,2px,p", "p"));
            this.dateClosed = new ValFormattedTextFieldSingle("Date", false, false, 10);
            this.dateClosed.setNew(true);
            this.dateClosed.setValue(null, "");
            this.dateClosed.setRequired(true);
            this.validator.hookupTextField(this.dateClosed, "2", true, UIValidator.Type.Changed, "", false);
            this.summaryLabel = UIHelper.createLabel("");
            pb.add((Component)this.summaryLabel, cc.xy(1, 1));
            pb.add((Component)UIHelper.createI18NLabel("LOANRET_AGENT"), cc.xy(3, 1));
            this.agentCBX = this.createAgentCombobox();
            pb.add((Component)this.agentCBX, cc.xy(5, 1));
            pb.add((Component)UIHelper.createI18NLabel("ON"), cc.xy(7, 1));
            pb.add((Component)this.dateClosed, cc.xy(9, 1));
            contentPanel.add((Component)pb.getPanel(), "North");
            contentPanel.add(new JScrollPane(mainPanel, 20, 31));
            JPanel p = new JPanel(new BorderLayout());
            p.setBorder(BorderFactory.createEmptyBorder(5, 0, 2, 0));
            p.add((Component)ButtonBarFactory.buildOKCancelApplyBar((JButton)this.okBtn, (JButton)cancel, (JButton)selectAllBtn), "Center");
            contentPanel.add((Component)p, "South");
            contentPanel.setBorder(BorderFactory.createEmptyBorder(4, 12, 2, 12));
            this.setContentPane(contentPanel);
            this.doEnableOKBtn();
            this.setDefaultCloseOperation(2);
            this.doEnableOKBtn();
            this.okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    LoanReturnDlg.this.setVisible(false);
                    LoanReturnDlg.this.isCancelled = false;
                }
            });
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    LoanReturnDlg.this.setVisible(false);
                }
            });
            selectAllBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    LoanReturnDlg.this.selectAllItems();
                }
            });
            this.pack();
            Dimension size = this.getPreferredSize();
            size.width += 20;
            size.height = size.height > 500 ? 500 : size.height;
            this.setSize(size);
            return true;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(LoanReturnDlg.class, ex);
            ex.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return false;
    }

    protected void doEnableOKBtn() {
        int retCnt = 0;
        int resCnt = 0;
        for (ColObjPanel colObjPanel : this.colObjPanels) {
            retCnt += colObjPanel.getReturnedCount();
            resCnt += colObjPanel.getResolvedCount();
        }
        this.okBtn.setEnabled((retCnt > 0 || resCnt > 0) && this.agentCBX.getValue() != null && this.dateClosed.getValue() != null);
        this.summaryLabel.setText(String.format(UIRegistry.getResourceString("LOANRET_NUM_ITEMS_2B_RET_FMT"), retCnt, resCnt));
    }

    protected ValComboBoxFromQuery createAgentCombobox() {
        FormCellField fcf = new FormCellField(FormCellIFace.CellType.field, "1", "agent", FormCellFieldIFace.FieldType.querycbx, FormCellFieldIFace.FieldType.querycbx, "", "Agent", "", true, 1, 1, 1, 1, "Changed", null, false);
        fcf.addProperty("name", "Agent");
        fcf.addProperty("title", UIRegistry.getResourceString("LOANRET_AGENT_DO_RET_TITLE"));
        ValComboBoxFromQuery cbx = ViewFactory.createQueryComboBox(this.validator, fcf, true, true);
        cbx.setAsNew(true);
        cbx.setState(UIValidatable.ErrorType.Incomplete);
        return cbx;
    }

    protected void selectAllItems() {
        for (ColObjPanel colObjPanel : this.colObjPanels) {
            for (PrepPanel pp : colObjPanel.getPanels()) {
                pp.selectAllItems();
            }
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public Agent getAgent() {
        return (Agent)this.agentCBX.getValue();
    }

    public Calendar getDate() {
        return (Calendar)this.dateClosed.getValue();
    }

    public List<LoanReturnInfo> getLoanReturnInfo() {
        Vector<LoanReturnInfo> returns = new Vector<LoanReturnInfo>();
        for (ColObjPanel colObjPanel : this.colObjPanels) {
            for (PrepPanel pp : colObjPanel.getPanels()) {
                if (pp.getReturnedCount() <= 0 && pp.getResolvedCount() <= 0) continue;
                returns.add(pp.getLoanReturnInfo());
            }
        }
        return returns;
    }

    class ColObjPanel
    extends JPanel {
        protected CollectionObject colObj;
        protected JCheckBox checkBox;
        protected Vector<PrepPanel> panels = new Vector();
        protected JDialog dlgParent;

        public ColObjPanel(DataProviderSessionIFace session, JDialog dlgParent, CollectionObject colObj, List<LoanPreparation> lpoList) {
            this.dlgParent = dlgParent;
            this.colObj = colObj;
            session.attach(colObj);
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            PanelBuilder pbuilder = new PanelBuilder(new FormLayout("f:p:g", "p,5px,p"), (JPanel)this);
            CellConstraints cc = new CellConstraints();
            String taxonName = "";
            for (Determination deter : colObj.getDeterminations()) {
                if (!deter.isCurrentDet()) continue;
                if (deter.getPreferredTaxon() != null) {
                    if (deter.getPreferredTaxon().getFullName() == null) {
                        Taxon parent = deter.getPreferredTaxon().getParent();
                        String genus = parent.getFullName() == null ? parent.getName() : parent.getFullName();
                        taxonName = String.valueOf(genus) + " " + deter.getPreferredTaxon().getName();
                        break;
                    }
                    taxonName = deter.getPreferredTaxon().getFullName();
                    break;
                }
                taxonName = UIRegistry.getResourceString("LOAN_NOT_DET");
                break;
            }
            String descr = String.format("%s - %s", colObj.getIdentityTitle(), taxonName);
            descr = StringUtils.stripToEmpty((String)descr);
            this.checkBox = UIHelper.createCheckBox(descr);
            pbuilder.add((Component)UIHelper.createLabel(descr), cc.xy(1, 1));
            this.checkBox.setSelected(true);
            JPanel outerPanel = new JPanel();
            outerPanel.setLayout(new BoxLayout(outerPanel, 1));
            outerPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            JPanel contentPanel = new JPanel();
            contentPanel.setLayout(new BoxLayout(contentPanel, 1));
            outerPanel.add(contentPanel);
            Color[] colors = new Color[]{new Color(255, 255, 255), new Color(235, 235, 255)};
            System.out.println(String.valueOf(colObj.getIdentityTitle()) + "  lpoList.size: " + lpoList.size());
            int i = 0;
            for (LoanPreparation lpo : lpoList) {
                PrepPanel pp = new PrepPanel(dlgParent, lpo);
                this.panels.add(pp);
                pp.setBackground(colors[i % 2]);
                contentPanel.add(pp);
                ++i;
            }
            pbuilder.add((Component)outerPanel, cc.xy(1, 3));
            this.checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    for (PrepPanel pp : ColObjPanel.this.panels) {
                        pp.setEnabled(ColObjPanel.this.checkBox.isSelected());
                    }
                    ColObjPanel.this.repaint();
                }
            });
        }

        public void addActionListener(ActionListener al, ChangeListener cl) {
            this.checkBox.addActionListener(al);
            for (PrepPanel pp : this.panels) {
                pp.addChangeListener(cl);
            }
        }

        public JCheckBox getCheckBox() {
            return this.checkBox;
        }

        public int getReturnedCount() {
            int count = 0;
            if (this.checkBox.isSelected()) {
                for (PrepPanel pp : this.panels) {
                    count += pp.getReturnedCount();
                }
            }
            return count;
        }

        public int getResolvedCount() {
            int count = 0;
            if (this.checkBox.isSelected()) {
                for (PrepPanel pp : this.panels) {
                    count += pp.getResolvedCount();
                }
            }
            return count;
        }

        public Vector<PrepPanel> getPanels() {
            return this.panels;
        }
    }

    class PrepPanel
    extends JPanel
    implements ActionListener {
        protected Preparation prep;
        protected LoanPreparation lpo;
        protected JLabel label = null;
        protected JLabel retLabel = null;
        protected JLabel resLabel = null;
        protected JComponent prepInfoBtn = null;
        protected JSpinner returnedSpinner;
        protected JSpinner resolvedSpinner;
        protected JDialog parent;
        protected JTextField remarks;
        protected int quantityReturned;
        protected int quantityResolved;
        protected int quantityLoaned;
        protected int maxValue = 0;
        protected boolean unknownQuantity;

        public PrepPanel(JDialog parent, LoanPreparation lpo) {
            this.prep = lpo.getPreparation();
            this.lpo = lpo;
            this.parent = parent;
            Color color = new Color(192, 192, 192);
            Color bg = color.darker();
            Color fg = color.brighter();
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            FormLayout fl = new FormLayout("max(120px;p),p,max(50px;p),2px,p,p,max(50px;p),2px,p,p,f:p:g", "f:p:g,2px,p");
            PanelBuilder pbuilder = new PanelBuilder(fl, (JPanel)this);
            CellConstraints cc = new CellConstraints();
            int x = 1;
            this.label = UIHelper.createLabel(this.prep.getPrepType().getName());
            pbuilder.add((Component)this.label, cc.xy(x, 1));
            this.label.setOpaque(false);
            pbuilder.add((Component)new VerticalSeparator(fg, bg, 20), cc.xy(++x, 1));
            ++x;
            boolean allReturned = false;
            if (this.prep.getCountAmt() != null) {
                this.quantityLoaned = lpo.getQuantity();
                this.quantityReturned = lpo.getQuantityReturned();
                this.quantityResolved = lpo.getQuantityResolved();
                int quantityResOut = this.quantityLoaned - this.quantityResolved;
                int quantityRetOut = this.quantityLoaned - this.quantityReturned;
                if (!(quantityResOut <= 0 && quantityRetOut <= 0 || lpo.getIsResolved().booleanValue())) {
                    this.maxValue = this.quantityLoaned;
                    SpinnerNumberModel retModel = new SpinnerNumberModel(this.quantityReturned, this.quantityReturned, this.quantityLoaned, 1);
                    this.returnedSpinner = new JSpinner(retModel);
                    this.fixBGOfJSpinner(this.returnedSpinner);
                    pbuilder.add((Component)this.returnedSpinner, cc.xy(x, 1));
                    UIHelper.setControlSize(this.returnedSpinner);
                    String fmtStr = String.format(UIRegistry.getResourceString("LOANRET_OF_FORMAT_RET"), this.quantityLoaned);
                    this.retLabel = UIHelper.createLabel(fmtStr);
                    pbuilder.add((Component)this.retLabel, cc.xy(x += 2, 1));
                    pbuilder.add((Component)new VerticalSeparator(fg, bg, 20), cc.xy(++x, 1));
                    SpinnerNumberModel resModel = new SpinnerNumberModel(this.quantityResolved, this.quantityResolved, this.quantityLoaned, 1);
                    this.resolvedSpinner = new JSpinner(resModel);
                    this.fixBGOfJSpinner(this.resolvedSpinner);
                    pbuilder.add((Component)this.resolvedSpinner, cc.xy(++x, 1));
                    UIHelper.setControlSize(this.resolvedSpinner);
                    fmtStr = String.format(UIRegistry.getResourceString("LOANRET_OF_FORMAT_RES"), this.quantityLoaned);
                    this.retLabel = UIHelper.createLabel(fmtStr);
                    pbuilder.add((Component)this.retLabel, cc.xy(x += 2, 1));
                    ++x;
                    ChangeListener cl = new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            int lrpResolvedQty = (Integer)PrepPanel.this.resolvedSpinner.getValue();
                            int lrpReturnedQty = (Integer)PrepPanel.this.returnedSpinner.getValue();
                            if (e != null) {
                                if (e.getSource() == PrepPanel.this.resolvedSpinner) {
                                    if (lrpResolvedQty < lrpReturnedQty) {
                                        final int qty = lrpReturnedQty = lrpResolvedQty;
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                (this).PrepPanel.this.returnedSpinner.setValue(qty);
                                            }
                                        });
                                    }
                                } else if (e.getSource() == PrepPanel.this.returnedSpinner && lrpReturnedQty > lrpResolvedQty) {
                                    lrpResolvedQty = lrpReturnedQty;
                                    final int qty = lrpReturnedQty;
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            (this).PrepPanel.this.resolvedSpinner.setValue(qty);
                                        }
                                    });
                                }
                            }
                        }
                    };
                    this.returnedSpinner.addChangeListener(cl);
                    this.resolvedSpinner.addChangeListener(cl);
                } else {
                    Calendar lastReturnDate = null;
                    for (LoanReturnPreparation lrpo : lpo.getLoanReturnPreparations()) {
                        Calendar retDate = lrpo.getReturnedDate();
                        if (retDate == null) continue;
                        if (lastReturnDate == null) {
                            lastReturnDate = lrpo.getReturnedDate();
                            continue;
                        }
                        if (!retDate.after(lastReturnDate)) continue;
                        lastReturnDate = retDate;
                    }
                    String fmtStr = lastReturnDate == null ? UIRegistry.getResourceString("LOANRET_ALL_RETURNED") : String.format(UIRegistry.getResourceString("LOANRET_ALL_RETURNED_ON_FMT"), LoanReturnDlg.this.scrDateFormat.format(lastReturnDate));
                    this.retLabel = UIHelper.createLabel(fmtStr);
                    pbuilder.add((Component)this.retLabel, cc.xy(x, 1));
                    allReturned = true;
                }
            } else {
                this.retLabel = UIHelper.createLabel(" " + UIRegistry.getResourceString("LOANRET_UNKNOWN_NUM_AVAIL"));
                pbuilder.add((Component)this.retLabel, cc.xywh(1, 1, 4, 1));
                this.unknownQuantity = true;
            }
            if (!allReturned) {
                this.remarks = new RemarksText();
                pbuilder.add((Component)this.remarks, cc.xywh(1, 3, 11, 1));
            }
        }

        protected void fixBGOfJSpinner(JSpinner spin) {
            JComponent edComp = spin.getEditor();
            int i = 0;
            while (i < edComp.getComponentCount()) {
                Component c = edComp.getComponent(i);
                if (c instanceof JTextField) {
                    c.setBackground(LoanReturnDlg.this.requiredfieldcolor.getColor());
                }
                ++i;
            }
        }

        public boolean isUnknownQuantity() {
            return this.unknownQuantity;
        }

        public void selectAllItems() {
            if (this.returnedSpinner != null) {
                this.returnedSpinner.setValue(this.quantityLoaned);
            }
            if (this.resolvedSpinner != null) {
                this.resolvedSpinner.setValue(this.quantityLoaned);
            }
        }

        public LoanPreparation getLoanPreparation() {
            return this.lpo;
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (this.label != null) {
                this.label.setEnabled(enabled);
            }
            if (this.retLabel != null) {
                this.retLabel.setEnabled(enabled);
            }
            if (this.resLabel != null) {
                this.resLabel.setEnabled(enabled);
            }
            if (this.prepInfoBtn != null) {
                this.prepInfoBtn.setEnabled(enabled);
            }
            if (this.returnedSpinner != null) {
                this.returnedSpinner.setEnabled(enabled);
            }
        }

        public void addChangeListener(ChangeListener cl) {
            if (this.returnedSpinner != null) {
                this.returnedSpinner.addChangeListener(cl);
            }
            if (this.resolvedSpinner != null) {
                this.resolvedSpinner.addChangeListener(cl);
            }
        }

        public int getReturnedCount() {
            if (this.returnedSpinner != null) {
                Object valObj = this.returnedSpinner.getValue();
                return valObj == null ? 0 : (Integer)valObj;
            }
            return 0;
        }

        public int getResolvedCount() {
            if (this.resolvedSpinner != null) {
                Object valObj = this.resolvedSpinner.getValue();
                return valObj == null ? 0 : (Integer)valObj;
            }
            return 0;
        }

        public LoanReturnInfo getLoanReturnInfo() {
            return new LoanReturnInfo(this.lpo, this.remarks != null ? this.remarks.getText() : null, this.getReturnedCount(), this.getResolvedCount(), this.getResolvedCount() == this.quantityLoaned);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FormViewObj formViewObj;
            Component comp;
            ViewIFace view;
            ViewBasedDisplayDialog dlg;
            MultiView mv;
            Viewable currentViewable;
            Vector<Loan> loans;
            block10: {
                loans = new Vector<Loan>();
                DataProviderSessionIFace session = null;
                try {
                    try {
                        session = DataProviderFactory.getInstance().createSession();
                        session.attach(this.prep);
                        for (LoanPreparation loanPO : this.prep.getLoanPreparations()) {
                            loans.add(loanPO.getLoan());
                        }
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(LoanReturnDlg.class, ex);
                        ex.printStackTrace();
                        if (session != null) {
                            session.close();
                        }
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        session.close();
                    }
                    throw throwable;
                }
                if (session != null) {
                    session.close();
                }
            }
            if ((currentViewable = (mv = (dlg = new ViewBasedDisplayDialog(this.parent, (view = AppContextMgr.getInstance().getView("Loan")).getViewSetName(), "Loan", null, UIRegistry.getResourceString("LoanSelectPrepsDlg.IAT_LOAN_REVIEW"), UIRegistry.getResourceString("CLOSE"), null, null, false, 1)).getMultiView()).getCurrentView()) != null && currentViewable instanceof FormViewObj && (comp = (formViewObj = (FormViewObj)currentViewable).getControlByName("generateInvoice")) instanceof JCheckBox) {
                comp.setVisible(false);
            }
            dlg.setModal(true);
            dlg.setData(loans);
            dlg.setVisible(true);
        }
    }

    class RemarksText
    extends JTextField {
        protected Insets inner;
        protected String bgStr = UIRegistry.getResourceString("LOANRET_REMARKS");
        protected Point pnt = null;
        protected Color textColor = new Color(0, 0, 0, 64);

        public RemarksText() {
            this.inner = this.getInsets();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            String text = this.getText();
            if (text == null || text.length() == 0) {
                if (this.pnt == null) {
                    FontMetrics fm = g.getFontMetrics();
                    this.pnt = new Point(this.inner.left, this.inner.top + fm.getAscent());
                }
                g.setColor(this.textColor);
                g.drawString(this.bgStr, this.pnt.x, this.pnt.y);
            }
        }
    }
}

