/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui;

import edu.ku.brc.ui.UIRegistry;
import java.awt.Toolkit;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class LengthInputVerifier
extends InputVerifier {
    protected String caption;
    protected int maxLength;

    public LengthInputVerifier(String caption, int maxLength) {
        this.caption = caption;
        this.maxLength = maxLength;
    }

    @Override
    public boolean verify(JComponent comp) {
        boolean isOK;
        String text = null;
        if (comp instanceof JTextComponent) {
            text = ((JTextComponent)comp).getText();
        } else if (comp instanceof JComboBox) {
            text = ((JComboBox)comp).getSelectedItem().toString();
        }
        boolean bl = isOK = text == null || text.length() <= this.maxLength;
        if (!isOK) {
            String msg = String.format(UIRegistry.getResourceString("UI_NEWDATA_TOO_LONG"), this.caption, this.maxLength);
            UIRegistry.getStatusBar().setErrorMessage(msg);
            Toolkit.getDefaultToolkit().beep();
        } else {
            UIRegistry.getStatusBar().setText("");
        }
        return isOK;
    }
}

