/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui;

import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.Specify;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Hashtable;
import javax.help.BadIDException;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.Map;
import javax.help.WindowPresentation;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class HelpMgr {
    private static final Logger log = Logger.getLogger(HelpMgr.class);
    protected static HelpSet hs;
    protected static HelpBroker hb;
    protected static String helpSystemName;
    protected static String loadingPage;
    protected static String appDefHelpId;
    protected static Hashtable<Component, String> compHelpHash;

    static {
        loadingPage = null;
        appDefHelpId = "About";
        compHelpHash = new Hashtable();
    }

    public static void initializeHelp(String helpName, Image frameIcon) {
        helpSystemName = helpName;
        ClassLoader cl = Specify.class.getClassLoader();
        try {
            URL hsURL = HelpSet.findHelpSet((ClassLoader)cl, (String)helpName);
            hs = new HelpSet(cl, hsURL);
        }
        catch (Exception ee) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(HelpMgr.class, ee);
            log.error((Object)ee);
            return;
        }
        hb = hs.createHelpBroker();
        hb.setFont(new Font("SansSerif", 0, 12));
        if (frameIcon != null && hb instanceof DefaultHelpBroker) {
            DefaultHelpBroker dhb = (DefaultHelpBroker)hb;
            WindowPresentation pres = dhb.getWindowPresentation();
            pres.createHelpWindow();
            Window window = pres.getHelpWindow();
            if (window instanceof JFrame) {
                ((JFrame)window).setIconImage(frameIcon);
            }
        }
    }

    public static void setAppDefHelpId(String appDefHelpId) {
        HelpMgr.appDefHelpId = appDefHelpId;
    }

    public static void setLoadingPage(String loadingPage) {
        HelpMgr.loadingPage = loadingPage;
    }

    public static JMenu createHelpMenuItem(JMenu helpMenu, String helpMenuName) {
        if (helpMenu != null) {
            JMenuItem mainHelpMenuItem = new JMenuItem(helpMenuName);
            mainHelpMenuItem.setAccelerator(KeyStroke.getKeyStroke("F1"));
            helpMenu.add(mainHelpMenuItem);
            HelpMgr.registerComponent((AbstractButton)mainHelpMenuItem, true);
        }
        return helpMenu;
    }

    public static boolean helpAvailable() {
        return hb != null;
    }

    private static boolean isGoodID(String id) {
        try {
            Map.ID.create((String)id, (HelpSet)hs);
            return true;
        }
        catch (BadIDException e) {
            JOptionPane.showMessageDialog(null, "No mapping for '" + id + "'");
            return false;
        }
    }

    public static void registerComponent(Component component, String idString) {
        compHelpHash.put(component, idString);
    }

    public static void registerComponent(AbstractButton component, final String idString) {
        if (HelpMgr.helpAvailable()) {
            ActionListener[] actionListenerArray = component.getActionListeners();
            int n = actionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionListener l = actionListenerArray[n2];
                component.removeActionListener(l);
                ++n2;
            }
            if (HelpMgr.isGoodID(idString)) {
                component.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        HelpMgr.displayHelp(HelpMgr.getMapID(idString));
                    }
                });
            } else {
                log.warn((Object)("No mapping for '" + idString + "'. Defaulting to '" + HelpMgr.getDefaultID() + "'"));
            }
            if (!HelpMgr.isGoodID(idString)) {
                component.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        UIRegistry.displayErrorDlg("No mapping for '" + idString + "'");
                    }
                });
            }
            component.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    UsageTracker.incrUsageCount("ShowHelp");
                }
            });
        } else {
            component.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showConfirmDialog(null, UIRegistry.getResourceString("HelpSystemNotLocated"), UIRegistry.getResourceString("HELP"), -1);
                }
            });
        }
    }

    public static void setHelpID(Component component, String idString) {
        compHelpHash.put(component, idString);
    }

    public static void registerComponent(AbstractButton component, boolean focusListener) {
        if (HelpMgr.helpAvailable()) {
            component.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HelpMgr.getHelpForContext();
                }
            });
        } else {
            component.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showConfirmDialog(null, UIRegistry.getResourceString("HelpSystemNotLocated"), UIRegistry.getResourceString("HELP"), -1);
                }
            });
        }
    }

    private static String getCurrentContext() {
        try {
            if (ContextMgr.getCurrentContext() != null) {
                log.debug((Object)ContextMgr.getCurrentContext().getName());
                return ContextMgr.getCurrentContext().getName();
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return HelpMgr.getDefaultID();
        }
    }

    private static String getDefaultID() {
        return appDefHelpId;
    }

    private static Map.ID getMapID(String id) {
        try {
            return Map.ID.create((String)id, (HelpSet)hs);
        }
        catch (BadIDException e) {
            try {
                UIRegistry.displayErrorDlg("No mapping for '" + id + "'. Defaulting to '" + HelpMgr.getDefaultID() + "'");
                log.warn((Object)("No mapping for '" + id + "'. Defaulting to '" + HelpMgr.getDefaultID() + "'"));
                return Map.ID.create((String)HelpMgr.getDefaultID(), (HelpSet)hs);
            }
            catch (BadIDException e2) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(HelpMgr.class, (Exception)((Object)e2));
                return null;
            }
        }
    }

    private static void helpless() {
        JOptionPane.showConfirmDialog(null, UIRegistry.getResourceString("NoHelpForContext"), UIRegistry.getResourceString("HELP"), -1);
    }

    public static void getHelpForContext() {
        SubPaneIFace subPane;
        String helpTarget = null;
        Component focusComp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusComp != null) {
            helpTarget = compHelpHash.get(focusComp);
        }
        if (helpTarget == null && (helpTarget = (subPane = SubPaneMgr.getInstance().getCurrentSubPane()) != null ? subPane.getHelpTarget() : HelpMgr.getCurrentContext()) == null) {
            helpTarget = HelpMgr.getDefaultID();
        }
        if (helpTarget != null) {
            HelpMgr.displayHelp(HelpMgr.getMapID(helpTarget));
        } else {
            HelpMgr.helpless();
        }
    }

    protected static void displayHelp(Map.ID id) {
        if (id == null) {
            HelpMgr.helpless();
        } else {
            try {
                if (hb.isDisplayed()) {
                    hb.setDisplayed(false);
                }
                if (loadingPage != null) {
                    hb.setCurrentID(HelpMgr.getMapID(loadingPage));
                }
                hb.setCurrentID(id);
                Window fWin = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
                ((DefaultHelpBroker)hb).setActivationWindow(fWin);
                if (!hb.isDisplayed()) {
                    hb.setDisplayed(true);
                }
            }
            catch (InvalidHelpSetContextException e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(HelpMgr.class, (Exception)((Object)e));
                HelpMgr.helpless();
            }
        }
    }

    public static HelpBroker getHb() {
        return hb;
    }

    public static String getHelpSystemName() {
        return helpSystemName;
    }

    public static HelpSet getHs() {
        return hs;
    }
}

