/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.expresssearch.ExpressResultsTableInfo;
import edu.ku.brc.af.core.expresssearch.ExpressSearchConfigCache;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.core.expresssearch.QueryForIdResultsSQL;
import edu.ku.brc.af.ui.ESTermParser;
import edu.ku.brc.af.ui.SearchTermField;
import edu.ku.brc.af.ui.db.ERTICaptionInfo;
import edu.ku.brc.af.ui.db.QueryForIdResultsIFace;
import edu.ku.brc.af.ui.db.ViewBasedSearchQueryBuilderIFace;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.persist.FormCellFieldIFace;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.tasks.subpane.ESResultsTablePanel;
import edu.ku.brc.specify.tasks.subpane.ESResultsTablePanelIFace;
import edu.ku.brc.specify.tasks.subpane.ExpressSearchResultsPaneIFace;
import edu.ku.brc.specify.ui.DBObjSearchDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DBObjSearchPanel
extends JPanel
implements ExpressSearchResultsPaneIFace,
PropertyChangeListener {
    private static final Logger log = Logger.getLogger(DBObjSearchDialog.class);
    protected SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    protected ViewIFace formView = null;
    protected Viewable form = null;
    protected List<String> fieldIds = new ArrayList<String>();
    protected List<String> fieldNames = new ArrayList<String>();
    protected ActionListener doQuery = null;
    protected String className;
    protected String idFieldName;
    protected String searchName;
    protected String fieldName;
    protected JButton okBtn;
    protected JTextField searchText;
    protected JPanel panel;
    protected JScrollPane scrollPane;
    protected JButton searchBtn;
    protected Color textBGColor = null;
    protected Color badSearchColor = new Color(255, 235, 235);
    protected Hashtable<String, ExpressResultsTableInfo> tables = new Hashtable();
    protected ExpressResultsTableInfo esTableInfo;
    protected ESResultsTablePanelIFace etrb = null;
    protected List<Integer> idList = null;
    protected String sqlStr;
    protected Hashtable<String, Object> dataMap = new Hashtable();
    protected ViewBasedSearchQueryBuilderIFace queryBuilder = null;
    protected QueryForIdResultsIFace queryForIdResults = null;
    protected boolean isMultipleSelection = true;

    public DBObjSearchPanel(String viewSetName, String viewName, String searchName, String className, String idFieldName, int searchBtnPos) throws HeadlessException {
        super(new BorderLayout());
        this.className = className;
        this.idFieldName = idFieldName;
        this.searchName = searchName;
        this.init();
        String rowDef = searchBtnPos == 1 ? "t:p" : (searchBtnPos == 3 ? "b:p" : "p");
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g,1dlu,p", String.valueOf(rowDef) + ",2px,p,10px,p"));
        CellConstraints cc = new CellConstraints();
        this.formView = AppContextMgr.getInstance().getView(viewSetName, viewName);
        if (this.formView != null) {
            this.form = ViewFactory.createFormView(null, this.formView, null, this.dataMap, 0, null);
        } else {
            log.error((Object)("Couldn't load form with name [" + viewSetName + "] Id [" + viewName + "]"));
        }
        if (this.form != null) {
            this.fieldIds = new ArrayList<String>();
            this.form.getFieldIds(this.fieldIds);
            for (String id : this.fieldIds) {
                Component comp = (Component)this.form.getCompById(id);
                if (!(comp instanceof JTextField)) continue;
                ((JTextField)comp).addActionListener(this.doQuery);
            }
            this.form.getFieldNames(this.fieldNames);
            this.createSearchBtn();
            pb.add(this.form.getUIComponent(), cc.xy(1, 1));
            pb.add((Component)this.searchBtn, cc.xy(3, 1));
            pb.add((Component)UIHelper.createI18NLabel("DBObjSearchPanel.ASTERISK_HINT"), cc.xyw(1, 3, 3));
            pb.addSeparator(UIRegistry.getResourceString("DBObjSearchPanel.RESULTS"), cc.xyw(1, 5, 3));
            this.add((Component)pb.getPanel(), "North");
            this.createUI();
        } else {
            log.error((Object)("ViewSet [" + viewSetName + "] View[" + viewName + "] could not be created."));
        }
    }

    public DBObjSearchPanel(String fieldName, String className, String idFieldName) throws HeadlessException {
        super(new BorderLayout());
        this.className = className;
        this.idFieldName = idFieldName;
        this.fieldName = fieldName;
        this.init();
        this.searchText = new JTextField(30);
        this.searchText.addActionListener(this.doQuery);
        this.searchText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (DBObjSearchPanel.this.searchText.getBackground() != DBObjSearchPanel.this.textBGColor) {
                    DBObjSearchPanel.this.searchText.setBackground(DBObjSearchPanel.this.textBGColor);
                }
            }
        });
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,1dlu,p", "p,2dlu,p,2dlu,p"));
        CellConstraints cc = new CellConstraints();
        pb.add((Component)this.searchText, cc.xy(1, 1));
        pb.add((Component)this.searchBtn, cc.xy(3, 1));
        this.add((Component)pb.getPanel(), "North");
        this.createUI();
    }

    public String getSearchName() {
        return this.searchName;
    }

    protected void getDataFromUI() {
        if (this.form != null) {
            this.form.getDataFromUI();
        } else {
            this.dataMap.put(this.fieldName, this.searchText.getText().trim());
        }
    }

    protected void init() {
        this.doQuery = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBObjSearchPanel.this.doStartQuery((JComponent)e.getSource());
            }
        };
        if (this.queryBuilder == null) {
            ExpressResultsTableInfo esTblInfo = ExpressSearchConfigCache.getTableInfoByName(this.searchName);
            if (esTblInfo != null) {
                this.esTableInfo = esTblInfo;
                this.esTableInfo.setViewSQLOverridden(true);
                this.tables.put(this.esTableInfo.getTableId(), this.esTableInfo);
                this.sqlStr = this.esTableInfo.getViewSql();
            } else {
                throw new RuntimeException("Couldn't find search name[" + this.searchName + "] in the search_config.xml");
            }
        }
    }

    protected void createSearchBtn() {
        this.searchBtn = UIHelper.createButton(UIRegistry.getResourceString("SEARCH"));
        this.searchBtn.addActionListener(this.doQuery);
    }

    public void createUI() {
        this.panel = new JPanel(new BorderLayout());
        this.add((Component)this.panel, "Center");
        this.panel.setPreferredSize(new Dimension(300, 200));
        this.panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0), BorderFactory.createLineBorder(Color.BLACK)));
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public Viewable getForm() {
        return this.form;
    }

    public void setOKBtn(JButton okBtn) {
        this.okBtn = okBtn;
        this.updateUIControls();
    }

    protected void updateUIControls() {
        if (this.okBtn != null) {
            this.okBtn.setEnabled(this.idList != null && (this.idList.size() == 1 && !this.isMultipleSelection || this.idList.size() > 0 && this.isMultipleSelection));
        }
    }

    protected void setUIEnabled(boolean enabled) {
        this.form.getFieldIds(this.fieldIds);
        for (String fieldId : this.fieldIds) {
            Component comp = (Component)this.form.getCompById(fieldId);
            if (!(comp instanceof JTextField)) continue;
            ((JTextField)comp).setEnabled(enabled);
        }
        this.searchBtn.setEnabled(enabled);
    }

    /*
     * Unable to fully structure code
     */
    protected void doStartQuery(JComponent comp) {
        this.getDataFromUI();
        resultsInfo = null;
        if (this.queryBuilder == null) ** GOTO lbl13
        this.sqlStr = this.queryBuilder.buildSQL(this.dataMap, this.fieldNames);
        if (StringUtils.isNotEmpty((String)this.sqlStr)) {
            resultsInfo = this.queryBuilder.createQueryForIdResults();
            if (resultsInfo != null) {
                resultsInfo.setSQL(this.sqlStr);
                resultsInfo.setMultipleSelection(this.isMultipleSelection);
            }
        } else {
            UIRegistry.getStatusBar().setLocalizedErrorMessage("ES_SUSPICIOUS_SQL", new Object[0]);
            return;
lbl13:
            // 1 sources

            qafd = QueryAdjusterForDomain.getInstance();
            strBuf = new StringBuilder(256);
            cnt = 0;
            for (ERTICaptionInfo captionInfo : this.esTableInfo.getVisibleCaptionInfo()) {
                colName = null;
                value = null;
                if (captionInfo.getColName() == null) {
                    for (ERTICaptionInfo.ColInfo colInfo : captionInfo.getColInfoList()) {
                        colName = colInfo.getColumnName();
                        DBObjSearchPanel.log.debug((Object)("colInfo - colInfoColumn Name[" + colName + "]"));
                        value = this.dataMap.get(colName);
                        if (value == null) continue;
                        DBObjSearchPanel.log.debug((Object)("Column Name[" + colName + "][" + captionInfo.getColLabel() + "] [" + captionInfo.getFieldInfo() + "] Value[" + value + "]"));
                        break;
                    }
                } else {
                    colName = captionInfo.getColName();
                    value = StringUtils.isNotEmpty((String)colName) != false ? this.dataMap.get(captionInfo.getColName()) : null;
                    DBObjSearchPanel.log.debug((Object)("Column Name[" + colName + "][" + captionInfo.getColLabel() + "] [" + captionInfo.getFieldInfo() + "] Value[" + value + "]"));
                }
                if (value == null || (valStr = value.toString()).length() <= 0) continue;
                if (qafd.isUserInputNotInjectable(valStr)) {
                    if (!ESTermParser.getInstance().parse(valStr.toLowerCase(), true) || !StringUtils.isNotEmpty((String)valStr)) continue;
                    fields = ESTermParser.getInstance().getFields();
                    firstTerm = fields.get(0);
                    if (cnt > 0) {
                        strBuf.append(" OR ");
                    }
                    clause = null;
                    if (captionInfo.getFieldInfo() != null && this.form instanceof FormViewObj && (fInfo = (fvo = (FormViewObj)this.form).getFieldInfoForName(colName)) != null && fInfo.getFormCell() != null && fInfo.getFormCell().getPropertyAsBoolean("ispartial", false)) {
                        if (fInfo.getFormCell() instanceof FormCellFieldIFace && StringUtils.isNotEmpty((String)(fmt = (cif = (FormCellFieldIFace)fInfo.getFormCell()).getUIFieldFormatterName())) && fmt.equals("SearchDate")) {
                            clause = this.getDateClause(firstTerm, colName);
                        }
                        if (clause == null) {
                            firstTerm.setTerm(firstTerm.getTerm());
                            firstTerm.setOption(64);
                        }
                    }
                    if (clause == null) {
                        clause = ESTermParser.getInstance().createWhereClause(firstTerm, null, colName);
                    }
                    strBuf.append(clause);
                    ++cnt;
                    continue;
                }
                UIRegistry.getStatusBar().setErrorMessage(UIRegistry.getResourceString("ES_SUSPICIOUS_SQL"));
                return;
            }
            if (cnt == 0) {
                return;
            }
            fullStrSql = QueryAdjusterForDomain.getInstance().adjustSQL(this.sqlStr);
            fullSQL = fullStrSql.replace("%s", strBuf.toString());
            DBObjSearchPanel.log.info((Object)fullSQL);
            this.setUIEnabled(false);
            resultsInfo = new QueryForIdResultsSQL(this.esTableInfo.getId(), null, this.esTableInfo, 0, "");
            resultsInfo.setSQL(fullSQL);
            resultsInfo.setMultipleSelection(this.isMultipleSelection);
        }
        this.addSearchResults(resultsInfo);
        if (comp instanceof JTextField) {
            txt = (JTextField)comp;
            len = txt.getText().length();
            txt.setSelectionEnd(len);
            txt.setSelectionStart(0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    txt.requestFocus();
                }
            });
        }
    }

    private String getDateClause(SearchTermField term, String columnName) {
        String termStr = term.getTerm();
        if (termStr.length() >= 4) {
            try {
                String[] tokens = StringUtils.split((String)termStr, (char)'-');
                if (tokens.length == 1 || termStr.length() == 4) {
                    this.sdf.parse(String.valueOf(termStr) + "-01-01");
                    return String.format(" YEAR(%s) = %s ", columnName, tokens[0]);
                }
                if (tokens.length == 2) {
                    this.sdf.parse(String.valueOf(termStr) + "-01");
                    return String.format(" (YEAR(%s) = %s AND MONTH(%s) = %s) ", columnName, tokens[0], columnName, tokens[1]);
                }
                if (tokens.length == 3) {
                    this.sdf.parse(termStr);
                    return String.format(" %s = '%s' ", columnName, termStr);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public void addSearchResults(QueryForIdResultsIFace results) {
        this.idList = null;
        this.updateUIControls();
        this.remove(this.panel != null ? this.panel : this.scrollPane);
        this.panel = null;
        if (this.etrb != null) {
            this.etrb.cleanUp();
        }
        ESResultsTablePanel etrbPanel = new ESResultsTablePanel(this, results, false, true, false);
        this.etrb = etrbPanel;
        this.etrb.setPropertyChangeListener(this);
        etrbPanel.startFilling();
        this.scrollPane = new JScrollPane(this.etrb.getUIComponent(), 22, 30);
        this.add((Component)this.scrollPane, "Center");
        this.validate();
        this.setUIEnabled(true);
        this.repaint();
    }

    @Override
    public void removeTable(ESResultsTablePanelIFace etrbTable) {
        etrbTable.cleanUp();
    }

    @Override
    public void addTable(ESResultsTablePanelIFace etrBase) {
    }

    @Override
    public void revalidateScroll() {
        this.scrollPane.revalidate();
    }

    @Override
    public boolean hasResults() {
        return this.etrb.hasResults();
    }

    private Object getSelectedObjects(boolean doAll) {
        Vector objList = null;
        String errMsg = null;
        if (this.idList != null && this.idList.size() > 0) {
            DataProviderSessionIFace session = null;
            try {
                session = DataProviderFactory.getInstance().createSession();
                for (Integer id : this.idList) {
                    log.debug((Object)("getSelectedObject class[" + this.className + "] idFieldName[" + this.idFieldName + "] id[" + id + "]"));
                    Class<?> classObj = Class.forName(this.className);
                    List<?> list = session.getDataList(classObj, this.idFieldName, id, DataProviderSessionIFace.CompareType.Restriction);
                    if (list.size() == 1) {
                        if (doAll) {
                            if (objList == null) {
                                objList = new Vector();
                            }
                            ((FormDataObjIFace)list.get(0)).forceLoad();
                            objList.add(list.get(0));
                            continue;
                        }
                        Object obj = list.get(0);
                        return obj;
                    }
                    errMsg = list.size() == 0 ? "Why could we NOT load the object with id[" + id + "] for class[" + this.className + "]in DBObjSearchDialog?" : "Why would more than one object be found in DBObjSearchDialog? return size[" + list.size() + "]";
                }
                Vector vector = objList;
                return vector;
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DBObjSearchPanel.class, ex);
                errMsg = ex.toString();
                ex.printStackTrace();
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        if (errMsg != null) {
            throw new RuntimeException(errMsg);
        }
        return null;
    }

    public Object getSelectedObject() {
        return this.getSelectedObjects(false);
    }

    public List<Object> getSelectedObjects() {
        return (List)this.getSelectedObjects(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("selection")) {
            Integer numRowsSelected = (Integer)evt.getOldValue();
            this.idList = numRowsSelected > 0 ? this.etrb.getListOfIds(false) : null;
            this.updateUIControls();
        } else if (evt.getPropertyName().equals("doubleClick")) {
            this.okBtn.doClick();
        } else if (evt.getPropertyName().equals("loaded") && evt.getNewValue() != null && (Integer)evt.getNewValue() == 1) {
            ESResultsTablePanel etrbPanel = (ESResultsTablePanel)this.etrb;
            etrbPanel.getTable().setRowSelectionInterval(0, 0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DBObjSearchPanel.this.okBtn.requestFocus();
                }
            });
        }
    }

    public void registerQueryBuilder(ViewBasedSearchQueryBuilderIFace builder) {
        this.queryBuilder = builder;
    }

    public boolean isMultipleSelection() {
        return this.isMultipleSelection;
    }

    public void setMultipleSelection(boolean isMultiple) {
        this.isMultipleSelection = isMultiple;
    }

    @Override
    public boolean doQueriesSynchronously() {
        return false;
    }

    @Override
    public void done() {
    }
}

