/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.ViewBasedDialogFactoryIFace;
import edu.ku.brc.af.ui.db.ViewBasedDisplayActionAdapter;
import edu.ku.brc.af.ui.db.ViewBasedDisplayDialog;
import edu.ku.brc.af.ui.db.ViewBasedDisplayFrame;
import edu.ku.brc.af.ui.db.ViewBasedDisplayIFace;
import edu.ku.brc.af.ui.db.ViewBasedSearchDialogIFace;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.exceptions.ConfigurationException;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.datamodel.SpTaskSemaphore;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.dbsupport.TaskSemaphoreMgr;
import edu.ku.brc.specify.ui.DBObjSearchDialog;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class DBObjDialogFactory
implements ViewBasedDialogFactoryIFace {
    private static final Logger log = Logger.getLogger(DBObjDialogFactory.class);
    public static final String factoryName = "edu.ku.brc.specify.ui.DBObjDialogFactory";
    protected static DBObjDialogFactory instance = null;
    protected Hashtable<String, DialogInfo> searchDialogs = new Hashtable();
    protected Hashtable<String, DialogInfo> dialogs = new Hashtable();

    public DBObjDialogFactory() {
        if (instance != null) {
            throw new RuntimeException("DBObjDialogFactory cannot be instanitated more than once");
        }
        instance = this;
        this.init();
    }

    public static DBObjDialogFactory getInstance() {
        return instance;
    }

    protected void init() {
        block5: {
            try {
                Element root = AppContextMgr.getInstance().getResourceAsDOM("DialogDefs");
                if (root != null) {
                    Iterator i = root.elementIterator("dialog");
                    while (i.hasNext()) {
                        Element fileElement = (Element)i.next();
                        String type = XMLHelper.getAttr(fileElement, "type", "display");
                        String name = XMLHelper.getAttr(fileElement, "name", null);
                        boolean isDisplay = type.equals("display");
                        DialogInfo di = new DialogInfo(isDisplay ? null : XMLHelper.getAttr(fileElement, "viewset", null), XMLHelper.getAttr(fileElement, "view", null), name, XMLHelper.getAttr(fileElement, "class", null), XMLHelper.getAttr(fileElement, "idfield", null), XMLHelper.getAttr(fileElement, "helpcontext", ""));
                        if (isDisplay) {
                            this.dialogs.put(name, di);
                            continue;
                        }
                        this.searchDialogs.put(name, di);
                    }
                    break block5;
                }
                String msg = "The root element for the document was null!";
                log.error((Object)msg);
                throw new ConfigurationException(msg);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DBObjDialogFactory.class, ex);
                log.error((Object)ex);
                ex.printStackTrace();
                throw new RuntimeException("Couldn't load DialogDefs");
            }
        }
    }

    @Override
    public ViewBasedSearchDialogIFace createSearchDialog(Window parent, String name) {
        DialogInfo info = DBObjDialogFactory.instance.searchDialogs.get(name);
        if (info != null) {
            String title = "";
            DBTableInfo ti = DBTableIdMgr.getInstance().getByClassName(info.getClassName());
            if (ti != null) {
                title = String.valueOf(ti.getTitle()) + " " + UIRegistry.getResourceString("SEARCH");
            }
            if (parent instanceof Frame) {
                return new DBObjSearchDialog((Frame)parent, info.getViewSetName(), info.getViewName(), info.getSearchName(), title, info.getClassName(), info.getIdFieldName(), info.getHelpContext());
            }
            return new DBObjSearchDialog((Dialog)parent, info.getViewSetName(), info.getViewName(), info.getSearchName(), title, info.getClassName(), info.getIdFieldName(), info.getHelpContext());
        }
        throw new RuntimeException("Couldn't create object implementing ViewBasedSearchDialogIFace by name[" + name + "]");
    }

    @Override
    public ViewBasedDisplayIFace createDisplay(Window parent, String name, String frameTitleArg, String closeBtnTitleArg, boolean isEditArg, int optionsArg, String helpContext, ViewBasedDialogFactoryIFace.FRAME_TYPE type) {
        boolean isEdit = isEditArg;
        int options = optionsArg;
        String closeBtnTitle = closeBtnTitleArg;
        DialogInfo info = DBObjDialogFactory.instance.dialogs.get(name);
        if (info != null) {
            DBTableInfo ti;
            String frameTitle;
            SpecifyAppContextMgr sacm = (SpecifyAppContextMgr)AppContextMgr.getInstance();
            String viewSetName = info.getViewSetName();
            String viewName = info.getViewName();
            final ViewIFace view = sacm.getView(null, viewName);
            if (view == null) {
                throw new RuntimeException("Couldn't find view [" + viewName + "]");
            }
            viewSetName = view.getViewSetName();
            FormLockStatus lockStatus = DBObjDialogFactory.isLockOK("LockTitle", view, MultiView.isOptionOn(options, 4), isEdit);
            if (lockStatus != FormLockStatus.GotLock) {
                if (lockStatus == FormLockStatus.ViewOnly) {
                    isEdit = false;
                    options &= 0xFFFFFFEF;
                    options |= 8;
                    closeBtnTitle = UIRegistry.getResourceString("CLOSE");
                } else if (lockStatus == FormLockStatus.Skip) {
                    return null;
                }
            }
            if (StringUtils.isEmpty((String)(frameTitle = frameTitleArg)) && (ti = DBTableIdMgr.getInstance().getByClassName(view.getClassName())) != null) {
                frameTitle = ti.getTitle();
            }
            Window viewDisplay = type == ViewBasedDialogFactoryIFace.FRAME_TYPE.FRAME ? (parent instanceof Frame ? new ViewBasedDisplayFrame(viewSetName, info.getViewName(), info.getSearchName(), frameTitle, closeBtnTitle, info.getClassName(), info.getIdFieldName(), isEdit, options) : new ViewBasedDisplayDialog((Dialog)parent, viewSetName, info.getViewName(), info.getSearchName(), frameTitle, closeBtnTitle, info.getClassName(), info.getIdFieldName(), isEdit, options)) : (parent instanceof Frame ? new ViewBasedDisplayDialog((Frame)parent, viewSetName, info.getViewName(), info.getSearchName(), frameTitle, closeBtnTitle, info.getClassName(), info.getIdFieldName(), isEdit, options) : new ViewBasedDisplayDialog((Dialog)parent, viewSetName, info.getViewName(), info.getSearchName(), frameTitle, closeBtnTitle, info.getClassName(), info.getIdFieldName(), isEdit, options));
            if (viewDisplay != null) {
                viewDisplay.setHelpContext(helpContext != null ? helpContext : info.getHelpContext());
                if (lockStatus == FormLockStatus.GotLock) {
                    String ERR_UNLOCKING_FORM = "DBObjDialogFactory.ERR_UNLOCKING_FORM";
                    viewDisplay.setCloseListener(new ViewBasedDisplayActionAdapter(){

                        @Override
                        public boolean cancelPressed(ViewBasedDisplayIFace vbd) {
                            if (!DBObjDialogFactory.unLockOK("LockTitle", view)) {
                                UIRegistry.showLocalizedError("DBObjDialogFactory.ERR_UNLOCKING_FORM");
                            }
                            return true;
                        }

                        @Override
                        public boolean okPressed(ViewBasedDisplayIFace vbd) {
                            if (!DBObjDialogFactory.unLockOK("LockTitle", view)) {
                                UIRegistry.showLocalizedError("DBObjDialogFactory.ERR_UNLOCKING_FORM");
                            }
                            return true;
                        }
                    });
                }
            }
            return viewDisplay;
        }
        throw new RuntimeException("Couldn't create ViewBasedDisplayFrame by name[" + name + "] (Check the List of dialog in dailog_defs.xml)");
    }

    public static FormLockStatus isLockOK(String lockTitle, ViewIFace view, boolean isNewForm, boolean isEdit) {
        Class<?> treeDefClass = ((SpecifyAppContextMgr)AppContextMgr.getInstance()).getTreeDefClass(view);
        if (treeDefClass != null) {
            String treeSemaphoreName = treeDefClass.getSimpleName();
            String treeFormSemaphoreName = String.valueOf(treeDefClass.getSimpleName()) + "Form";
            DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByClassName(view.getClassName());
            String title = String.valueOf(tableInfo.getTitle()) + " " + "Tree";
            if (TaskSemaphoreMgr.doesOwnSemaphore(treeFormSemaphoreName, TaskSemaphoreMgr.SCOPE.Discipline)) {
                return FormLockStatus.OK;
            }
            TaskSemaphoreMgr.USER_ACTION action = TaskSemaphoreMgr.USER_ACTION.OK;
            if (isEdit || isNewForm) {
                SpTaskSemaphore semaphore = TaskSemaphoreMgr.getLockInfo(title, treeSemaphoreName, TaskSemaphoreMgr.SCOPE.Discipline);
                if (semaphore != null && semaphore.getIsLocked().booleanValue()) {
                    String prevLockedBy = null;
                    SpecifyUser user = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
                    if (semaphore.getOwner() != null && !semaphore.getOwner().getId().equals(user.getId()) && semaphore.getOwner().getAgents() != null && semaphore.getOwner().getAgents().size() > 0) {
                        prevLockedBy = semaphore.getOwner().getAgents().iterator().next().getIdentityTitle();
                    }
                    if (prevLockedBy != null) {
                        UIRegistry.displayInfoMsgDlgLocalized("DBObjDialogFactory.LockedOut1", title, prevLockedBy);
                    } else {
                        UIRegistry.displayInfoMsgDlgLocalized("DBObjDialogFactory.LockedOut2", title, prevLockedBy);
                    }
                    return FormLockStatus.Skip;
                }
                if (action != TaskSemaphoreMgr.USER_ACTION.OK) {
                    if (action == TaskSemaphoreMgr.USER_ACTION.Cancel) {
                        return FormLockStatus.Skip;
                    }
                    if (isNewForm) {
                        return FormLockStatus.Skip;
                    }
                    if (isEdit) {
                        return FormLockStatus.ViewOnly;
                    }
                    return FormLockStatus.Skip;
                }
            } else {
                return FormLockStatus.ViewOnly;
            }
            if (action == TaskSemaphoreMgr.USER_ACTION.OK) {
                if (!TaskSemaphoreMgr.incrementUsageCount(title, treeSemaphoreName, TaskSemaphoreMgr.SCOPE.Discipline)) {
                    action = TaskSemaphoreMgr.USER_ACTION.Error;
                }
                if (action != TaskSemaphoreMgr.USER_ACTION.OK) {
                    UIRegistry.showLocalizedError("TREE_LOCKED_ERR_FRM");
                    return FormLockStatus.Skip;
                }
                return FormLockStatus.GotLock;
            }
            UIRegistry.showLocalizedError("TREE_LOCKED_ERR");
            return FormLockStatus.Skip;
        }
        return FormLockStatus.OK;
    }

    public static boolean unLockOK(String lockTitle, ViewIFace view) {
        Class<?> treeDefClass = ((SpecifyAppContextMgr)AppContextMgr.getInstance()).getTreeDefClass(view);
        if (treeDefClass != null) {
            String treeSemaphoreName = treeDefClass.getSimpleName();
            String treeFormSemaphoreName = String.valueOf(treeDefClass.getSimpleName()) + "Form";
            DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByClassName(view.getClassName());
            String title = String.valueOf(tableInfo.getTitle()) + " " + "Tree";
            return TaskSemaphoreMgr.decrementUsageCount(title, treeSemaphoreName, TaskSemaphoreMgr.SCOPE.Discipline);
        }
        return true;
    }

    @Override
    public String getSearchName(String searchDlgName) {
        DialogInfo info = DBObjDialogFactory.instance.searchDialogs.get(searchDlgName);
        return info != null ? info.getSearchName() : null;
    }

    class DialogInfo {
        protected String viewSetName;
        protected String viewName;
        protected String searchName;
        protected String className;
        protected String idFieldName;
        protected String helpContext;

        public DialogInfo(String viewSetName, String viewName, String dialogName, String className, String idFieldName, String helpContext) {
            this.viewSetName = viewSetName;
            this.viewName = viewName;
            this.searchName = dialogName;
            this.className = className;
            this.idFieldName = idFieldName;
            this.helpContext = helpContext;
        }

        public String getClassName() {
            return this.className;
        }

        public String getViewName() {
            return this.viewName;
        }

        public String getIdFieldName() {
            return this.idFieldName;
        }

        public String getSearchName() {
            return this.searchName;
        }

        public String getViewSetName() {
            return this.viewSetName;
        }

        public String getHelpContext() {
            return this.helpContext;
        }
    }

    public static enum FormLockStatus {
        Skip,
        OK,
        GotLock,
        ViewOnly;

    }
}

