/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui;

import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.ViewBasedDialogFactoryIFace;
import edu.ku.brc.af.ui.db.ViewBasedDisplayIFace;
import edu.ku.brc.af.ui.forms.IconViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Collector;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.log4j.Logger;

public class CollectorActionListener
implements ActionListener {
    protected static final Logger log = Logger.getLogger(CollectorActionListener.class);

    @Override
    public void actionPerformed(ActionEvent e) {
        ViewBasedDisplayIFace dialog;
        String title;
        if (!(e instanceof IconViewObj.IconViewActionEvent)) {
            throw new RuntimeException("Event MUST be instance of IconViewObj.IconViewActionEvent");
        }
        Object source = e.getSource();
        if (!(source instanceof Collector)) {
            throw new IllegalArgumentException("Passed object must be a Collector");
        }
        Collector collector = (Collector)source;
        IconViewObj iconViewObj = ((IconViewObj.IconViewActionEvent)e).getIconViewObj();
        Agent agent = collector.getAgent();
        String classname = Agent.class.getName();
        DBTableInfo setTI = DBTableIdMgr.getInstance().getByClassName(classname);
        String defFormName = setTI.getEditObjDialog();
        if (defFormName == null) {
            log.error((Object)("Cannot find default form for " + collector.getClass().getSimpleName() + " records"));
            return;
        }
        int options = iconViewObj.getViewOptions();
        boolean isEditting = iconViewObj.getAltView().getMode() == AltViewIFace.CreationMode.EDIT;
        String string = title = MultiView.isOptionOn(options, 4) && isEditting ? UIRegistry.getResourceString("EDIT") : collector.getIdentityTitle();
        if (!isEditting) {
            options ^= 2;
            options ^= 1;
        }
        if ((dialog = UIRegistry.getViewbasedFactory().createDisplay(UIHelper.getWindow(iconViewObj.getUIComponent()), defFormName, title, isEditting ? UIRegistry.getResourceString("OK") : UIRegistry.getResourceString("CLOSE"), isEditting, options, null, ViewBasedDialogFactoryIFace.FRAME_TYPE.DIALOG)) != null) {
            dialog.setData(agent);
            dialog.createUI();
            dialog.getOkBtn().setEnabled(!isEditting);
            dialog.showDisplay(true);
            dialog.dispose();
        }
    }
}

