/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.forms.FormHelper;
import edu.ku.brc.af.ui.forms.formatters.DataObjDataField;
import edu.ku.brc.af.ui.forms.formatters.DataObjDataFieldFormatIFace;
import edu.ku.brc.af.ui.forms.formatters.DataObjSwitchFormatter;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.ui.DateWrapper;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import org.apache.commons.lang.StringUtils;

public class CollectingEventDataObjFmt
implements DataObjDataFieldFormatIFace,
Cloneable {
    protected static final String DEF_FMT_STR = "FN; DT; LC; LA, LO; CO, ST, CT";
    protected final String FIELD_NUM = "FN";
    protected final String LOC_DATE = "DT";
    protected final String CONTINENT = "CN";
    protected final String COUNTRY = "CT";
    protected final String STATE = "ST";
    protected final String COUNTY = "CO";
    protected final String LOC_STR = "LC";
    protected final String LATITUDE = "LA";
    protected final String LONGITUDE = "LO";
    protected String[] tokens = new String[]{"FN", "DT", "CN", "CT", "ST", "CO", "LC", "LA", "LO"};
    protected List<Pair<Integer, String>> sepsList = new ArrayList<Pair<Integer, String>>(this.tokens.length);
    protected Hashtable<String, String> values = new Hashtable();
    protected Hashtable<String, Boolean> fieldsHash = new Hashtable();
    protected String name;
    protected String formatStr;
    protected ChangeListener changeListener = null;
    protected JTextField textField = null;

    protected Geography getGeoByRank(Geography geo, int rankId) {
        Geography geography = geo;
        while (geography != null && geography.getRankId() != rankId) {
            geography = geography.getParent();
        }
        return geography != null && geography.getRankId() == rankId ? geography : null;
    }

    protected String getGeoNameByRank(Geography geo, int rankId) {
        Geography g = this.getGeoByRank(geo, rankId);
        return g != null ? g.getName() : "";
    }

    protected String getGeoCoordAsStr(BigDecimal val) {
        if (val != null) {
            return String.format("%5.2f", val);
        }
        return "";
    }

    private void fillGeoValues(Geography geo) {
        String[] keys = new String[]{"CN", "CT", "ST", "CO"};
        int rank = 100;
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (this.fieldsHash.get(key) != null) {
                this.values.put(key, this.getGeoNameByRank(geo, rank));
            }
            rank += 100;
            ++n2;
        }
    }

    @Override
    public String format(Object dataValue) {
        DBTableInfo tblInfo;
        if (dataValue == null) {
            return "";
        }
        if (!(dataValue instanceof CollectingEvent)) {
            throw new RuntimeException("The data value set into CollectingEventDataObjFmt is not a CollectingEvent [" + dataValue.getClass().getSimpleName() + "]");
        }
        if (this.fieldsHash.size() == 0 && StringUtils.isNotEmpty((String)this.formatStr)) {
            return "The Collecting Event is empty.";
        }
        String restricted = FormHelper.checkForRestrictedValue(CollectingEvent.getClassTableId());
        if (restricted != null) {
            return restricted;
        }
        boolean isSecurityOn = AppContextMgr.isSecurityOn();
        CollectingEvent ce = (CollectingEvent)dataValue;
        this.values.clear();
        String str = "";
        if (ce.getStartDate() != null) {
            DateWrapper scrDateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat");
            str = scrDateFormat.format(ce.getStartDate().getTime());
        }
        this.values.put("DT", str);
        str = ce.getStationFieldNumber();
        this.values.put("FN", StringUtils.isNotEmpty((String)str) ? str : "");
        Locality locality = ce.getLocality();
        PermissionSettings localityPerms = null;
        if (isSecurityOn && locality != null && (tblInfo = DBTableIdMgr.getInstance().getInfoById(Locality.getClassTableId())) != null && (localityPerms = tblInfo.getPermissions()) != null && !localityPerms.canView()) {
            locality = null;
        }
        Geography geo = null;
        if (locality != null) {
            geo = locality.getGeography();
            str = locality.getLocalityName();
            this.values.put("LC", StringUtils.isNotEmpty((String)str) ? str : "");
            if (this.fieldsHash.get("LA") != null) {
                this.values.put("LA", this.getGeoCoordAsStr(locality.getLatitude1()));
            }
            if (this.fieldsHash.get("LO") != null) {
                this.values.put("LO", this.getGeoCoordAsStr(locality.getLongitude1()));
            }
        }
        if (geo != null) {
            if (isSecurityOn) {
                PermissionSettings perms;
                DBTableInfo tblInfo2 = DBTableIdMgr.getInstance().getInfoById(Geography.getClassTableId());
                if (tblInfo2 != null && (perms = tblInfo2.getPermissions()).canView()) {
                    this.fillGeoValues(geo);
                }
            } else {
                this.fillGeoValues(geo);
            }
        }
        if (StringUtils.isNotEmpty((String)this.formatStr)) {
            if (this.sepsList.size() == 0) {
                ArrayList<Pair<Integer, String>> tokenMappings = new ArrayList<Pair<Integer, String>>();
                int i = 0;
                while (i < this.tokens.length) {
                    int inx = this.formatStr.indexOf(this.tokens[i]);
                    if (inx > -1) {
                        tokenMappings.add(new Pair<Integer, String>(inx, this.tokens[i]));
                    }
                    ++i;
                }
                Collections.sort(tokenMappings, new Comparator<Pair<Integer, String>>(){

                    @Override
                    public int compare(Pair<Integer, String> o1, Pair<Integer, String> o2) {
                        return ((Integer)o1.first).compareTo((Integer)o2.first);
                    }
                });
                int inx = -1;
                int prv = -1;
                int i2 = 0;
                while (i2 < tokenMappings.size()) {
                    Pair locPair = (Pair)tokenMappings.get(i2);
                    if (prv > -1) {
                        inx = (Integer)locPair.first;
                        String sep = this.formatStr.substring(prv, inx);
                        Pair<Integer, String> p = new Pair<Integer, String>(i2 - 1, sep);
                        this.sepsList.add(p);
                    } else {
                        inx = 0;
                    }
                    prv = inx + ((String)locPair.second).length();
                    ++i2;
                }
            }
            if (this.sepsList.size() > 0) {
                StringBuilder sb = new StringBuilder();
                String sep = null;
                for (Pair<Integer, String> pair : this.sepsList) {
                    String valStr = this.values.get(this.tokens[(Integer)pair.first]);
                    if (!StringUtils.isNotEmpty((String)valStr)) continue;
                    if (sep != null) {
                        sb.append(sep);
                    }
                    sb.append(valStr);
                    sep = (String)pair.second;
                }
                return sb.toString();
            }
        }
        return "";
    }

    @Override
    public Class<?> getDataClass() {
        return CollectingEvent.class;
    }

    @Override
    public DataObjDataField[] getFields() {
        return null;
    }

    @Override
    public String getName() {
        return "CollectingEventDetail";
    }

    @Override
    public String getValue() {
        return null;
    }

    @Override
    public void setValue(String value) {
    }

    @Override
    public void init(String nameArg, Properties properties) {
        this.name = nameArg;
        if (properties != null) {
            this.formatStr = properties.getProperty("format");
        }
        if (StringUtils.isEmpty((String)this.formatStr)) {
            this.formatStr = DEF_FMT_STR;
        }
        String[] stringArray = this.tokens;
        int n = this.tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (StringUtils.contains((String)this.formatStr, (String)token)) {
                this.fieldsHash.put(token, true);
            }
            ++n2;
        }
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public boolean isDirectFormatter() {
        return true;
    }

    @Override
    public String getSingleField() {
        return null;
    }

    @Override
    public void setTableAndFieldInfo() {
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void toXML(StringBuilder sb) {
        sb.append("          <external");
        XMLHelper.xmlAttr(sb, "class", this.getClass().getName());
        if (StringUtils.isNotEmpty((String)this.formatStr)) {
            sb.append(">\n");
            sb.append("            <param");
            XMLHelper.xmlAttr(sb, "name", "format");
            sb.append(">");
            sb.append(this.formatStr);
            sb.append("</param>\n");
            sb.append("          </external>\n");
        } else {
            sb.append("/>\n");
        }
    }

    @Override
    public void setDataObjSwitchFormatter(DataObjSwitchFormatter objFormatter) {
    }

    @Override
    public JPanel getCustomEditor(ChangeListener l) {
        this.changeListener = l;
        this.textField = UIHelper.createTextField();
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "p"));
        pb.add((Component)this.textField, cc.xy(1, 1));
        this.textField.setText(this.formatStr);
        this.textField.getDocument().addDocumentListener(new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                CollectingEventDataObjFmt.this.changeListener.stateChanged(new ChangeEvent(this));
            }
        });
        return pb.getPanel();
    }

    @Override
    public boolean isCustom() {
        return true;
    }

    @Override
    public boolean hasEditor() {
        return true;
    }

    @Override
    public boolean isValid() {
        return !this.textField.getText().isEmpty();
    }

    @Override
    public String getLabel() {
        return "Format";
    }

    @Override
    public void doneEditting(boolean wasCancelled) {
        this.formatStr = this.textField.getText();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CollectingEventDataObjFmt cedof = (CollectingEventDataObjFmt)super.clone();
        cedof.values = new Hashtable();
        for (String key : this.values.keySet()) {
            cedof.values.put(key, this.values.get(key));
        }
        return cedof;
    }
}

