/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui;

import gov.nasa.worldwind.ViewStateIterator;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.FlyToOrbitViewStateIterator;
import gov.nasa.worldwind.view.OrbitView;

public class ClickAndGoSelectListener
implements SelectListener {
    private final WorldWindow wwd;
    private final Class<?> pickedObjClass;
    private final double elevationOffset;

    public ClickAndGoSelectListener(WorldWindow wwd, Class<?> pickedObjClass) {
        if (wwd == null) {
            String msg = Logging.getMessage((String)"nullValue.WorldWindow");
            Logging.logger().severe(msg);
            throw new IllegalArgumentException(msg);
        }
        this.wwd = wwd;
        this.pickedObjClass = pickedObjClass;
        this.elevationOffset = 0.0;
    }

    public ClickAndGoSelectListener(WorldWindow wwd, Class<?> pickedObjClass, double elevationOffset) {
        if (wwd == null) {
            String msg = Logging.getMessage((String)"nullValue.WorldWindow");
            Logging.logger().severe(msg);
            throw new IllegalArgumentException(msg);
        }
        if (pickedObjClass == null) {
            String msg = Logging.getMessage((String)"nullValue.ClassIsNull");
            Logging.logger().severe(msg);
            throw new IllegalArgumentException(msg);
        }
        this.wwd = wwd;
        this.pickedObjClass = pickedObjClass;
        this.elevationOffset = elevationOffset;
    }

    public void selected(SelectEvent event) {
        if (event.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick") && event.hasObjects() && event.getTopPickedObject().hasPosition() && event.getTopObject().getClass().equals(this.pickedObjClass) && this.wwd.getView() instanceof OrbitView) {
            Position targetPos = event.getTopPickedObject().getPosition();
            OrbitView view = (OrbitView)this.wwd.getView();
            Globe globe = this.wwd.getModel().getGlobe();
            if (globe != null && view != null) {
                view.applyStateIterator((ViewStateIterator)FlyToOrbitViewStateIterator.createPanToIterator((OrbitView)view, (Globe)globe, (Position)new Position((LatLon)targetPos, 0.0), (Angle)Angle.ZERO, (Angle)Angle.ZERO, (double)(targetPos.getElevation() + this.elevationOffset)));
            }
        }
    }
}

