/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.ui.db.RecordSetListCellRenderer;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class ChooseRecordSetDlg
extends CustomDialog {
    private static final Logger log = Logger.getLogger(ChooseRecordSetDlg.class);
    protected JList list = null;
    protected List<Pair<String, Integer>> recordSets = null;
    protected boolean includeAddBtn = false;

    public ChooseRecordSetDlg(int tableId) throws HeadlessException {
        this(tableId, false);
    }

    public ChooseRecordSetDlg(int tableId, boolean includeAddBtn) throws HeadlessException {
        super((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("RECORDSET_CHOOSE"), true, 7, null);
        Vector<Integer> id = new Vector<Integer>(1);
        id.add(tableId);
        this.initialize(id);
        this.includeAddBtn = includeAddBtn;
        if (includeAddBtn) {
            this.whichBtns = 15;
            this.setApplyLabel(UIRegistry.getResourceString("New"));
        }
        this.helpContext = "RS_Add";
    }

    public ChooseRecordSetDlg(Vector<Integer> tableIds) throws HeadlessException {
        this(tableIds, false);
    }

    public ChooseRecordSetDlg(Vector<Integer> tableIds, boolean includeAddBtn) throws HeadlessException {
        super((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("RECORDSET_CHOOSE"), true, 7, null);
        this.includeAddBtn = includeAddBtn;
        if (includeAddBtn) {
            this.whichBtns = 15;
            this.setApplyLabel(UIRegistry.getResourceString("New"));
        }
        this.initialize(tableIds);
        this.helpContext = "ChooseRecordSet";
    }

    protected void initialize(Vector<Integer> tableIds) {
        String sql = "SELECT rs.Name,RecordSetID FROM recordset rs INNER JOIN specifyuser spu ON spu.SpecifyUserID = rs.SpecifyUserID WHERE rs.Type = 0 AND rs.CollectionMemberID = COLLID AND spu.SpecifyUserID = SPECIFYUSERID";
        if (tableIds.size() > 0 && (tableIds.size() != 0 || tableIds.get(0) >= 0)) {
            StringBuilder sb = new StringBuilder(tableIds.get(0).toString());
            int i = 1;
            while (i < tableIds.size()) {
                sb.append(",");
                sb.append(tableIds.get(i));
                ++i;
            }
            sql = String.valueOf(sql) + " AND rs.TableID in(" + sb.toString() + ")";
        }
        sql = String.valueOf(sql) + " ORDER BY rs.Name";
        sql = QueryAdjusterForDomain.getInstance().adjustSQL(sql);
        System.out.println(sql);
        Vector<Object[]> rows = BasicSQLUtils.query(sql);
        if (rows != null && rows.size() > 0) {
            this.recordSets = new Vector<Pair<String, Integer>>();
            for (Object[] row : rows) {
                this.recordSets.add(new Pair<String, Integer>(row[0].toString(), (Integer)row[1]));
            }
        }
    }

    @Override
    public void createUI() {
        super.createUI();
        this.okBtn.setEnabled(false);
        AbstractListModel listModel = new AbstractListModel(){

            @Override
            public int getSize() {
                return ChooseRecordSetDlg.this.recordSets == null ? 0 : ChooseRecordSetDlg.this.recordSets.size();
            }

            @Override
            public Object getElementAt(int index) {
                return ChooseRecordSetDlg.this.recordSets == null ? null : ChooseRecordSetDlg.this.recordSets.get(index);
            }
        };
        this.list = new JList(listModel);
        this.list.setCellRenderer(new RecordSetListCellRenderer());
        this.list.setVisibleRowCount(10);
        this.list.setCellRenderer(new PairListRenderer());
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ChooseRecordSetDlg.this.okBtn.setEnabled(ChooseRecordSetDlg.this.list.getSelectedIndex() > -1);
                if (e.getClickCount() == 2) {
                    ChooseRecordSetDlg.this.okBtn.doClick();
                    return;
                }
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)UIHelper.createScrollPane(this.list), "Center");
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.contentPanel = panel;
        this.mainPanel.add(this.contentPanel, "Center");
        this.pack();
    }

    @Override
    protected void applyButtonPressed() {
        super.applyButtonPressed();
        this.setVisible(false);
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.recordSets != null) {
            this.recordSets.clear();
        }
    }

    public void addAdditionalObjectsAsRecordSets(Vector<RecordSetIFace> additionalRS) {
        if (this.recordSets == null) {
            this.recordSets = new Vector<Pair<String, Integer>>();
        }
        for (RecordSetIFace rsi : additionalRS) {
            this.recordSets.add(new Pair<String, Integer>(rsi.getName(), rsi.getOnlyItem().getRecordId()));
        }
    }

    public boolean hasRecordSets() {
        return this.recordSets != null && this.recordSets.size() > 0;
    }

    public RecordSetIFace getSelectedRecordSet() {
        int inx;
        if (this.list != null && (inx = this.list.getSelectedIndex()) != -1) {
            DataProviderSessionIFace session = null;
            try {
                String sql = "FROM RecordSet WHERE recordSetId = " + this.recordSets.get((int)inx).second;
                session = DataProviderFactory.getInstance().createSession();
                List<?> rvList = session.getDataList(sql);
                if (rvList.size() == 1) {
                    RecordSetIFace recordSetIFace = (RecordSetIFace)rvList.get(0);
                    return recordSetIFace;
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ChooseRecordSetDlg.class, ex);
                log.error((Object)ex);
                ex.printStackTrace();
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        return null;
    }

    class PairListRenderer
    extends DefaultListCellRenderer {
        PairListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setText((String)((Pair)value).first);
            return label;
        }
    }
}

