/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.ui.ChooseRecordSetDlg;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import org.apache.log4j.Logger;

public class ChooseColObjIdsDlg
extends JDialog
implements ActionListener {
    private static final Logger log = Logger.getLogger(ChooseRecordSetDlg.class);
    private static final ImageIcon icon = IconManager.getImage("Record_Set", IconManager.IconSize.Std16);
    protected JButton cancelBtn;
    protected JButton okBtn;
    protected JList list;
    protected List<?> recordSets;

    public ChooseColObjIdsDlg(Frame frame) throws HeadlessException {
        super(frame, true);
        this.createUI();
        this.setLocationRelativeTo(UIRegistry.get("frame"));
        this.setDefaultCloseOperation(0);
        ImageIcon appIcon = IconManager.getIcon("AppIcon");
        if (appIcon != null) {
            this.setIconImage(appIcon.getImage());
        }
    }

    protected JPanel createUIRecordSets() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("RECORDSET_CHOOSE"), IconManager.getImage("Record_Set", IconManager.IconSize.Std24), 2), "North");
        try {
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            this.recordSets = session.getDataList(RecordSet.class);
            session.close();
            AbstractListModel listModel = new AbstractListModel(){

                @Override
                public int getSize() {
                    return ChooseColObjIdsDlg.this.recordSets.size();
                }

                @Override
                public Object getElementAt(int index) {
                    return ((RecordSetIFace)ChooseColObjIdsDlg.this.recordSets.get(index)).getName();
                }
            };
            this.list = new JList(listModel);
            class MyCellRenderer
            extends JLabel
            implements ListCellRenderer {
                MyCellRenderer() {
                }

                public Component getListCellRendererComponent(JList renderList, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    String s = value.toString();
                    this.setText(s);
                    this.setIcon(icon);
                    if (isSelected) {
                        this.setBackground(renderList.getSelectionBackground());
                        this.setForeground(renderList.getSelectionForeground());
                    } else {
                        this.setBackground(renderList.getBackground());
                        this.setForeground(renderList.getForeground());
                    }
                    this.setEnabled(renderList.isEnabled());
                    this.setFont(renderList.getFont());
                    this.setOpaque(true);
                    return this;
                }
            }
            this.list.setCellRenderer(new MyCellRenderer());
            this.list.setVisibleRowCount(5);
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        ChooseColObjIdsDlg.this.okBtn.doClick();
                    }
                }
            });
            JScrollPane listScroller = new JScrollPane(this.list);
            panel.add((Component)listScroller, "Center");
            this.cancelBtn = UIHelper.createButton(UIRegistry.getResourceString("CANCEL"));
            this.okBtn = UIHelper.createButton(UIRegistry.getResourceString("OK"));
            this.okBtn.addActionListener(this);
            this.getRootPane().setDefaultButton(this.okBtn);
            ButtonBarBuilder btnBuilder = new ButtonBarBuilder();
            btnBuilder.addGriddedButtons(new JButton[]{this.cancelBtn, this.okBtn});
            this.cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ChooseColObjIdsDlg.this.setVisible(false);
                }
            });
            panel.add((Component)btnBuilder.getPanel(), "South");
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ChooseColObjIdsDlg.class, ex);
            log.error((Object)ex);
        }
        return panel;
    }

    protected void createUI() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Record Sets", tabbedPane);
        this.setContentPane(tabbedPane);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    public RecordSetIFace getSelectedRecordSet() {
        int inx = this.list.getSelectedIndex();
        if (inx != -1) {
            return (RecordSetIFace)this.recordSets.get(inx);
        }
        return null;
    }
}

