/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.tasks.BaseTask;
import edu.ku.brc.af.ui.db.ViewBasedDisplayDialog;
import edu.ku.brc.af.ui.db.ViewBasedDisplayPanel;
import edu.ku.brc.af.ui.db.ViewBasedSearchDialogIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.ValCheckBox;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.tasks.ColObjSourceHelper;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.DateWrapper;
import edu.ku.brc.ui.EditDeleteAddPanel;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.SimpleGlassPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import sun.swing.table.DefaultTableCellHeaderRenderer;

public class BatchReidentifyPanel
extends JPanel {
    private static final String LOOKUP_SQL = "SELECT co.CollectionObjectID, co.CatalogNumber, d.DeterminedDate,  d.TypeStatusName, t.FullName, d.DeterminationID FROM collectionobject co LEFT JOIN determination d ON co.CollectionObjectID = d.CollectionObjectID LEFT JOIN taxon t ON d.TaxonID = t.TaxonID WHERE co.CollectionObjectID %s AND (d.IsCurrent OR d.DeterminationID IS NULL) ORDER BY co.CatalogNumber";
    protected static DateWrapper scrDateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat");
    private ColObjTaxaTableModel model;
    private JTable coTable;
    private RecordSetIFace recordSet = null;
    private Determination determination;
    private Vector<ColObjTaxa> items = new Vector();
    private EditDeleteAddPanel edaPanel;
    private UIFieldFormatterIFace fmtr = DBTableIdMgr.getFieldFormatterFor(CollectionObject.class, "catalogNumber");
    private ViewBasedDisplayPanel vbPanel = null;
    private AtomicBoolean handlingValidatorUpdate = new AtomicBoolean(false);

    public CustomDialog createDlg() {
        CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getMostRecentWindow(), UIRegistry.getResourceString("DET_BTCH_REIDENT_MENU"), true, 11, this){

            @Override
            protected void cancelButtonPressed() {
                this.btnPressed = 2;
            }

            @Override
            protected void okButtonPressed() {
                this.btnPressed = 1;
            }
        };
        dlg.createUI();
        this.setDlg(dlg);
        return dlg;
    }

    private void setDlg(final CustomDialog dlg) {
        dlg.getApplyBtn().setVisible(true);
        dlg.getOkBtn().setEnabled(false);
        dlg.setOkLabel(UIRegistry.getResourceString("DET_BTCH_.RE_IDEE"));
        dlg.setCancelLabel(UIRegistry.getResourceString("DET_BTCH_.SELECT_SPECIMENS"));
        dlg.setApplyLabel(UIRegistry.getResourceString("CLOSE"));
        dlg.getOkBtn().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                BatchReidentifyPanel.this.handlingValidatorUpdate.set(true);
                BatchReidentifyPanel.this.updateBtnUI();
                BatchReidentifyPanel.this.handlingValidatorUpdate.set(false);
            }
        });
        dlg.getOkBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                BatchReidentifyPanel.this.doReIdentify(dlg);
            }
        });
        dlg.getCancelBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                boolean closeIt;
                boolean bl = closeIt = !BatchReidentifyPanel.this.askForColObjs();
                if (closeIt) {
                    dlg.setVisible(false);
                }
            }
        });
        dlg.setCloseOnApplyClk(true);
        this.vbPanel.setOkCancelBtns(dlg.getOkBtn(), dlg.getCancelBtn());
    }

    protected void createUI() {
        FormViewObj.FVOFieldInfo fi;
        ActionListener editAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchReidentifyPanel.this.viewCO();
            }
        };
        ActionListener delAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchReidentifyPanel.this.removeCO();
            }
        };
        ActionListener addAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchReidentifyPanel.this.searchCO();
            }
        };
        this.edaPanel = new EditDeleteAddPanel(editAL, delAL, addAL);
        this.edaPanel.getEditBtn().setIcon(IconManager.getIcon("ViewForm", IconManager.IconSize.Std16));
        this.edaPanel.getAddBtn().setIcon(IconManager.getIcon("Search", IconManager.IconSize.Std16));
        this.loadColObjInfo();
        this.model = new ColObjTaxaTableModel();
        this.coTable = new JTable(this.model);
        DefaultTableCellRenderer cr = new DefaultTableCellRenderer();
        DefaultTableCellHeaderRenderer tchr = new DefaultTableCellHeaderRenderer();
        cr.setHorizontalAlignment(0);
        tchr.setHorizontalAlignment(0);
        this.coTable.setDefaultRenderer(String.class, cr);
        this.coTable.getTableHeader().setDefaultRenderer(tchr);
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "p,8px,p,4px,f:350px:g,2px,p"), (JPanel)this);
        this.vbPanel = new ViewBasedDisplayPanel(null, "Determination", Determination.class.getName(), true, 8);
        pb.add((Component)this.vbPanel, cc.xy(1, 1));
        pb.addSeparator(DBTableIdMgr.getInstance().getTitleForId(CollectionObject.getClassTableId()), cc.xy(1, 3));
        pb.add((Component)UIHelper.createScrollPane(this.coTable), cc.xy(1, 5));
        pb.add((Component)this.edaPanel, cc.xy(1, 7));
        this.determination = new Determination();
        this.determination.initialize();
        this.determination.setIsCurrent(true);
        this.vbPanel.getMultiView().setData(this.determination);
        FormViewObj fvo = this.vbPanel.getMultiView().getCurrentViewAsFormViewObj();
        if (fvo != null && (fi = fvo.getFieldInfoForName("isCurrent")) != null) {
            ((ValCheckBox)fi.getComp()).setValue(true, null);
            fi.getComp().setEnabled(false);
        }
        pb.setDefaultDialogBorder();
        this.updateBtnUI();
        this.coTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BatchReidentifyPanel.this.updateBtnUI();
            }
        });
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                BatchReidentifyPanel.this.updateBtnUI();
            }
        });
    }

    private void updateBtnUI() {
        Dialog parentDlg;
        boolean isRowSelected = this.coTable.getSelectedRow() > -1;
        this.edaPanel.getEditBtn().setEnabled(isRowSelected);
        this.edaPanel.getDelBtn().setEnabled(isRowSelected);
        this.edaPanel.getAddBtn().setEnabled(true);
        if (this.getParent() != null && (parentDlg = UIHelper.getDialog(this)) != null && parentDlg instanceof CustomDialog) {
            if (!this.handlingValidatorUpdate.get()) {
                this.vbPanel.getMultiView().getCurrentValidator().validateForm();
            }
            ((CustomDialog)parentDlg).getOkBtn().setEnabled(this.model.getRowCount() > 0 && this.vbPanel.getMultiView().getCurrentValidator().getState() == UIValidatable.ErrorType.Valid);
        }
    }

    private void viewCO() {
        if (this.coTable.getSelectedRow() > -1) {
            ColObjTaxa cotx = this.items.get(this.coTable.getSelectedRow());
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    CollectionObject co = session.get(CollectionObject.class, cotx.getColObjId());
                    co.forceLoad();
                    for (Determination d : co.getDeterminations()) {
                        d.forceLoad();
                    }
                    String title = DBTableIdMgr.getInstance().getTitleForId(CollectionObject.getClassTableId());
                    ViewBasedDisplayDialog dlg = new ViewBasedDisplayDialog((Frame)UIRegistry.getTopWindow(), null, "CollectionObject", null, title, "Close", null, null, false, 8);
                    dlg.setWhichBtns(1);
                    dlg.getMultiView().getCurrentViewAsFormViewObj().setDataObj(co);
                    session.close();
                    session = null;
                    UIHelper.centerAndShow(dlg);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(BatchReidentifyPanel.class, ex);
                    if (session != null) {
                        session.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
    }

    private void searchCO() {
        try {
            String title = "CollectionObjectSearch";
            ViewBasedSearchDialogIFace srchDlg = UIRegistry.getViewbasedFactory().createSearchDialog(null, title);
            if (srchDlg != null) {
                srchDlg.getDialog().setVisible(true);
                if (!srchDlg.isCancelled()) {
                    CollectionObject co = (CollectionObject)srchDlg.getSelectedObject();
                    String sql = String.format(LOOKUP_SQL, String.format(" = %d", co.getId()));
                    if (this.addItems(sql) > 0) {
                        Collections.sort(this.items);
                        this.model.fireDataChanged();
                    }
                }
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
        }
    }

    private void removeCO() {
        if (this.coTable.getSelectedRow() > -1) {
            int inx;
            int[] indexes = this.coTable.getSelectedRows();
            Vector<Integer> idxs = new Vector<Integer>();
            int[] nArray = indexes;
            int n = indexes.length;
            int n2 = 0;
            while (n2 < n) {
                inx = nArray[n2];
                idxs.add(inx);
                ++n2;
            }
            Collections.sort(idxs);
            Collections.reverse(idxs);
            Iterator iterator = idxs.iterator();
            while (iterator.hasNext()) {
                inx = (Integer)iterator.next();
                this.items.remove(inx);
            }
            this.model.fireDataChanged();
        }
    }

    public boolean askForColObjs() {
        ColObjSourceHelper colObjSrcHelper = new ColObjSourceHelper(ColObjSourceHelper.TypeOfRS.eColObjs);
        this.recordSet = colObjSrcHelper.getRecordSet(null);
        if (this.recordSet != null && colObjSrcHelper.getAskTypeRV() != BaseTask.ASK_TYPE.Cancel) {
            if (this.vbPanel == null) {
                this.createUI();
            } else {
                this.loadColObjInfo();
                this.model.fireDataChanged();
            }
            return true;
        }
        return false;
    }

    protected void loadColObjInfo() {
        if (this.recordSet != null) {
            block11: {
                if (this.recordSet.getRecordSetId() != null) {
                    DataProviderSessionIFace session = null;
                    try {
                        try {
                            session = DataProviderFactory.getInstance().createSession();
                            RecordSet rs = session.get(RecordSet.class, this.recordSet.getRecordSetId());
                            rs.getItems().size();
                            this.recordSet = rs;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(BatchReidentifyPanel.class, ex);
                            if (session != null) {
                                session.close();
                            }
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        if (session != null) {
                            session.close();
                        }
                        throw throwable;
                    }
                    if (session != null) {
                        session.close();
                    }
                }
            }
            this.items = new Vector(this.recordSet.getNumItems());
            if (this.fmtr != null) {
                String sql = String.format(LOOKUP_SQL, DBTableIdMgr.getInstance().getInClause(this.recordSet));
                this.addItems(sql);
            }
        }
    }

    private int addItems(String sql) {
        int cnt = 0;
        for (Object[] cols : BasicSQLUtils.query(sql)) {
            String catNumStr = (String)this.fmtr.formatToUI(cols[1]);
            String detDateStr = scrDateFormat.format((Date)cols[2]);
            String typeStatus = (String)cols[3];
            String taxonName = (String)cols[4];
            this.items.add(new ColObjTaxa(catNumStr, detDateStr, typeStatus, taxonName, (Integer)cols[0]));
            ++cnt;
        }
        return cnt;
    }

    public void doReIdentify(CustomDialog dlg) {
        String GLASSKEY = "REIDENTIFY";
        this.vbPanel.getMultiView().getDataFromUI();
        SwingWorker<Integer, Integer> worker = new SwingWorker<Integer, Integer>(){
            final Vector<Integer> errors = new Vector();

            protected RecordSetIFace getErrorRecordSet() {
                RecordSet result = new RecordSet();
                result.initialize();
                result.setDbTableId(CollectionObject.getClassTableId());
                result.setSpecifyUser(AppContextMgr.getInstance().getClassObject(SpecifyUser.class));
                for (Integer id : this.errors) {
                    result.addItem(id);
                }
                int maxNameLength = DBTableIdMgr.getInstance().getInfoByTableName("recordset").getFieldByColumnName("name").getLength();
                String rsName = UIRegistry.getResourceString("DET_BTCH_.ErrRSNameBase");
                GregorianCalendar now = new GregorianCalendar();
                String[] chunks = new String[]{"_" + String.valueOf(now.get(1)), "-" + String.valueOf(now.get(2) + 1), "-" + String.valueOf(now.get(5)), "_" + String.valueOf(now.get(11)), ":" + String.valueOf(now.get(13))};
                int c = 0;
                while (c < chunks.length && (String.valueOf(rsName) + chunks[c]).length() <= maxNameLength) {
                    rsName = String.valueOf(rsName) + chunks[c++];
                }
                result.setName(rsName);
                return result;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            protected Integer doInBackground() throws Exception {
                cnt = 0;
                try {
                    continueSelected = false;
                    block8: for (ColObjTaxa cot : BatchReidentifyPanel.access$0(BatchReidentifyPanel.this)) {
                        block14: {
                            session = null;
                            tranOpen = false;
                            try {
                                block15: {
                                    try {
                                        session = DataProviderFactory.getInstance().createSession();
                                        co = session.get(CollectionObject.class, cot.getColObjId());
                                        newDet = (Determination)BatchReidentifyPanel.access$6(BatchReidentifyPanel.this).clone();
                                        for (Determination d : co.getDeterminations()) {
                                            if (!d.getIsCurrent().booleanValue()) continue;
                                            d.setIsCurrent(false);
                                        }
                                        newDet.setCollectionObject(co);
                                        co.getDeterminations().add(newDet);
                                        co.setTimestampModified(new Timestamp(System.currentTimeMillis()));
                                        co.setModifiedByAgent(Agent.getUserAgent());
                                        session.beginTransaction();
                                        tranOpen = true;
                                        session.saveOrUpdate(co);
                                        session.commit();
                                        tranOpen = false;
                                        break block14;
                                    }
                                    catch (Exception ex) {
                                        if (tranOpen) {
                                            session.rollback();
                                            tranOpen = false;
                                        }
                                        if (continueSelected) break block15;
                                        UsageTracker.incrHandledUsageCount();
                                        ExceptionTracker.getInstance().capture(BatchReidentifyPanel.class, ex);
                                        ex.printStackTrace();
                                        continueSelected = UIRegistry.displayConfirmLocalized("DET_BTCH_.ErrActionTitle", "DET_BTCH_.ErrActionMsg", "Continue", "Cancel", 2);
                                        if (continueSelected) break block15;
                                        r = cnt;
                                        ** while (r < BatchReidentifyPanel.access$0((BatchReidentifyPanel)BatchReidentifyPanel.this).size())
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                        this.errors.add(((ColObjTaxa)BatchReidentifyPanel.access$0(BatchReidentifyPanel.this).get(r)).getColObjId());
                                        ++r;
                                        continue;
lbl44:
                                        // 1 sources

                                        break block8;
                                    }
                                }
                                if (continueSelected) {
                                    this.errors.add(((ColObjTaxa)BatchReidentifyPanel.access$0(BatchReidentifyPanel.this).get(cnt)).getColObjId());
                                }
                            }
                            finally {
                                if (session != null) {
                                    session.close();
                                }
                            }
                        }
                        this.firePropertyChange("REIDENTIFY", 0, ++cnt);
                    }
                    this.firePropertyChange("REIDENTIFY", 0, BatchReidentifyPanel.access$0(BatchReidentifyPanel.this).size());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                UIRegistry.clearSimpleGlassPaneMsg();
                if (this.errors.size() > 0) {
                    RecordSetIFace errs;
                    block7: {
                        errs = this.getErrorRecordSet();
                        DataProviderSessionIFace session = null;
                        try {
                            try {
                                session = DataProviderFactory.getInstance().createSession();
                                session.beginTransaction();
                                session.save(errs);
                                session.commit();
                            }
                            catch (Exception ex) {
                                UsageTracker.incrHandledUsageCount();
                                ExceptionTracker.getInstance().capture(BatchReidentifyPanel.class, ex);
                                ex.printStackTrace();
                                session.close();
                                break block7;
                            }
                        }
                        catch (Throwable throwable) {
                            session.close();
                            throw throwable;
                        }
                        session.close();
                    }
                    UIRegistry.displayInfoMsgDlgLocalized("DET_BTCH_.ErrRSSaved", errs.getName());
                } else {
                    UIRegistry.displayInfoMsgDlgLocalized("DET_BTCH_.Success", new Object[0]);
                }
            }
        };
        final SimpleGlassPane gp = UIRegistry.writeSimpleGlassPaneMsg(UIRegistry.getResourceString("DET_BTCH_REIDENT_MENU"), 24);
        gp.setProgress(0);
        worker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("REIDENTIFY".equals(evt.getPropertyName())) {
                    double value = ((Integer)evt.getNewValue()).intValue();
                    int percent = (int)(value / (double)BatchReidentifyPanel.this.items.size() * 100.0);
                    gp.setProgress(percent);
                }
            }
        });
        worker.execute();
    }

    static /* synthetic */ Determination access$6(BatchReidentifyPanel batchReidentifyPanel) {
        return batchReidentifyPanel.determination;
    }

    class ColObjTaxa
    implements Comparable<ColObjTaxa> {
        protected String catalogNumber;
        protected String detDate;
        protected String typeStatus;
        protected String taxa;
        protected Integer colObjId;

        public ColObjTaxa(String catalogNumber, String detDate, String typeStatus, String taxa, Integer colObjId) {
            this.catalogNumber = catalogNumber;
            this.taxa = taxa;
            this.detDate = detDate;
            this.typeStatus = typeStatus;
            this.colObjId = colObjId;
        }

        public String getCatalogNumber() {
            return this.catalogNumber;
        }

        public String getTaxa() {
            return this.taxa;
        }

        public String getDetDate() {
            return this.detDate;
        }

        public String getTypeStatus() {
            return this.typeStatus;
        }

        public Integer getColObjId() {
            return this.colObjId;
        }

        @Override
        public int compareTo(ColObjTaxa o) {
            return this.catalogNumber.compareTo(o.catalogNumber);
        }
    }

    class ColObjTaxaTableModel
    extends DefaultTableModel {
        private String[] header = new String[]{"catalogNumber", "determinedDate", "typeStatusName", ""};
        private int[] tblIds = new int[]{CollectionObject.getClassTableId(), Determination.getClassTableId(), Determination.getClassTableId()};

        public ColObjTaxaTableModel() {
            int i = 0;
            while (i < this.tblIds.length) {
                this.header[i] = DBTableIdMgr.getInstance().getTitleForField(this.tblIds[i], this.header[i]);
                ++i;
            }
            this.header[this.tblIds.length] = DBTableIdMgr.getInstance().getTitleForId(Taxon.getClassTableId());
        }

        public void fireDataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.header != null ? this.header.length : 0;
        }

        @Override
        public String getColumnName(int column) {
            return this.header[column];
        }

        @Override
        public Object getValueAt(int row, int column) {
            ColObjTaxa cot = (ColObjTaxa)BatchReidentifyPanel.this.items.get(row);
            switch (column) {
                case 0: {
                    return cot.getCatalogNumber();
                }
                case 1: {
                    return cot.getDetDate();
                }
                case 2: {
                    return cot.getTypeStatus();
                }
                case 3: {
                    return cot.getTaxa();
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return BatchReidentifyPanel.this.items.size();
        }
    }
}

