/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui;

import edu.ku.brc.af.core.db.AutoNumberIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatter;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterField;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.ui.DateWrapper;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.text.DecimalFormatSymbols;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class BaseUIFieldFormatter
implements UIFieldFormatterIFace,
Cloneable {
    protected static final String deftitle = UIRegistry.getResourceString("FFE_DEFAULT");
    protected String name;
    protected String title;
    protected boolean isNumericCatalogNumber;
    protected boolean isIncrementer;
    protected int length;
    protected int uiLength;
    protected AutoNumberIFace autoNumber;
    protected UIFieldFormatterField field;
    protected Vector<UIFieldFormatterField> fields = null;
    protected Pair<Integer, Integer> incPos;
    protected String pattern;
    protected boolean isDefault = false;
    protected UIFieldFormatterIFace.PartialDateEnum partialDateType = UIFieldFormatterIFace.PartialDateEnum.None;
    protected Boolean hasDash = null;

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getFieldName() {
        return "catalogNumber";
    }

    @Override
    public void setFieldName(String fieldName) {
    }

    @Override
    public Class<?> getDataClass() {
        return String.class;
    }

    @Override
    public void setDataClass(Class<?> dataClass) {
    }

    @Override
    public void setType(UIFieldFormatterIFace.FormatterType type) {
    }

    @Override
    public String getSample() {
        return "123";
    }

    @Override
    public boolean byYearApplies() {
        return false;
    }

    @Override
    public boolean getByYear() {
        return false;
    }

    @Override
    public void setByYear(boolean byYear) {
    }

    @Override
    public DateWrapper getDateWrapper() {
        return null;
    }

    @Override
    public Vector<UIFieldFormatterField> getFields() {
        return this.fields;
    }

    @Override
    public UIFieldFormatterField getYear() {
        return null;
    }

    @Override
    public Pair<Integer, Integer> getIncPosition() {
        return this.incPos;
    }

    @Override
    public Pair<Integer, Integer> getYearPosition() {
        return null;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void resetLength() {
    }

    @Override
    public int getUILength() {
        return this.uiLength;
    }

    @Override
    public boolean isLengthOK(int lengthOfData) {
        return lengthOfData == this.getLength();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UIFieldFormatterIFace.PartialDateEnum getPartialDateType() {
        return this.partialDateType;
    }

    @Override
    public void setPartialDateType(UIFieldFormatterIFace.PartialDateEnum partialDateType) {
        this.partialDateType = partialDateType;
    }

    @Override
    public boolean isDate() {
        return false;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Override
    public boolean isIncrementer() {
        return this.isIncrementer;
    }

    @Override
    public void setIncrementer(boolean isIncrementer) {
    }

    @Override
    public boolean isFromUIFormatter() {
        return this.isNumericCatalogNumber;
    }

    @Override
    public Object formatFromUI(Object data) {
        String dataStr;
        if (this.isNumericCatalogNumber && data != null && data instanceof String && UIHelper.isANumber((String)data) && StringUtils.isNotEmpty((String)(dataStr = (String)data))) {
            if (this.isNumericCatalogNumber && dataStr.equals(this.pattern)) {
                return this.pattern;
            }
            char separator = DecimalFormatSymbols.getInstance().getDecimalSeparator();
            int sepIdx = dataStr.indexOf(separator);
            if (sepIdx >= 0) {
                int precision = dataStr.length() - sepIdx - 1;
                String fmtStr = "%0" + this.length + "." + precision + "f";
                return String.format(fmtStr, Float.valueOf(Float.parseFloat((String)data)));
            }
            String fmtStr = "%0" + this.length + "d";
            return String.format(fmtStr, Integer.parseInt((String)data));
        }
        return data;
    }

    @Override
    public Object formatToUI(Object ... datas) {
        Object data = datas[0];
        if (this.isNumericCatalogNumber && data != null) {
            if (this.isNumericCatalogNumber && data instanceof String && StringUtils.isEmpty((String)data.toString())) {
                return this.pattern;
            }
            return StringUtils.stripStart((String)data.toString(), (String)"0");
        }
        return data;
    }

    @Override
    public boolean isInBoundFormatter() {
        return this.isNumericCatalogNumber;
    }

    @Override
    public String toPattern() {
        return this.pattern;
    }

    @Override
    public AutoNumberIFace getAutoNumber() {
        return this.autoNumber;
    }

    @Override
    public void setAutoNumber(AutoNumberIFace autoNumber) {
        this.autoNumber = autoNumber;
    }

    @Override
    public String getNextNumber(String value) {
        return this.getNextNumber(value, false);
    }

    @Override
    public String getNextNumber(String value, boolean incrementValue) {
        if (this.autoNumber != null) {
            String number;
            String val = value;
            if (StringUtils.isEmpty((String)val)) {
                int i = 0;
                while (i < this.getLength()) {
                    val = String.valueOf(val) + ' ';
                    ++i;
                }
            }
            if ((number = this.autoNumber.getNextNumber(this, val, incrementValue)) == null && this.autoNumber.isInError()) {
                UIRegistry.showError(this.autoNumber.getErrorMsg());
            } else {
                return number;
            }
        }
        return null;
    }

    @Override
    public boolean isUserInputNeeded() {
        if (!this.isNumericCatalogNumber) {
            for (UIFieldFormatterField f : this.fields) {
                UIFieldFormatterField.FieldType type = f.getType();
                if (type != UIFieldFormatterField.FieldType.alphanumeric || type != UIFieldFormatterField.FieldType.alpha) {
                    return true;
                }
                if (type == UIFieldFormatterField.FieldType.numeric || f.isIncrementer()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasDash() {
        if (this.hasDash == null) {
            this.hasDash = false;
            for (UIFieldFormatterField fld : this.getFields()) {
                if (!fld.isSeparator() && !fld.isConstant() || !fld.getValue().equals("-")) continue;
                this.hasDash = true;
                break;
            }
        }
        return this.hasDash;
    }

    @Override
    public boolean isNumeric() {
        return this.isNumericCatalogNumber;
    }

    @Override
    public Number getMaxValue() {
        return this.isNumericCatalogNumber ? Integer.valueOf(Integer.MAX_VALUE) : null;
    }

    @Override
    public Number getMinValue() {
        return this.isNumericCatalogNumber ? Integer.valueOf(0) : null;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.getTitle());
        str.append(" [");
        for (UIFieldFormatterField fld : this.fields) {
            str.append(fld.getValue());
        }
        str.append("]");
        str.append(this.isDefault ? String.valueOf(' ') + deftitle : "");
        return str.toString();
    }

    @Override
    public boolean isSystem() {
        return true;
    }

    @Override
    public boolean isValid(String value) {
        if (this.isNumericCatalogNumber) {
            return StringUtils.isNotEmpty((String)value) && value.length() == this.length && StringUtils.isNumeric((String)value);
        }
        return UIFieldFormatter.isValid(this, value, false);
    }

    @Override
    public void toXML(StringBuilder sb) {
        sb.append("  <format");
        XMLHelper.xmlAttr(sb, "system", true);
        XMLHelper.xmlAttr(sb, "name", this.name);
        XMLHelper.xmlAttr(sb, "class", CollectionObject.class.getName());
        XMLHelper.xmlAttr(sb, "fieldname", this.getFieldName());
        XMLHelper.xmlAttr(sb, "default", this.isDefault);
        sb.append(">\n");
        if (this.autoNumber != null) {
            this.autoNumber.toXML(sb);
        }
        sb.append("    <external>" + this.getClass().getName() + "</external>\n");
        sb.append("  </format>\n\n");
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BaseUIFieldFormatter uif = (BaseUIFieldFormatter)super.clone();
        uif.fields = new Vector();
        for (UIFieldFormatterField fld : this.fields) {
            uif.fields.add((UIFieldFormatterField)fld.clone());
        }
        return uif;
    }
}

