/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui;

import edu.ku.brc.specify.datamodel.Attachment;
import edu.ku.brc.specify.ui.ObjectIconMapper;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.thumbnails.Thumbnailer;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AttachmentIconMapper
implements ObjectIconMapper {
    private static final Logger log = Logger.getLogger(AttachmentIconMapper.class);
    protected Hashtable<Attachment, ImageIcon> thumbnailCache = new Hashtable();
    protected List<Attachment> thumbGenStarted = new Vector<Attachment>();

    @Override
    public Class<?>[] getMappedClasses() {
        Class[] mappedClasses = new Class[]{Attachment.class};
        return mappedClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageIcon getIcon(Object obj) {
        String imgIconName;
        String ext;
        String mimeType;
        final IconManager.IconSize size = IconManager.IconSize.Std32;
        final Attachment attatchment = (Attachment)obj;
        ImageIcon cachedIcon = this.thumbnailCache.get(attatchment);
        if (cachedIcon != null) {
            return cachedIcon;
        }
        File thumb = AttachmentUtils.getAttachmentManager().getThumbnail(attatchment);
        if (thumb != null) {
            if (thumb.exists()) {
                ImageIcon icon = new ImageIcon(thumb.getAbsolutePath());
                icon = IconManager.getScaledIcon(icon, IconManager.IconSize.NonStd, size);
                this.thumbnailCache.put(attatchment, icon);
                return icon;
            }
            return IconManager.getIcon("BrokenImage");
        }
        boolean doGen = true;
        List<Attachment> list = this.thumbGenStarted;
        synchronized (list) {
            if (thumb == null || this.thumbGenStarted.contains(attatchment)) {
                doGen = false;
            }
        }
        final String origFilename = attatchment.getOrigFilename();
        if (origFilename != null && doGen) {
            List<Attachment> list2 = this.thumbGenStarted;
            synchronized (list2) {
                this.thumbGenStarted.add(attatchment);
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    log.debug((Object)("Starting thumb gen thread for " + attatchment.getOrigFilename()));
                    Thumbnailer thumbnailGen = AttachmentUtils.getThumbnailer();
                    File thumbFile = null;
                    try {
                        thumbFile = File.createTempFile("sp6_thumb_", null);
                        thumbFile.deleteOnExit();
                        log.debug((Object)("Generating thumb for " + attatchment.getOrigFilename()));
                        thumbnailGen.generateThumbnail(origFilename, thumbFile.getAbsolutePath(), false);
                        log.debug((Object)("Done generating thumb for " + attatchment.getOrigFilename()));
                    }
                    catch (IOException e) {
                        thumbFile = null;
                    }
                    if (thumbFile != null) {
                        ImageIcon icon = new ImageIcon(thumbFile.getAbsolutePath());
                        icon = IconManager.getScaledIcon(icon, IconManager.IconSize.NonStd, size);
                        log.debug((Object)("Caching thumb for " + attatchment.getOrigFilename()));
                        AttachmentIconMapper.this.thumbnailCache.put(attatchment, icon);
                    }
                }
            };
            Thread t = new Thread(r);
            t.start();
        }
        if ((mimeType = attatchment.getMimeType()) == null) {
            return IconManager.getIcon("unknown", size);
        }
        int inx = mimeType.indexOf(47);
        if (inx > -1) {
            ImageIcon icon;
            String mimePrefix = mimeType.substring(0, inx);
            String mimeStr = Thumbnailer.getIconNameFromExtension(mimePrefix);
            if (mimeStr != null && (icon = IconManager.getIcon(mimeStr, size)) != null) {
                return icon;
            }
            if (inx == 11 && mimePrefix.equalsIgnoreCase("application") && !(mimeStr = mimeType.substring(inx + 1, mimeType.length())).equals("octet-stream") && (icon = IconManager.getIcon(mimeStr, size)) != null) {
                return icon;
            }
        }
        if (StringUtils.isNotEmpty((String)origFilename) && (ext = FilenameUtils.getExtension((String)origFilename)) != null && (imgIconName = Thumbnailer.getIconNameFromExtension(ext)) != null) {
            return IconManager.getIcon(imgIconName, size);
        }
        return IconManager.getIcon("unknown", size);
    }
}

