/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui;

import com.install4j.api.launcher.ApplicationLauncher;
import com.install4j.api.update.ApplicationDisplayMode;
import com.install4j.api.update.UpdateChecker;
import com.install4j.api.update.UpdateDescriptor;
import com.install4j.api.update.UpdateDescriptorEntry;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.FrameworkAppIFace;
import edu.ku.brc.af.core.MacOSAppHandler;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.AppPrefsEditor;
import edu.ku.brc.af.prefs.PreferencesDlg;
import edu.ku.brc.af.tasks.BaseTask;
import edu.ku.brc.af.ui.ProcessListUtil;
import edu.ku.brc.af.ui.db.DatabaseLoginListener;
import edu.ku.brc.af.ui.db.DatabaseLoginPanel;
import edu.ku.brc.af.ui.forms.FormHelper;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.specify.config.init.RegisterSpecify;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.CustomFrame;
import edu.ku.brc.ui.GraphicsUtils;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.JTiledToolbar;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.ToolbarLayoutManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.VerticalSeparator;
import edu.ku.brc.ui.dnd.GhostGlassPane;
import edu.ku.brc.ui.skin.SkinItem;
import edu.ku.brc.ui.skin.SkinsMgr;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.TeeOutputStream;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AppBase
extends JPanel
implements DatabaseLoginListener,
CommandListener,
FrameworkAppIFace {
    private static final Logger log = Logger.getLogger(AppBase.class);
    private static AppBase appInstance = null;
    public static final String ERROR_LOG = "error.log";
    public static final String SPECIFY_LOG = "specify.log";
    public static final String OUTPUT_LOG = "output.log";
    public static final String ERRORSYS_LOG = "error_sys.log";
    protected JStatusBar statusField = null;
    protected JMenuBar menuBar = null;
    protected JFrame topFrame = null;
    protected JLabel appIcon = null;
    protected DatabaseLoginPanel dbLoginPanel = null;
    protected String databaseName = null;
    protected String userName = null;
    protected GhostGlassPane glassPane;
    protected String appName = "Specify";
    protected String appVersion = "6.0";
    protected String appBuildVersion = "(Unknown)";

    protected void preStartUp() {
        new MacOSAppHandler(this);
        AppBase.setUpSystemProperties();
    }

    public static void checkForSpecifyAppsRunning() {
        List<Integer> ids = ProcessListUtil.getProcessIdWithText("exe4j.moduleName", "specify", "SpiReport");
        if (ids.size() > 1) {
            UIRegistry.showLocalizedMsg("WARNING", "Specify.TOO_MANY_SP", new Object[0]);
            System.exit(0);
        }
    }

    public static void setUpSystemProperties() {
        System.setProperty("edu.ku.brc.af.ui.forms.ViewFactory", "edu.ku.brc.specify.config.SpecifyViewFactory");
        System.setProperty("edu.ku.brc.af.core.AppContextMgrFactory", "edu.ku.brc.specify.config.SpecifyAppContextMgr");
        System.setProperty("edu.ku.brc.af.prefs.AppPrefsIOIFace", "edu.ku.brc.specify.config.AppPrefsDBIOIImpl");
        System.setProperty("edu.ku.brc.ui.ViewBasedDialogFactoryIFace", "edu.ku.brc.specify.ui.DBObjDialogFactory");
        System.setProperty("edu.ku.brc.ui.forms.DraggableRecordIdentifierFactory", "edu.ku.brc.specify.ui.SpecifyDraggableRecordIdentiferFactory");
        System.setProperty("edu.ku.brc.dbsupport.AuditInterceptor", "edu.ku.brc.specify.dbsupport.AuditInterceptor");
        System.setProperty("edu.ku.brc.dbsupport.DataProvider", "edu.ku.brc.specify.dbsupport.HibernateDataProvider");
        System.setProperty("edu.ku.brc.ui.db.PickListDBAdapterFactory", "edu.ku.brc.specify.ui.db.PickListDBAdapterFactory");
        System.setProperty("edu.ku.brc.dbsupport.CustomQueryFactory", "edu.ku.brc.specify.dbsupport.SpecifyCustomQueryFactory");
        System.setProperty("edu.ku.brc.ui.forms.formatters.UIFieldFormatterMgr", "edu.ku.brc.specify.ui.SpecifyUIFieldFormatterMgr");
        System.setProperty("edu.ku.brc.af.core.ExpressSearchSQLAdjuster", "edu.ku.brc.specify.dbsupport.SpecifyQueryAdjusterForDomain");
        System.setProperty("edu.ku.brc.af.core.SchemaI18NService", "edu.ku.brc.specify.config.SpecifySchemaI18NService");
        System.setProperty("edu.ku.brc.ui.weblink.WebLinkMgr", "edu.ku.brc.specify.config.SpecifyWebLinkMgr");
        System.setProperty("edu.ku.brc.ui.forms.formatters.DataObjFieldFormatMgr", "edu.ku.brc.specify.config.SpecifyDataObjFieldFormatMgr");
        System.setProperty("RecordSetFactory", "edu.ku.brc.specify.config.SpecifyRecordSetFactory");
        System.setProperty("edu.ku.brc.dbsupport.DBTableIdMgr", "edu.ku.brc.specify.config.SpecifyDBTableIdMgr");
        System.setProperty("edu.ku.brc.af.auth.SecurityMgr", "edu.ku.brc.af.auth.specify.SpecifySecurityMgr");
        System.setProperty("edu.ku.brc.af.core.db.BackupServiceFactory", "edu.ku.brc.af.core.db.MySQLBackupService");
        System.setProperty("edu.ku.brc.exceptions.ExceptionTracker", "edu.ku.brc.specify.config.SpecifyExceptionTracker");
        System.setProperty(DBMSUserMgr.factoryName, "edu.ku.brc.dbsupport.MySQLDMBSUserMgr");
        System.setProperty("edu.ku.brc.af.core.db.SchmeaUpdateService", "edu.ku.brc.specify.dbsupport.SpecifySchemaUpdateService");
        System.setProperty("edu.ku.brc.af.core.CollectionObjLSIDGenFactory", "edu.ku.brc.specify.config.SpecifyLSIDGeneratorFactory");
    }

    protected void setAppIcon(String imgEncoded) {
        String appIconName = "AppIcon";
        String innerAppIconName = "InnerAppIcon";
        ImageIcon appImgIcon = null;
        if (StringUtils.isNotEmpty((String)imgEncoded) && (appImgIcon = GraphicsUtils.uudecodeImage("", imgEncoded)) != null && appImgIcon.getIconWidth() == 32 && appImgIcon.getIconHeight() == 32) {
            this.appIcon.setIcon(appImgIcon);
            CustomDialog.setAppIcon(appImgIcon);
            CustomFrame.setAppIcon(appImgIcon);
            IconManager.register(innerAppIconName, appImgIcon, null, IconManager.IconSize.Std32);
            return;
        }
        appImgIcon = IconManager.getImage(appIconName, IconManager.IconSize.Std32);
        this.appIcon.setIcon(appImgIcon);
        if (!UIHelper.isMacOS()) {
            appImgIcon = IconManager.getImage("SpecifyWhite32", IconManager.IconSize.Std32);
        }
        CustomDialog.setAppIcon(appImgIcon);
        CustomFrame.setAppIcon(appImgIcon);
        IconManager.register(innerAppIconName, appImgIcon, null, IconManager.IconSize.Std32);
        if (this.topFrame != null) {
            this.topFrame.setIconImage(appImgIcon.getImage());
        }
    }

    protected JToolBar createToolBar() {
        JToolBar toolBar;
        SkinItem skinItem = SkinsMgr.getSkinItem("ToolBar");
        if (SkinsMgr.hasSkins() && skinItem != null && (skinItem.getBGImage() != null || skinItem.getBgColor() != null)) {
            JTiledToolbar ttb = new JTiledToolbar(skinItem.getBGImage());
            if (skinItem.getBgColor() != null) {
                ttb.setBackground(skinItem.getBgColor());
                ttb.setOpaque(true);
            } else {
                ttb.setOpaque(false);
            }
            toolBar = ttb;
        } else {
            toolBar = new JToolBar();
        }
        toolBar.setLayout(new ToolbarLayoutManager(2, 2));
        this.appIcon = new JLabel("  ");
        this.setAppIcon(AppPreferences.getRemote().get("ui.formatting.user_icon_image", null));
        CommandDispatcher.register("Preferences", new CommandListener(){

            @Override
            public void doCommand(CommandAction cmdAction) {
                if (cmdAction.isAction("Updated")) {
                    AppBase.this.setAppIcon(AppPreferences.getRemote().get("ui.formatting.user_icon_image", null));
                }
            }
        });
        return toolBar;
    }

    @Override
    public void doPreferences() {
        if (AppContextMgr.getInstance().hasContext()) {
            PreferencesDlg dlg = new PreferencesDlg(false);
            dlg.setVisible(true);
        } else {
            UIRegistry.showLocalizedMsg("Specify.NOTAVAIL");
        }
    }

    protected void checkForUpdates() {
        block7: {
            try {
                UpdateDescriptor updateDesc = UpdateChecker.getUpdateDescriptor((String)UIRegistry.getResourceString("UPDATE_PATH"), (ApplicationDisplayMode)ApplicationDisplayMode.UNATTENDED);
                UpdateDescriptorEntry entry = updateDesc.getPossibleUpdateEntry();
                if (entry != null) {
                    Object[] options = new Object[]{UIRegistry.getResourceString("Specify.INSTALLUPDATE"), UIRegistry.getResourceString("Specify.SKIP")};
                    int userChoice = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), UIRegistry.getLocalizedMessage("Specify.UPDATE_AVAIL", entry.getNewVersion()), UIRegistry.getResourceString("Specify.UPDATE_AVAIL_TITLE"), 1, 3, null, options, options[0]);
                    if (userChoice == 0) {
                        if (!this.doExit(false)) {
                            return;
                        }
                        break block7;
                    }
                    return;
                }
                UIRegistry.showLocalizedError("Specify.NO_UPDATE_AVAIL");
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                UIRegistry.showLocalizedError("Specify.UPDATE_CHK_ERROR");
                return;
            }
        }
        try {
            ApplicationLauncher.Callback callback = new ApplicationLauncher.Callback(){

                public void exited(int exitValue) {
                    System.err.println("exitValue: " + exitValue);
                }

                public void prepareShutdown() {
                    System.err.println("prepareShutdown");
                }
            };
            ApplicationLauncher.launchApplication((String)"100", null, (boolean)true, (ApplicationLauncher.Callback)callback);
        }
        catch (Exception ex) {
            System.err.println("EXPCEPTION");
        }
    }

    private static File getFile(String path, String fileName, boolean doCreate) {
        File dir;
        String fullPath = String.valueOf(path) + File.separator + fileName;
        File file = new File(fullPath);
        if (file.exists()) {
            return file;
        }
        if (doCreate && ((dir = new File(path)).exists() || dir.mkdirs())) {
            return file;
        }
        return null;
    }

    private static File getFullLogFilePath(String fileName) {
        String homePath = System.getProperty("user.home");
        String userHome = String.valueOf(homePath) + File.separator + "Specify";
        File logFile = AppBase.getFile(userHome, fileName, true);
        if (logFile != null) {
            return logFile;
        }
        return null;
    }

    protected static JScrollPane getLogFilePanel(File logFile, boolean doError) {
        JTextArea textArea = new JTextArea();
        if (logFile.exists()) {
            try {
                textArea.setText(FileUtils.readFileToString((File)logFile));
            }
            catch (Exception exception) {}
        } else {
            textArea.setText(doError ? UIRegistry.getResourceString("Specify.LOG_NO_ERRORS") : UIRegistry.getResourceString("Specify.LOG_EMPTY"));
        }
        textArea.setEditable(false);
        return new JScrollPane(textArea, 20, 30);
    }

    public static void displaySpecifyLogFiles() {
        File spLogFile = AppBase.getFullLogFilePath(SPECIFY_LOG);
        File errLogFile = AppBase.getFullLogFilePath(ERRORSYS_LOG);
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.add(UIRegistry.getResourceString("Specify.ERROR"), AppBase.getLogFilePanel(errLogFile, true));
        tabPane.add("Specify", AppBase.getLogFilePanel(spLogFile, true));
        String title = UIRegistry.getResourceString("Specify.LOG_FILES_TITLE");
        CustomDialog dialog = new CustomDialog((JFrame)UIRegistry.getTopWindow(), title, true, 1, (Component)tabPane);
        String okLabel = UIRegistry.getResourceString("Specify.CLOSE");
        dialog.setOkLabel(okLabel);
        dialog.createUI();
        dialog.setSize(800, 600);
        UIHelper.centerWindow(dialog);
        dialog.setVisible(true);
    }

    public static void setupTeeForStdErrStdOut(boolean doStdErr, boolean doStdOut) {
        try {
            TeeOutputStream tee;
            File file;
            if (doStdOut && (file = AppBase.getFullLogFilePath(OUTPUT_LOG)) != null) {
                PrintStream out = new PrintStream(new FileOutputStream(file));
                tee = new TeeOutputStream(System.out, out);
                System.setOut(tee);
            }
            if (doStdErr && (file = AppBase.getFullLogFilePath(ERRORSYS_LOG)) != null) {
                PrintStream err = new PrintStream(new FileOutputStream(file));
                tee = new TeeOutputStream(System.err, err);
                System.setErr(tee);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void openPrefsEditor(AppPreferences prefs, String titleKey) {
        String titleStr = UIRegistry.getResourceString("Specify." + titleKey);
        CustomDialog dialog = new CustomDialog(this.topFrame, titleStr, true, 1, (Component)new AppPrefsEditor(prefs));
        String okLabel = UIRegistry.getResourceString("Specify.CLOSE");
        dialog.setOkLabel(okLabel);
        dialog.pack();
        UIHelper.centerAndShow(dialog);
        if (!dialog.isCancelled()) {
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
            CommandDispatcher.dispatch(new CommandAction("Preferences", "Changed", prefs));
        }
    }

    private void openLocalPrefs() {
        this.openPrefsEditor(AppPreferences.getLocalPrefs(), "LOCAL_PREFS");
    }

    private void openRemotePrefs() {
        this.openPrefsEditor(AppPreferences.getRemote(), "REMOTE_PREFS");
    }

    private void openGlobalPrefs() {
        this.openPrefsEditor(AppPreferences.getGlobalPrefs(), "GLOBAL_PREFS");
    }

    @Override
    public void doAbout() {
        AppContextMgr acm = AppContextMgr.getInstance();
        boolean hasContext = acm.hasContext();
        int baseNumRows = 9;
        String serverName = AppPreferences.getLocalPrefs().get("login.servers_selected", null);
        if (serverName != null) {
            ++baseNumRows;
        }
        CellConstraints cc = new CellConstraints();
        PanelBuilder infoPB = new PanelBuilder(new FormLayout("p,6px,f:p:g", "p,4px,p,4px," + UIHelper.createDuplicateJGoodiesDef("p", "2px", baseNumRows)));
        JLabel iconLabel = new JLabel(IconManager.getIcon("SpecifyLargeIcon"), 0);
        PanelBuilder iconPB = new PanelBuilder(new FormLayout("p", "20px,t:p,f:p:g"));
        iconPB.add((Component)iconLabel, cc.xy(1, 2));
        if (hasContext) {
            Vector<Object[]> list;
            DBTableIdMgr tableMgr = DBTableIdMgr.getInstance();
            boolean hasReged = !RegisterSpecify.isAnonymous() && RegisterSpecify.hasInstitutionRegistered();
            int y = 1;
            infoPB.addSeparator(UIRegistry.getResourceString("Specify.SYS_INFO"), cc.xyw(1, y, 3));
            JLabel lbl = UIHelper.createLabel(this.databaseName);
            infoPB.add((Component)UIHelper.createI18NFormLabel("Specify.DB"), cc.xy(1, y += 2));
            infoPB.add((Component)lbl, cc.xy(3, y));
            lbl.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        AppBase.this.openLocalPrefs();
                    }
                }
            });
            infoPB.add((Component)UIHelper.createFormLabel(tableMgr.getTitleForId(Institution.getClassTableId())), cc.xy(1, y += 2));
            lbl = UIHelper.createLabel(acm.getClassObject(Institution.class).getName());
            infoPB.add((Component)lbl, cc.xy(3, y));
            lbl.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        AppBase.this.openRemotePrefs();
                    }
                }
            });
            infoPB.add((Component)UIHelper.createFormLabel(tableMgr.getTitleForId(Division.getClassTableId())), cc.xy(1, y += 2));
            infoPB.add((Component)UIHelper.createLabel(acm.getClassObject(Division.class).getName()), cc.xy(3, y));
            infoPB.add((Component)UIHelper.createFormLabel(tableMgr.getTitleForId(Discipline.getClassTableId())), cc.xy(1, y += 2));
            infoPB.add((Component)UIHelper.createLabel(acm.getClassObject(Discipline.class).getName()), cc.xy(3, y));
            infoPB.add((Component)UIHelper.createFormLabel(tableMgr.getTitleForId(Collection.getClassTableId())), cc.xy(1, y += 2));
            infoPB.add((Component)UIHelper.createLabel(acm.getClassObject(Collection.class).getCollectionName()), cc.xy(3, y));
            infoPB.add((Component)UIHelper.createI18NFormLabel("Specify.BLD"), cc.xy(1, y += 2));
            infoPB.add((Component)UIHelper.createLabel(this.appBuildVersion), cc.xy(3, y));
            infoPB.add((Component)UIHelper.createI18NFormLabel("Specify.REG"), cc.xy(1, y += 2));
            infoPB.add((Component)UIHelper.createI18NLabel(hasReged ? "Specify.HASREG" : "Specify.NOTREG"), cc.xy(3, y));
            String isaNumber = RegisterSpecify.getISANumber();
            infoPB.add((Component)UIHelper.createI18NFormLabel("Specify.ISANUM"), cc.xy(1, y += 2));
            infoPB.add((Component)UIHelper.createLabel(StringUtils.isNotEmpty((String)isaNumber) ? isaNumber : ""), cc.xy(3, y));
            y += 2;
            if (serverName != null) {
                infoPB.add((Component)UIHelper.createI18NFormLabel("Specify.SERVER"), cc.xy(1, y));
                infoPB.add((Component)UIHelper.createLabel(StringUtils.isNotEmpty((String)serverName) ? serverName : ""), cc.xy(3, y));
                y += 2;
            }
            if (StringUtils.contains((String)DBConnection.getInstance().getConnectionStr(), (String)"mysql") && (list = BasicSQLUtils.query("select version() as ve")) != null && list.size() > 0) {
                infoPB.add((Component)UIHelper.createFormLabel("MySQL Version"), cc.xy(1, y));
                infoPB.add((Component)UIHelper.createLabel(list.get(0)[0].toString()), cc.xy(3, y));
                y += 2;
            }
            infoPB.add((Component)UIHelper.createFormLabel("Java Version"), cc.xy(1, y));
            infoPB.add((Component)UIHelper.createLabel(System.getProperty("java.version")), cc.xy(3, y));
            y += 2;
        }
        String txt = AppBase.getAboutText(this.appName, this.appVersion);
        JLabel txtLbl = UIHelper.createLabel(txt);
        txtLbl.setFont(UIRegistry.getDefaultFont());
        JEditorPane txtPane = new JEditorPane("text/html", txt);
        txtPane.setEditable(false);
        txtPane.setBackground(new JPanel().getBackground());
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,20px,f:min(400px;p):g,10px,8px,10px,p:g", "f:p:g"));
        pb.add((Component)iconPB.getPanel(), cc.xy(1, 1));
        pb.add((Component)txtPane, cc.xy(3, 1));
        Color bg = this.getBackground();
        if (hasContext) {
            pb.add((Component)new VerticalSeparator(bg.darker(), bg.brighter()), cc.xy(5, 1));
            pb.add((Component)infoPB.getPanel(), cc.xy(7, 1));
        }
        pb.setDefaultDialogBorder();
        String title = UIRegistry.getResourceString("Specify.ABOUT");
        CustomDialog aboutDlg = new CustomDialog(this.topFrame, String.valueOf(title) + " " + this.appName, true, 1, (Component)pb.getPanel());
        String okLabel = UIRegistry.getResourceString("Specify.CLOSE");
        aboutDlg.setOkLabel(okLabel);
        aboutDlg.createUI();
        aboutDlg.pack();
        Dimension size = aboutDlg.getSize();
        size.height += 120;
        aboutDlg.setSize(size);
        txtPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        AttachmentUtils.openURI(event.getURL().toURI());
                    }
                    catch (Exception e) {
                        UsageTracker.incrHandledUsageCount();
                    }
                }
            }
        });
        UIHelper.centerAndShow(aboutDlg);
    }

    public static String getAboutText(String appNameArg, String appVersionArg) {
        return "<html><font face=\"sans-serif\" size=\"11pt\">" + appNameArg + " " + appVersionArg + "<br><br>Specify Software Project<br>" + "Biodiversity Institute<br>University of Kansas<br>1345 Jayhawk Blvd.<br>Lawrence, KS  USA 66045<br><br>" + "<a href=\"http://www.specifysoftware .org\">www.specifysoftware.org</a>" + "<br><a href=\"mailto:specify@ku.edu\">specify@ku.edu</a><br>" + "<p>The Specify Software Project is " + "funded by the Advances in Biological Informatics Program, " + "U.S. National Science Foundation  (Award DBI-0446544 and earlier awards).<br><br>" + "Specify 6.0 Copyright \u00a9 2009 University of Kansas Center for Research. " + "Specify comes with ABSOLUTELY NO WARRANTY.<br><br>" + "This is free software licensed under GNU General Public License 2 (GPL2).</P></font></html>";
    }

    @Override
    public boolean doExit(boolean doAppExit) {
        return true;
    }

    public JStatusBar getStatusField() {
        return this.statusField;
    }

    protected String getTitle() {
        String resAppVersion = UIRegistry.getAppVersion();
        if (StringUtils.isNotEmpty((String)resAppVersion)) {
            this.appVersion = resAppVersion;
        }
        return AppBase.getTitle(this.appVersion, this.appBuildVersion, this.appName);
    }

    public static String getTitle(String appVersionStr, String appBuildVersionStr, String appNameStr) {
        String title = "";
        String resAppVersion = UIRegistry.getAppVersion();
        title = StringUtils.isNotEmpty((String)resAppVersion) ? String.valueOf(appNameStr) + " " + appVersionStr : String.valueOf(appNameStr) + " " + appVersionStr + "  - " + appBuildVersionStr;
        if (UIRegistry.isEmbedded().booleanValue()) {
            title = String.valueOf(title) + " (EZDB)";
        } else if (UIRegistry.isMobile()) {
            title = String.valueOf(title) + " (Mobile)";
        }
        return title;
    }

    public void showApp() {
        JFrame f = this.getFrame();
        f.setTitle(this.getTitle());
        f.getContentPane().add((Component)this, "Center");
        f.pack();
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AppBase.this.doExit(true);
            }
        });
        UIHelper.centerWindow(f);
        Rectangle r = f.getBounds();
        int x = AppPreferences.getLocalPrefs().getInt("APP.X", r.x);
        int y = AppPreferences.getLocalPrefs().getInt("APP.Y", r.y);
        int w = AppPreferences.getLocalPrefs().getInt("APP.W", r.width);
        int h = AppPreferences.getLocalPrefs().getInt("APP.H", r.height);
        UIHelper.positionAndFitToScreen(f, x, y, w, h);
        f.setVisible(true);
    }

    public JFrame getFrame() {
        return this.topFrame;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setStatus(final String str) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppBase.getAppInstance().getStatusField().setText(str);
            }
        });
    }

    protected static void setupDefaultFonts() {
        Font labelFont = UIHelper.createLabel("").getFont();
        Font defaultFont = !UIHelper.isMacOS() ? labelFont : labelFont;
        BaseTask.setToolbarBtnFont(defaultFont);
        RolloverCommand.setDefaultFont(defaultFont);
    }

    public void restartApp(Window window, String databaseNameArg, String userNameArg, boolean startOver, boolean firstTime) {
    }

    @Override
    public void loggedIn(Window window, String databaseNameArg, String userNameArg) {
        log.debug((Object)("loggedIn - database[" + databaseNameArg + "] username[" + userNameArg + "]"));
        boolean firstTime = this.databaseName == null;
        this.databaseName = databaseNameArg;
        this.userName = userNameArg;
        FormHelper.setCurrentUserEditStr(userNameArg);
        AppPreferences.setConnectedToDB(true);
        this.restartApp(window, this.databaseName, this.userName, false, firstTime);
        this.statusField.setSectionText(2, this.userName);
        this.statusField.setSectionToolTipText(2, DBTableIdMgr.getInstance().getTitleForId(SpecifyUser.getClassTableId()));
    }

    protected void setDatabaseNameAndCollection() {
        AppContextMgr mgr = AppContextMgr.getInstance();
        String disciplineName = mgr.getClassObject(Discipline.class).getName();
        String collectionName = mgr.getClassObject(Collection.class) != null ? mgr.getClassObject(Collection.class).getCollectionName() : "";
        this.statusField.setSectionText(0, disciplineName);
        this.statusField.setSectionText(1, collectionName);
        this.statusField.setSectionToolTipText(0, DBTableIdMgr.getInstance().getTitleForId(Discipline.getClassTableId()));
        this.statusField.setSectionToolTipText(1, DBTableIdMgr.getInstance().getTitleForId(Collection.getClassTableId()));
        AppPreferences.getLocalPrefs().put("CURRENT_DB", this.databaseName);
    }

    @Override
    public void cancelled() {
        System.exit(0);
    }

    public static void adjustLocaleFromPrefs() {
        String language = AppPreferences.getLocalPrefs().get("locale.lang", null);
        if (language != null) {
            String country = AppPreferences.getLocalPrefs().get("locale.country", null);
            String variant = AppPreferences.getLocalPrefs().get("locale.var", null);
            Locale prefLocale = new Locale(language, country, variant);
            Locale.setDefault(prefLocale);
            UIRegistry.setResourceLocale(prefLocale);
        }
        try {
            ResourceBundle.getBundle("resources", Locale.getDefault());
        }
        catch (MissingResourceException ex) {
            Locale.setDefault(Locale.ENGLISH);
            UIRegistry.setResourceLocale(Locale.ENGLISH);
        }
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getAppBuildVersion() {
        return this.appBuildVersion;
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isType("App")) {
            if (cmdAction.isAction("AppReqRestart")) {
                UIRegistry.writeGlassPaneMsg(UIRegistry.getResourceString("Specify.RESET_ENV"), 24);
                SwingWorker workerThread = new SwingWorker(){

                    @Override
                    public Object construct() {
                        AppBase.this.restartApp(null, AppBase.this.databaseName, AppBase.this.userName, true, false);
                        return null;
                    }

                    @Override
                    public void finished() {
                        UIRegistry.clearGlassPaneMsg();
                    }
                };
                workerThread.start();
            } else if (cmdAction.isAction("AppReqExit")) {
                this.doExit(true);
            } else if (cmdAction.isAction("CheckForUpdates")) {
                this.checkForUpdates();
            }
        }
    }

    public static void processArgs(String[] args) {
        String embeddeddbdir;
        String embeddedStr;
        String mobile;
        String appdatadir;
        UIRegistry.setEmbeddedDBPath(UIRegistry.getDefaultEmbeddedDBPath());
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] pairs = s.split("=");
            if (pairs.length == 2) {
                if (pairs[0].startsWith("-D")) {
                    System.setProperty(pairs[0].substring(2, pairs[0].length()), pairs[1]);
                }
            } else {
                String symbol = pairs[0].substring(2, pairs[0].length());
                System.setProperty(symbol, symbol);
            }
            ++n2;
        }
        String appDir = System.getProperty("appdir");
        if (StringUtils.isNotEmpty((String)appDir)) {
            UIRegistry.setDefaultWorkingPath(appDir);
        }
        if (StringUtils.isNotEmpty((String)(appdatadir = System.getProperty("appdatadir")))) {
            UIRegistry.setBaseAppDataDir(appdatadir);
        }
        if (StringUtils.isNotEmpty((String)(mobile = System.getProperty("mobile")))) {
            UIRegistry.setMobile(true);
            DBConnection.setIsEmbeddedDB(true);
        }
        if (StringUtils.isNotEmpty((String)(embeddedStr = System.getProperty("embedded")))) {
            UIRegistry.setEmbedded(true);
            DBConnection.setIsEmbeddedDB(true);
        }
        if (StringUtils.isNotEmpty((String)(embeddeddbdir = System.getProperty("embeddeddbdir")))) {
            UIRegistry.setEmbeddedDBPath(embeddeddbdir);
        } else {
            UIRegistry.setEmbeddedDBPath(UIRegistry.getDefaultEmbeddedDBPath());
        }
    }

    public static AppBase getAppInstance() {
        return appInstance;
    }
}

