/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.treeutils;

import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.Treeable;
import java.util.List;
import javax.swing.SwingWorker;
import org.hibernate.HibernateException;

public abstract class TreeTraversalWorker<T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>>
extends SwingWorker<Boolean, Object> {
    protected static int writesPerFlush = 2000;
    protected DataProviderSessionIFace.QueryIFace childrenQuery = null;
    protected DataProviderSessionIFace.QueryIFace ancestorQuery = null;
    long progressChunk;
    int progressIncr;
    int progressPerCent;
    int writeCount;
    protected final D treeDef;
    protected DataProviderSessionIFace traversalSession = null;

    public TreeTraversalWorker(D treeDef) {
        this.treeDef = treeDef;
    }

    protected void initProgress() {
        int total = BasicSQLUtils.getNumRecords("select count(" + this.getNodeKeyFldName() + ") from " + this.getNodeTblName() + " where " + this.getNodeTreeFldName() + "=" + this.treeDef.getTreeDefId());
        this.progressChunk = Math.round(Math.floor((double)total / 100.0));
        if (this.progressChunk < 1L) {
            this.progressChunk = 1L;
        }
        this.progressIncr = 0;
        this.progressPerCent = 0;
    }

    protected void initCacheInfo() {
        this.writeCount = 0;
    }

    protected void incrementProgress() {
        if ((long)(++this.progressIncr) == this.progressChunk) {
            this.updateProgress();
            this.progressIncr = 0;
        }
    }

    protected void checkCache() throws Exception {
        if (++this.writeCount == writesPerFlush) {
            this.clearCache();
            this.writeCount = 0;
        }
    }

    protected void clearCache() throws Exception {
        this.traversalSession.flush();
        this.traversalSession.clear();
        this.traversalSession.commit();
        this.traversalSession.beginTransaction();
    }

    protected void updateProgress() {
        ++this.progressPerCent;
        if (this.progressPerCent > 100) {
            this.progressPerCent = 90;
        }
        this.setProgress(this.progressPerCent);
    }

    protected String getNodeKeyFldName() {
        return String.valueOf(this.treeDef.getNodeClass().getSimpleName()) + "Id";
    }

    protected String getNodeTblName() {
        return this.treeDef.getNodeClass().getSimpleName().toLowerCase();
    }

    protected String getNodeTreeFldName() {
        return String.valueOf(this.treeDef.getNodeClass().getSimpleName()) + "TreeDefId";
    }

    protected String getNodeParentFldName() {
        return "parentId";
    }

    protected T getTreeRoot() {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        boolean attached = false;
        try {
            Object rootDefItem = this.treeDef.getDefItemByRank(0);
            try {
                session.attach(rootDefItem);
                attached = true;
            }
            catch (HibernateException hibernateException) {
                // empty catch block
            }
            Treeable result = (Treeable)rootDefItem.getTreeEntries().iterator().next();
            if (attached) {
                session.evict(rootDefItem);
            }
            Treeable treeable = result;
            return (T)treeable;
        }
        finally {
            session.close();
        }
    }

    protected List<?> getChildIds(int parentId) {
        this.childrenQuery.setParameter("parentArg", parentId);
        return this.childrenQuery.list();
    }

    public String getProgressName() {
        return this.treeDef.getName();
    }

    protected void buildChildrenQuery() {
        String childrenSQL = "select " + this.getNodeKeyFldName() + " from " + this.getNodeTblName() + " where " + this.getNodeParentFldName() + " =:parentArg  order by name";
        this.childrenQuery = this.traversalSession.createQuery(childrenSQL, true);
    }
}

