/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.treeutils;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.treeutils.FullNameBuilder;
import edu.ku.brc.specify.treeutils.NodeNumberer;
import edu.ku.brc.specify.treeutils.TreeNodeInfo;
import edu.ku.brc.specify.treeutils.TreeTraversalWorker;
import java.awt.Window;
import java.util.LinkedList;
import java.util.List;

public class TreeRebuilder<T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>>
extends TreeTraversalWorker<T, D, I> {
    protected FullNameBuilder<T, D, I> fullNameBuilder;
    protected final int minRank;
    protected DataProviderSessionIFace.QueryIFace updateNodeQuery = null;
    protected final boolean doNodeNumbers;
    protected final boolean doFullNames;
    protected Window progWin = null;
    protected Boolean hasCompletedOK = null;

    public TreeRebuilder(D treeDef, int minRank, RebuildMode rebuildMode) {
        super(treeDef);
        this.minRank = minRank;
        this.doNodeNumbers = rebuildMode == RebuildMode.Full || rebuildMode == RebuildMode.NodeNumbers;
        this.doFullNames = rebuildMode == RebuildMode.Full || rebuildMode == RebuildMode.FullNames;
    }

    @Override
    protected Boolean doInBackground() throws Exception {
        this.traversalSession = DataProviderFactory.getInstance().createSession();
        try {
            this.traversalSession.beginTransaction();
            this.buildChildrenQuery();
            this.buildUpdateNodeQuery();
            Object root = this.getTreeRoot();
            this.initProgress();
            this.initCacheInfo();
            this.fullNameBuilder = new FullNameBuilder(this.treeDef);
            this.rebuildTree(new TreeNodeInfo(root.getTreeId(), root.getRankId(), root.getName(), root.getIsAccepted()), new LinkedList<TreeNodeInfo>(), 1);
            this.traversalSession.commit();
            Boolean bl = this.hasCompletedOK = Boolean.valueOf(true);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(NodeNumberer.class, e);
            Boolean bl = this.hasCompletedOK = Boolean.valueOf(false);
            return bl;
        }
        finally {
            this.traversalSession.close();
        }
    }

    public Boolean hasCompletedOK() {
        return this.hasCompletedOK;
    }

    @Override
    protected void buildChildrenQuery() {
        String childrenSQL = "select " + this.getNodeKeyFldName() + ", " + this.getNodeTblName() + ".Name, RankId, IsAccepted from " + this.getNodeTblName() + " where " + this.getNodeParentFldName() + " =:parentArg  order by name";
        this.childrenQuery = this.traversalSession.createQuery(childrenSQL, true);
    }

    protected int rebuildTree(TreeNodeInfo node, LinkedList<TreeNodeInfo> parents, int nodeNumber) throws Exception {
        int nn = nodeNumber;
        List<?> children = this.getChildrenInfo(node);
        boolean addParent = false;
        if (this.doFullNames && node.isAccepted() && this.fullNameBuilder.isInFullName(node.getRank())) {
            parents.addLast(node);
            addParent = true;
        }
        while (children.size() > 0) {
            Object child = children.get(0);
            Object[] childInfo = (Object[])child;
            nn = this.rebuildTree(new TreeNodeInfo((Integer)childInfo[0], (Integer)childInfo[2], (String)childInfo[1], (Boolean)childInfo[3]), parents, nn + 1);
            children.remove(0);
            child = null;
        }
        children = null;
        String fullName = null;
        if (this.doFullNames && node.isAccepted()) {
            if (addParent) {
                parents.removeLast();
            }
            fullName = this.fullNameBuilder.buildFullName(node, parents);
        }
        this.writeNode(node.getId(), fullName, nodeNumber, nn, node.isAccepted());
        this.incrementProgress();
        this.checkCache();
        return nn;
    }

    protected List<?> getChildrenInfo(TreeNodeInfo node) {
        this.childrenQuery.setParameter("parentArg", node.getId());
        return this.childrenQuery.list();
    }

    protected void writeNode(int nodeId, String fullName, int nodeNumber, int highestChildNodeNumber, boolean isAccepted) throws Exception {
        this.updateNodeQuery.setParameter("keyArg", nodeId);
        if (this.doFullNames) {
            this.updateNodeQuery.setParameter("fnArg", fullName);
        }
        if (this.doNodeNumbers) {
            this.updateNodeQuery.setParameter("nnArg", nodeNumber);
            this.updateNodeQuery.setParameter("hcnArg", highestChildNodeNumber);
        }
        this.updateNodeQuery.executeUpdate();
    }

    protected void buildUpdateNodeQuery() {
        String updateSQL = "update " + this.getNodeTblName() + " set ";
        if (this.doNodeNumbers) {
            updateSQL = String.valueOf(updateSQL) + "NodeNumber=:nnArg, HighestChildNodeNumber=:hcnArg";
            if (this.doFullNames) {
                updateSQL = String.valueOf(updateSQL) + ", ";
            }
        }
        if (this.doFullNames) {
            updateSQL = String.valueOf(updateSQL) + "FullName=case when :fnArg is not null then :fnArg else FullName end";
        }
        updateSQL = String.valueOf(updateSQL) + " where " + this.getNodeKeyFldName() + "=:keyArg";
        this.updateNodeQuery = this.traversalSession.createQuery(updateSQL, true);
    }

    public void setProgWin(Window progWin) {
        this.progWin = progWin;
    }

    @Override
    protected void done() {
        super.done();
        if (this.progWin != null) {
            this.progWin.setVisible(false);
        }
    }

    public static enum RebuildMode {
        Full,
        FullNames,
        NodeNumbers;

    }
}

