/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.treeutils;

import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.treeutils.TreeOrderSiblingComparator;
import java.util.Comparator;
import java.util.List;

public class TreePathComparator<T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>>
implements Comparator<T> {
    protected TreeOrderSiblingComparator siblingComp;
    protected boolean ignoreCase;

    public TreePathComparator(boolean ignoreCase) {
        this.siblingComp = new TreeOrderSiblingComparator(ignoreCase);
        this.ignoreCase = ignoreCase;
    }

    @Override
    public int compare(T o1, T o2) {
        if (o1.isDescendantOf(o2)) {
            return 1;
        }
        if (o2.isDescendantOf(o1)) {
            return -1;
        }
        List path1 = o1.getAllAncestors();
        path1.add(o1);
        List path2 = o2.getAllAncestors();
        path2.add(o2);
        int i = 0;
        while (i < Math.min(path1.size(), path2.size())) {
            Treeable t2;
            Treeable t1 = (Treeable)path1.get(i);
            if (t1 != (t2 = (Treeable)path2.get(i))) {
                return this.siblingComp.compare(t1, t2);
            }
            ++i;
        }
        return 0;
    }
}

