/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.treeutils;

import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.datamodel.busrules.BaseTreeBusRules;
import edu.ku.brc.specify.treeutils.TreeMergeException;
import edu.ku.brc.specify.treeutils.TreeMergerUIIFace;
import java.sql.Connection;
import java.sql.Statement;
import java.util.List;
import java.util.Vector;

public class TreeMerger<N extends Treeable<N, D, I>, D extends TreeDefIface<N, D, I>, I extends TreeDefItemIface<N, D, I>> {
    final TreeDefIface<N, D, I> treeDef;
    final DBTableInfo nodeTable;
    List<TreeMergerUIIFace<N, D, I>> listeners = new Vector<TreeMergerUIIFace<N, D, I>>();
    Connection connection = null;

    public TreeMerger(TreeDefIface<N, D, I> treeDef) {
        this.treeDef = treeDef;
        this.nodeTable = this.getNodeTable();
    }

    public void addListener(TreeMergerUIIFace<N, D, I> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TreeMergerUIIFace<N, D, I> listener) {
        this.listeners.remove(listener);
    }

    public DBTableInfo getNodeTable() {
        return DBTableIdMgr.getInstance().getByClassName(this.treeDef.getNodeClass().getName());
    }

    protected String getParentFld() {
        return "parentId";
    }

    protected String getAcceptedFld() {
        return "isaccepted";
    }

    public String getNameFld() {
        return "name";
    }

    public String getFullNameFld() {
        return "fullname";
    }

    protected List<Object[]> getChildren(Integer parentId) {
        return BasicSQLUtils.query(this.connection, "select " + this.nodeTable.getIdFieldName() + ", " + this.getNameFld() + ", " + this.getAcceptedFld() + " from " + this.nodeTable.getName() + " where " + this.getParentFld() + " = " + parentId);
    }

    protected Integer getMatch(Object[] child, Integer parentId) throws TreeMergeException {
        Boolean isAccepted = (Boolean)child[2];
        String sql = "select " + this.nodeTable.getIdFieldName() + " from " + this.nodeTable.getName() + " where " + this.getNameFld() + " = " + BasicSQLUtils.getEscapedSQLStrExpr((String)child[1]) + " and " + (isAccepted == false ? "not " : "") + this.getAcceptedFld() + " and " + this.getParentFld() + " = " + parentId;
        Vector<Object[]> matches = BasicSQLUtils.query(this.connection, sql);
        if (matches.size() == 0) {
            return null;
        }
        if (matches.size() == 1) {
            return (Integer)matches.get(0)[0];
        }
        throw new TreeMergeException(this, (String)child[1], parentId);
    }

    protected void mergeTreeIntoTree(Integer toMergeId, Integer mergeIntoId) throws Exception {
        for (TreeMergerUIIFace<N, D, I> face : this.listeners) {
            face.merging(toMergeId, mergeIntoId);
        }
        List<Object[]> children = this.getChildren(toMergeId);
        for (Object[] objectArray : children) {
            Integer matchingChildId = this.getMatch(objectArray, mergeIntoId);
            if (matchingChildId == null) {
                this.move((Integer)objectArray[0], mergeIntoId);
                continue;
            }
            this.mergeTreeIntoTree((Integer)objectArray[0], matchingChildId);
        }
        this.mergeNodes(toMergeId, mergeIntoId);
        for (TreeMergerUIIFace treeMergerUIIFace : this.listeners) {
            treeMergerUIIFace.merged(toMergeId, mergeIntoId);
        }
    }

    public void mergeTrees(Integer toMergeId, Integer mergeIntoId) throws Exception {
        boolean transOpen = false;
        this.connection = DBConnection.getInstance().createConnection();
        this.connection.setAutoCommit(false);
        transOpen = true;
        try {
            try {
                this.mergeTreeIntoTree(toMergeId, mergeIntoId);
                this.connection.commit();
                transOpen = false;
            }
            catch (Exception ex) {
                if (transOpen) {
                    this.connection.rollback();
                }
                throw ex;
            }
        }
        finally {
            this.connection.close();
            this.connection = null;
        }
    }

    protected void mergeNodes(Integer toMergeId, Integer mergeIntoId) throws Exception {
        this.preMerge(toMergeId, mergeIntoId);
        Statement stmt = this.connection.createStatement();
        try {
            stmt.execute("delete from " + this.nodeTable.getName() + " where " + this.nodeTable.getIdFieldName() + " = " + toMergeId);
        }
        finally {
            stmt.close();
        }
    }

    protected List<String> getPreMergeSql(Integer toMergeId, Integer mergeIntoId) {
        Vector<String> result = new Vector<String>();
        BaseTreeBusRules busRules = (BaseTreeBusRules)DBTableIdMgr.getInstance().getBusinessRule(this.treeDef.getNodeClass());
        if (busRules != null) {
            String[] rels = busRules.getAllRelatedTableAndColumnNames();
            int i = 0;
            while (i < rels.length) {
                result.add("update " + rels[i] + " set " + rels[i + 1] + " = " + mergeIntoId + " where " + rels[i + 1] + " = " + toMergeId);
                i += 2;
            }
        }
        return result;
    }

    protected void preMerge(Integer toMergeId, Integer mergeIntoId) throws TreeMergeException, Exception {
        List<String> updaters = this.getPreMergeSql(toMergeId, mergeIntoId);
        if (updaters.size() > 0) {
            Statement stmt = this.connection.createStatement();
            for (String sql : updaters) {
                BasicSQLUtils.exeUpdateCmd(stmt, sql);
            }
        } else {
            throw new TreeMergeException(this, null, toMergeId, mergeIntoId, null, 0);
        }
    }

    protected void move(Integer toMoveId, Integer parentId) throws Exception {
        String sql = "update " + this.nodeTable.getName() + " set " + this.getParentFld() + " = " + parentId + " where " + this.nodeTable.getIdFieldName() + " = " + toMoveId;
        Statement stmt = this.connection.createStatement();
        try {
            BasicSQLUtils.exeUpdateCmd(stmt, sql);
        }
        finally {
            stmt.close();
        }
        for (TreeMergerUIIFace<N, D, I> face : this.listeners) {
            face.moved(toMoveId, null, parentId);
        }
    }
}

