/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.treeutils;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.treeutils.TreeMerger;
import edu.ku.brc.ui.UIRegistry;
import org.apache.commons.lang.StringUtils;

public class TreeMergeException
extends Exception {
    public static final int UNSPECIFIED = 0;
    public static final int MULTIPLE_MATCHES = 1;
    private TreeMerger<?, ?, ?> merger;
    private String toMergeName;
    private Integer toMergeId;
    private Integer mergeToId;
    private Integer mergeToParentId;
    private int exceptionType;

    public TreeMergeException(TreeMerger<?, ?, ?> merger, String toMergeName, Integer toMergeId, Integer mergeToId, Integer mergeToParentId, int exceptionType) {
        this.merger = merger;
        this.toMergeName = toMergeName;
        this.toMergeId = toMergeId;
        this.mergeToId = mergeToId;
        this.mergeToParentId = mergeToParentId;
        this.exceptionType = exceptionType;
    }

    public TreeMergeException(TreeMerger<?, ?, ?> merger, String toMergeName, Integer mergeToParentId) {
        this(merger, toMergeName, null, null, mergeToParentId, 1);
    }

    public String getToMergeName() {
        return this.toMergeName;
    }

    public void setToMergeName(String toMergeName) {
        this.toMergeName = toMergeName;
    }

    public Integer getToMergeId() {
        return this.toMergeId;
    }

    public void setToMergeId(Integer toMergeId) {
        this.toMergeId = toMergeId;
    }

    public Integer getMergeToId() {
        return this.mergeToId;
    }

    public void setMergeToId(Integer mergeToId) {
        this.mergeToId = mergeToId;
    }

    public Integer getMergeToParentId() {
        return this.mergeToParentId;
    }

    public void setMergeToParentId(Integer mergeToParentId) {
        this.mergeToParentId = mergeToParentId;
    }

    public int getExceptionType() {
        return this.exceptionType;
    }

    @Override
    public String getMessage() {
        String parentName;
        String sql;
        String mergeNodeText = this.getToMergeName();
        if (StringUtils.isBlank((String)mergeNodeText) && this.getToMergeId() != null) {
            sql = "select " + this.merger.getFullNameFld() + " from " + this.merger.getNodeTable().getName() + " where " + this.merger.getNodeTable().getIdColumnName() + " = " + this.getToMergeId();
            mergeNodeText = (String)BasicSQLUtils.querySingleObj(sql);
        }
        if (StringUtils.isBlank((String)mergeNodeText)) {
            return UIRegistry.getResourceString("TreeMergeException.GenericMsg");
        }
        if (this.getExceptionType() == 1 && this.getMergeToParentId() != null && StringUtils.isNotBlank((String)(parentName = (String)BasicSQLUtils.querySingleObj(sql = "select " + this.merger.getFullNameFld() + " from " + this.merger.getNodeTable().getName() + " where " + this.merger.getNodeTable().getIdColumnName() + " = " + this.getMergeToParentId())))) {
            return String.format(UIRegistry.getResourceString("TreeMergeException.MultipleMatchMsg"), mergeNodeText, parentName);
        }
        return String.format(UIRegistry.getResourceString("TreeMergeException.MergeErrorMsg"), mergeNodeText);
    }
}

