/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.treeutils;

import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.GeologicTimePeriod;
import edu.ku.brc.specify.datamodel.LithoStrat;
import edu.ku.brc.specify.datamodel.Storage;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.ui.UIRegistry;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TreeHelper {
    protected static final Logger log = Logger.getLogger(TreeHelper.class);

    public static <T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>> String generateFullname(T treeNode) {
        Vector<T> parts = new Vector<T>();
        parts.add(treeNode);
        T node = treeNode.getParent();
        while (node != null) {
            Boolean include = node.getDefinitionItem().getIsInFullName();
            if (include != null && include.booleanValue()) {
                parts.add(node);
            }
            node = node.getParent();
        }
        int direction = treeNode.getDefinition().getFullNameDirection();
        StringBuilder fullNameBuilder = new StringBuilder(parts.size() * 10);
        switch (direction) {
            case 1: {
                int j = parts.size() - 1;
                while (j > -1) {
                    Treeable part = (Treeable)parts.get(j);
                    String before = part.getDefinitionItem().getTextBefore();
                    String after = part.getDefinitionItem().getTextAfter();
                    String separator = part.getDefinitionItem().getFullNameSeparator();
                    if (before != null) {
                        fullNameBuilder.append(before);
                    }
                    fullNameBuilder.append(part.getName());
                    if (after != null) {
                        fullNameBuilder.append(after);
                    }
                    if (j != 0 && separator != null) {
                        fullNameBuilder.append(separator);
                    }
                    --j;
                }
                break;
            }
            case -1: {
                int j = 0;
                while (j < parts.size()) {
                    Treeable part = (Treeable)parts.get(j);
                    String before = part.getDefinitionItem().getTextBefore();
                    String after = part.getDefinitionItem().getTextAfter();
                    String separator = part.getDefinitionItem().getFullNameSeparator();
                    if (before != null) {
                        fullNameBuilder.append(before);
                    }
                    fullNameBuilder.append(part.getName());
                    if (after != null) {
                        fullNameBuilder.append(after);
                    }
                    if (j != parts.size() - 1 && separator != null) {
                        fullNameBuilder.append(separator);
                    }
                    ++j;
                }
                break;
            }
            default: {
                log.error((Object)"Invalid tree walk direction (for creating fullname field) found in tree definition");
                return null;
            }
        }
        return fullNameBuilder.toString().trim();
    }

    public static <T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>> void fixFullnameForNodeAndDescendants(T treeNode) {
        if (treeNode instanceof Geography) {
            TreeHelper.fixFullnameForNodeAndDescendants((Geography)treeNode);
            return;
        }
        if (treeNode instanceof GeologicTimePeriod) {
            TreeHelper.fixFullnameForNodeAndDescendants((GeologicTimePeriod)treeNode);
            return;
        }
        if (treeNode instanceof Storage) {
            TreeHelper.fixFullnameForNodeAndDescendants((Storage)treeNode);
            return;
        }
        if (treeNode instanceof LithoStrat) {
            TreeHelper.fixFullnameForNodeAndDescendants((LithoStrat)treeNode);
            return;
        }
        if (treeNode instanceof Taxon) {
            TreeHelper.fixFullnameForNodeAndDescendants((Taxon)treeNode);
            return;
        }
    }

    public static void fixFullnameForNodeAndDescendants(Geography geo) {
        String generated = TreeHelper.generateFullname(geo);
        geo.setFullName(generated);
        for (Geography child : geo.getChildren()) {
            TreeHelper.fixFullnameForNodeAndDescendants(child);
        }
    }

    public static void fixFullnameForNodeAndDescendants(GeologicTimePeriod gtp) {
        String generated = TreeHelper.generateFullname(gtp);
        gtp.setFullName(generated);
        for (GeologicTimePeriod child : gtp.getChildren()) {
            TreeHelper.fixFullnameForNodeAndDescendants(child);
        }
    }

    public static void fixFullnameForNodeAndDescendants(LithoStrat litho) {
        String generated = TreeHelper.generateFullname(litho);
        litho.setFullName(generated);
        for (LithoStrat child : litho.getChildren()) {
            TreeHelper.fixFullnameForNodeAndDescendants(child);
        }
    }

    public static void fixFullnameForNodeAndDescendants(Storage loc) {
        String generated = TreeHelper.generateFullname(loc);
        loc.setFullName(generated);
        for (Storage child : loc.getChildren()) {
            TreeHelper.fixFullnameForNodeAndDescendants(child);
        }
    }

    public static void fixFullnameForNodeAndDescendants(Taxon taxon) {
        String generated = TreeHelper.generateFullname(taxon);
        taxon.setFullName(generated);
        for (Taxon child : taxon.getChildren()) {
            if (!child.getIsAccepted().booleanValue()) continue;
            TreeHelper.fixFullnameForNodeAndDescendants(child);
        }
    }

    public static <T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>> void initializeRelatedObjects(T treeNode) {
        if (treeNode instanceof Geography) {
            TreeHelper.initializeRelatedObjects((Geography)treeNode);
            return;
        }
        if (treeNode instanceof GeologicTimePeriod) {
            TreeHelper.initializeRelatedObjects((GeologicTimePeriod)treeNode);
            return;
        }
        if (treeNode instanceof Storage) {
            TreeHelper.initializeRelatedObjects((Storage)treeNode);
            return;
        }
        if (treeNode instanceof Taxon) {
            TreeHelper.initializeRelatedObjects((Taxon)treeNode);
            return;
        }
        if (treeNode instanceof LithoStrat) {
            TreeHelper.initializeRelatedObjects((LithoStrat)treeNode);
            return;
        }
    }

    public static void initializeRelatedObjects(Storage loc) {
        loc.getContainers().size();
        loc.getPreparations().size();
    }

    public static void initializeRelatedObjects(GeologicTimePeriod gtp) {
        gtp.getBioStratsPaleoContext().size();
        gtp.getChronosStratsPaleoContext().size();
    }

    public static void initializeRelatedObjects(Geography geo) {
        geo.getLocalities().size();
    }

    public static void initializeRelatedObjects(LithoStrat litho) {
        litho.getPaleoContexts().size();
    }

    public static void initializeRelatedObjects(Taxon taxon) {
        taxon.getTaxonAttachments().size();
        taxon.getDeterminations().size();
        taxon.getTaxonCitations().size();
        taxon.getAcceptedChildren().size();
        taxon.getChildren().size();
        taxon.getHybridChildren1().size();
        taxon.getHybridChildren2().size();
    }

    public static <T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>> String createNodeRelationship(T source, T destination) {
        source.setIsAccepted(false);
        source.setAcceptedParent(destination);
        for (Treeable evenOlderName : source.getAcceptedChildren()) {
            evenOlderName.setIsAccepted(false);
            evenOlderName.setAcceptedParent(destination);
        }
        return String.format(UIRegistry.getResourceString("TTV_TreeRelationshipCreatedMsg"), source.getFullName(), destination.getFullName());
    }

    public static <T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>> boolean canChildBeReparentedToNode(T child, T newParent) {
        if (newParent.getRankId() >= child.getRankId()) {
            return false;
        }
        Integer nextEnforcedRank = TreeHelper.getRankOfNextHighestEnforcedLevel(child);
        if (nextEnforcedRank == null) {
            return true;
        }
        return nextEnforcedRank <= newParent.getRankId();
    }

    public static <T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>> boolean canChildBeReparentedToNode(int childRankID, int newParentRankID, D treeDef) {
        if (newParentRankID >= childRankID) {
            return false;
        }
        Integer nextEnforcedRank = TreeHelper.getRankOfNextHighestEnforcedLevel(treeDef.getDefItemByRank(childRankID));
        if (nextEnforcedRank == null) {
            return true;
        }
        return nextEnforcedRank <= newParentRankID;
    }

    public static <T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>> Integer getRankOfNextHighestEnforcedLevel(T node) {
        I defItem = node.getDefinitionItem();
        while (defItem.getParent() != null) {
            if ((defItem = defItem.getParent()).getIsEnforced() == null || !defItem.getIsEnforced().booleanValue()) continue;
            return defItem.getRankId();
        }
        return null;
    }

    public static <T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>> Integer getRankOfNextHighestEnforcedLevel(I definitionItem) {
        I defItem = definitionItem;
        while (defItem.getParent() != null) {
            if ((defItem = defItem.getParent()).getIsEnforced() == null || !defItem.getIsEnforced().booleanValue()) continue;
            return defItem.getRankId();
        }
        return null;
    }

    public static <T extends Treeable<?, D, I>, D extends TreeDefIface<?, D, I>, I extends TreeDefItemIface<?, D, I>> boolean nodeCanHaveChildren(T node) {
        I defItem = node.getDefinitionItem();
        return defItem.getChild() != null;
    }
}

