/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.treeutils;

import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.GeographyTreeDefItem;
import edu.ku.brc.specify.datamodel.GeologicTimePeriod;
import edu.ku.brc.specify.datamodel.GeologicTimePeriodTreeDefItem;
import edu.ku.brc.specify.datamodel.LithoStrat;
import edu.ku.brc.specify.datamodel.LithoStratTreeDefItem;
import edu.ku.brc.specify.datamodel.Storage;
import edu.ku.brc.specify.datamodel.StorageTreeDef;
import edu.ku.brc.specify.datamodel.StorageTreeDefItem;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import edu.ku.brc.specify.datamodel.TaxonTreeDefItem;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.ui.treetables.TreeNode;
import java.util.Set;
import org.apache.log4j.Logger;

public class TreeFactory {
    public static final Logger log = Logger.getLogger(TreeFactory.class);
    private static Object[][] stdTaxonItems = new Object[][]{{0, "Taxonomy Root", true, false}, {10, "Kingdom", true, false}, {20, "Subkingdom", false, false}, {30, "Phylum", true, false}, {40, "Subphylum", false, false}, {50, "Superclass", false, false}, {60, "Class", true, false}, {70, "Subclass", false, false}, {80, "Infraclass", false, false}, {90, "Superorder", false, false}, {100, "Order", true, false}, {110, "Suborder", false, false}, {120, "Infraorder", false, false}, {130, "Superfamily", false, false}, {140, "Family", false, false}, {150, "Subfamily", false, false}, {160, "Tribe", false, false}, {170, "Subtribe", false, false}, {180, "Genus", true, true}, {190, "Subgenus", false, true}, {200, "Section", false, true}, {210, "Subsection", false, true}, {220, "Species", false, true}, {230, "Subspecies", false, true}, {240, "Variety", false, true}, {250, "Subvariety", false, true}, {260, "Forma", false, true}, {270, "Subforma", false, true}};

    public static <T extends Treeable<T, ?, ?>> T createNewTreeable(Class<? extends T> implementingClass, String name) {
        DataModelObjBase t = null;
        if (implementingClass.equals(Geography.class)) {
            t = new Geography();
            ((Geography)t).initialize();
        } else if (implementingClass.equals(GeologicTimePeriod.class)) {
            t = new GeologicTimePeriod();
            ((GeologicTimePeriod)t).initialize();
        } else if (implementingClass.equals(Storage.class)) {
            t = new Storage();
            ((Storage)t).initialize();
        } else if (implementingClass.equals(Taxon.class)) {
            t = new Taxon();
            ((Taxon)t).initialize();
        } else if (implementingClass.equals(LithoStrat.class)) {
            t = new LithoStrat();
            ((LithoStrat)t).initialize();
        } else {
            throw new IllegalArgumentException("Provided class must be one of Geography, GeologicTimePeriod, Storage, LithoStrat or Taxon");
        }
        t.setName(name);
        return (T)t;
    }

    public static <T extends Treeable<T, ?, ?>> T createNewTreeable(T nodeOfSameClass, String name) {
        if (nodeOfSameClass instanceof Taxon) {
            return (T)TreeFactory.createNewTreeable(Taxon.class, name);
        }
        if (nodeOfSameClass instanceof Geography) {
            return (T)TreeFactory.createNewTreeable(Geography.class, name);
        }
        if (nodeOfSameClass instanceof GeologicTimePeriod) {
            return (T)TreeFactory.createNewTreeable(GeologicTimePeriod.class, name);
        }
        if (nodeOfSameClass instanceof LithoStrat) {
            return (T)TreeFactory.createNewTreeable(LithoStrat.class, name);
        }
        if (nodeOfSameClass instanceof Storage) {
            return (T)TreeFactory.createNewTreeable(Storage.class, name);
        }
        throw new IllegalArgumentException("Provided node must be instance of Geography, GeologicTimePeriod, Storage, LithoStrat or Taxon");
    }

    public static <I extends TreeDefItemIface<?, ?, I>> I createNewTreeDefItem(Class<? extends I> implementingClass, I parent, String name) {
        DataModelObjBase t = null;
        if (implementingClass.equals(GeographyTreeDefItem.class)) {
            t = new GeographyTreeDefItem();
        } else if (implementingClass.equals(GeologicTimePeriodTreeDefItem.class)) {
            t = new GeologicTimePeriodTreeDefItem();
        } else if (implementingClass.equals(StorageTreeDefItem.class)) {
            t = new StorageTreeDefItem();
        } else if (implementingClass.equals(TaxonTreeDefItem.class)) {
            t = new TaxonTreeDefItem();
        } else if (implementingClass.equals(LithoStratTreeDefItem.class)) {
            t = new LithoStratTreeDefItem();
        } else {
            return null;
        }
        t.initialize();
        if (parent != null) {
            t.setParent(parent);
        }
        if (name != null) {
            t.setName(name);
        }
        return (I)t;
    }

    public static <T extends Treeable<T, ?, ?>> String getChildQueryString(T parent) {
        if (parent instanceof Taxon) {
            return "SELECT n.id, n.name, n.fullName, n.nodeNumber, n.highestChildNodeNumber, n.rankId, n2.id, n2.fullName FROM Taxon n LEFT OUTER JOIN n.acceptedTaxon n2 WHERE n.parent=:PARENT ORDER BY n.rankId, n.name";
        }
        if (parent instanceof Geography) {
            return "SELECT n.id, n.name, n.fullName, n.nodeNumber, n.highestChildNodeNumber, n.rankId, n2.id, n2.fullName FROM Geography n LEFT OUTER JOIN n.acceptedGeography n2 WHERE n.parent=:PARENT ORDER BY n.rankId, n.name";
        }
        if (parent instanceof GeologicTimePeriod) {
            return "SELECT n.id, n.name, n.fullName, n.nodeNumber, n.highestChildNodeNumber, n.rankId, n2.id, n2.fullName FROM GeologicTimePeriod n LEFT OUTER JOIN n.acceptedGeologicTimePeriod n2 WHERE n.parent=:PARENT ORDER BY n.startPeriod, n.endPeriod, n.name";
        }
        if (parent instanceof Storage) {
            return "SELECT n.id, n.name, n.fullName, n.nodeNumber, n.highestChildNodeNumber, n.rankId, n2.id, n2.fullName FROM Storage n LEFT OUTER JOIN n.acceptedStorage n2 WHERE n.parent=:PARENT ORDER BY n.rankId, n.name";
        }
        if (parent instanceof LithoStrat) {
            return "SELECT n.id, n.name, n.fullName, n.nodeNumber, n.highestChildNodeNumber, n.rankId, n2.id, n2.fullName FROM LithoStrat n LEFT OUTER JOIN n.acceptedLithoStrat n2 WHERE n.parent=:PARENT ORDER BY n.rankId, n.name";
        }
        return null;
    }

    public static String getSynonymQueryString(Class<?> clazz) {
        if (clazz.equals(Taxon.class)) {
            return "SELECT n.id, n.fullName FROM " + clazz.getName() + " n WHERE n.acceptedTaxon.id=:NODEID";
        }
        if (clazz.equals(Geography.class)) {
            return "SELECT n.id, n.fullName FROM " + clazz.getName() + " n WHERE n.acceptedGeography.id=:NODEID";
        }
        if (clazz.equals(GeologicTimePeriod.class)) {
            return "SELECT n.id, n.fullName FROM " + clazz.getName() + " n WHERE n.acceptedGeologicTimePeriod.id=:NODEID";
        }
        if (clazz.equals(Storage.class)) {
            return "SELECT n.id, n.fullName FROM " + clazz.getName() + " n WHERE n.acceptedStorage.id=:NODEID";
        }
        if (clazz.equals(LithoStrat.class)) {
            return "SELECT n.id, n.fullName FROM " + clazz.getName() + " n WHERE n.acceptedLithoStrat.id=:NODEID";
        }
        return null;
    }

    public static boolean isQueryHQL(Class<?> clazz) {
        return clazz.equals(GeologicTimePeriod.class) || clazz.equals(LithoStrat.class) || clazz.equals(Storage.class);
    }

    public static StringBuilder getRelatedRecordCountSQLBase(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        if (clazz.equals(Taxon.class)) {
            sb.append("SELECT count(*) ");
            sb.append("FROM taxon AS TX INNER JOIN determination as DET ON TX.TaxonID = ");
            sb.append("DET.PreferredTaxonID ");
            sb.append("INNER JOIN collectionobject ON DET.CollectionObjectID = collectionobject.CollectionObjectID ");
        }
        if (clazz.equals(Geography.class)) {
            sb.append("SELECT count(*) ");
            sb.append("FROM geography AS G INNER JOIN locality ON G.GeographyID = locality.GeographyID ");
            sb.append("INNER JOIN collectingevent AS CE ON locality.LocalityID = CE.LocalityID ");
            sb.append("INNER JOIN collectionobject AS CO ON CE.CollectingEventID = CO.CollectingEventID ");
        }
        return sb;
    }

    public static String getRelatedRecordCountSQLSingleNode(Class<?> clazz) {
        StringBuilder sb = TreeFactory.getRelatedRecordCountSQLBase(clazz);
        if (clazz.equals(Taxon.class)) {
            sb.append(" WHERE DET.CollectionMemberID = COLMEMID AND IsCurrent = 1 AND TX.TaxonID = %d");
        } else if (clazz.equals(Geography.class)) {
            sb.append(" WHERE CO.CollectionMemberID = COLMEMID AND G.GeographyID = %d");
        } else if (clazz.equals(Storage.class)) {
            sb.append("SELECT count(DISTINCT co.id) FROM CollectionObject AS co INNER JOIN co.preparations AS prep INNER JOIN prep.storage as loc WHERE prep.collectionMemberId = COLMEMID AND loc.id = %d");
        } else if (clazz.equals(GeologicTimePeriod.class)) {
            sb.append("SELECT count(DISTINCT co.id) FROM CollectionObject AS co INNER JOIN co.paleoContext AS pc INNER JOIN pc.chronosStrat as gtp WHERE pc.collectionMemberId = COLMEMID AND gtp.id = %d");
        } else if (clazz.equals(LithoStrat.class)) {
            sb.append("SELECT count(DISTINCT co.id) FROM CollectionObject AS co INNER JOIN co.paleoContext AS pc INNER JOIN pc.lithoStrat as ls WHERE pc.collectionMemberId = COLMEMID AND ls.id = %d");
        }
        if (sb.length() > 0) {
            return QueryAdjusterForDomain.getInstance().adjustSQL(sb.toString());
        }
        return null;
    }

    public static String getRelatedRecordCountSQLForRange(Class<?> clazz, TreeNode node) {
        StringBuilder sb = TreeFactory.getRelatedRecordCountSQLBase(clazz);
        if (clazz.equals(Taxon.class)) {
            sb.append(" WHERE DET.CollectionMemberID = COLMEMID AND IsCurrent = 1 AND NodeNumber > %d AND HighestChildNodeNumber <= %d");
        } else if (clazz.equals(Geography.class)) {
            sb.append(" WHERE CO.CollectionMemberID = COLMEMID AND NodeNumber > %d AND HighestChildNodeNumber <= %d");
        } else if (clazz.equals(GeologicTimePeriod.class)) {
            sb.append("SELECT count(*) FROM CollectionObject AS co INNER JOIN co.paleoContext AS pc INNER JOIN pc.chronosStrat as gtp WHERE pc.collectionMemberId = COLMEMID AND gtp.nodeNumber > %d AND gtp.highestChildNodeNumber <= %d");
        } else if (clazz.equals(Storage.class)) {
            sb.append("SELECT count(*) FROM CollectionObject AS co INNER JOIN co.preparations AS prep INNER JOIN prep.storage as loc WHERE prep.collectionMemberId = COLMEMID AND loc.nodeNumber > %d AND loc.highestChildNodeNumber <= %d");
        } else if (clazz.equals(LithoStrat.class)) {
            sb.append("SELECT count(*) FROM CollectionObject AS co INNER JOIN co.paleoContext AS pc INNER JOIN pc.lithoStrat as ls WHERE pc.collectionMemberId = COLMEMID AND ls.nodeNumber > %d AND ls.highestChildNodeNumber <= %d");
        }
        if (sb.length() > 0) {
            return QueryAdjusterForDomain.getInstance().adjustSQL(sb.toString());
        }
        return null;
    }

    public static String getNodeNumberQuery(Class<?> clazz) {
        if (clazz.equals(Taxon.class)) {
            return QueryAdjusterForDomain.getInstance().adjustSQL("SELECT TaxonId, NodeNumber, HighestChildNodeNumber FROM taxon WHERE TaxonTreeDefID = TAXTREEDEFID AND TaxonID = %d");
        }
        if (clazz.equals(Geography.class)) {
            return QueryAdjusterForDomain.getInstance().adjustSQL("SELECT GeographyID, NodeNumber, HighestChildNodeNumber FROM geography WHERE GeographyTreeDefID = GEOTREEDEFID AND GeographyID = %d");
        }
        if (clazz.equals(GeologicTimePeriod.class)) {
            return QueryAdjusterForDomain.getInstance().adjustSQL("SELECT id, nodeNumber, highestChildNodeNumber FROM GeologicTimePeriod WHERE geologicTimePeriodTreeDefId = GTPTREEDEFID AND id = %d");
        }
        if (clazz.equals(Storage.class)) {
            return QueryAdjusterForDomain.getInstance().adjustSQL("SELECT id, nodeNumber, highestChildNodeNumber FROM Storage WHERE storageTreeDefId = STORTREEDEFID AND id = %d");
        }
        if (clazz.equals(LithoStrat.class)) {
            return QueryAdjusterForDomain.getInstance().adjustSQL("SELECT id, nodeNumber, highestChildNodeNumber FROM LithoStrat WHERE lithoStratTreeDefId = LITHOTREEDEFID AND id = %d");
        }
        return null;
    }

    public static String getAppropriateViewName(Object node) {
        log.info((Object)"getAppropriateFormsetAndViewNames(Object): Replace this with a call to the table ID manager to get the appropriate form");
        if (node instanceof Geography) {
            return "Geography";
        }
        if (node instanceof GeologicTimePeriod) {
            return "GeologicTimePeriod";
        }
        if (node instanceof LithoStrat) {
            return "LithoStrat";
        }
        if (node instanceof Storage) {
            return "Storage";
        }
        if (node instanceof Taxon) {
            return "Taxon";
        }
        if (node instanceof TreeDefIface) {
            return "TreeDefEditor";
        }
        if (node instanceof GeographyTreeDefItem) {
            TreeDefItemIface defItem = (TreeDefItemIface)node;
            if (defItem.getParent() == null) {
                return "RootGeographyTreeDefItem";
            }
            return "GeographyTreeDefItem";
        }
        if (node instanceof GeologicTimePeriodTreeDefItem) {
            TreeDefItemIface defItem = (TreeDefItemIface)node;
            if (defItem.getParent() == null) {
                return "RootGeologicTimePeriodTreeDefItem";
            }
            return "GeologicTimePeriodTreeDefItem";
        }
        if (node instanceof LithoStratTreeDefItem) {
            TreeDefItemIface defItem = (TreeDefItemIface)node;
            if (defItem.getParent() == null) {
                return "RootLithoStratTreeDefItem";
            }
            return "LithoStratTreeDefItem";
        }
        if (node instanceof StorageTreeDefItem) {
            TreeDefItemIface defItem = (TreeDefItemIface)node;
            if (defItem.getParent() == null) {
                return "RootStorageTreeDefItem";
            }
            return "StorageTreeDefItem";
        }
        if (node instanceof TaxonTreeDefItem) {
            TreeDefItemIface defItem = (TreeDefItemIface)node;
            if (defItem.getParent() == null) {
                return "RootTaxonTreeDefItem";
            }
            return "TaxonTreeDefItem";
        }
        return null;
    }

    public static StorageTreeDef createStdStorageTreeDef(String defName, String remarks) {
        StorageTreeDef def = new StorageTreeDef();
        def.initialize();
        def.setName(defName);
        def.setRemarks(remarks);
        StorageTreeDefItem defItem = new StorageTreeDefItem();
        defItem.initialize();
        defItem.setName("Root");
        defItem.setRankId(0);
        defItem.setIsEnforced(true);
        defItem.setIsInFullName(false);
        Storage rootNode = new Storage();
        rootNode.initialize();
        rootNode.setName("Root");
        rootNode.setFullName("Root");
        rootNode.setRankId(0);
        rootNode.setNodeNumber(1);
        rootNode.setHighestChildNodeNumber(1);
        defItem.setTreeDef(def);
        defItem.getTreeEntries().add(rootNode);
        def.getTreeDefItems().add(defItem);
        def.getTreeEntries().add(rootNode);
        rootNode.setDefinitionItem(defItem);
        rootNode.setDefinition(def);
        return def;
    }

    public static Set<TaxonTreeDefItem> addStandardTaxonDefItems(TaxonTreeDef def) {
        return TreeFactory.addStandardTaxonDefItems(def, stdTaxonItems);
    }

    public static Set<TaxonTreeDefItem> addStandardTaxonDefItems(TaxonTreeDef def, Object[][] taxonItems) {
        Set<TaxonTreeDefItem> items = def.getTreeDefItems();
        TaxonTreeDefItem prevItem = null;
        Object[][] objectArray = taxonItems;
        int n = taxonItems.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] itemDesc = objectArray[n2];
            TaxonTreeDefItem item = new TaxonTreeDefItem();
            item.initialize();
            items.add(item);
            item.setTreeDef(def);
            item.setRankId((Integer)itemDesc[0]);
            item.setName((String)itemDesc[1]);
            item.setIsEnforced((Boolean)itemDesc[2]);
            item.setIsInFullName((Boolean)itemDesc[3]);
            item.setFullNameSeparator(" ");
            item.setParent(prevItem);
            prevItem = item;
            ++n2;
        }
        return items;
    }
}

