/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.treeutils;

import edu.ku.brc.dbsupport.CustomQueryListener;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.ui.treetables.TreeNode;
import edu.ku.brc.util.Pair;
import java.util.List;
import java.util.Set;

public interface TreeDataService<T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>> {
    public static final int SUCCESS = 0;
    public static final int CANCELLED = 1;
    public static final int ERROR = 2;

    public List<T> findByName(D var1, String var2, boolean var3);

    public T getRootNode(D var1);

    public T getNodeById(Class<?> var1, int var2);

    public List<D> getAllTreeDefs(Class<D> var1);

    public D getTreeDef(Class<D> var1, int var2);

    public Set<T> getChildNodes(T var1);

    public List<TreeNode> getChildTreeNodes(T var1);

    public int getDescendantCount(T var1);

    public void calcRelatedRecordCount(Class<?> var1, int var2, CustomQueryListener var3);

    public boolean deleteTreeNode(T var1);

    public void refresh(Object ... var1);

    public int countNodesAtLevel(int var1, D var2);

    public List<String> nodesSkippingOverLevel(int var1, D var2);

    public List<String> nodeNamesAtLevel(int var1, D var2);

    public boolean updateNodeNumbersAfterNodeAddition(T var1, DataProviderSessionIFace var2) throws Exception;

    public boolean updateNodeNumbersAfterNodeEdit(T var1, DataProviderSessionIFace var2) throws Exception;

    public boolean updateNodeNumbersAfterNodeDeletion(T var1, DataProviderSessionIFace var2) throws Exception;

    public int moveTreeNode(T var1, T var2);

    public String synonymize(T var1, T var2);

    public String unSynonymize(T var1);

    public Set<T> getSynonyms(T var1);

    public Set<Pair<Integer, String>> getSynonymIdsAndNames(Class<?> var1, Integer var2);

    public void initializeRelatedObjects(T var1);
}

