/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.treeutils;

import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.Taxon;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class TreeAdditionalProcFactory {
    protected static final Logger log = Logger.getLogger(TreeAdditionalProcFactory.class);
    protected static final TreeAdditionalProcFactory instance = new TreeAdditionalProcFactory();

    public static TreeAdditionalProcFactory getInstance() {
        return instance;
    }

    private TreeAdditionalProcFactory() {
    }

    public TreeAdditionalProcessing createProcessor(Class<?> implClass) {
        if (implClass == Taxon.class) {
            return new TaxonAdditionalProcessing();
        }
        return null;
    }

    private class TaxonAdditionalProcessing
    implements TreeAdditionalProcessing {
        @Override
        public boolean process(Session session, Object source, Object dest) {
            if (session == null || source == null || !(source instanceof Taxon) || dest != null && !(dest instanceof Taxon)) {
                return false;
            }
            Taxon srcTaxon = (Taxon)source;
            Taxon dstTaxon = (Taxon)dest;
            if (dstTaxon != null) {
                return this.processTaxonSynonymy(session, srcTaxon, dstTaxon);
            }
            return this.processTaxonUnSynonymy(session, srcTaxon);
        }

        protected boolean processTaxonSynonymy(Session session, Taxon srcTaxon, Taxon dstTaxon) {
            Vector<Taxon> sources = new Vector<Taxon>();
            sources.add(srcTaxon);
            sources.addAll(srcTaxon.getAcceptedChildren());
            log.debug((Object)"Source:");
            for (Taxon srcTax : sources) {
                for (Determination det : new Vector<Determination>(srcTax.getDeterminations())) {
                    log.debug((Object)(String.valueOf(det.getCollectionObject().getIdentityTitle()) + " has  " + det.getIdentityTitle() + "  " + det.getTaxon().getIdentityTitle() + " " + det.getCollectionObject().getCollectionMemberId()));
                    det.setPreferredTaxon(dstTaxon);
                    session.saveOrUpdate((Object)det);
                }
            }
            return true;
        }

        protected boolean processTaxonUnSynonymy(Session session, Taxon srcTaxon) {
            for (Determination det : new Vector<Determination>(srcTaxon.getDeterminations())) {
                det.setPreferredTaxon(srcTaxon);
                session.saveOrUpdate((Object)det);
            }
            return true;
        }
    }

    public static interface TreeAdditionalProcessing {
        public boolean process(Session var1, Object var2, Object var3);
    }
}

