/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.treeutils;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.treeutils.TreeTraversalWorker;
import java.util.List;
import javax.swing.JDialog;

public class NodeNumberer<T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>>
extends TreeTraversalWorker<T, D, I> {
    protected DataProviderSessionIFace.QueryIFace updateNodeQuery = null;
    protected JDialog progDlg = null;

    public NodeNumberer(D treeDef) {
        super(treeDef);
    }

    public void setProgDlg(JDialog progDlg) {
        this.progDlg = progDlg;
    }

    @Override
    protected void done() {
        super.done();
        if (this.progDlg != null) {
            this.progDlg.setVisible(false);
        }
    }

    @Override
    public Boolean doInBackground() {
        this.traversalSession = DataProviderFactory.getInstance().createSession();
        try {
            this.traversalSession.beginTransaction();
            this.buildReNumberingQueries();
            Object root = this.getTreeRoot();
            this.initProgress();
            this.initCacheInfo();
            this.reNumberNodesFaster(root.getTreeId(), 1);
            this.traversalSession.commit();
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(NodeNumberer.class, e);
            Boolean bl = false;
            return bl;
        }
        finally {
            this.traversalSession.close();
        }
    }

    protected int reNumberNodesFaster(int nodeId, int nodeNumber) throws Exception {
        List<?> children = this.getChildIds(nodeId);
        int nn = nodeNumber;
        while (children.size() > 0) {
            Object child = children.get(0);
            nn = this.reNumberNodesFaster((Integer)child, nn + 1);
            children.remove(0);
            child = null;
        }
        children = null;
        this.writeNode(nodeId, nodeNumber, nn);
        this.incrementProgress();
        this.checkCache();
        return nn;
    }

    protected void writeNode(int nodeId, int nodeNumber, int highestChildNodeNumber) throws Exception {
        this.updateNodeQuery.setParameter("keyArg", nodeId);
        this.updateNodeQuery.setParameter("nnArg", nodeNumber);
        this.updateNodeQuery.setParameter("hcnArg", highestChildNodeNumber);
        this.updateNodeQuery.executeUpdate();
    }

    protected void buildReNumberingQueries() {
        this.buildChildrenQuery();
        this.buildUpdateNodeQuery();
    }

    protected void buildUpdateNodeQuery() {
        String updateSQL = "update " + this.getNodeTblName() + " set NodeNumber=:nnArg, HighestChildNodeNumber=:hcnArg where " + this.getNodeKeyFldName() + "=:keyArg";
        this.updateNodeQuery = this.traversalSession.createQuery(updateSQL, true);
    }
}

