/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.treeutils;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.treeutils.NodeNumberer;
import edu.ku.brc.specify.treeutils.TreeTraversalWorker;
import java.util.LinkedList;
import java.util.List;

public class NodeNumberVerifier<T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>>
extends TreeTraversalWorker<T, D, I> {
    public NodeNumberVerifier(D treeDef) {
        super(treeDef);
    }

    @Override
    public Boolean doInBackground() {
        this.traversalSession = DataProviderFactory.getInstance().createSession();
        try {
            this.buildVerificationQueries();
            Object root = this.getTreeRoot();
            LinkedList<Integer> parentIds = new LinkedList<Integer>();
            this.initProgress();
            this.verifyNodes(root.getTreeId(), root.getNodeNumber(), parentIds);
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(NodeNumberer.class, e);
            Boolean bl = false;
            return bl;
        }
        finally {
            this.traversalSession.close();
        }
    }

    protected void verifyNodes(int nodeId, int nodeNumber, LinkedList<Integer> parentIds) throws Exception {
        this.checkNode(nodeId, nodeNumber, parentIds);
        this.incrementProgress();
        List<?> children = this.getChildIds(nodeId);
        parentIds.push(nodeId);
        for (Object child : children) {
            Object childId = ((Object[])child)[0];
            Object nodeNum = ((Object[])child)[1];
            this.verifyNodes((Integer)childId, (Integer)nodeNum, parentIds);
        }
        parentIds.pop();
    }

    protected void checkNode(int nodeId, int nodeNumber, List<Integer> parentIds) throws Exception {
        List<?> ancestors = this.getAncestors(nodeNumber);
        if (ancestors.size() != parentIds.size()) {
            throw new Exception(String.valueOf(nodeId));
        }
        int a = 0;
        while (a < ancestors.size()) {
            Object ancestor = ancestors.get(a);
            Integer parentId = parentIds.get(a);
            if (parentId == null ? ancestor != null : !parentId.equals(ancestor)) {
                throw new Exception(String.valueOf(nodeId));
            }
            ++a;
        }
    }

    protected List<?> getAncestors(int nodeNumber) {
        this.ancestorQuery.setParameter("descendantArg", nodeNumber);
        return this.ancestorQuery.list();
    }

    protected void buildChildrenQueryForVerification() {
        String childrenSQL = "select " + this.getNodeKeyFldName() + ", nodenumber from " + this.getNodeTblName() + " where " + this.getNodeParentFldName() + " =:parentArg  order by name";
        this.childrenQuery = this.traversalSession.createQuery(childrenSQL, true);
    }

    protected void buildAncestorQuery() {
        String ancestorSQL = "select " + this.getNodeKeyFldName() + " from " + this.getNodeTblName() + " where " + ":descendantArg between nodenumber and highestchildnodenumber  and :descendantArg <> nodenumber and " + this.getNodeTreeFldName() + "=" + this.treeDef.getTreeDefId() + " order by rankId desc";
        this.ancestorQuery = this.traversalSession.createQuery(ancestorSQL, true);
    }

    protected void buildVerificationQueries() {
        this.buildChildrenQueryForVerification();
        this.buildAncestorQuery();
    }
}

