/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.treeutils;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.dbsupport.CustomQueryListener;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.datamodel.busrules.BaseTreeBusRules;
import edu.ku.brc.specify.dbsupport.HibernateDataProviderSession;
import edu.ku.brc.specify.treeutils.TreeAdditionalProcFactory;
import edu.ku.brc.specify.treeutils.TreeDataService;
import edu.ku.brc.specify.treeutils.TreeFactory;
import edu.ku.brc.specify.treeutils.TreeHelper;
import edu.ku.brc.specify.treeutils.TreePathComparator;
import edu.ku.brc.specify.ui.treetables.TreeNode;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

public class HibernateTreeDataServiceImpl<T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>>
implements TreeDataService<T, D, I> {
    protected static final Logger log = Logger.getLogger(HibernateTreeDataServiceImpl.class);

    @Override
    public synchronized List<T> findByName(D treeDef, String name, boolean isExact) {
        Vector<Treeable> results = new Vector<Treeable>();
        Class nodeClass = treeDef.getNodeClass();
        org.hibernate.Session session = this.getNewSession(treeDef);
        try {
            try {
                DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByClassName(nodeClass.getName());
                String columns = QueryAdjusterForDomain.getInstance().getSpecialColumns(tableInfo, true);
                String sql = "FROM " + nodeClass.getSimpleName() + " as node WHERE " + columns + " AND node.name LIKE :name";
                Query q = session.createQuery(sql);
                String newName = name;
                if (!isExact) {
                    if (newName.contains("*")) {
                        // empty if block
                    }
                    if (!(newName = newName.replace("*", "%")).endsWith("%")) {
                        newName = String.valueOf(newName) + "%";
                    }
                }
                q.setParameter("name", (Object)newName);
                for (Object o : q.list()) {
                    Treeable t = (Treeable)o;
                    Object parent = t.getParent();
                    while (parent != null) {
                        parent = parent.getParent();
                    }
                    results.add(t);
                }
                Collections.sort(results, new TreePathComparator(true));
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(HibernateTreeDataServiceImpl.class, ex);
                log.error((Object)ex);
                session.close();
            }
        }
        finally {
            session.close();
        }
        return results;
    }

    @Override
    public synchronized Set<T> getChildNodes(T parent) {
        if (Hibernate.isInitialized(parent.getChildren())) {
            return parent.getChildren();
        }
        Set children = null;
        org.hibernate.Session session = this.getNewSession(parent);
        try {
            try {
                children = parent.getChildren();
                for (Treeable treeable : children) {
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(HibernateTreeDataServiceImpl.class, ex);
                log.error((Object)ex);
                session.close();
            }
        }
        finally {
            session.close();
        }
        return children;
    }

    @Override
    public List<TreeNode> getChildTreeNodes(T parent) {
        Vector<TreeNode> treeNodes = new Vector<TreeNode>();
        if (parent != null) {
            org.hibernate.Session session = this.getNewSession(parent);
            try {
                try {
                    List list;
                    String childQueryString = TreeFactory.getChildQueryString(parent);
                    Query getNodeInfoList = session.createQuery(childQueryString);
                    getNodeInfoList.setParameter("PARENT", parent);
                    List nodeInfoList = list = getNodeInfoList.list();
                    for (Object[] nodeInfo : nodeInfoList) {
                        treeNodes.add(this.createNode(nodeInfo, parent));
                    }
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(HibernateTreeDataServiceImpl.class, ex);
                    log.error((Object)ex);
                    session.close();
                }
            }
            finally {
                session.close();
            }
        }
        return treeNodes;
    }

    private TreeNode createNode(Object[] nodeInfo, T parent) {
        int parentRank;
        int parentId;
        T parentRecord;
        Integer id = (Integer)nodeInfo[0];
        String nodeName = (String)nodeInfo[1];
        String fullName = (String)nodeInfo[2];
        Integer nodeNum = (Integer)nodeInfo[3];
        Integer highChild = (Integer)nodeInfo[4];
        int rank = (Integer)nodeInfo[5];
        Integer acceptedParentId = (Integer)nodeInfo[6];
        String acceptedParentFullName = (String)nodeInfo[7];
        int descCount = 0;
        if (highChild != null && nodeNum != null) {
            descCount = highChild - nodeNum;
        }
        if ((parentRecord = parent) == null) {
            parentId = id;
            parentRank = -1;
        } else {
            parentId = parentRecord.getTreeId();
            parentRank = parentRecord.getRankId();
        }
        Set<Pair<Integer, String>> synIdsAndNames = this.getSynonymIdsAndNames(parent.getClass(), id);
        TreeNode node = new TreeNode(nodeName, fullName, id, parentId, rank, parentRank, descCount != 0, acceptedParentId, acceptedParentFullName, synIdsAndNames);
        if (parent != null) {
            node.setDataObjClass(parent.getClass());
        }
        return node;
    }

    @Override
    public void calcRelatedRecordCount(Class<?> clazz, int id, CustomQueryListener listener) {
    }

    @Override
    public synchronized T getRootNode(D treeDef) {
        Treeable root;
        block6: {
            root = null;
            org.hibernate.Session session = this.getNewSession(treeDef);
            try {
                try {
                    for (TreeDefItemIface defItem : treeDef.getTreeDefItems()) {
                        Iterator entries;
                        if (defItem.getParent() != null || !(entries = defItem.getTreeEntries().iterator()).hasNext()) continue;
                        root = (Treeable)defItem.getTreeEntries().iterator().next();
                        break;
                    }
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(HibernateTreeDataServiceImpl.class, ex);
                    log.error((Object)ex);
                    session.close();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                session.close();
                throw throwable;
            }
            session.close();
        }
        return (T)root;
    }

    @Override
    public synchronized T getNodeById(Class<?> clazz, int id) {
        org.hibernate.Session session = this.getNewSession(new Object[0]);
        try {
            Treeable treeable = (Treeable)session.load(clazz, (Serializable)Integer.valueOf(id));
            return (T)treeable;
        }
        catch (ObjectNotFoundException e) {
            log.error((Object)e);
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(HibernateTreeDataServiceImpl.class, ex);
            log.error((Object)ex);
        }
        finally {
            session.close();
        }
        return null;
    }

    @Override
    public synchronized List<D> getAllTreeDefs(Class<D> treeDefClass) {
        Vector<TreeDefIface> defs = null;
        org.hibernate.Session session = this.getNewSession(new Object[0]);
        try {
            try {
                Query q = session.createQuery("FROM " + treeDefClass.getSimpleName());
                List results = q.list();
                defs = new Vector<TreeDefIface>(results.size());
                for (Object o : results) {
                    TreeDefIface def = (TreeDefIface)o;
                    def.getTreeDefItems().size();
                    defs.add(def);
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(HibernateTreeDataServiceImpl.class, ex);
                log.error((Object)ex);
                session.close();
            }
        }
        finally {
            session.close();
        }
        return defs;
    }

    @Override
    public synchronized D getTreeDef(Class<D> defClass, int defId) {
        org.hibernate.Session session = this.getNewSession(new Object[0]);
        try {
            String className = defClass.getSimpleName();
            String idFieldName = String.valueOf(className.toLowerCase().substring(0, 1)) + className.substring(1) + "Id";
            Query query = session.createQuery("FROM " + className + " WHERE " + idFieldName + "=:defId");
            query.setParameter("defId", (Object)defId);
            TreeDefIface def = (TreeDefIface)query.uniqueResult();
            def.getTreeDefItems().size();
            TreeDefIface treeDefIface = def;
            return (D)treeDefIface;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(HibernateTreeDataServiceImpl.class, ex);
            log.error((Object)ex);
        }
        finally {
            session.close();
        }
        return null;
    }

    @Override
    public synchronized int getDescendantCount(T node) {
        if (node == null) {
            return 0;
        }
        org.hibernate.Session session = this.getNewSession(node);
        try {
            Integer nodeNum = node.getNodeNumber();
            Integer highChild = node.getHighestChildNodeNumber();
            int descCnt = 0;
            descCnt = nodeNum != null && highChild != null ? highChild - nodeNum : node.getDescendantCount();
            int n = descCnt;
            return n;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(HibernateTreeDataServiceImpl.class, ex);
            log.error((Object)ex);
        }
        finally {
            session.close();
        }
        return 0;
    }

    /*
     * Loose catch block
     */
    @Override
    public synchronized boolean deleteTreeNode(T nodeToDelete) {
        block17: {
            Session session = HibernateUtil.getSessionFactory().openSession();
            try {
                Treeable node = (Treeable)this.mergeIntoSession((org.hibernate.Session)session, nodeToDelete);
                session.refresh((Object)node);
                Object parent = node.getParent();
                if (parent != null) {
                    parent = (Treeable)this.mergeIntoSession((org.hibernate.Session)session, parent);
                    session.refresh(parent);
                }
                Transaction tx = session.beginTransaction();
                if (parent != null) {
                    parent.removeChild((Treeable)node);
                    node.setParent(null);
                }
                HibernateDataProviderSession sessionWrapper = new HibernateDataProviderSession((org.hibernate.Session)session);
                BusinessRulesIFace busRulesObj = DBTableIdMgr.getInstance().getBusinessRule(node);
                if (busRulesObj != null) {
                    node = (Treeable)busRulesObj.beforeDelete(node, sessionWrapper);
                }
                session.delete((Object)node);
                if (busRulesObj != null) {
                    try {
                        if (!busRulesObj.beforeDeleteCommit(node, sessionWrapper)) {
                            tx.rollback();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        tx.rollback();
                        if (session.isOpen()) {
                            session.close();
                        }
                        return false;
                    }
                }
                boolean retVal = this.commitTransaction((org.hibernate.Session)session, tx);
                if (busRulesObj != null && retVal) {
                    busRulesObj.afterDeleteCommit(node);
                }
                boolean bl = retVal;
                return bl;
                {
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(HibernateTreeDataServiceImpl.class, ex);
                        log.error((Object)ex);
                        break block17;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (session.isOpen()) {
                    session.close();
                }
            }
        }
        return false;
    }

    @Override
    public List<String> nodesSkippingOverLevel(int levelSkippedRank, D treeDef) {
        org.hibernate.Session session = this.getNewSession(new Object[0]);
        try {
            Class nodeClass = treeDef.getNodeClass();
            Query nodeSkippingLevelQuery = session.createQuery("select n.fullName from " + nodeClass.getName() + " n where rankId>:rankID AND parent.rankId<:rankID AND definition=:treeDef");
            nodeSkippingLevelQuery.setParameter("rankID", (Object)levelSkippedRank);
            nodeSkippingLevelQuery.setParameter("treeDef", treeDef);
            List results = nodeSkippingLevelQuery.list();
            Vector<String> nodeNames = new Vector<String>(results.size());
            for (Object o : results) {
                nodeNames.add((String)o);
            }
            Vector<String> vector = nodeNames;
            return vector;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(HibernateTreeDataServiceImpl.class, ex);
            log.error((Object)ex);
        }
        finally {
            session.close();
        }
        return null;
    }

    @Override
    public List<String> nodeNamesAtLevel(int rankID, D treeDef) {
        org.hibernate.Session session = this.getNewSession(new Object[0]);
        try {
            Class nodeClass = treeDef.getNodeClass();
            Query nodeNamesQuery = session.createQuery("select n.fullName from " + nodeClass.getName() + " n where rankId=:rankID AND definition=:treeDef");
            nodeNamesQuery.setParameter("rankID", (Object)rankID);
            nodeNamesQuery.setParameter("treeDef", treeDef);
            List results = nodeNamesQuery.list();
            Vector<String> nodeNames = new Vector<String>(results.size());
            for (Object o : results) {
                nodeNames.add((String)o);
            }
            Vector<String> vector = nodeNames;
            return vector;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(HibernateTreeDataServiceImpl.class, ex);
            log.error((Object)ex);
        }
        finally {
            session.close();
        }
        return null;
    }

    @Override
    public int countNodesAtLevel(int rankID, D treeDef) {
        org.hibernate.Session session = this.getNewSession(new Object[0]);
        try {
            Class nodeClass = treeDef.getNodeClass();
            Query nodeCountQuery = session.createQuery("select count(n) from " + nodeClass.getName() + " n where rankID=:rankID AND definition=:treeDef");
            nodeCountQuery.setParameter("rankID", (Object)rankID);
            nodeCountQuery.setParameter("treeDef", treeDef);
            Integer count = (Integer)nodeCountQuery.uniqueResult();
            int n = count;
            return n;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(HibernateTreeDataServiceImpl.class, ex);
            log.error((Object)ex);
        }
        finally {
            session.close();
        }
        return 0;
    }

    @Override
    public synchronized boolean updateNodeNumbersAfterNodeEdit(T node, DataProviderSessionIFace session) throws Exception {
        DataProviderSessionIFace.QueryIFace q = session.createQuery("select nodeNumber, highestChildNodeNumber from " + node.getClass().getSimpleName().toLowerCase() + " where " + node.getClass().getSimpleName() + "ID = " + node.getTreeId() + " and " + node.getClass().getSimpleName() + "TreeDefID = " + node.getDefinition().getTreeDefId(), true);
        Object resObj = q.uniqueResult();
        Object[] result = (Object[])resObj;
        node.setNodeNumber((Integer)result[0]);
        node.setHighestChildNodeNumber((Integer)result[1]);
        return true;
    }

    @Override
    public synchronized boolean updateNodeNumbersAfterNodeAddition(T newNode, DataProviderSessionIFace session) throws Exception {
        boolean doNodeNumberUpdate = true;
        Object parent = newNode.getParent();
        Integer parentNN = null;
        if (parent == null) {
            doNodeNumberUpdate = false;
        } else {
            parentNN = parent.getNodeNumber();
            if (parentNN == null) {
                doNodeNumberUpdate = false;
            }
        }
        if (!doNodeNumberUpdate) {
            return true;
        }
        Treeable mergedParent = (Treeable)session.merge(parent);
        session.refresh(mergedParent);
        parentNN = mergedParent.getNodeNumber();
        String className = mergedParent.getClass().getName();
        Object def = mergedParent.getDefinition();
        String updateNodeNumbersQueryStr = "UPDATE " + className + " SET nodeNumber=nodeNumber+1 WHERE nodeNumber>:parentNN AND definition=:def";
        DataProviderSessionIFace.QueryIFace fixNodeNumQuery = session.createQuery(updateNodeNumbersQueryStr, false);
        fixNodeNumQuery.setParameter("parentNN", parentNN);
        fixNodeNumQuery.setParameter("def", def);
        fixNodeNumQuery.executeUpdate();
        String updateHighChildQueryStr = "UPDATE " + className + " SET highestChildNodeNumber=highestChildNodeNumber+1 WHERE highestChildNodeNumber>=:parentNN AND definition=:def";
        DataProviderSessionIFace.QueryIFace fixHighChildQuery = session.createQuery(updateHighChildQueryStr, false);
        fixHighChildQuery.setParameter("parentNN", parentNN);
        fixHighChildQuery.setParameter("def", def);
        fixHighChildQuery.executeUpdate();
        int newChildNN = parentNN + 1;
        String setChildNNQueryStr = "UPDATE " + className + " SET nodeNumber=:newChildNN WHERE nodeNumber IS NULL AND parentID=:parentID";
        DataProviderSessionIFace.QueryIFace setChildNNQuery = session.createQuery(setChildNNQueryStr, false);
        setChildNNQuery.setParameter("newChildNN", newChildNN);
        setChildNNQuery.setParameter("parentID", parent.getTreeId());
        setChildNNQuery.executeUpdate();
        String setChildHCQueryStr = "UPDATE " + className + " SET highestChildNodeNumber=:newChildNN WHERE highestChildNodeNumber IS NULL AND parentID=:parentID";
        DataProviderSessionIFace.QueryIFace setChildHCQuery = session.createQuery(setChildHCQueryStr, false);
        setChildHCQuery.setParameter("newChildNN", newChildNN);
        setChildHCQuery.setParameter("parentID", parent.getTreeId());
        setChildHCQuery.executeUpdate();
        return true;
    }

    @Override
    public boolean updateNodeNumbersAfterNodeDeletion(T deletedNode, DataProviderSessionIFace session) throws Exception {
        boolean success = true;
        Integer delNodeNN = deletedNode.getNodeNumber();
        Integer delNodeHC = deletedNode.getHighestChildNodeNumber();
        boolean doNodeNumberUpdate = true;
        if (delNodeNN == null || delNodeHC == null) {
            doNodeNumberUpdate = false;
        }
        if (doNodeNumberUpdate) {
            int nodesDeleted = delNodeHC - delNodeNN + 1;
            String className = deletedNode.getClass().getName();
            Object def = deletedNode.getDefinition();
            session.beginTransaction();
            String updateNodeNumbersQueryStr = "UPDATE " + className + " SET nodeNumber=nodeNumber-:nodesDeleted WHERE nodeNumber>=:delNodeNN AND definition=:def";
            DataProviderSessionIFace.QueryIFace fixNodeNumQuery = session.createQuery(updateNodeNumbersQueryStr, false);
            fixNodeNumQuery.setParameter("nodesDeleted", nodesDeleted);
            fixNodeNumQuery.setParameter("delNodeNN", delNodeNN);
            fixNodeNumQuery.setParameter("def", def);
            fixNodeNumQuery.executeUpdate();
            String updateHighChildQueryStr = "UPDATE " + className + " SET highestChildNodeNumber=highestChildNodeNumber-:nodesDeleted WHERE highestChildNodeNumber>=:delNodeHC AND definition=:def";
            DataProviderSessionIFace.QueryIFace fixHighChildQuery = session.createQuery(updateHighChildQueryStr, false);
            fixHighChildQuery.setParameter("nodesDeleted", nodesDeleted);
            fixHighChildQuery.setParameter("delNodeHC", delNodeHC);
            fixHighChildQuery.setParameter("def", def);
            fixHighChildQuery.executeUpdate();
            session.commit();
        }
        return success;
    }

    /*
     * Loose catch block
     */
    @Override
    public synchronized int moveTreeNode(T node, T newParent) {
        block24: {
            if (node == null || newParent == null) {
                throw new NullPointerException("'node' and 'newParent' must both be non-null");
            }
            if (node.getParent() == newParent) {
                return 2;
            }
            Object oldParent = node.getParent();
            if (oldParent == null) {
                throw new NullPointerException("'node' must already have a parent");
            }
            BusinessRulesIFace busRules = DBTableIdMgr.getInstance().getBusinessRule(node);
            BusinessRulesIFace.STATUS status = ((BaseTreeBusRules)busRules).checkForSiblingWithSameName(newParent, node, true);
            if (status != BusinessRulesIFace.STATUS.OK) {
                return 1;
            }
            org.hibernate.Session session = this.getNewSession(new Object[0]);
            try {
                String step1QueryStr;
                Treeable mergedNode = (Treeable)this.mergeIntoSession(session, node);
                Treeable mergedNewParent = (Treeable)this.mergeIntoSession(session, newParent);
                Treeable mergedOldParent = (Treeable)this.mergeIntoSession(session, oldParent);
                Transaction tx = session.beginTransaction();
                session.refresh((Object)mergedNode);
                session.refresh((Object)mergedNewParent);
                mergedOldParent.removeChild(mergedNode);
                mergedNewParent.addChild(mergedNode);
                mergedNode.setParent(mergedNewParent);
                HibernateDataProviderSession sessionWrapper = new HibernateDataProviderSession(session);
                if (busRules != null) {
                    busRules.beforeSave(mergedNode, sessionWrapper);
                }
                session.saveOrUpdate((Object)mergedNode);
                Treeable rootNode = mergedNewParent;
                while (rootNode.getParent() != null) {
                    rootNode = rootNode.getParent();
                }
                int rootHC = rootNode.getHighestChildNodeNumber();
                int xNN = mergedNode.getNodeNumber();
                int xHC = mergedNode.getHighestChildNodeNumber();
                int yNN = mergedNewParent.getNodeNumber();
                Object def = mergedNode.getDefinition();
                String className = mergedNode.getClass().getName();
                int numMoving = xHC - xNN + 1;
                boolean downwardMove = true;
                if (xNN > yNN) {
                    downwardMove = false;
                }
                if (downwardMove) {
                    step1QueryStr = "UPDATE " + className + " SET nodeNumber=nodeNumber+:rootHC, highestChildNodeNumber=highestChildNodeNumber+:rootHC WHERE nodeNumber>=:xNN AND nodeNumber<=:xHC AND definition=:def";
                    Query step1Query = session.createQuery(step1QueryStr);
                    step1Query.setParameter("def", def);
                    step1Query.setParameter("xNN", (Object)xNN);
                    step1Query.setParameter("xHC", (Object)xHC);
                    step1Query.setParameter("rootHC", (Object)rootHC);
                    step1Query.executeUpdate();
                    String step2QueryStr = "UPDATE " + className + " SET nodeNumber=nodeNumber-:numMoving WHERE nodeNumber>:xHC AND nodeNumber<=:yNN AND definition=:def";
                    Query step2Query = session.createQuery(step2QueryStr);
                    step2Query.setParameter("def", def);
                    step2Query.setParameter("xHC", (Object)xHC);
                    step2Query.setParameter("yNN", (Object)yNN);
                    step2Query.setParameter("numMoving", (Object)numMoving);
                    step2Query.executeUpdate();
                    String step3QueryStr = "UPDATE " + className + " SET highestChildNodeNumber=highestChildNodeNumber-:numMoving WHERE highestChildNodeNumber>=:xHC AND highestChildNodeNumber<:yNN AND definition=:def";
                    Query step3Query = session.createQuery(step3QueryStr);
                    step3Query.setParameter("def", def);
                    step3Query.setParameter("xHC", (Object)xHC);
                    step3Query.setParameter("yNN", (Object)yNN);
                    step3Query.setParameter("numMoving", (Object)numMoving);
                    step3Query.executeUpdate();
                    String step4QueryStr = "UPDATE " + className + " SET highestChildNodeNumber=highestChildNodeNumber-nodeNumber WHERE nodeNumber>:rootHC AND definition=:def";
                    Query step4Query = session.createQuery(step4QueryStr);
                    step4Query.setParameter("def", def);
                    step4Query.setParameter("rootHC", (Object)rootHC);
                    step4Query.executeUpdate();
                    String step5QueryStr = "UPDATE " + className + " SET nodeNumber=nodeNumber + :yNN - :xHC - :rootHC WHERE nodeNumber>:rootHC AND definition=:def";
                    Query step5Query = session.createQuery(step5QueryStr);
                    step5Query.setParameter("def", def);
                    step5Query.setParameter("xHC", (Object)xHC);
                    step5Query.setParameter("yNN", (Object)yNN);
                    step5Query.setParameter("rootHC", (Object)rootHC);
                    step5Query.executeUpdate();
                    String step6QueryStr = "UPDATE " + className + " SET highestChildNodeNumber=nodeNumber+highestChildNodeNumber WHERE nodeNumber >:lowerBound AND nodeNumber<=:yNN AND definition=:def";
                    Query step6Query = session.createQuery(step6QueryStr);
                    step6Query.setParameter("def", def);
                    step6Query.setParameter("yNN", (Object)yNN);
                    step6Query.setParameter("lowerBound", (Object)(yNN - numMoving));
                    step6Query.executeUpdate();
                } else {
                    step1QueryStr = "UPDATE " + className + " SET nodeNumber=nodeNumber+:rootHC, highestChildNodeNumber=highestChildNodeNumber+:rootHC WHERE nodeNumber>=:xNN AND nodeNumber<=:xHC AND definition=:def";
                    Query step1Query = session.createQuery(step1QueryStr);
                    step1Query.setParameter("def", def);
                    step1Query.setParameter("xNN", (Object)xNN);
                    step1Query.setParameter("xHC", (Object)xHC);
                    step1Query.setParameter("rootHC", (Object)rootHC);
                    step1Query.executeUpdate();
                    String step2QueryStr = "UPDATE " + className + " SET nodeNumber=nodeNumber+:numMoving WHERE nodeNumber>:yNN AND nodeNumber<:xNN AND definition=:def";
                    Query step2Query = session.createQuery(step2QueryStr);
                    step2Query.setParameter("def", def);
                    step2Query.setParameter("xNN", (Object)xNN);
                    step2Query.setParameter("yNN", (Object)yNN);
                    step2Query.setParameter("numMoving", (Object)numMoving);
                    step2Query.executeUpdate();
                    String step3QueryStr = "UPDATE " + className + " SET highestChildNodeNumber=highestChildNodeNumber+:numMoving WHERE highestChildNodeNumber>=:yNN AND highestChildNodeNumber<:xHC AND definition=:def";
                    Query step3Query = session.createQuery(step3QueryStr);
                    step3Query.setParameter("def", def);
                    step3Query.setParameter("yNN", (Object)yNN);
                    step3Query.setParameter("xHC", (Object)xHC);
                    step3Query.setParameter("numMoving", (Object)numMoving);
                    step3Query.executeUpdate();
                    String step4QueryStr = "UPDATE " + className + " SET highestChildNodeNumber=highestChildNodeNumber-nodeNumber WHERE nodeNumber>:rootHC AND definition=:def";
                    Query step4Query = session.createQuery(step4QueryStr);
                    step4Query.setParameter("def", def);
                    step4Query.setParameter("rootHC", (Object)rootHC);
                    step4Query.executeUpdate();
                    String step5QueryStr = "UPDATE " + className + " SET nodeNumber=nodeNumber+1+:yNN-:xNN-:rootHC WHERE nodeNumber>:rootHC AND definition=:def";
                    Query step5Query = session.createQuery(step5QueryStr);
                    step5Query.setParameter("def", def);
                    step5Query.setParameter("xNN", (Object)xNN);
                    step5Query.setParameter("yNN", (Object)yNN);
                    step5Query.setParameter("rootHC", (Object)rootHC);
                    step5Query.executeUpdate();
                    String step6QueryStr = "UPDATE " + className + " SET highestChildNodeNumber=highestChildNodeNumber+nodeNumber WHERE nodeNumber>:yNN AND nodeNumber<=:upperBound AND definition=:def";
                    Query step6Query = session.createQuery(step6QueryStr);
                    step6Query.setParameter("def", def);
                    step6Query.setParameter("yNN", (Object)yNN);
                    step6Query.setParameter("upperBound", (Object)(yNN + numMoving));
                    step6Query.executeUpdate();
                }
                if (busRules != null) {
                    try {
                        boolean retVal = busRules.beforeSaveCommit(mergedNode, sessionWrapper);
                        if (!retVal) {
                            tx.rollback();
                            return 2;
                        }
                    }
                    catch (Exception e) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(HibernateTreeDataServiceImpl.class, e);
                        tx.rollback();
                        if (session.isOpen()) {
                            session.close();
                        }
                        return 2;
                    }
                }
                boolean success = this.commitTransaction(session, tx);
                if (busRules != null) {
                    success &= busRules.afterSaveCommit(mergedNode, null);
                }
                if (success) {
                    return 0;
                }
                return 2;
                {
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(HibernateTreeDataServiceImpl.class, ex);
                        log.error((Object)ex);
                        break block24;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (session.isOpen()) {
                    session.close();
                }
            }
        }
        return 2;
    }

    protected boolean fixAdditionalRelationsips(org.hibernate.Session session, T source, T dest) {
        TreeAdditionalProcFactory.TreeAdditionalProcessing proc;
        if (source != null && (proc = TreeAdditionalProcFactory.getInstance().createProcessor(source.getClass())) != null) {
            return proc.process(session, source, dest);
        }
        return true;
    }

    @Override
    public String synonymize(T source, T destination) {
        String statusMsg = null;
        org.hibernate.Session session = this.getNewSession(source);
        Transaction tx = null;
        try {
            try {
                Treeable mergedDest = (Treeable)this.mergeIntoSession(session, destination);
                Treeable mergedSrc = (Treeable)this.mergeIntoSession(session, source);
                tx = session.beginTransaction();
                if (this.fixAdditionalRelationsips(session, mergedSrc, mergedDest)) {
                    TreeHelper.createNodeRelationship(mergedSrc, mergedDest);
                    if (!this.commitTransaction(session, tx)) {
                        statusMsg = UIRegistry.getResourceString("HibernateTreeDataService.NodeSynonymizedAddlRelError");
                    }
                } else if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(HibernateTreeDataServiceImpl.class, ex);
                log.error((Object)ex);
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        return statusMsg;
    }

    @Override
    public String unSynonymize(T node) {
        String statusMsg;
        block8: {
            statusMsg = null;
            org.hibernate.Session session = this.getNewSession(node);
            try {
                try {
                    Treeable mergedNode = (Treeable)this.mergeIntoSession(session, node);
                    Transaction tx = session.beginTransaction();
                    if (!this.fixAdditionalRelationsips(session, mergedNode, null)) break block8;
                    mergedNode.setIsAccepted(true);
                    mergedNode.setAcceptedParent(null);
                    if (!this.commitTransaction(session, tx)) {
                        statusMsg = UIRegistry.getResourceString("HibernateTreeDataService.NodeUnSynonymizedAddlRelError");
                        break block8;
                    }
                    statusMsg = String.format(UIRegistry.getResourceString("HibernateTreeDataService.NodeUnSynonymized"), node.getFullName());
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(HibernateTreeDataServiceImpl.class, ex);
                    log.error((Object)ex);
                    if (session != null && session.isOpen()) {
                        session.close();
                    }
                }
            }
            finally {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
        }
        return statusMsg;
    }

    @Override
    public Set<T> getSynonyms(T node) {
        Set synonyms = null;
        org.hibernate.Session session = this.getNewSession(node);
        try {
            try {
                synonyms = node.getAcceptedChildren();
                synonyms.size();
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(HibernateTreeDataServiceImpl.class, ex);
                log.error((Object)ex);
                session.close();
            }
        }
        finally {
            session.close();
        }
        return synonyms;
    }

    public Set<T> getSynonyms(Class<? extends Treeable<?, ?, ?>> clazz, Integer id) {
        T node = this.getNodeById(clazz, id);
        return this.getSynonyms(node);
    }

    @Override
    public Set<Pair<Integer, String>> getSynonymIdsAndNames(Class<?> clazz, Integer nodeId) {
        HashSet<Pair<Integer, String>> idsAndNames = new HashSet<Pair<Integer, String>>();
        org.hibernate.Session session = this.getNewSession(new Object[0]);
        try {
            try {
                String queryString = TreeFactory.getSynonymQueryString(clazz);
                Query q = session.createQuery(queryString);
                q.setParameter("NODEID", (Object)nodeId);
                List results = q.list();
                for (Object[] idAndName : results) {
                    Integer id = (Integer)idAndName[0];
                    String name = (String)idAndName[1];
                    idsAndNames.add(new Pair<Integer, String>(id, name));
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(HibernateTreeDataServiceImpl.class, ex);
                log.error((Object)ex);
                session.close();
            }
        }
        finally {
            session.close();
        }
        return idsAndNames;
    }

    @Override
    public synchronized void initializeRelatedObjects(T node) {
        org.hibernate.Session session = null;
        try {
            try {
                session = this.getNewSession(node);
                if (session != null) {
                    TreeHelper.initializeRelatedObjects(node);
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(HibernateTreeDataServiceImpl.class, ex);
                log.error((Object)ex);
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    @Override
    public synchronized void refresh(Object ... objects) {
        org.hibernate.Session session = this.getNewSession(objects);
        try {
            try {
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    session.refresh(o);
                    ++n2;
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(HibernateTreeDataServiceImpl.class, ex);
                log.error((Object)ex);
                session.close();
            }
        }
        finally {
            session.close();
        }
    }

    private org.hibernate.Session getNewSession(Object ... objects) {
        Session session = HibernateUtil.getSessionFactory().openSession();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            DataModelObjBase dmob;
            Object o = objectArray[n2];
            if (o != null && (dmob = (DataModelObjBase)o).getId() != null) {
                session.lock(o, LockMode.NONE);
            }
            ++n2;
        }
        return session;
    }

    private Object mergeIntoSession(org.hibernate.Session session, Object object) {
        return session.merge(object);
    }

    private boolean commitTransaction(org.hibernate.Session session, Transaction tx) {
        boolean result = true;
        try {
            try {
                tx.commit();
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(HibernateTreeDataServiceImpl.class, ex);
                result = false;
                log.error((Object)"Error while committing transaction to DB", (Throwable)ex);
                tx.rollback();
                if (session.isOpen()) {
                    session.close();
                }
            }
        }
        finally {
            if (session.isOpen()) {
                session.close();
            }
        }
        return result;
    }

    private String nodeDebugInfo(Object o) {
        if (o instanceof Treeable) {
            Treeable t = (Treeable)o;
            return t.getTreeId() + " " + t.getName() + " 0x" + Integer.toHexString(t.hashCode());
        }
        return o.toString();
    }
}

