/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.treeutils;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.treeutils.FullNameBuilder;
import edu.ku.brc.specify.treeutils.NodeNumberer;
import edu.ku.brc.specify.treeutils.TreeNodeInfo;
import edu.ku.brc.specify.treeutils.TreeTraversalWorker;
import java.util.LinkedList;
import java.util.List;

public class FullNameRebuilder<T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>>
extends TreeTraversalWorker<T, D, I> {
    protected DataProviderSessionIFace.QueryIFace updateNodeQuery = null;
    protected final int minRank;
    protected final boolean ownsSession;
    protected FullNameBuilder<T, D, I> fullNameBuilder;

    public FullNameRebuilder(D treeDef, DataProviderSessionIFace traversalSession, int minRank) {
        super(treeDef);
        this.traversalSession = traversalSession;
        this.ownsSession = traversalSession == null;
        this.minRank = minRank;
    }

    @Override
    public Boolean doInBackground() throws Exception {
        if (this.ownsSession) {
            this.traversalSession = DataProviderFactory.getInstance().createSession();
        }
        try {
            if (this.ownsSession) {
                this.traversalSession.beginTransaction();
            }
            this.buildQueries();
            Object root = this.getTreeRoot();
            this.initProgress();
            this.initCacheInfo();
            this.fullNameBuilder = new FullNameBuilder(this.treeDef);
            this.rebuildFullNames(new TreeNodeInfo(root.getTreeId(), root.getRankId(), root.getName(), root.getIsAccepted()), new LinkedList<TreeNodeInfo>());
            if (this.ownsSession) {
                this.traversalSession.commit();
            }
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(NodeNumberer.class, e);
            Boolean bl = false;
            return bl;
        }
        finally {
            if (this.ownsSession) {
                this.traversalSession.close();
            }
        }
    }

    protected void rebuildFullNames(TreeNodeInfo node, LinkedList<TreeNodeInfo> parents) throws Exception {
        List<?> children = this.getChildrenInfo(node);
        if (node.getRank() >= this.minRank) {
            this.writeNode(node.getId(), this.fullNameBuilder.buildFullName(node, parents));
        }
        parents.addLast(node);
        for (Object child : children) {
            Object[] childInfo = (Object[])child;
            this.rebuildFullNames(new TreeNodeInfo((Integer)childInfo[0], (Integer)childInfo[2], (String)childInfo[1], (Boolean)childInfo[3]), parents);
        }
        parents.removeLast();
        this.incrementProgress();
        this.checkCache();
    }

    protected List<?> getChildrenInfo(TreeNodeInfo node) {
        this.childrenQuery.setParameter("parentArg", node.getId());
        return this.childrenQuery.list();
    }

    protected void buildQueries() {
        this.buildChildrenQuery();
        this.buildUpdateNodeQuery();
    }

    protected void buildUpdateNodeQuery() {
        String updateSQL = "update " + this.getNodeTblName() + " set FullName=:fnArg where " + this.getNodeKeyFldName() + "=:keyArg";
        this.updateNodeQuery = this.traversalSession.createQuery(updateSQL, true);
    }

    protected void writeNode(int nodeId, String fullName) throws Exception {
        this.updateNodeQuery.setParameter("keyArg", nodeId);
        this.updateNodeQuery.setParameter("fnArg", fullName);
        this.updateNodeQuery.executeUpdate();
    }

    @Override
    protected void buildChildrenQuery() {
        String childrenSQL = "select " + this.getNodeKeyFldName() + ", " + this.getNodeTblName() + ".Name, RankId from " + this.getNodeTblName() + " where " + this.getNodeParentFldName() + " =:parentArg  order by name";
        this.childrenQuery = this.traversalSession.createQuery(childrenSQL, true);
    }
}

