/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.treeutils;

import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.treeutils.TreeNodeInfo;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;

public class FullNameBuilder<T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>> {
    protected final D treedef;
    protected final SortedSet<FullNameInfo> ranks;
    protected final int reverse;
    protected final FullNameInfo fullNameInfo = new FullNameInfo(null, null, null, -1);

    public FullNameBuilder(D treedef) {
        this.treedef = treedef;
        this.reverse = treedef.getFullNameDirection();
        this.ranks = new TreeSet<FullNameInfo>(new Comparator<FullNameInfo>(){

            @Override
            public int compare(FullNameInfo arg0, FullNameInfo arg1) {
                return FullNameBuilder.this.reverse * arg0.getRank().compareTo(arg1.getRank());
            }
        });
        for (TreeDefItemIface rank : treedef.getTreeDefItems()) {
            if (rank.getIsInFullName() == null || !rank.getIsInFullName().booleanValue()) continue;
            this.ranks.add(new FullNameInfo(this, rank));
        }
    }

    public boolean isInFullName(int rankid) {
        this.fullNameInfo.setRank(rankid);
        return this.ranks.contains(this.fullNameInfo);
    }

    public String buildFullName(TreeNodeInfo node, LinkedList<TreeNodeInfo> parents) throws Exception {
        if (!this.isInFullName(node.getRank())) {
            return node.getName();
        }
        StringBuilder sb = new StringBuilder();
        boolean backwards = this.reverse == -1;
        int parentIdx = backwards ? parents.size() - 1 : 0;
        int incrementor = backwards ? -1 : 1;
        Iterator fullNameIterator = this.ranks.iterator();
        boolean addedNode = false;
        String nextSeparator = null;
        while (fullNameIterator.hasNext()) {
            FullNameInfo info = (FullNameInfo)fullNameIterator.next();
            String name = null;
            if (info.getRank().intValue() == node.getRank()) {
                addedNode = true;
                name = node.getName();
            } else if ((addedNode || !backwards) && parentIdx >= 0 && parentIdx < parents.size()) {
                TreeNodeInfo parentInfo = parents.get(parentIdx);
                if (parentInfo.getRank() == info.getRank().intValue()) {
                    name = parentInfo.getName();
                }
                if (!backwards && parentInfo.getRank() <= info.getRank() || backwards && parentInfo.getRank() >= info.getRank()) {
                    parentIdx += incrementor;
                }
            }
            if (name == null) continue;
            if (nextSeparator != null) {
                sb.append(nextSeparator);
            }
            if (info.getBefore() != null) {
                sb.append(info.getBefore());
            }
            sb.append(name);
            if (info.getAfter() != null) {
                sb.append(info.getAfter());
            }
            nextSeparator = info.getSeparator();
        }
        if (!addedNode) {
            throw new Exception("FullNameBuilder: error building full name for " + node.getName() + " (id=" + node.getId() + ")");
        }
        return sb.toString();
    }

    public class FullNameInfo {
        private final String before;
        private final String after;
        private final String separator;
        private Integer rank;

        public FullNameInfo(Integer rank) {
            this(null, null, null, rank);
        }

        public FullNameInfo(String before, String after, String separator, Integer rank) {
            this.before = before;
            this.after = after;
            this.separator = separator;
            this.rank = rank;
        }

        public FullNameInfo(I rank) {
            this(rank.getTextBefore(), rank.getTextAfter(), rank.getFullNameSeparator(), rank.getRankId());
        }

        public String getBefore() {
            return this.before;
        }

        public String getAfter() {
            return this.after;
        }

        public String getSeparator() {
            return this.separator;
        }

        public Integer getRank() {
            return this.rank;
        }

        public void setRank(Integer rank) {
            this.rank = rank;
        }
    }
}

