/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.treeutils;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.CustomQueryIFace;
import edu.ku.brc.dbsupport.CustomQueryListener;
import edu.ku.brc.dbsupport.JPAQuery;
import edu.ku.brc.dbsupport.SQLExecutionListener;
import edu.ku.brc.dbsupport.SQLExecutionProcessor;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.ui.treetables.TreeNode;
import edu.ku.brc.specify.ui.treetables.TreeTableViewer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ChildNodeCounter
implements SQLExecutionListener,
CustomQueryListener {
    protected static final Logger log = Logger.getLogger(ChildNodeCounter.class);
    protected TreeNode node;
    protected int step = 0;
    protected int valStep = 2;
    protected boolean isHQL = false;
    protected String nodeNumQuery;
    protected String countQuery;
    protected int slotIndex;
    protected TreeTableViewer<?, ?, ?> viewer;

    public ChildNodeCounter(TreeTableViewer<?, ?, ?> viewer, int slotIndex, TreeNode node, String nodeNumQuery, String countQuery, boolean isHQL) {
        this.viewer = viewer;
        this.slotIndex = slotIndex;
        this.node = node;
        this.countQuery = countQuery;
        this.nodeNumQuery = nodeNumQuery;
        this.isHQL = isHQL;
        this.setCalcCount(true);
        this.doQuery(this.getQuery(node.getId()));
        this.valStep = countQuery == null ? 1 : 2;
    }

    protected void setCalcCount(boolean calc) {
        if (this.slotIndex == 1) {
            this.node.setCalcCount(calc);
        } else {
            this.node.setCalcCount2(calc);
        }
    }

    protected void setHasCalcCount(boolean hasCalc) {
        if (this.slotIndex == 1) {
            this.node.setHasCalcCount(hasCalc);
        } else {
            this.node.setHasCalcCount2(hasCalc);
        }
    }

    protected String getQuery(Object data) {
        switch (this.step) {
            case 0: {
                return String.format(this.nodeNumQuery, (Integer)data);
            }
            case 1: {
                if (((List)data).size() > 0) {
                    int botNodenum;
                    List row = (List)((List)data).get(0);
                    if (row == null || row.size() <= 2) break;
                    if (row.get(1) == null || row.get(2) == null) {
                        log.warn((Object)"null node number: skipping count");
                        return null;
                    }
                    int topNodeNum = (Integer)row.get(1);
                    if (topNodeNum >= (botNodenum = ((Integer)row.get(2)).intValue())) break;
                    return String.format(this.countQuery, topNodeNum, botNodenum);
                }
                log.warn((Object)"object list is empty: skipping count");
            }
        }
        return null;
    }

    protected void doQuery(String sql) {
        if (sql != null) {
            ++this.step;
            if (this.isHQL) {
                JPAQuery jpaQuery = new JPAQuery(sql, (CustomQueryListener)this);
                jpaQuery.setUnique(true);
                jpaQuery.start();
            } else {
                SQLExecutionProcessor sqlExec = new SQLExecutionProcessor(this, sql);
                sqlExec.start();
            }
        } else {
            this.cleanup();
        }
    }

    protected void setCount(int count) {
        if (this.slotIndex == 1) {
            this.node.setAssociatedRecordCount(count);
        } else {
            this.node.setAssociatedRecordCount2(count);
        }
        if (this.viewer != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChildNodeCounter.this.viewer.repaintLists();
                }
            });
        }
    }

    protected void cleanup() {
        this.node = null;
        this.countQuery = null;
        this.nodeNumQuery = null;
    }

    @Override
    public void exectionDone(SQLExecutionProcessor process, ResultSet resultSet) {
        this.setCalcCount(false);
        this.setHasCalcCount(true);
        if (this.step == this.valStep) {
            try {
                if (resultSet.next()) {
                    int count = resultSet.getInt(1);
                    this.setCount(count);
                    this.cleanup();
                    return;
                }
            }
            catch (SQLException ex) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(ChildNodeCounter.class, ex);
                ex.printStackTrace();
            }
            this.setCount(0);
            this.cleanup();
        } else {
            ArrayList dataRows = new ArrayList();
            try {
                ResultSetMetaData colInfo = resultSet.getMetaData();
                while (resultSet.next()) {
                    ArrayList<Object> row = new ArrayList<Object>();
                    int i = 1;
                    while (i <= colInfo.getColumnCount()) {
                        row.add(resultSet.getObject(i));
                        ++i;
                    }
                    dataRows.add(row);
                }
                this.doQuery(this.getQuery(dataRows));
            }
            catch (SQLException ex) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(ChildNodeCounter.class, ex);
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void executionError(SQLExecutionProcessor process, Exception ex) {
        this.setCalcCount(false);
        this.setHasCalcCount(true);
        this.setCount(0);
        this.cleanup();
    }

    @Override
    public void exectionDone(CustomQueryIFace customQuery) {
        List<?> list = customQuery.getDataObjects();
        if (this.step == this.valStep) {
            int count = (Integer)list.get(0);
            this.setCount(count);
            this.cleanup();
            return;
        }
        ArrayList dataRows = new ArrayList();
        for (Object row : list) {
            ArrayList<Object> rowArray = new ArrayList<Object>();
            dataRows.add(rowArray);
            if (row instanceof Collection) {
                for (Object obj : (Collection)row) {
                    rowArray.add(obj);
                }
                continue;
            }
            if (row instanceof Object[]) {
                Object[] objectArray = (Object[])row;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj;
                    obj = objectArray[n2];
                    rowArray.add(obj);
                    ++n2;
                }
                continue;
            }
            rowArray.add(row);
        }
        this.doQuery(this.getQuery(dataRows));
    }

    @Override
    public void executionError(CustomQueryIFace customQuery) {
    }
}

