/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode.mexconabio;

import com.csvreader.CsvReader;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.tasks.subpane.wb.CSVImport;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureCSV;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureExternalDataIFace;
import edu.ku.brc.specify.tasks.subpane.wb.DataImportIFace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class MexConvToSQLNew {
    protected Vector<String> toks = new Vector();

    private String fixName(String nameArg) {
        String name = nameArg.toLowerCase();
        StringBuilder nm = new StringBuilder();
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c != ':' && c <= 'z') {
                nm.append(c);
            }
            ++i;
        }
        return StringUtils.replace((String)nm.toString().trim(), (String)" ", (String)"_");
    }

    private Vector<String> split(String line) {
        String[] tokens;
        this.toks.clear();
        String[] stringArray = tokens = StringUtils.splitPreserveAllTokens((String)line, (char)'|');
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.toks.add(s);
            ++n2;
        }
        return this.toks;
    }

    public void convert(String tableName, String fileName) {
        String str = "";
        int fldLen = 0;
        int inx = 0;
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = DriverManager.getConnection("jdbc:mysql://localhost/mex?characterEncoding=UTF-8&autoReconnect=true", "root", "root");
                stmt = conn.createStatement();
                int[] fieldLengths = null;
                BasicSQLUtils.deleteAllRecordsFromTable(conn, tableName, BasicSQLUtils.SERVERTYPE.MySQL);
                Vector<Integer> types = new Vector<Integer>();
                Vector<String> names = new Vector<String>();
                String selectStr = null;
                String prepareStr = null;
                try {
                    prepareStr = FileUtils.readFileToString((File)new File("prepare_stmt.txt"));
                    selectStr = FileUtils.readFileToString((File)new File("select.txt"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                int idInx = selectStr.indexOf("ID,");
                if (idInx == 0) {
                    selectStr = selectStr.substring(3);
                }
                File file = new File("/Users/rods/Documents/" + fileName);
                SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
                int rowCnt = 0;
                try {
                    System.out.println(prepareStr);
                    PreparedStatement pStmt = conn.prepareStatement(prepareStr);
                    BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
                    str = in.readLine();
                    String[] fieldNames = StringUtils.split((String)str, (String)",");
                    String sql = "SELECT " + selectStr + " FROM " + tableName;
                    System.out.println(sql);
                    ResultSet rs = stmt.executeQuery(sql);
                    ResultSetMetaData rsmd = rs.getMetaData();
                    fieldLengths = new int[rsmd.getColumnCount()];
                    int i = 1;
                    while (i <= rsmd.getColumnCount()) {
                        fieldLengths[i - 1] = rsmd.getPrecision(i);
                        types.add(rsmd.getColumnType(i));
                        names.add(rsmd.getColumnName(i));
                        System.out.println(String.valueOf(i > 1 ? fieldNames[i - 2] : "ID") + " / " + rsmd.getColumnName(i) + " - " + rsmd.getPrecision(i));
                        ++i;
                    }
                    int numCols = rsmd.getColumnCount();
                    rs.close();
                    System.out.println("Number of Fields: " + numCols);
                    str = in.readLine();
                    while (str != null) {
                        Vector<String> fields = this.split(str = StringUtils.replace((String)str.substring(1, str.length() - 1), (String)"\",\"", (String)"|"));
                        if (fields.size() != numCols) {
                            System.out.println("numCols: " + numCols + " != " + fields.size() + "fields.size()");
                            continue;
                        }
                        int col = 1;
                        inx = 0;
                        for (String fld : fields) {
                            String field = fld.trim();
                            fldLen = field.length();
                            pStmt.setObject(col, null);
                            switch ((Integer)types.get(inx)) {
                                case -16: 
                                case -1: 
                                case 12: {
                                    if (field.length() > 0) {
                                        if (field.length() <= fieldLengths[inx]) {
                                            pStmt.setString(col, field);
                                            break;
                                        }
                                        System.err.println(String.format("The data for `%s` (%d) is too big %d f[%s]", names.get(inx), fieldLengths[inx], field.length(), field));
                                        pStmt.setString(col, null);
                                        break;
                                    }
                                    pStmt.setString(col, null);
                                    break;
                                }
                                case 6: 
                                case 8: {
                                    if (StringUtils.isNotEmpty((String)field)) {
                                        if (StringUtils.isNumeric((String)field)) {
                                            pStmt.setDouble(col, field.length() > 0 ? Double.valueOf(Double.parseDouble(field)) : null);
                                            break;
                                        }
                                        System.err.println(String.valueOf(col) + " Bad Number[" + field + "] ");
                                        pStmt.setDate(col, null);
                                        break;
                                    }
                                    pStmt.setDate(col, null);
                                    break;
                                }
                                case 4: {
                                    if (StringUtils.isNotEmpty((String)field)) {
                                        if (StringUtils.isNumeric((String)field)) {
                                            pStmt.setInt(col, field.length() > 0 ? Integer.valueOf(Integer.parseInt(field)) : null);
                                            break;
                                        }
                                        System.err.println(String.valueOf(col) + " Bad Number[" + field + "] ");
                                        pStmt.setDate(col, null);
                                        break;
                                    }
                                    pStmt.setDate(col, null);
                                    break;
                                }
                                case 92: {
                                    Time time = null;
                                    try {
                                        time = Time.valueOf(field);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    pStmt.setTime(col, time);
                                    break;
                                }
                                case 91: {
                                    try {
                                        if (StringUtils.isNotEmpty((String)field)) {
                                            if (StringUtils.contains((String)field, (String)"/")) {
                                                field = StringUtils.replace((String)field, (String)"/", (String)"-");
                                            } else if (StringUtils.contains((String)field, (String)" ")) {
                                                field = StringUtils.replace((String)field, (String)" ", (String)"-");
                                            }
                                            pStmt.setDate(col, field.length() > 0 ? new Date(sdf.parse(field).getTime()) : null);
                                            break;
                                        }
                                        pStmt.setDate(col, null);
                                    }
                                    catch (Exception ex) {
                                        System.err.println(String.valueOf(col) + " Bad Date[" + field + "]\n" + str);
                                        pStmt.setDate(col, null);
                                    }
                                    break;
                                }
                                default: {
                                    System.err.println("Error - " + types.get(inx));
                                }
                            }
                            ++inx;
                            ++col;
                        }
                        pStmt.execute();
                        str = in.readLine();
                        ++rowCnt;
                    }
                    in.close();
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    System.err.println("Row: " + rowCnt);
                    System.err.println(str);
                    System.err.println(String.valueOf(inx) + "  " + fieldLengths[inx] + " - Field Len: " + fldLen);
                    e.printStackTrace();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    stmt.close();
                    conn.close();
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        finally {
            try {
                stmt.close();
                conn.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void readCSV(File file) {
        ConfigureCSV config = new ConfigureCSV(file);
        if (config.getStatus() == ConfigureExternalDataIFace.Status.Valid) {
            this.getData(config);
        }
    }

    public DataImportIFace.Status getData(ConfigureCSV config) {
        CsvReader csv = null;
        try {
            ConfigureCSV configCSV = null;
            if (config instanceof ConfigureCSV && (configCSV = config).getStatus() == ConfigureExternalDataIFace.Status.Valid) {
                csv = new CsvReader((InputStream)new FileInputStream(config.getFile()), configCSV.getDelimiter(), configCSV.getCharset());
                csv.setEscapeMode(configCSV.getEscapeMode());
                csv.setTextQualifier(configCSV.getTextQualifier());
                if (config.getFirstRowHasHeaders()) {
                    csv.readHeaders();
                } else {
                    csv.setHeaders(configCSV.setupHeaders());
                }
                String[] newHeaders = null;
                if (configCSV.getNumOfColsToAppend() > csv.getColumnCount()) {
                    newHeaders = configCSV.padColumnHeaders(configCSV.getNumOfColsToAppend(), csv.getHeaders());
                    csv.setHeaders(newHeaders);
                }
                this.convertFROMCSV(config, csv);
            }
            return DataImportIFace.Status.Valid;
        }
        catch (IOException ex) {
            csv.close();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(CSVImport.class, ex);
            return DataImportIFace.Status.Error;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void convertFROMCSV(ConfigureCSV config, CsvReader csv) {
        String str = "";
        int strLen = 0;
        int inx = 0;
        CsvReader csvObj = null;
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = DriverManager.getConnection("jdbc:mysql://localhost/mex?characterEncoding=UTF-8&autoReconnect=true", "root", "root");
                stmt = conn.createStatement();
                StringBuilder pStmtStr = new StringBuilder();
                StringBuilder sb = new StringBuilder();
                StringBuilder ques = new StringBuilder();
                int[] fieldLengths = null;
                BasicSQLUtils.deleteAllRecordsFromTable(conn, "mex", BasicSQLUtils.SERVERTYPE.MySQL);
                Vector<Integer> types = new Vector<Integer>();
                Vector names = new Vector();
                File file = new File("/Users/rods/Documents/Untitled.mer");
                Element root = XMLHelper.readFileToDOM4J(new File("/Users/rods/Documents/Acer.xml"));
                if (root != null) {
                    fieldLengths = new int[csv.getColumnCount()];
                    int i = 0;
                    while (i < fieldLengths.length) {
                        fieldLengths[i] = 0;
                        ++i;
                    }
                    int row = 0;
                    while (csv.readRecord()) {
                        ++row;
                        int col = 0;
                        while (col < csv.getColumnCount()) {
                            String dataObj = csv.get(col);
                            int len = dataObj.length() + 1;
                            if (len > fieldLengths[inx]) {
                                fieldLengths[inx] = len;
                            }
                            ++inx;
                            ++col;
                        }
                        if (row % 10000 != 0) continue;
                        System.out.println(row);
                    }
                    System.out.println("--------------");
                    HashMap<String, Integer> hashSize = new HashMap<String, Integer>();
                    int i2 = 0;
                    while (i2 < names.size()) {
                        hashSize.put((String)names.get(i2), fieldLengths[i2]);
                        System.out.println(String.valueOf((String)names.get(i2)) + " -> " + fieldLengths[i2]);
                        ++i2;
                    }
                    sb.append("CREATE TABLE mex (");
                    List items = root.selectNodes("/FIELDS/FIELD");
                    System.out.println(items.size());
                    inx = 0;
                    for (Element fieldNode : items) {
                        String nullOK = fieldNode.attributeValue("EMPTYOK");
                        String fldName = this.fixName(fieldNode.attributeValue("NAME").trim());
                        String type = fieldNode.attributeValue("TYPE");
                        sb.append("`");
                        sb.append(fldName);
                        sb.append("` ");
                        System.err.println("[" + fldName + "]");
                        int len = (Integer)hashSize.get(fldName);
                        if (pStmtStr.length() > 0) {
                            pStmtStr.append(',');
                        }
                        pStmtStr.append("`" + fldName + "`");
                        if (ques.length() > 0) {
                            ques.append(',');
                        }
                        ques.append("?");
                        if (type.equals("TEXT")) {
                            if (StringUtils.contains((String)fldName, (String)"img folder")) {
                                sb.append("longtext ");
                            } else {
                                sb.append("VARCHAR(" + len + ") CHARACTER SET utf8 ");
                            }
                            types.add(DataType.TEXT.ordinal());
                        } else if (type.equals("NUMBER")) {
                            sb.append("DOUBLE ");
                            types.add(DataType.NUMBER.ordinal());
                        } else if (type.equals("DATE")) {
                            sb.append("DATE ");
                            types.add(DataType.DATE.ordinal());
                        } else if (type.equals("TIME")) {
                            sb.append("VARCHAR(16) ");
                            types.add(DataType.TIME.ordinal());
                        } else {
                            System.err.println("Unhandled Type[" + type + "]");
                        }
                        sb.append(nullOK.equals("YES") ? "DEFAULT NULL," : ",");
                        sb.append("\n");
                        ++inx;
                    }
                    sb.setLength(sb.length() - 2);
                    sb.append(") ENGINE=MyISAM DEFAULT CHARSET=utf8;");
                }
                SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
                int rowCnt = 0;
                try {
                    try {
                        String stmtStr = "INSERT INTO mex (" + pStmtStr + ") VALUES(" + ques + ")";
                        System.out.println(stmtStr);
                        try {
                            stmt.executeUpdate("DROP TABLE mex");
                        }
                        catch (SQLException capIter) {
                            // empty catch block
                        }
                        System.err.println(sb.toString());
                        stmt.executeUpdate(sb.toString());
                        PreparedStatement pStmt = conn.prepareStatement(stmtStr);
                        csv.close();
                        csvObj = new CsvReader((InputStream)new FileInputStream(config.getFile()), config.getDelimiter(), config.getCharset());
                        csvObj.readRecord();
                        int row = 0;
                        while (csvObj.readRecord()) {
                            ++row;
                            int col = 0;
                            while (col < csvObj.getColumnCount()) {
                                String dataStr = csvObj.get(col);
                                strLen = dataStr.length();
                                switch ((Integer)types.get(inx)) {
                                    case 0: 
                                    case 3: {
                                        if (strLen > 0) {
                                            if (strLen <= fieldLengths[inx]) {
                                                pStmt.setString(col, dataStr);
                                                break;
                                            }
                                            System.err.println(String.format("The data for `%s` (%d) is too big %d", names.get(inx), fieldLengths[inx], strLen));
                                            pStmt.setString(col, null);
                                            break;
                                        }
                                        pStmt.setString(col, null);
                                        break;
                                    }
                                    case 1: {
                                        if (StringUtils.isNotEmpty((String)dataStr)) {
                                            if (StringUtils.isNumeric((String)dataStr)) {
                                                pStmt.setDouble(col, strLen > 0 ? Double.valueOf(Double.parseDouble(dataStr)) : null);
                                                break;
                                            }
                                            System.err.println(String.valueOf(col) + " Bad Number[" + dataStr + "] ");
                                            pStmt.setDate(col, null);
                                            break;
                                        }
                                        pStmt.setDate(col, null);
                                        break;
                                    }
                                    case 2: {
                                        try {
                                            if (StringUtils.isNotEmpty((String)dataStr)) {
                                                if (StringUtils.contains((String)dataStr, (String)"/")) {
                                                    dataStr = StringUtils.replace((String)dataStr, (String)"/", (String)"-");
                                                } else if (StringUtils.contains((String)dataStr, (String)" ")) {
                                                    dataStr = StringUtils.replace((String)dataStr, (String)" ", (String)"-");
                                                }
                                                pStmt.setDate(col, strLen > 0 ? new Date(sdf.parse(dataStr).getTime()) : null);
                                                break;
                                            }
                                            pStmt.setDate(col, null);
                                        }
                                        catch (Exception ex) {
                                            System.err.println(String.valueOf(col) + " Bad Date[" + dataStr + "]\n" + str);
                                            pStmt.setDate(col, null);
                                        }
                                        break;
                                    }
                                    default: {
                                        System.err.println("Error - " + types.get(inx));
                                    }
                                }
                                ++inx;
                                ++col;
                                ++col;
                            }
                            pStmt.execute();
                            ++row;
                        }
                        return;
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                        if (csvObj == null) return;
                        csvObj.close();
                        return;
                    }
                    catch (Exception e) {
                        System.err.println("Row: " + rowCnt);
                        System.err.println(str);
                        System.err.println(String.valueOf(inx) + "  " + fieldLengths[inx] + " - Field Len: " + strLen);
                        e.printStackTrace();
                        if (csvObj == null) return;
                        csvObj.close();
                        return;
                    }
                }
                finally {
                    if (csvObj != null) {
                        csvObj.close();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    stmt.close();
                    conn.close();
                    return;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            return;
        }
        finally {
            try {
                stmt.close();
                conn.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        MexConvToSQLNew m = new MexConvToSQLNew();
        m.convert("Conabio", "ConabioAll.mer");
    }

    static enum DataType {
        TEXT,
        NUMBER,
        DATE,
        TIME;

    }
}

