/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode.mexconabio;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.ConversionLogger;
import edu.ku.brc.specify.conversion.TableWriter;
import edu.ku.brc.specify.toycode.mexconabio.FMPCreateTable;
import edu.ku.brc.specify.toycode.mexconabio.FieldDef;
import edu.ku.brc.util.AttachmentUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class MexConvToSQL {
    private static final String BGR = "bgr";
    private static final String GR = "gr";
    private static final String BYW = "byw";
    private static final String YW = "yw";
    private static final String DF = "df";
    protected Vector<String> toks = new Vector();
    protected char[] seps = new char[]{'`', '~', '|', '+'};
    private PreparedStatement pStmt = null;
    private ConversionLogger convLogger = new ConversionLogger();
    private PreparedStatement mpStmt = null;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    int fndCnt = 0;
    int numRecs = 0;
    Calendar cal = Calendar.getInstance();
    String[] cCls = new String[7];
    String[] mCls = new String[7];
    int[] histo = new int[101];
    Connection conn = null;
    int totalScore = 0;

    private Vector<String> split(String line, char c) {
        String[] tokens;
        this.toks.clear();
        String[] stringArray = tokens = StringUtils.splitPreserveAllTokens((String)line, (char)c);
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.toks.add(s);
            ++n2;
        }
        return this.toks;
    }

    private void processFieldSizes(FMPCreateTable fmpInfo, String srcFileName) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        Vector<FieldDef> fieldDefs = fmpInfo.getFields();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(srcFileName)), "UTF8"));
        String str = in.readLine();
        int recNumber = 41477000;
        str = in.readLine();
        int rowCnt = 0;
        while (str != null) {
            Vector<String> fields;
            String line = str;
            char sep = '`';
            String sepStr = "";
            Object object = this.seps;
            int n = this.seps.length;
            int n2 = 0;
            while (n2 < n) {
                char c = object[n2];
                if (line.indexOf(c) == -1) {
                    sepStr = String.valueOf(sepStr) + c;
                    sep = c;
                    break;
                }
                ++n2;
            }
            str = StringUtils.replace((String)str.substring(1, str.length() - 1), (String)"\",\"", (String)sepStr);
            if (rowCnt >= recNumber) {
                Vector<String> fields2 = this.split(str, '|');
                Vector<String> fields22 = new Vector<String>(this.split(str, sep));
                int x = 0;
                while (x < fields2.size()) {
                    if (StringUtils.isNotEmpty((String)fields2.get(x)) && StringUtils.isNotEmpty((String)fields22.get(x)) || x > 39 && x < 51) {
                        System.out.println(String.valueOf(x) + "  [" + fields2.get(x) + "][" + fields22.get(x) + "]");
                    }
                    ++x;
                }
                System.out.println(line);
                System.out.println(str);
            }
            if ((fields = this.split(str, sep)).size() != fieldDefs.size() - 1) {
                System.out.println(String.valueOf(rowCnt) + "  -  " + fields.size() + " != " + (fieldDefs.size() - 1));
                int i = 0;
                for (String value : fields) {
                    System.out.println(String.valueOf(i) + " [" + value + "]");
                    ++i;
                }
                System.out.println(line);
            }
            int inx = 1;
            object = fields.iterator();
            while (object.hasNext()) {
                String value = (String)object.next();
                FieldDef fd = fieldDefs.get(inx);
                int len = value.length() + 1;
                fd.setMaxSize(len);
                if (fd.getType() == FieldDef.DataType.eNumber && value.contains(".")) {
                    fd.setDouble(true);
                }
                ++inx;
            }
            if (++rowCnt % 1000 == 0) {
                System.out.println(rowCnt);
            }
            str = in.readLine();
        }
        in.close();
    }

    protected void mapTable(Connection conn, String databaseName, String mapTableName) {
        String sql = String.format("SELECT COUNT(*) FROM `INFORMATION_SCHEMA`.`COLUMNS` WHERE TABLE_SCHEMA = '%s' AND TABLE_NAME = '%s'", databaseName, mapTableName);
        System.out.println(sql);
        int count = BasicSQLUtils.getCountAsInt(conn, sql);
        if (count > 0) {
            BasicSQLUtils.update(conn, "DROP TABLE " + mapTableName);
        }
        sql = "CREATE TABLE `" + mapTableName + "` (" + "`OldID` int(11) NOT NULL default '0', " + "`NewID` int(11) NOT NULL default '0', " + " PRIMARY KEY (`OldID`) ) ENGINE=InnoDB DEFAULT CHARSET=latin1";
        BasicSQLUtils.update(conn, sql);
        sql = "ALTER TABLE " + mapTableName + " ADD INDEX INX_" + mapTableName + " (NewID)";
        BasicSQLUtils.update(conn, sql);
    }

    public void process(String databaseName) {
        block18: {
            boolean doingMapTable = false;
            this.cal.set(13, 0);
            this.cal.set(12, 0);
            this.cal.set(10, 0);
            this.cal.set(14, 0);
            int i = 0;
            while (i < this.histo.length) {
                this.histo[i] = 0;
                ++i;
            }
            this.convLogger.initialize("mich_conabio", databaseName);
            StringBuilder extraStyle = new StringBuilder();
            extraStyle.append("TD.yw  { color: rgb(200,200,0); }\n");
            extraStyle.append("TD.gr  { color: rgb(200,0,200); }\n");
            extraStyle.append("TD.bgr { color: rgb(0,255,0); }\n");
            extraStyle.append("TD.byw { color: yellow; }\n");
            extraStyle.append("TD.df  { color: rgb(100,255,200); }\n");
            String mapTableName = "maptable";
            Statement stmt = null;
            try {
                try {
                    String sqlMain;
                    this.conn = DriverManager.getConnection("jdbc:mysql://localhost/" + databaseName + "?characterEncoding=UTF-8&autoReconnect=true", "root", "root");
                    BasicSQLUtils.setDBConnection(this.conn);
                    int matches = BasicSQLUtils.getCountAsInt("SELECT COUNT(*) FROM maptable");
                    this.mpStmt = this.conn.prepareStatement("INSERT INTO " + mapTableName + " VALUES (?,?)");
                    String sql = sqlMain = "SELECT E.IdEjemplar, E.NumeroDeCatalogo, NumeroDeColecta, Grupo.DescripcionGpo AS Colector, NombreLocalidad.NombreOriginal, CategoriaTaxonomica.NombreCategoriaTaxonomica, IF (CategoriaTaxonomica.IdNivel1<7,Nombre.Nombre, IF (CategoriaTaxonomica.IdNivel3 = 0, CONCAT(Nombre_1.Nombre,\" \", Nombre.Nombre),CONCAT(Nombre_2.Nombre, \" \",Nombre_1.Nombre,\" \", Nombre.Nombre))) AS Nombre, Nombre_2.Nombre AS N2, Nombre_1.Nombre AS N1, Nombre.Nombre AS N0, AnioColecta, MesColecta, DiaColecta FROM Grupo INNER JOIN (CategoriaTaxonomica INNER JOIN (NombreLocalidad INNER JOIN (((Nombre INNER JOIN Nombre AS Nombre_1 ON Nombre.IdAscendObligatorio = Nombre_1.IdNombre) INNER JOIN Nombre AS Nombre_2 ON Nombre_1.IdAscendObligatorio = Nombre_2.IdNombre) INNER JOIN Ejemplar E ON Nombre.IdNombre = E.IdNombre) ON NombreLocalidad.IdNombreLocalidad = E.IdNombreLocalidad) ON CategoriaTaxonomica.IdCategoriaTaxonomica = Nombre.IdCategoriaTaxonomica) ON Grupo.IdGrupo = E.IdColector ORDER BY E.NumeroDeCatalogo ";
                    TableWriter tblWriter = this.convLogger.getWriter("MichConabio1.html", "Matches Cat No. / Collector No. / Genus / Species", extraStyle.toString());
                    tblWriter.startTable();
                    tblWriter.log("<TR><TH COLSPAN=\"7\">Conabio</TH><TH COLSPAN=\"7\">Michigan</TH><TD>&nbsp;</TH></TR>");
                    tblWriter.logHdr("Col Num", "Cat Num", "Genus", "Species", "Collector", "Locality", "Date Collected", "Col Num", "Cat Num", "Genus", "Species", "Collector", "Locality", "Date Collected", "Score");
                    this.fndCnt = 0;
                    this.numRecs = 0;
                    System.out.println(sql);
                    stmt = this.conn.createStatement(1004, 1007);
                    ResultSet rs = stmt.executeQuery(sql);
                    while (rs.next()) {
                        this.process(0, rs, tblWriter, doingMapTable);
                    }
                    rs.close();
                    tblWriter.endTable();
                    tblWriter.log("<BR>");
                    tblWriter.log(String.format("Number of records that match: %d  of %d records.", this.fndCnt, this.numRecs));
                    tblWriter.log(String.format("Average Score: %5.2f", (double)this.totalScore / (double)this.fndCnt));
                    tblWriter.log(String.format("Mode Score: %d", this.getModeScore()));
                    this.totalScore = 0;
                    sql = "SELECT * FROM (" + sqlMain + ") T1 LEFT JOIN maptable ON IdEjemplar = OldID WHERE NewID IS NULL";
                    this.fndCnt = 0;
                    this.numRecs = 0;
                    tblWriter = this.convLogger.getWriter("MichConabio2.html", "Matches Cat No. / Collector No. ", extraStyle.toString());
                    tblWriter.startTable();
                    tblWriter.log("<TR><TH COLSPAN=\"7\">Conabio</TH><TH COLSPAN=\"7\">Michigan</TH><TD>&nbsp;</TH></TR>");
                    tblWriter.logHdr("Col Num", "Cat Num", "Genus", "Species", "Collector", "Locality", "Date Collected", "Col Num", "Cat Num", "Genus", "Species", "Collector", "Locality", "Date Collected", "Score");
                    rs = stmt.executeQuery(sql);
                    while (rs.next()) {
                        this.process(1, rs, tblWriter, doingMapTable);
                    }
                    rs.close();
                    tblWriter.endTable();
                    tblWriter.log("<BR>");
                    tblWriter.log(String.format("Number of records that match: %d  of %d records.", this.fndCnt, this.numRecs));
                    tblWriter.log(String.format("Average Score: %5.2f", (double)this.totalScore / (double)this.fndCnt));
                    tblWriter.log(String.format("Mode Score: %d", this.getModeScore()));
                    this.totalScore = 0;
                    this.fndCnt = 0;
                    this.numRecs = 0;
                    tblWriter = this.convLogger.getWriter("MichConabio3.html", "Matches Collector No. ", extraStyle.toString());
                    tblWriter.startTable();
                    tblWriter.log("<TR><TH COLSPAN=\"7\">Conabio</TH><TH COLSPAN=\"7\">Michigan</TH><TD>&nbsp;</TH></TR>");
                    tblWriter.logHdr("Col Num", "Cat Num", "Genus", "Species", "Collector", "Locality", "Date Collected", "Col Num", "Cat Num", "Genus", "Species", "Collector", "Locality", "Date Collected", "Score");
                    rs = stmt.executeQuery(sql);
                    while (rs.next()) {
                        this.process(2, rs, tblWriter, doingMapTable);
                    }
                    rs.close();
                    tblWriter.endTable();
                    tblWriter.log("<BR>");
                    tblWriter.log(String.format("Number of records that match: %d  of %d records.", this.fndCnt, this.numRecs));
                    tblWriter.log(String.format("Average Score: %5.2f", (double)this.totalScore / (double)this.fndCnt));
                    tblWriter.log(String.format("Mode Score: %d", this.getModeScore()));
                    this.totalScore = 0;
                    this.fndCnt = 0;
                    this.numRecs = 0;
                    tblWriter = this.convLogger.getWriter("MichConabio4.html", "Matches Cat No. ", extraStyle.toString());
                    tblWriter.startTable();
                    tblWriter.log("<TR><TH COLSPAN=\"7\">Conabio</TH><TH COLSPAN=\"7\">Michigan</TH><TD>&nbsp;</TH></TR>");
                    tblWriter.logHdr("Col Num", "Cat Num", "Genus", "Species", "Collector", "Locality", "Date Collected", "Col Num", "Cat Num", "Genus", "Species", "Collector", "Locality", "Date Collected", "Score");
                    rs = stmt.executeQuery(sql);
                    while (rs.next()) {
                        this.process(3, rs, tblWriter, doingMapTable);
                    }
                    rs.close();
                    tblWriter.endTable();
                    tblWriter.log("<BR>");
                    tblWriter.log(String.format("Number of records that match: %d  of %d records.", this.fndCnt, this.numRecs));
                    tblWriter.log(String.format("Average Score: %5.2f", (double)this.totalScore / (double)this.fndCnt));
                    tblWriter.log(String.format("Mode Score: %d", this.getModeScore()));
                    this.totalScore = 0;
                    tblWriter.flush();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        stmt.close();
                        this.mpStmt.close();
                        this.conn.close();
                    }
                    catch (Exception ex2) {
                        ex2.printStackTrace();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    stmt.close();
                    this.mpStmt.close();
                    this.conn.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                throw throwable;
            }
            try {
                stmt.close();
                this.mpStmt.close();
                this.conn.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        File indexFile = this.convLogger.closeAll();
        try {
            AttachmentUtils.openURI(indexFile.toURI());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getModeScore() {
        int max = 0;
        int mean = 0;
        int i = 0;
        while (i < this.histo.length) {
            if (this.histo[i] > max) {
                max = this.histo[i];
                mean = i;
            }
            this.histo[i] = 0;
            ++i;
        }
        return mean;
    }

    public void process(int type, ResultSet rs, TableWriter tblWriter, boolean doingMapTable) throws SQLException {
        Integer idEjemplar = rs.getInt(1);
        String catNum = rs.getString(2).trim();
        String collectorNum = rs.getString(3).trim();
        String collector = rs.getString(4);
        String genus = rs.getString(9);
        String species = rs.getString(10);
        String locality = rs.getString(5);
        int year = rs.getInt(11);
        int mon = rs.getInt(12);
        int day = rs.getInt(13);
        boolean hasDate = year > 0 && mon > 0 && day > 0;
        String dateStr = hasDate ? String.format("%04d-%02d-%02d", year, mon, day) : "&nbsp;";
        String where = null;
        switch (type) {
            case 0: {
                where = String.format("FROM conabio WHERE GenusName = '%s' AND SpeciesName = '%s' AND CollNr = '%s' AND BarCD = '%s'", genus, species, collectorNum, catNum);
                break;
            }
            case 1: {
                where = String.format("FROM conabio WHERE CollNr = '%s' AND BarCD = '%s'", collectorNum, catNum);
                break;
            }
            case 2: {
                where = String.format("FROM conabio WHERE CollNr = '%s' AND BarCD <> '%s'", collectorNum, catNum);
                break;
            }
            case 3: {
                where = String.format("FROM conabio WHERE CollNr <> '%s' AND BarCD = '%s'", collectorNum, catNum);
            }
        }
        String sql2 = "SELECT COUNT(*) " + where;
        int cnt = BasicSQLUtils.getCountAsInt(this.conn, sql2);
        if (cnt == 1) {
            int finalScore;
            Vector<Object[]> rows;
            Object[] cols;
            Date date;
            int i = 0;
            while (i < this.cCls.length) {
                this.cCls[i] = null;
                this.mCls[i] = null;
                ++i;
            }
            if (doingMapTable) {
                sql2 = "SELECT ID " + where;
                int id = BasicSQLUtils.getCountAsInt(this.conn, sql2);
                this.mpStmt.setInt(1, idEjemplar);
                this.mpStmt.setInt(2, id);
                this.mpStmt.executeUpdate();
            }
            boolean michHasDate = (date = (Date)(cols = (rows = BasicSQLUtils.query(this.conn, sql2 = "SELECT BarCD, CollNr, GenusName, SpeciesName, Collectoragent1, LocalityName, Datecollstandrd " + where)).get(0))[6]) != null;
            String michDate = michHasDate ? this.sdf.format(date) : "&nbsp;";
            Integer michCatNumInt = (Integer)cols[0];
            String michCatNum = michCatNumInt.toString();
            String michColNum = ((String)cols[1]).trim();
            String michGenus = ((String)cols[2]).trim();
            String michSpecies = (String)cols[3];
            String michCollector = (String)cols[4];
            String michLocality = (String)cols[5];
            int michYear = 0;
            int michMon = 0;
            int michDay = 0;
            if (date != null) {
                this.cal.setTime(date);
                michYear = michHasDate ? this.cal.get(1) : 0;
                michMon = michHasDate ? this.cal.get(2) + 1 : 0;
                michDay = michHasDate ? this.cal.get(5) : 0;
            }
            int maxScore = 115;
            int score = 0;
            if (hasDate && michHasDate) {
                score += year == michYear ? 10 : 0;
                score += mon == michMon ? 20 : 0;
                score += day == michDay ? 30 : 0;
                if (year == michYear && mon == michMon && day == michDay && year != 0 && mon != 0 && day != 0) {
                    this.cCls[6] = BGR;
                    this.mCls[6] = BGR;
                } else if (year == michYear && mon == michMon && year != 0 && mon != 0) {
                    this.cCls[6] = GR;
                    this.mCls[6] = GR;
                } else if (year == michYear) {
                    this.cCls[6] = YW;
                    this.mCls[6] = YW;
                }
            }
            double ratingLoc = this.check(locality, michLocality, false);
            double ratingColtr = this.check(collector, michCollector, false);
            if (ratingLoc > 50.0) {
                this.cCls[5] = BGR;
                this.mCls[5] = BGR;
                score += 10;
            } else if (ratingLoc > 30.0) {
                this.cCls[5] = GR;
                this.mCls[5] = GR;
                score += 6;
            } else if (ratingLoc > 0.0) {
                this.cCls[5] = YW;
                this.mCls[5] = YW;
                score += 3;
            }
            if (ratingColtr > 50.0) {
                this.cCls[4] = BGR;
                this.mCls[4] = BGR;
                score += 10;
            } else if (ratingColtr > 30.0) {
                this.cCls[4] = GR;
                this.mCls[4] = GR;
                score += 6;
            } else if (ratingColtr > 0.0) {
                this.cCls[4] = YW;
                this.mCls[4] = YW;
                score += 3;
            }
            boolean genusMatches = false;
            if (michGenus != null && genus != null) {
                if (michGenus.equals(genus)) {
                    score += 15;
                    this.cCls[2] = GR;
                    this.mCls[2] = GR;
                    genusMatches = true;
                } else if (StringUtils.getLevenshteinDistance((String)genus, (String)michGenus) < 3) {
                    score += 7;
                    this.cCls[2] = YW;
                    this.mCls[2] = YW;
                }
            }
            if (michSpecies != null && species != null) {
                if (michSpecies.equals(species)) {
                    score += 20;
                    if (genusMatches) {
                        this.cCls[2] = BGR;
                        this.mCls[2] = BGR;
                        this.cCls[3] = BGR;
                        this.mCls[3] = BGR;
                    } else {
                        this.cCls[3] = GR;
                        this.mCls[3] = GR;
                    }
                } else if (StringUtils.getLevenshteinDistance((String)species, (String)michSpecies) < 3) {
                    score += 10;
                    this.cCls[3] = YW;
                    this.mCls[3] = YW;
                }
            }
            if (michGenus != null && species != null && michGenus.equals(species)) {
                this.cCls[3] = DF;
                this.mCls[2] = DF;
                score += 10;
            }
            if (michSpecies != null && genus != null && michSpecies.equals(genus)) {
                this.cCls[2] = DF;
                this.mCls[3] = DF;
                score += 15;
            }
            if (catNum.equals(michCatNum)) {
                this.cCls[1] = BGR;
                this.mCls[1] = BGR;
            }
            if (collectorNum.equals(michColNum)) {
                this.cCls[0] = BGR;
                this.mCls[0] = BGR;
            }
            int n = finalScore = (int)((double)score / (double)maxScore * 100.0 + 0.5);
            this.histo[n] = this.histo[n] + 1;
            this.totalScore += finalScore;
            String scoreStr = String.format("%d", finalScore);
            tblWriter.println("<TR>");
            tblWriter.logTDCls(this.cCls[0], collectorNum);
            tblWriter.logTDCls(this.cCls[1], catNum);
            tblWriter.logTDCls(this.cCls[2], genus);
            tblWriter.logTDCls(this.cCls[3], species);
            tblWriter.logTDCls(this.cCls[4], collector);
            tblWriter.logTDCls(this.cCls[5], locality);
            tblWriter.logTDCls(this.cCls[6], dateStr);
            tblWriter.logTDCls(this.cCls[0], michColNum);
            tblWriter.logTDCls(this.cCls[1], michCatNum != null ? michCatNum.toString() : "&nbsp;");
            tblWriter.logTDCls(this.mCls[2], michGenus);
            tblWriter.logTDCls(this.mCls[3], michSpecies);
            tblWriter.logTDCls(this.mCls[4], michCollector);
            tblWriter.logTDCls(this.mCls[5], michLocality);
            tblWriter.logTDCls(this.mCls[6], michDate);
            tblWriter.logTDCls(null, scoreStr);
            tblWriter.println("</TR>");
            ++this.fndCnt;
            System.out.println("Fnd: " + this.fndCnt + "  Num Recs: " + this.numRecs + "  Dif: " + (this.numRecs - this.fndCnt));
        }
        ++this.numRecs;
    }

    private String clean(String str, boolean usePeriods) {
        String s = StringUtils.remove((String)str, (char)':');
        if (!usePeriods) {
            s = StringUtils.remove((String)s, (char)'.');
        }
        s = StringUtils.remove((String)s, (char)'-');
        s = StringUtils.remove((String)s, (char)',');
        return s;
    }

    private double check(String str1, String str2, boolean usePeriods) {
        String[] shortToks;
        String shortStr;
        String longStr;
        if (str1 == null || str2 == null) {
            return 0.0;
        }
        if (str1.length() > str2.length()) {
            longStr = str1;
            shortStr = str2;
        } else {
            longStr = str2;
            shortStr = str1;
        }
        longStr = this.clean(longStr, usePeriods);
        shortStr = this.clean(shortStr, usePeriods);
        int score = 0;
        String[] longToks = StringUtils.split((String)longStr, (String)" ");
        String[] stringArray = shortToks = StringUtils.split((String)shortStr, (String)" ");
        int n = shortToks.length;
        int n2 = 0;
        while (n2 < n) {
            String sStr = stringArray[n2];
            String[] stringArray2 = longToks;
            int n3 = longToks.length;
            int n4 = 0;
            while (n4 < n3) {
                String lStr = stringArray2[n4];
                if (lStr.equals(sStr) || sStr.length() > 2 && StringUtils.getLevenshteinDistance((String)lStr, (String)sStr) < 3) {
                    ++score;
                }
                ++n4;
            }
            ++n2;
        }
        double rating = (double)score / (double)shortToks.length * 100.0;
        return rating;
    }

    public void convert(String databaseName, String tableName, String srcFileName, String xmlFileName) {
        String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        HashMap<String, Integer> monthHash = new HashMap<String, Integer>();
        String[] stringArray = months;
        int n = months.length;
        int n2 = 0;
        while (n2 < n) {
            String mn = stringArray[n2];
            monthHash.put(mn, monthHash.size() + 1);
            ++n2;
        }
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = DriverManager.getConnection("jdbc:mysql://localhost/" + databaseName + "?characterEncoding=UTF-8&autoReconnect=true", "root", "root");
                stmt = conn.createStatement();
                FMPCreateTable fmpInfo = new FMPCreateTable(tableName, null, true);
                fmpInfo.process(xmlFileName);
                boolean doCreateTable = true;
                if (doCreateTable) {
                    this.processFieldSizes(fmpInfo, srcFileName);
                    PrintWriter pw = new PrintWriter(new File("fields.txt"));
                    int i = 0;
                    for (FieldDef fd : fmpInfo.getFields()) {
                        pw.println(String.valueOf(i) + " " + fd.getName() + "\t" + (Object)((Object)fd.getType()) + "\t" + fd.isDouble());
                        ++i;
                    }
                    pw.close();
                    BasicSQLUtils.update(conn, fmpInfo.dropTableStr());
                    String sqlCreateTable = fmpInfo.createTableStr();
                    BasicSQLUtils.update(conn, sqlCreateTable);
                    System.out.println(sqlCreateTable);
                }
                String prepSQL = fmpInfo.getPrepareStmtStr(true, true);
                System.out.println(prepSQL);
                this.pStmt = conn.prepareStatement(prepSQL);
                Vector<FieldDef> fieldDefs = fmpInfo.getFields();
                int rowCnt = 0;
                BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(srcFileName)));
                String str = in.readLine();
                str = in.readLine();
                while (str != null) {
                    String line = str;
                    char sep = '`';
                    String sepStr = "";
                    char[] cArray = this.seps;
                    int n3 = this.seps.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        char c = cArray[n4];
                        if (line.indexOf(c) == -1) {
                            sepStr = String.valueOf(sepStr) + c;
                            sep = c;
                            break;
                        }
                        ++n4;
                    }
                    str = StringUtils.replace((String)str.substring(1, str.length() - 1), (String)"\",\"", (String)sepStr);
                    Vector<String> fields = this.split(str, sep);
                    SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
                    int col = 1;
                    int inx = 0;
                    for (String fld : fields) {
                        String value = fld.trim();
                        FieldDef fd = fieldDefs.get(inx);
                        switch (fd.getType()) {
                            case eText: 
                            case eMemo: {
                                if (value.length() > 0) {
                                    if (value.length() <= fd.getMaxSize()) {
                                        this.pStmt.setString(col, value);
                                        break;
                                    }
                                    System.err.println(String.format("The data for `%s` max(%d) is too big %d", fd.getName(), fd.getMaxSize(), value.length()));
                                    this.pStmt.setString(col, null);
                                    break;
                                }
                                this.pStmt.setString(col, null);
                                break;
                            }
                            case eNumber: {
                                String origValue;
                                if (StringUtils.isNotEmpty((String)value)) {
                                    origValue = value;
                                    String val = value.charAt(0) == '\ufffd' ? value.substring(1) : value;
                                    val = val.charAt(0) == '-' ? val.substring(1) : val;
                                    val = val.indexOf(46) > -1 ? StringUtils.replace((String)val, (String)".", (String)"") : val;
                                    String string = val = val.indexOf(65533) > -1 ? StringUtils.replace((String)val, (String)"\ufffd", (String)"") : val;
                                    if (StringUtils.isNumericSpace((String)val)) {
                                        if (fd.isDouble()) {
                                            this.pStmt.setDouble(col, Double.parseDouble(val));
                                            break;
                                        }
                                        this.pStmt.setInt(col, Integer.parseInt(val));
                                        break;
                                    }
                                    if (val.startsWith("ca. ")) {
                                        this.pStmt.setInt(col, Integer.parseInt(val.substring(4)));
                                        break;
                                    }
                                    if (val.startsWith("ca ")) {
                                        this.pStmt.setInt(col, Integer.parseInt(val.substring(3)));
                                        break;
                                    }
                                    System.err.println(String.valueOf(col) + " Bad Number val[" + val + "] origValue[" + origValue + "] " + fieldDefs.get(col - 1).getName());
                                    this.pStmt.setObject(col, null);
                                    break;
                                }
                                this.pStmt.setDate(col, null);
                                break;
                            }
                            case eTime: {
                                Time time = null;
                                try {
                                    time = Time.valueOf(value);
                                }
                                catch (Exception val) {
                                    // empty catch block
                                }
                                this.pStmt.setTime(col, time);
                                break;
                            }
                            case eDate: {
                                String origValue = value;
                                try {
                                    if (StringUtils.isNotEmpty((String)value) && !value.equals("?") && !value.equals("-")) {
                                        String year;
                                        int len = value.length();
                                        if (len == 8 && value.charAt(1) == '-' && value.charAt(3) == '-') {
                                            String dayStr = value.substring(0, 1);
                                            String monStr = value.substring(2, 3);
                                            if (StringUtils.isNumeric((String)dayStr) && StringUtils.isNumeric((String)monStr)) {
                                                year = value.substring(4);
                                                int day = Integer.parseInt(dayStr);
                                                int mon = Integer.parseInt(monStr);
                                                if (day == 0) {
                                                    day = 1;
                                                }
                                                if (mon == 0) {
                                                    mon = 1;
                                                }
                                                value = String.format("%02d-%02d-%s", day, mon, year);
                                            } else {
                                                String[] toks = StringUtils.split((String)(value = StringUtils.replaceChars((String)value, (char)'.', (char)' ')), (char)' ');
                                                if (toks.length == 3) {
                                                    String dyStr = toks[0];
                                                    String mnStr = toks[1];
                                                    String yrStr = toks[2];
                                                    if (StringUtils.isNumeric((String)mnStr) && StringUtils.isNumeric((String)dyStr) && StringUtils.isNumeric((String)yrStr)) {
                                                        int day = Integer.parseInt(dyStr);
                                                        int mon = Integer.parseInt(mnStr);
                                                        int year2 = Integer.parseInt(yrStr);
                                                        if (day == 0) {
                                                            day = 1;
                                                        }
                                                        if (mon == 0) {
                                                            mon = 1;
                                                        }
                                                        value = String.format("%02d-%02d-%04d", day, mon, year2);
                                                    } else {
                                                        System.err.println(String.valueOf(col) + " Bad Date#[" + value + "]  [" + origValue + "]\n");
                                                    }
                                                } else {
                                                    System.err.println(String.valueOf(col) + " Bad Date#[" + value + "]  [" + origValue + "]\n");
                                                }
                                            }
                                        } else if (len == 8 && (value.charAt(3) == '-' || value.charAt(3) == ' ')) {
                                            String monStr = value.substring(0, 3);
                                            Integer month = (Integer)monthHash.get(monStr);
                                            year = value.substring(4);
                                            if (month != null && StringUtils.isNumeric((String)year)) {
                                                value = String.format("01-%02d-%s", month, year);
                                            } else {
                                                String[] toks = StringUtils.split((String)(value = StringUtils.replaceChars((String)value, (char)'.', (char)' ')), (char)' ');
                                                if (toks.length == 3) {
                                                    String dyStr = toks[0];
                                                    String mnStr = toks[1];
                                                    String yrStr = toks[2];
                                                    if (StringUtils.isNumeric((String)mnStr) && StringUtils.isNumeric((String)dyStr) && StringUtils.isNumeric((String)yrStr)) {
                                                        int day = Integer.parseInt(dyStr);
                                                        int mon = Integer.parseInt(mnStr);
                                                        int yr = Integer.parseInt(yrStr);
                                                        if (day == 0) {
                                                            day = 1;
                                                        }
                                                        if (mon == 0) {
                                                            mon = 1;
                                                        }
                                                        value = String.format("%02d-%02d-%04d", day, mon, yr);
                                                    } else {
                                                        System.err.println(String.valueOf(col) + " Bad Date#[" + value + "]  [" + origValue + "]\n");
                                                    }
                                                } else {
                                                    System.err.println(String.valueOf(col) + " Bad Date#[" + value + "]  [" + origValue + "]\n");
                                                }
                                            }
                                        } else if (len == 11 && value.charAt(2) == '-' && value.charAt(6) == '-' || len == 10 && value.charAt(1) == '-' && value.charAt(5) == '-') {
                                            boolean do11 = len == 11;
                                            String dayStr = value.substring(0, do11 ? 2 : 1);
                                            String monStr = value.substring(do11 ? 3 : 2, do11 ? 6 : 5);
                                            Integer month = (Integer)monthHash.get(monStr);
                                            String year3 = value.substring(do11 ? 7 : 6);
                                            if (month != null && StringUtils.isNumeric((String)dayStr) && StringUtils.isNumeric((String)year3)) {
                                                int day = Integer.parseInt(dayStr);
                                                if (day == 0) {
                                                    day = 1;
                                                }
                                                value = String.format("%02d-%02d-%s", day, month, year3);
                                            } else {
                                                System.err.println(String.valueOf(col) + " Bad Date^[" + value + "]  [" + origValue + "]\n");
                                            }
                                        } else if (len == 4) {
                                            if (StringUtils.isNumeric((String)value)) {
                                                value = "01-01-" + value;
                                            } else if (value.equalsIgnoreCase("s.d.") || value.equalsIgnoreCase("n.d.") || value.equalsIgnoreCase("s.n.")) {
                                                value = null;
                                            }
                                        } else if (StringUtils.contains((String)value, (String)"/")) {
                                            value = StringUtils.replace((String)value, (String)"/", (String)"-");
                                        } else if (StringUtils.contains((String)value, (String)" ")) {
                                            value = StringUtils.replace((String)value, (String)" ", (String)"-");
                                        }
                                        this.pStmt.setDate(col, StringUtils.isNotEmpty((String)value) ? new Date(sdf.parse(value).getTime()) : null);
                                        break;
                                    }
                                    this.pStmt.setDate(col, null);
                                }
                                catch (Exception ex) {
                                    System.err.println(String.valueOf(col) + " Bad Date[" + value + "]  [" + origValue + "]\n" + str);
                                    this.pStmt.setDate(col, null);
                                }
                                break;
                            }
                            default: {
                                System.err.println("Col: " + col + "  Error - " + (Object)((Object)fd.getType()));
                            }
                        }
                        ++inx;
                        ++col;
                    }
                    this.pStmt.execute();
                    str = in.readLine();
                    if (++rowCnt % 1000 != 0) continue;
                    System.out.println(rowCnt);
                }
                in.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    stmt.close();
                    conn.close();
                    this.pStmt.close();
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        finally {
            try {
                stmt.close();
                conn.close();
                this.pStmt.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        String path = "/Users/rods/databases/SGR_CONABIO_data_files/";
        MexConvToSQL m = new MexConvToSQL();
        m.convert("michigan_data", "fmpdata", String.valueOf(path) + "MichData.mer", String.valueOf(path) + "MichiganData.xml");
    }
}

