/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode.mexconabio;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.toycode.mexconabio.AnalysisBase;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MakeGBIFProcessHash
extends AnalysisBase {
    private static final Logger log = Logger.getLogger(MakeGBIFProcessHash.class);
    private final int MAX_RECORDS_SEG = 300000;
    protected PrintWriter pw = null;
    protected Statement stmt = null;
    protected PreparedStatement insertStmt = null;
    protected PreparedStatement updateStmt = null;
    protected PreparedStatement checkStmt = null;
    protected PreparedStatement insertIds = null;
    protected long totalRecs;
    protected int writeCnt = 0;
    protected int updateCnt = 0;
    protected Stack<DataEntry> recycleStack = new Stack();
    protected HashMap<String, DataEntry> groupHash = new HashMap();

    private void writeIds(int grpId, ArrayList<Integer> rawIds) {
        for (Integer rawId : rawIds) {
            try {
                this.insertIds.setInt(1, grpId);
                this.insertIds.setInt(2, rawId);
                this.insertIds.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void writeHash() throws SQLException {
        System.out.println("Writing Hash...");
        this.pw.println("Writing Hash...");
        long sTm = System.currentTimeMillis();
        int err = 0;
        int cnt = 0;
        for (DataEntry de : this.groupHash.values()) {
            this.checkStmt.setString(1, de.collnum);
            this.checkStmt.setString(2, de.genus);
            this.checkStmt.setString(3, de.year);
            ResultSet rs = this.checkStmt.executeQuery();
            if (rs.next()) {
                int id = rs.getInt(1);
                try {
                    this.updateStmt.setInt(1, de.cnt);
                    this.updateStmt.setInt(2, id);
                    this.updateStmt.executeUpdate();
                    ++this.updateCnt;
                    this.writeIds(id, de.ids);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    ++err;
                }
            } else {
                this.insertStmt.setString(1, de.collnum);
                this.insertStmt.setString(2, de.genus);
                this.insertStmt.setString(3, de.year);
                this.insertStmt.setString(4, de.mon);
                this.insertStmt.setInt(5, de.cnt);
                try {
                    this.insertStmt.executeUpdate();
                    ++this.writeCnt;
                    this.writeIds(BasicSQLUtils.getInsertedId(this.insertStmt), de.ids);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    ++err;
                }
            }
            rs.close();
            if (++cnt % 10000 != 0) continue;
            System.out.println(cnt);
            this.pw.println(cnt);
        }
        this.recycle(this.groupHash.values());
        this.groupHash.clear();
        long elapsed = (System.currentTimeMillis() - sTm) / 1000L;
        String msg = String.format("Done Writing Dups: %d  Cnt: %d Elapsed: %d", err, cnt, elapsed);
        System.out.println(msg);
        this.pw.println(msg);
    }

    @Override
    public void process(int type, int options) {
        double HRS = 3600000.0;
        long PAGE_CNT = 1000000L;
        this.totalRecs = BasicSQLUtils.getCount(this.dbGBIFConn, "SELECT COUNT(*) FROM raw").intValue();
        int minIndex = BasicSQLUtils.getCount(this.dbGBIFConn, "SELECT MIN(id) FROM raw");
        int segs = (int)(this.totalRecs / 1000000L) + 1;
        try {
            this.pw = new PrintWriter("GroupHash.log");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        long procRecs = 0L;
        long startTime = System.currentTimeMillis();
        int secsThreshold = 0;
        try {
            String idsInsert = "INSERT INTO group_hash_ids (GrpID, RawID) VALUES (?,?)";
            this.insertIds = this.dbDstConn.prepareStatement(idsInsert);
            String gbifsnibInsert = "INSERT INTO group_hash (collnum, genus, year, mon, cnt) VALUES (?,?,?,?,?)";
            this.insertStmt = this.dbDstConn.prepareStatement(gbifsnibInsert);
            String gbifsnibUpdate = "UPDATE group_hash SET cnt=? WHERE id = ?";
            this.updateStmt = this.dbDstConn.prepareStatement(gbifsnibUpdate);
            String gbifsnibCheck = "SELECT id FROM group_hash WHERE collnum=? AND genus=? AND year=?";
            this.checkStmt = this.dbDstConn.prepareStatement(gbifsnibCheck);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        int pc = 0;
        while (pc < segs) {
            block36: {
                try {
                    try {
                        String clause = String.format(" FROM raw WHERE id > %d AND id < %d", (long)pc * 1000000L + (long)minIndex, (long)(pc + 1) * 1000000L + (long)minIndex + 1L);
                        String gbifSQL = "SELECT  id, collector_num, genus, year, month " + clause;
                        System.out.println(gbifSQL);
                        this.pw.println(gbifSQL);
                        this.stmt = this.dbGBIFConn.createStatement(1000, 1007);
                        this.stmt.setFetchSize(Integer.MIN_VALUE);
                        String msg = "Starting Query... " + this.totalRecs;
                        System.out.println(msg);
                        this.pw.println(msg);
                        ResultSet rs = this.stmt.executeQuery(gbifSQL);
                        msg = String.format("Starting Processing... Total Records %d  Max Score: %d  Threshold: %d", this.totalRecs, this.maxScore, this.thresholdScore);
                        System.out.println(msg);
                        this.pw.println(msg);
                        while (rs.next()) {
                            String name;
                            DataEntry de;
                            ++procRecs;
                            String year = rs.getString(4);
                            String string = year = StringUtils.isNotEmpty((String)year) ? year.trim() : null;
                            if (StringUtils.isNotEmpty((String)year) && !StringUtils.isNumeric((String)year)) continue;
                            int rawId = rs.getInt(1);
                            String collnum = rs.getString(2);
                            String genus = rs.getString(3);
                            String mon = rs.getString(5);
                            collnum = StringUtils.isNotEmpty((String)collnum) ? collnum.trim() : null;
                            genus = StringUtils.isNotEmpty((String)genus) ? genus.trim() : null;
                            mon = StringUtils.isNotEmpty((String)mon) ? mon.trim() : null;
                            int c = 0;
                            if (collnum == null) {
                                ++c;
                            }
                            if (genus == null) {
                                ++c;
                            }
                            if (year == null) {
                                ++c;
                            }
                            if (c == 2) continue;
                            collnum = collnum != null ? collnum : "";
                            genus = genus != null ? genus : "";
                            year = year != null ? year : "";
                            String string2 = mon = mon != null ? mon : "";
                            if (collnum.length() > 64) {
                                collnum = collnum.substring(0, 63);
                            }
                            if (genus.length() > 64) {
                                genus = genus.substring(0, 63);
                            }
                            if (year.length() > 8) {
                                year = year.substring(0, 8);
                            }
                            if (mon.length() > 8) {
                                mon = year.substring(0, 8);
                            }
                            if ((de = this.groupHash.get(name = String.format("%s_%s_%s", collnum, genus, year))) != null) {
                                ++de.cnt;
                            } else {
                                de = this.getDataEntry(collnum, genus, year, mon);
                                this.groupHash.put(name, de);
                            }
                            de.ids.add(rawId);
                            if (this.groupHash.size() <= 300000) continue;
                            this.writeHash();
                        }
                        rs.close();
                        if (this.groupHash.size() > 0) {
                            this.writeHash();
                        }
                        System.out.println("Done with seg " + pc);
                        this.pw.println("Done with seg " + pc);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        try {
                            if (this.stmt != null) {
                                this.stmt.close();
                            }
                            break block36;
                        }
                        catch (Exception exception) {}
                        break block36;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (this.stmt != null) {
                            this.stmt.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (this.stmt != null) {
                        this.stmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            double timePerRecord = elapsedTime / procRecs;
            double hrsLeft = (double)(this.totalRecs - procRecs) * timePerRecord / 3600000.0;
            int seconds = (int)((double)elapsedTime / 60000.0);
            if (secsThreshold != seconds) {
                secsThreshold = seconds;
                String msg = String.format("Elapsed %8.2f hr.mn   Percent: %6.3f  Hours Left: %8.2f ", (double)elapsedTime / 3600000.0, 100.0 * ((double)procRecs / (double)this.totalRecs), hrsLeft);
                System.out.println(msg);
                this.pw.println(msg);
                this.pw.flush();
            }
            ++pc;
        }
        try {
            if (this.insertStmt != null) {
                this.insertStmt.close();
            }
            if (this.updateStmt != null) {
                this.updateStmt.close();
            }
            if (this.checkStmt != null) {
                this.checkStmt.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        String msg = String.format("Done - Writes: %d  Updates: %d", this.writeCnt, this.updateCnt);
        System.out.println(msg);
        this.pw.println(msg);
        this.pw.flush();
        this.pw.close();
    }

    private DataEntry getDataEntry(String collnumArg, String genusArg, String yearArg, String monArg) {
        if (this.recycleStack.size() > 0) {
            DataEntry de = this.recycleStack.pop();
            de.collnum = collnumArg;
            de.genus = genusArg;
            de.year = yearArg;
            de.mon = monArg;
            de.cnt = 1;
            de.clear();
            return de;
        }
        return new DataEntry(collnumArg, genusArg, yearArg, monArg);
    }

    protected void recycle(Collection<DataEntry> dec) {
        this.recycleStack.addAll(dec);
    }

    public static void main(String[] args) {
        MakeGBIFProcessHash awg = new MakeGBIFProcessHash();
        awg.createDBConnection("localhost", "3306", "plants", "root", "root");
        awg.createDestDBConnection("localhost", "3306", "plants", "root", "root");
        awg.process(0, 0);
        awg.cleanup();
    }

    class DataEntry {
        String collnum;
        String genus;
        String year;
        String mon;
        int cnt;
        ArrayList<Integer> ids = new ArrayList();

        public DataEntry(String collnum, String genus, String year, String mon) {
            this.collnum = collnum;
            this.genus = genus;
            this.year = year;
            this.mon = mon;
            this.cnt = 1;
        }

        public void addId(int id) {
            this.ids.add(id);
        }

        public void clear() {
            this.ids.clear();
        }
    }
}

