/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode.mexconabio;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import com.jgoodies.looks.plastic.theme.SkyKrupp;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBInfoBase;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.Specify;
import edu.ku.brc.specify.config.SpecifyDataObjFieldFormatMgr;
import edu.ku.brc.specify.config.SpecifyWebLinkMgr;
import edu.ku.brc.specify.dbsupport.cleanuptools.DataObjTableModel;
import edu.ku.brc.specify.dbsupport.cleanuptools.DataObjTableModelRowInfo;
import edu.ku.brc.specify.tools.schemalocale.SchemaLocalizerFrame;
import edu.ku.brc.specify.ui.SpecifyUIFieldFormatterMgr;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class GBIFFullTextSearchFrame
extends CustomDialog {
    private Connection dbConn = null;
    private JTextField searchField;
    private JTable table;
    private DataObjTableModel model;
    private JLabel status;
    protected File INDEX_DIR = new File("index-gbif2");
    protected IndexReader reader;
    protected Searcher searcher;
    protected Analyzer analyzer = new StandardAnalyzer(Version.LUCENE_30);

    public GBIFFullTextSearchFrame() throws HeadlessException {
        super((Frame)null, "GBIF Search", true, 2, (Component)null);
        try {
            this.reader = IndexReader.open((Directory)FSDirectory.open((File)this.INDEX_DIR), (boolean)true);
            this.searcher = new IndexSearcher(this.reader);
        }
        catch (CorruptIndexException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createDBConnection(String server, String port, String dbName, String username, String pwd) {
        String connStr = "jdbc:mysql://%s:%s/%s?characterEncoding=UTF-8&autoReconnect=true";
        try {
            this.dbConn = DriverManager.getConnection(String.format(connStr, server, port, dbName), username, pwd);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void createUI() {
        super.createUI();
        PanelBuilder builder = new PanelBuilder(new FormLayout("p,10px,f:p:g,2px,p", "p,10px,f:p:g,4px,p"));
        CellConstraints cc = new CellConstraints();
        this.searchField = new JTextField();
        builder.add((Component)UIHelper.createFormLabel("Search"), cc.xy(1, 1));
        builder.add((Component)this.searchField, cc.xy(3, 1));
        JButton searchBtn = UIHelper.createButton("Search");
        builder.add((Component)searchBtn, cc.xy(5, 1));
        this.table = new JTable();
        builder.add((Component)UIHelper.createScrollPane(this.table, true), cc.xyw(1, 3, 5));
        this.status = UIHelper.createLabel("");
        builder.add((Component)this.status, cc.xyw(1, 5, 5));
        builder.setDefaultDialogBorder();
        this.contentPanel = builder.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.pack();
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                if (e.getKeyCode() == 10) {
                    GBIFFullTextSearchFrame.this.doSearch(GBIFFullTextSearchFrame.this.searchField.getText());
                }
            }
        });
        this.searchField.setText("10029 AND Ipomoea");
        searchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GBIFFullTextSearchFrame.this.doSearch(GBIFFullTextSearchFrame.this.searchField.getText());
            }
        });
    }

    private void doSearch(String serachStr) {
        long startTime = System.currentTimeMillis();
        try {
            Query q = new QueryParser(Version.LUCENE_30, "contents", this.analyzer).parse(serachStr);
            int hitsPerPage = 1000;
            TopScoreDocCollector collector = TopScoreDocCollector.create((int)hitsPerPage, (boolean)true);
            this.searcher.search(q, (Collector)collector);
            ScoreDoc[] hits = collector.topDocs().scoreDocs;
            if (hits.length > 0) {
                ArrayList<String> ids = new ArrayList<String>(hits.length);
                System.out.println("Found " + hits.length + " hits.");
                int i = 0;
                while (i < hits.length) {
                    int docId = hits[i].doc;
                    Document d = this.searcher.doc(docId);
                    System.out.println(String.valueOf(i + 1) + ". " + d.get("id"));
                    String id = d.get("id");
                    ids.add(id);
                    ++i;
                }
                this.createAndFillModels(ids);
            } else {
                TableModel mdl = this.table.getModel();
                if (mdl instanceof DataObjTableModel) {
                    ((DataObjTableModel)mdl).clear();
                }
            }
            System.out.println(String.format("Time: %8.2f", (double)(System.currentTimeMillis() - startTime) / 1000.0));
            String msg = String.format("Found %d items in %8.2f", hits.length, (double)(System.currentTimeMillis() - startTime) / 1000.0);
            this.status.setText(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void createAndFillModels(List<String> ids) {
        StringBuilder sb = new StringBuilder();
        for (String id : ids) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(id);
        }
        final String inClause = sb.toString();
        final String[] colNames = new String[]{"Id", "Collector Number", "Institution Code", "Collection Code", "Catalog Number", "Scientific Name", "Author", "Genus", "Species", "Subspecies", "Latitude", "Longitude", "Lat Long Prec", "Max altitude", "Min altitude", "Alt Precision", "Min Depth", "Max Depth", "Depth Precision", "Continent Ocean", "Country", "State", "County", "Collector Name", "Locality", "Year", "Month", "Day"};
        final Class[] dataClasses = new Class[]{Integer.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
        this.model = new DataObjTableModel(this.dbConn, 100, null, false){

            @Override
            protected String buildSQL() {
                String gSQL = String.format("SELECT id, collector_num, institution_code, collection_code, catalogue_number, scientific_name, author, genus, species, subspecies, latitude, longitude,  lat_long_precision, max_altitude, min_altitude, altitude_precision, min_depth, max_depth, depth_precision, continent_ocean, country, state_province, county, collector_name, locality, year, month, day FROM raw WHERE id in (%s)", inClause);
                this.tableInfo = new DBTableInfo(100, this.getClass().getName(), "raw", "id", "r");
                int i = 0;
                while (i < colNames.length) {
                    DBFieldInfo fi = new DBFieldInfo(this.tableInfo, colNames[i], dataClasses[i]);
                    fi.setTitle(colNames[i]);
                    this.colDefItems.add(fi);
                    ++i;
                }
                this.numColumns = colNames.length;
                return gSQL;
            }

            @Override
            protected void addAdditionalRows(ArrayList<DBInfoBase> colDefItemsArg, ArrayList<DataObjTableModelRowInfo> rowInfoListArg) {
            }
        };
        this.table.setModel(this.model);
        DefaultTableCellRenderer tcr = this.getTableCellRenderer(this.model.getRowInfoList());
        int i = 0;
        while (i < this.model.getColumnCount()) {
            if (this.model.getColumnClass(i) != Boolean.class) {
                this.table.setDefaultRenderer(this.model.getColumnClass(i), tcr);
            }
            ++i;
        }
    }

    protected DefaultTableCellRenderer getTableCellRenderer(final List<DataObjTableModelRowInfo> rowInfoList) {
        final Color sameColor = new Color(0, 128, 0);
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable tableArg, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                DataObjTableModelRowInfo rowInfo = (DataObjTableModelRowInfo)rowInfoList.get(row);
                boolean doCenter = false;
                Object val = value;
                if (value instanceof Pair) {
                    Pair pair = (Pair)value;
                    val = pair.first;
                    doCenter = true;
                }
                JLabel lbl = (JLabel)super.getTableCellRendererComponent(tableArg, val, isSelected, hasFocus, row, column);
                if (rowInfo.isMainRecord()) {
                    lbl.setForeground(Color.WHITE);
                    lbl.setBackground(Color.BLUE.brighter().brighter());
                } else {
                    lbl.setForeground(GBIFFullTextSearchFrame.this.model.isSame(column) ? sameColor : Color.BLACK);
                    lbl.setBackground(Color.WHITE);
                }
                lbl.setHorizontalTextPosition(doCenter ? 0 : 2);
                return lbl;
            }
        };
    }

    public void cleanup() {
        try {
            if (this.dbConn != null) {
                this.dbConn.close();
            }
            if (this.searcher != null) {
                this.searcher.close();
            }
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.analyzer != null) {
                this.analyzer.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIRegistry.setAppName("Specify");
                IconManager.setApplicationClass(Specify.class);
                IconManager.loadIcons(XMLHelper.getConfigDir("icons_datamodel.xml"));
                IconManager.loadIcons(XMLHelper.getConfigDir("icons_plugins.xml"));
                IconManager.loadIcons(XMLHelper.getConfigDir("icons_disciplines.xml"));
                try {
                    UIHelper.OSTYPE osType = UIHelper.getOSType();
                    if (osType == UIHelper.OSTYPE.Windows) {
                        UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                        PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new ExperienceBlue());
                    } else if (osType == UIHelper.OSTYPE.Linux) {
                        PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new SkyKrupp());
                        UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                    }
                }
                catch (Exception e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(SchemaLocalizerFrame.class, e);
                    e.printStackTrace();
                }
                System.setProperty("edu.ku.brc.af.core.AppContextMgrFactory", "edu.ku.brc.specify.config.SpecifyAppContextMgr");
                System.setProperty("edu.ku.brc.af.core.SchemaI18NService", "edu.ku.brc.specify.config.SpecifySchemaI18NService");
                System.setProperty("edu.ku.brc.ui.forms.formatters.UIFieldFormatterMgr", "edu.ku.brc.specify.ui.SpecifyUIFieldFormatterMgr");
                System.setProperty("edu.ku.brc.ui.weblink.WebLinkMgr", "edu.ku.brc.specify.config.SpecifyWebLinkMgr");
                System.setProperty("edu.ku.brc.ui.forms.formatters.DataObjFieldFormatMgr", "edu.ku.brc.specify.config.SpecifyDataObjFieldFormatMgr");
                SpecifyDataObjFieldFormatMgr.setDoingLocal(true);
                SpecifyUIFieldFormatterMgr.setDoingLocal(true);
                SpecifyWebLinkMgr.setDoingLocal(true);
                GBIFFullTextSearchFrame dlg = new GBIFFullTextSearchFrame();
                dlg.createDBConnection("localhost", "3306", "gbif", "root", "root");
                dlg.setCancelLabel("Close");
                dlg.setSize(900, 700);
                UIHelper.centerAndShow(dlg);
                dlg.cleanup();
                System.exit(0);
            }
        });
    }
}

