/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode.mexconabio;

import edu.ku.brc.specify.dbsupport.cleanuptools.BaseFindCleanupItems;
import edu.ku.brc.specify.dbsupport.cleanuptools.FindItemInfo;
import edu.ku.brc.specify.toycode.mexconabio.AnalysisWithGBIF;
import edu.ku.brc.specify.toycode.mexconabio.GBIFCleanupResults;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;

public class GBIFFindCleanupItems
extends BaseFindCleanupItems {
    protected AnalysisWithGBIF awg;

    public GBIFFindCleanupItems(AnalysisWithGBIF awg) throws HeadlessException {
        super("GBIF", "Catalog Number");
        this.awg = awg;
    }

    @Override
    protected void doCleanupOfItem() {
        FindItemInfo itemInfo = (FindItemInfo)this.itemsList.getSelectedValue();
        if (itemInfo != null) {
            GBIFCleanupResults gbifResults = new GBIFCleanupResults("Comparative Results", itemInfo, this.awg);
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            gbifResults.createUI();
            gbifResults.setBounds(0, 0, dim.width, dim.height);
            gbifResults.setVisible(true);
        }
    }

    @Override
    protected DefaultListCellRenderer getListCellRenderer() {
        return null;
    }

    @Override
    protected Vector<FindItemInfo> doWork() {
        Connection dstDBConn = this.awg.getDstDBConn();
        Vector<FindItemInfo> items = new Vector<FindItemInfo>();
        Statement stmt = null;
        try {
            try {
                stmt = dstDBConn.createStatement(1004, 1007);
                String sql = "SELECT c.id, c.BarCd, T1.CNT FROM (SELECT SNIBID, COUNT(SNIBID) CNT FROM gbifsnib WHERE score > 50 GROUP BY SNIBID) T1 INNER JOIN conabio c on c.id = SNIBID WHERE CNT > 1";
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    int id = rs.getInt(1);
                    String catNum = rs.getString(2);
                    int cnt = rs.getInt(3);
                    String titleStr = String.format("%s - %d", catNum, cnt);
                    items.add(new FindItemInfo(id, catNum, titleStr));
                }
                rs.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
        return items;
    }
}

