/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode.mexconabio;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBInfoBase;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.specify.dbsupport.cleanuptools.BaseCleanupResults;
import edu.ku.brc.specify.dbsupport.cleanuptools.DataObjTableModel;
import edu.ku.brc.specify.dbsupport.cleanuptools.DataObjTableModelRowInfo;
import edu.ku.brc.specify.dbsupport.cleanuptools.FindItemInfo;
import edu.ku.brc.specify.toycode.mexconabio.AnalysisWithGBIF;
import java.awt.HeadlessException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;

public class GBIFCleanupResults
extends BaseCleanupResults {
    protected AnalysisWithGBIF awg;

    public GBIFCleanupResults(String title, FindItemInfo itemInfo, AnalysisWithGBIF awg) throws HeadlessException {
        super(title, itemInfo);
        this.awg = awg;
    }

    @Override
    protected void createAndFillModels() {
        final String[] colNames = new String[]{"Id", "Institution Code", "Collection Code", "Catalog Number", "Scientific Name", "Author", "Genus", "Species", "Subspecies", "Latitude", "Longitude", "Lat Long Prec", "Max altitude", "Min altitude", "Alt Precision", "Min Depth", "Max Depth", "Depth Precision", "Continent Ocean", "Country", "State", "County", "Collector Name", "Locality", "Year", "Month", "Day", "Collector Number", "Phase", "Score"};
        final Class[] dataClasses = new Class[]{Integer.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Integer.class, Integer.class};
        this.model = new DataObjTableModel(this.awg.getDstDBConn(), 100, this.itemInfo.getId(), false){

            @Override
            protected String buildSQL() {
                String sql = " SELECT id, r.institution_code, r.collection_code, catalogue_number, r.scientific_name, r.author, r.genus, r.species, r.subspecies, r.latitude, r.longitude, lat_long_precision, r.max_altitude, r.min_altitude, r.altitude_precision, r.min_depth, r.max_depth, r.depth_precision, continent_ocean, r.country, r.state_province, r.county, r.collector_name, locality, r.year, r.month, r.day, r.collector_num, g.reltype, g.score FROM gbifsnib AS g Inner Join raw AS r ON g.GBIFID = r.id WHERE g.SNIBID = ? AND g.score > 50 ORDER BY g.score DESC";
                this.tableInfo = new DBTableInfo(100, this.getClass().getName(), "raw", "id", "r");
                int i = 0;
                while (i < colNames.length) {
                    DBFieldInfo fi = new DBFieldInfo(this.tableInfo, colNames[i], dataClasses[i]);
                    fi.setTitle(colNames[i]);
                    this.colDefItems.add(fi);
                    ++i;
                }
                this.numColumns = colNames.length;
                return sql;
            }

            @Override
            protected void addAdditionalRows(ArrayList<DBInfoBase> colDefItemsArg, ArrayList<DataObjTableModelRowInfo> rowInfoListArg) {
                Calendar cal = Calendar.getInstance();
                String cSQL = String.format("SELECT BarCD, GenusName, SpeciesName, SubspeciesName, Latminenetq, Lngminenetq, LatLongFuente, AltMaxEtq, AltMinEtq, COUNTRY, STATE, MUNIC, Collectoragent1, LocalityName, Datecollstandrd, CollNr FROM conabio WHERE ID = %d", (Integer)this.searchValue);
                Connection srcConn = GBIFCleanupResults.this.awg.getSrcDBConn();
                Statement stmt = null;
                try {
                    try {
                        stmt = srcConn.createStatement(1004, 1007);
                        String collNum = null;
                        ResultSet rs = stmt.executeQuery(cSQL);
                        while (rs.next()) {
                            Object[] row = new Object[this.numColumns];
                            int inx = 0;
                            int dbInx = 1;
                            row[inx++] = null;
                            row[inx++] = null;
                            row[inx++] = null;
                            row[inx++] = rs.getObject(dbInx++);
                            row[inx++] = null;
                            row[inx++] = null;
                            row[inx++] = rs.getObject(dbInx++);
                            row[inx++] = rs.getObject(dbInx++);
                            row[inx++] = rs.getObject(dbInx++);
                            row[inx++] = rs.getObject(dbInx++);
                            row[inx++] = rs.getObject(dbInx++);
                            row[inx++] = rs.getObject(dbInx++);
                            row[inx++] = rs.getObject(dbInx++);
                            row[inx++] = rs.getObject(dbInx++);
                            row[inx++] = null;
                            row[inx++] = null;
                            row[inx++] = null;
                            row[inx++] = null;
                            row[inx++] = null;
                            row[inx++] = rs.getObject(dbInx++);
                            row[inx++] = rs.getObject(dbInx++);
                            row[inx++] = rs.getObject(dbInx++);
                            row[inx++] = rs.getObject(dbInx++);
                            row[inx++] = rs.getObject(dbInx++);
                            Date collDate = rs.getDate(dbInx);
                            ++dbInx;
                            if (collDate == null) {
                                row[inx++] = null;
                                row[inx++] = null;
                                row[inx++] = null;
                            } else {
                                cal.setTime(collDate);
                                Integer year = cal.get(1);
                                Integer mon = cal.get(2) + 1;
                                Integer day = cal.get(5);
                                row[inx++] = year.toString();
                                row[inx++] = mon.toString();
                                row[inx++] = day.toString();
                            }
                            collNum = rs.getString(dbInx++);
                            row[inx++] = collNum;
                            row[inx++] = 0;
                            row[inx++] = 0;
                            this.values.add(row);
                            rowInfoListArg.add(new DataObjTableModelRowInfo(rs.getInt(1), false, false));
                        }
                        rs.close();
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            }
        };
        this.newModel = new DataObjTableModel(this.awg.getDstDBConn(), 100, this.model.getItems(), this.model.getHasDataList(), this.model.getSameValues(), this.model.getMapInx(), this.model.getIndexHash());
    }
}

