/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode.mexconabio;

import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.DesertBlue;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.toycode.mexconabio.FieldDef;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class FileMakerToMySQL
extends DefaultHandler {
    protected SimpleDateFormat sdf = new SimpleDateFormat("d/M/yyyy");
    protected SimpleDateFormat stf = new SimpleDateFormat("k:mm:ss");
    protected XMLReader xmlReader;
    protected StringBuilder buffer = new StringBuilder();
    protected Vector<FieldDef> fields = new Vector();
    protected Vector<String> values = new Vector();
    protected Vector<Integer> sizes = new Vector();
    protected int rowCnt = 0;
    protected int rowNum = 0;
    protected int colNum = 0;
    protected boolean doColSizes = false;
    protected boolean debug = false;
    protected int chkRow = 106000;
    protected String dbName = "mex";
    protected String userName = "root";
    protected String password = "root";
    protected String tableName = null;
    protected String keyField = null;
    protected boolean doAddKey = false;
    protected Connection conn = null;
    protected PreparedStatement pStmt = null;

    public FileMakerToMySQL(String tableName, String keyField, boolean doAddKey) {
        this.tableName = tableName;
        this.keyField = keyField;
        this.doAddKey = doAddKey;
        try {
            this.conn = DriverManager.getConnection("jdbc:mysql://localhost/" + this.dbName + "?characterEncoding=UTF-8&autoReconnect=true", this.userName, this.password);
            Statement stmt = this.conn.createStatement();
            stmt.execute("DROP TABLE " + tableName);
            stmt.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void shutdown() {
        try {
            if (this.pStmt != null) {
                this.pStmt.close();
            }
            this.conn.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) {
        block18: {
            block19: {
                this.buffer.setLength(0);
                if (!localName.equals("FIELD")) break block19;
                if (!this.doColSizes) break block18;
                FieldDef fldDef = new FieldDef();
                this.fields.add(fldDef);
                int i = 0;
                while (i < attrs.getLength()) {
                    String attr = attrs.getLocalName(i);
                    String value = attrs.getValue(i);
                    if (attr.equals("EMPTYOK")) {
                        fldDef.setNullable(value.equals("YES"));
                    } else if (attr.equals("NAME")) {
                        value = StringUtils.capitalize((String)value.trim());
                        value = StringUtils.deleteWhitespace((String)value);
                        value = StringUtils.replace((String)value, (String)":", (String)"");
                        value = StringUtils.replace((String)value, (String)";", (String)"");
                        value = StringUtils.replace((String)value, (String)".", (String)"");
                        if ((value = StringUtils.replace((String)value, (String)"/", (String)"")).charAt(0) >= '0' && value.charAt(0) <= '9' || value.equalsIgnoreCase("New") || value.equalsIgnoreCase("Group")) {
                            value = "Fld" + value;
                        }
                        fldDef.setName(value);
                    } else if (attr.equals("TYPE")) {
                        if (value.equals("TEXT")) {
                            fldDef.setType(FieldDef.DataType.eText);
                        } else if (value.equals("NUMBER")) {
                            fldDef.setType(FieldDef.DataType.eNumber);
                        } else if (value.equals("DATE")) {
                            fldDef.setType(FieldDef.DataType.eDate);
                        } else if (value.equals("TIME")) {
                            fldDef.setType(FieldDef.DataType.eTime);
                        } else {
                            System.err.println("Unknown Type[" + value + "]");
                        }
                    }
                    ++i;
                }
                break block18;
            }
            if (localName.equals("ROW")) {
                int i = 0;
                while (i < attrs.getLength()) {
                    String attr = attrs.getLocalName(i);
                    String value = attrs.getValue(i);
                    if (attr.equals("RECORDID")) {
                        this.rowNum = Integer.parseInt(value);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return super.resolveEntity(publicId, systemId);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String[] syms = new String[]{"\u00fc", "\u00f3", "\u00e9", "\u00e4", "\u00e1", "\u00ed", "\u00f6", "\u00f8", "\u00c5", "\u00ea", "\u00f1", "\u00e7", "\ufffdx", "\u00fa", "\u00c1"};
        String[] chars = new String[]{"\ufffd", "\ufffd", "\ufffd", "\ufffd", "\ufffd", "\ufffd", "\ufffd", "\ufffd", "\ufffd", "\ufffd", "\ufffd", "\ufffd", "\ufffd", "\ufffd", "\ufffd"};
        if (this.buffer != null) {
            String s = new String(ch, start, length);
            int i = 0;
            while (i < syms.length) {
                s = StringUtils.replace((String)s, (String)syms[i], (String)chars[i]);
                ++i;
            }
            this.buffer.append(s);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        if (localName.equals("DATA")) {
            if (this.debug) {
                // empty if block
            }
            if (!this.doColSizes) {
                this.values.add(this.buffer.toString());
            } else {
                String val = this.buffer.toString();
                FieldDef fd = this.fields.get(this.colNum);
                fd.setMaxSize(this.buffer.length());
                if (fd.isNumber() && !fd.isDouble() && StringUtils.contains((String)this.buffer.toString(), (char)'.')) {
                    fd.setDouble(true);
                }
            }
            ++this.colNum;
        } else if (localName.equals("ROW")) {
            if (!this.doColSizes) {
                this.writeRow();
            }
            if (this.rowCnt % 1000 == 0) {
                System.out.println(this.rowCnt);
            }
            ++this.rowCnt;
            this.colNum = 0;
        } else if (localName.equals("METADATA")) {
            if (!this.doColSizes) {
                this.createTable(this.tableName, this.keyField, true);
                System.exit(0);
            }
        } else if (localName.equals("RESULTSET") && this.doColSizes) {
            for (FieldDef fd : this.fields) {
                if (fd.getMaxSize() <= 0) continue;
                System.out.println(String.valueOf(fd.getName()) + " - " + fd.getMaxSize());
            }
        }
        this.buffer.setLength(0);
    }

    private void createTable(String tblName, String keyField, boolean doForceAll) {
        String[] syms = new String[]{"\u00fc", "\u00f3", "\u00e9", "\u00e4", "\u00e1", "\u00ed", "\u00f6", "\u00f8", "\u00c5", "\u00ea", "\u00f1", "\u00e7", "\ufffdx", "\u00fa", "\u00c1"};
        String[] chars = new String[]{"u", "o", "e", "a", "a", "i", "o", "o", "A", "e", "n", "c", "i", "u", "A"};
        StringBuilder selectDB = new StringBuilder();
        for (FieldDef fd : this.fields) {
            String s = fd.getName();
            System.out.println(s);
            while (s.indexOf(65533) > -1) {
                int ii = 0;
                while (ii < syms.length) {
                    s = StringUtils.replace((String)s, (String)syms[ii], (String)chars[ii]);
                    ++ii;
                }
            }
            if (selectDB.length() > 0) {
                selectDB.append(", ");
            }
            selectDB.append(s);
            fd.setName(s);
        }
        try {
            FileUtils.writeStringToFile((File)new File("select.txt"), (String)selectDB.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int primaryIndex = -1;
        int i = 0;
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE " + tblName + " (");
        for (FieldDef fd : this.fields) {
            if ((fd.getName() == null || fd.getMaxSize() == 0) && !doForceAll) continue;
            String fieldName = fd.getName();
            if (i == 0 && keyField == null || keyField != null && keyField.equals(fieldName)) {
                primaryIndex = i;
                if (!fieldName.endsWith("ID")) {
                    fieldName = String.valueOf(fieldName) + "ID";
                }
                String keyName = StringUtils.deleteWhitespace((String)fieldName);
                sb.append(keyName);
                sb.append(" int(11) NOT NULL AUTO_INCREMENT,\n");
                fd.setName(fieldName);
            } else {
                sb.append(fd.getName());
                sb.append(" ");
                switch (fd.getType()) {
                    case eText: {
                        int sz = ((int)((double)fd.getMaxSize() / 8.0) + 2) * 8;
                        System.out.println(String.valueOf(fd.getName()) + "  [" + fd.getMaxSize() + "][" + sz + "]");
                        if (sz > 255) {
                            sb.append("text");
                            break;
                        }
                        sb.append("varchar(" + sz + ")");
                        break;
                    }
                    case eNumber: {
                        sb.append(fd.isDouble() ? "double" : "int(11)");
                        break;
                    }
                    case eDate: {
                        sb.append("date");
                        break;
                    }
                    case eTime: {
                        sb.append("TIME");
                    }
                }
                sb.append(fd.isNullable() ? " DEFAULT NULL," : ",");
                sb.append("\n");
            }
            ++i;
        }
        sb.append(String.format("PRIMARY KEY (`%s`)\n", this.fields.get(primaryIndex).getName()));
        sb.append(") ENGINE=InnoDB DEFAULT CHARSET=utf8;\n");
        System.err.println(sb.toString());
        System.setProperty(DBMSUserMgr.factoryName, "edu.ku.brc.dbsupport.MySQLDMBSUserMgr");
        DBMSUserMgr mgr = DBMSUserMgr.getInstance();
        if (mgr.connect("root", "root", "localhost", "mex")) {
            if (mgr.doesDBHaveTable(tblName)) {
                mgr.dropTable(tblName);
            }
            mgr.close();
        }
        BasicSQLUtils.update(this.conn, sb.toString());
        this.createPrepare(tblName, true);
    }

    protected void createPrepare(String tblName, boolean doAllFields) {
        if (this.doAddKey) {
            this.fields.remove(0);
        }
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append(tblName);
        sb.append(" (");
        int i = 0;
        for (FieldDef fd : this.fields) {
            if (!doAllFields && fd.getMaxSize() <= 0 && !doAllFields) continue;
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(fd.getName());
            ++i;
        }
        sb.append(") VALUES(");
        i = 0;
        for (FieldDef fd : this.fields) {
            if (fd.getMaxSize() <= 0 && !doAllFields) continue;
            if (i > 0) {
                sb.append(", ");
            }
            sb.append('?');
            ++i;
        }
        sb.append(")");
        try {
            this.pStmt = this.conn.prepareStatement(sb.toString());
            FileUtils.writeStringToFile((File)new File("prepare_stmt.txt"), (String)sb.toString());
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeRow() {
        try {
            int i = 0;
            int col = 1;
            for (FieldDef fd : this.fields) {
                block17: {
                    block19: {
                        block18: {
                            if (fd.getMaxSize() <= 0) break block17;
                            String val = this.values.get(i);
                            if (!StringUtils.isNotEmpty((String)val)) break block18;
                            switch (fd.getType()) {
                                case eText: {
                                    this.pStmt.setString(col, val);
                                    break;
                                }
                                case eNumber: {
                                    if (StringUtils.isNumericSpace((String)val)) {
                                        if (fd.isDouble()) {
                                            this.pStmt.setDouble(col, Double.parseDouble(val));
                                            break;
                                        }
                                        this.pStmt.setInt(col, Integer.parseInt(val));
                                        break;
                                    }
                                    this.pStmt.setObject(col, null);
                                    break;
                                }
                                case eDate: {
                                    java.util.Date date = null;
                                    try {
                                        date = this.sdf.parse(val);
                                        this.pStmt.setDate(col, new Date(date.getTime()));
                                    }
                                    catch (Exception ex) {
                                        this.pStmt.setObject(col, null);
                                    }
                                    break block19;
                                }
                                case eTime: {
                                    Time time = null;
                                    try {
                                        time = Time.valueOf(val);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    this.pStmt.setTime(col, time);
                                }
                            }
                            break block19;
                        }
                        this.pStmt.setObject(col, null);
                    }
                    ++col;
                }
                ++i;
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        try {
            this.pStmt.execute();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        this.values.clear();
    }

    protected void cleanFile(String fileName) {
        File srcFile = new File(fileName);
        try {
            File destFile = new File("xxx.xml");
            FileUtils.copyFile((File)srcFile, (File)destFile);
            FileReader fr = new FileReader(srcFile);
            PrintWriter pw = new PrintWriter(destFile);
            char[] chars = new char[32768];
            int numChars = fr.read(chars, 0, chars.length);
            while (numChars > 0) {
                int i = 0;
                while (i < chars.length) {
                    if (chars[i] == '\u000b') {
                        System.out.println("fixed[" + chars[i] + "]");
                        chars[i] = 32;
                    }
                    ++i;
                }
                pw.write(chars, 0, numChars);
                numChars = fr.read(chars, 0, chars.length);
            }
            fr.close();
            pw.close();
            FileUtils.copyFile((File)destFile, (File)srcFile);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void error(SAXParseException exception) {
        System.err.println("line " + exception.getLineNumber() + ": col. " + exception.getColumnNumber() + ": " + exception.getMessage());
    }

    @Override
    public void fatalError(SAXParseException exception) {
        System.err.println("line " + exception.getLineNumber() + ": col. " + exception.getColumnNumber() + ": " + exception.getMessage());
    }

    public void process(boolean doColSizes) {
        this.rowCnt = 0;
        this.doColSizes = doColSizes;
        if (doColSizes && this.doAddKey) {
            this.fields.add(new FieldDef("ID", "ID", FieldDef.DataType.eNumber, false, false));
        }
        try {
            FileReader fr = new FileReader(new File("/Users/rods/Documents/Conabio.xml"));
            this.xmlReader = new SAXParser();
            this.xmlReader.setContentHandler(this);
            this.xmlReader.setErrorHandler(this);
            InputSource is = new InputSource(fr);
            is.setEncoding("UTF-8");
            this.xmlReader.parse(is);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (!System.getProperty("os.name").equals("Mac OS X")) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
            }
            catch (UnsupportedLookAndFeelException e) {
                e.printStackTrace();
            }
            PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new DesertBlue());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String fileName = "xxx.xml";
                if (StringUtils.isNotEmpty((String)fileName)) {
                    String tableName = "Conabio";
                    boolean addKey = true;
                    FileMakerToMySQL fm2mysql = new FileMakerToMySQL(tableName, null, addKey);
                    fm2mysql.process(true);
                    fm2mysql.process(false);
                    fm2mysql.shutdown();
                } else {
                    System.exit(0);
                }
            }
        });
    }

    class FileMakerConvertFrame
    extends JFrame {
        FileMakerConvertFrame() {
        }

        public void start() {
        }
    }
}

