/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode.mexconabio;

import edu.ku.brc.specify.toycode.mexconabio.FieldDef;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class FMPCreateTable
extends DefaultHandler {
    public static final String[] twoByteSyms = new String[]{"\u00fc", "\u00f3", "\u00e9", "\u00e4", "\u00e1", "\u00ed", "\u00f6", "\u00f8", "\u00c5", "\u00ea", "\u00f1", "\u00e7", "\u00fa", "\u00c1"};
    public static final String[] chars = new String[]{"\ufffd", "\ufffd", "\ufffd", "\ufffd", "\ufffd", "\ufffd", "\ufffd", "\ufffd", "\ufffd", "\ufffd", "\ufffd", "\ufffd", "\ufffd", "\ufffd"};
    public static final String[] ascii = new String[]{"u", "o", "e", "a", "a", "i", "o", "o", "A", "e", "n", "c", "u", "A"};
    protected XMLReader xmlReader;
    protected StringBuilder buffer = new StringBuilder();
    protected Vector<FieldDef> fields = new Vector();
    protected int rowCnt = 0;
    protected int rowNum = 0;
    protected boolean debug = false;
    protected String fieldListString = null;
    protected String prepareStmtStr = null;
    protected String tableName = null;
    protected String keyField = null;
    protected boolean doAddKey = false;

    public FMPCreateTable(String tableName, String keyField, boolean doAddKey) {
        this.tableName = tableName;
        this.keyField = keyField;
        this.doAddKey = doAddKey;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) {
        this.buffer.setLength(0);
        if (localName.equals("FIELD")) {
            FieldDef fldDef = new FieldDef();
            this.fields.add(fldDef);
            int i = 0;
            while (i < attrs.getLength()) {
                String attr = attrs.getLocalName(i);
                String value = attrs.getValue(i);
                if (attr.equals("EMPTYOK")) {
                    fldDef.setNullable(value.equals("YES"));
                } else if (attr.equals("NAME")) {
                    value = StringUtils.capitalize((String)value.trim());
                    value = StringUtils.deleteWhitespace((String)value);
                    if ((value = StringUtils.replace((String)value, (String)"_", (String)"")).charAt(0) >= '0' && value.charAt(0) <= '9' || value.equalsIgnoreCase("New") || value.equalsIgnoreCase("Group")) {
                        value = "Fld" + value;
                    }
                    String fixedStr = FMPCreateTable.convertFromTwoByteUTF8(value);
                    fixedStr = StringUtils.replace((String)fixedStr, (String)".", (String)"");
                    fixedStr = StringUtils.replace((String)fixedStr, (String)":", (String)"");
                    fixedStr = StringUtils.replace((String)fixedStr, (String)"/", (String)"_");
                    fldDef.setName(fixedStr);
                    fldDef.setOrigName(value);
                } else if (attr.equals("TYPE")) {
                    if (value.equals("TEXT")) {
                        fldDef.setType(FieldDef.DataType.eText);
                    } else if (value.equals("NUMBER")) {
                        fldDef.setType(FieldDef.DataType.eNumber);
                    } else if (value.equals("DATE")) {
                        fldDef.setType(FieldDef.DataType.eDate);
                    } else if (value.equals("TIME")) {
                        fldDef.setType(FieldDef.DataType.eTime);
                    } else {
                        System.err.println("Unknown Type[" + value + "]");
                    }
                }
                ++i;
            }
        }
    }

    public static String convertFromTwoByteUTF8(String str) {
        String s = str;
        int ii = 0;
        while (ii < twoByteSyms.length) {
            s = StringUtils.replace((String)s, (String)twoByteSyms[ii], (String)chars[ii]);
            ++ii;
        }
        return s;
    }

    public static String convertToAcsii(String str) {
        String s = str;
        int ii = 0;
        while (ii < chars.length) {
            s = StringUtils.replace((String)s, (String)chars[ii], (String)ascii[ii]);
            ++ii;
        }
        return s;
    }

    public static String fixName(String nameArg) {
        String name = nameArg.toLowerCase();
        StringBuilder nm = new StringBuilder();
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c != ':' && c <= 'z') {
                nm.append(c);
            }
            ++i;
        }
        return StringUtils.replace((String)nm.toString().trim(), (String)" ", (String)"_");
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.buffer != null) {
            String s = new String(ch, start, length);
            this.buffer.append(FMPCreateTable.convertFromTwoByteUTF8(s));
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        this.buffer.setLength(0);
    }

    public String dropTableStr() {
        return "DROP TABLE " + this.tableName;
    }

    public String createTableStr() {
        return this.createTableStr(this.tableName, this.keyField, true);
    }

    private String createTableStr(String tblName, String keyField, boolean doForceAll) {
        StringBuilder selectDB = new StringBuilder();
        for (FieldDef fd : this.fields) {
            String s = FMPCreateTable.convertToAcsii(fd.getName());
            if (selectDB.length() > 0) {
                selectDB.append(", ");
            }
            selectDB.append(s);
            fd.setName(s);
        }
        this.fieldListString = selectDB.toString();
        int primaryIndex = -1;
        int i = 0;
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE " + tblName + " (");
        for (FieldDef fd : this.fields) {
            if ((fd.getName() == null || fd.getMaxSize() == 0) && !doForceAll) continue;
            String fieldName = fd.getName();
            if (i == 0 && keyField == null || keyField != null && keyField.equals(fieldName)) {
                primaryIndex = i;
                if (!fieldName.endsWith("ID")) {
                    fieldName = String.valueOf(fieldName) + "ID";
                }
                String keyName = StringUtils.deleteWhitespace((String)fieldName);
                sb.append(keyName);
                sb.append(" int(11) NOT NULL AUTO_INCREMENT,\n");
                fd.setName(fieldName);
            } else {
                sb.append(fd.getName());
                sb.append(" ");
                switch (fd.getType()) {
                    case eText: {
                        int sz = ((int)((double)fd.getMaxSize() / 8.0) + 2) * 8;
                        System.out.println(String.valueOf(fd.getName()) + "  [" + fd.getMaxSize() + "][" + sz + "]");
                        if (sz > 255) {
                            sb.append("text");
                            break;
                        }
                        sb.append("varchar(" + sz + ")");
                        break;
                    }
                    case eNumber: {
                        sb.append(fd.isDouble() ? "double" : "int(11)");
                        break;
                    }
                    case eDate: {
                        sb.append("date");
                        break;
                    }
                    case eTime: {
                        sb.append("TIME");
                    }
                }
                sb.append(fd.isNullable() ? " DEFAULT NULL," : ",");
                sb.append("\n");
            }
            ++i;
        }
        sb.append(String.format("PRIMARY KEY (`%s`)\n", this.fields.get(primaryIndex).getName()));
        sb.append(") ENGINE=InnoDB DEFAULT CHARSET=utf8;\n");
        System.err.println(sb.toString());
        return sb.toString();
    }

    public String getFieldListString() {
        return this.fieldListString;
    }

    public String getPrepareStmtStr(boolean doAllFields, boolean doRemoveIdField) {
        if (this.prepareStmtStr == null) {
            this.createPrepare(doAllFields, doRemoveIdField);
        }
        return this.prepareStmtStr;
    }

    private void createPrepare(boolean doAllFields, boolean doRemoveIdField) {
        if (doRemoveIdField && this.doAddKey) {
            this.fields.remove(0);
        }
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append(this.tableName);
        sb.append(" (");
        int i = 0;
        for (FieldDef fd : this.fields) {
            if (!doAllFields && fd.getMaxSize() <= 0) continue;
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(FMPCreateTable.convertToAcsii(fd.getName()));
            ++i;
        }
        sb.append(") VALUES(");
        i = 0;
        for (FieldDef fd : this.fields) {
            if (fd.getMaxSize() <= 0 && !doAllFields) continue;
            if (i > 0) {
                sb.append(", ");
            }
            sb.append('?');
            ++i;
        }
        sb.append(")");
        this.prepareStmtStr = sb.toString();
    }

    @Override
    public void error(SAXParseException exception) {
        System.err.println("line " + exception.getLineNumber() + ": col. " + exception.getColumnNumber() + ": " + exception.getMessage());
    }

    @Override
    public void fatalError(SAXParseException exception) {
        System.err.println("line " + exception.getLineNumber() + ": col. " + exception.getColumnNumber() + ": " + exception.getMessage());
    }

    public Vector<FieldDef> getFields() {
        return this.fields;
    }

    public void process(String xmlFileName) {
        this.rowCnt = 0;
        if (this.doAddKey) {
            this.fields.add(new FieldDef("ID", "ID", FieldDef.DataType.eNumber, false, false));
        }
        try {
            FileReader fr = new FileReader(new File(xmlFileName));
            this.xmlReader = new SAXParser();
            this.xmlReader.setContentHandler(this);
            this.xmlReader.setErrorHandler(this);
            InputSource is = new InputSource(fr);
            is.setEncoding("UTF-8");
            this.xmlReader.parse(is);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

