/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode.mexconabio;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.toycode.mexconabio.AnalysisBase;
import edu.ku.brc.util.Pair;
import edu.ku.brc.util.Triple;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import java.util.Vector;

public class CreateReportForXRef
extends AnalysisBase {
    protected HashMap<String, Pair<Integer, Integer>> instAverageScoresHashpMap = new HashMap();
    protected Stack<Object[]> recycler = new Stack();

    protected Object[] getRow() {
        Object[] row = this.recycler.size() > 0 ? this.recycler.pop() : new Object[16];
        System.arraycopy(this.objNulls, 0, row, 0, 16);
        return row;
    }

    protected void recycle(Collection<Object[]> collection) {
        this.recycler.addAll(collection);
        collection.clear();
    }

    protected void compareRowsForReports(String trClass, Object[] refRow, Object[] cmpRow) {
        this.clearRowAttrs();
        this.score(refRow, cmpRow);
        this.writeRow(trClass, cmpRow, this.tdColorCodes);
    }

    protected void regScore(String instCode, int score) {
        Pair<Integer, Integer> entry = this.instAverageScoresHashpMap.get(instCode);
        if (entry == null) {
            entry = new Pair<Integer, Integer>(0, 0);
            this.instAverageScoresHashpMap.put(instCode, entry);
        }
        entry.first = (Integer)entry.first + 1;
        entry.second = (Integer)entry.second + score;
    }

    @Override
    public void process(int type, int options) {
        block36: {
            String dataDirName = "compare";
            Object[] refRow = new Object[16];
            Object[] cmpRow = new Object[16];
            String sql = "SELECT sm.SNIBID, a.IdSNIB, r.id FROM gbifsnib AS gs Inner Join snibmex AS sm ON gs.SNIBID = sm.SNIBID Inner Join raw AS r ON gs.GBIFID = r.id Inner Join angiospermas AS a ON sm.GBIFID = a.IdSNIB WHERE r.genus =  a.Genus AND r.`year` =  CONVERT(a.`Year`, CHAR(8)) AND r.`month` =  CONVERT(a.`Month`, CHAR(8)) AND a.latitude IS NOT NULL ORDER BY sm.SNIBID, a.IdSNIB, r.id";
            String sqlCnt = "SELECT COUNT(*) FROM gbifsnib AS gs Inner Join snibmex AS sm ON gs.SNIBID = sm.SNIBID Inner Join raw AS r ON gs.GBIFID = r.id Inner Join angiospermas AS a ON sm.GBIFID = a.IdSNIB WHERE r.genus =  a.Genus AND r.`year` =  CONVERT(a.`Year`, CHAR(8)) AND r.`month` =  CONVERT(a.`Month`, CHAR(8)) AND a.latitude IS NOT NULL ORDER BY sm.SNIBID, a.IdSNIB, r.id";
            String snibFromClause1 = "FROM angiospermas WHERE IdSNIB = ?";
            String gbifFromClause1 = "FROM raw WHERE id = ?";
            String michFromClause1 = "FROM conabio WHERE ID = ?";
            Comparator<Object[]> comparator = new Comparator<Object[]>(){

                @Override
                public int compare(Object[] o1, Object[] o2) {
                    Integer i1 = (Integer)o1[15];
                    Integer i2 = (Integer)o2[15];
                    return i2.compareTo(i1);
                }
            };
            long totalRecs = BasicSQLUtils.getCount(this.dbLMConn, sqlCnt).intValue();
            long procRecs = 0L;
            long startTime = System.currentTimeMillis();
            int secsThreshold = 0;
            Statement stmt = null;
            Statement refStmt = null;
            Statement snibStmt = null;
            Statement gbifStmt = null;
            try {
                try {
                    stmt = this.dbLMConn.createStatement(1000, 1007);
                    stmt.setFetchSize(Integer.MIN_VALUE);
                    refStmt = this.dbSrcConn.prepareStatement("SELECT BarCD, CollNr, Collectoragent1, GenusName, SpeciesName, SubSpeciesName, LocalityName, Datecollstandrd, COUNTRY, STATE, ID " + michFromClause1);
                    snibStmt = this.dbDstConn.prepareStatement("SELECT IdSNIB, CatalogNumber, Genus, Species, Cataegoryinfraspecies, Latitude, Longitude, Country, LastNameFather, LastNameMother, FirstName, State, Locality, `Year`, `Month`, `Day`, CollectorNumber, InstitutionAcronym " + snibFromClause1);
                    gbifStmt = this.dbGBIFConn.prepareStatement("SELECT id, catalogue_number, genus, species, subspecies, latitude, longitude, country, state_province, collector_name, locality, year, month, day, collector_num, institution_code " + gbifFromClause1);
                    HashSet<Integer> snibIdsHash = new HashSet<Integer>();
                    HashSet<Integer> gbifIdsHash = new HashSet<Integer>();
                    Integer prevRefId = null;
                    int reportRecsSize = 500;
                    String title = String.format("%s %d - %d", dataDirName, 0, reportRecsSize);
                    String fileName = String.format("%s_%d_%d.html", dataDirName, 0, reportRecsSize);
                    this.startLogging("analysis", dataDirName, fileName, title, true, 100);
                    ResultSet rs = stmt.executeQuery(sql);
                    Vector<Object[]> gbifRows = new Vector<Object[]>();
                    Vector<Object[]> snibRows = new Vector<Object[]>();
                    while (rs.next()) {
                        int refId = rs.getInt(1);
                        int n = rs.getInt(2);
                        int gbifId = rs.getInt(3);
                        if (prevRefId == null || prevRefId != refId) {
                            int score;
                            for (Integer sId : snibIdsHash) {
                                snibStmt.setInt(1, sId);
                                ResultSet snibRS = snibStmt.executeQuery();
                                if (snibRS.next()) {
                                    cmpRow = this.getRow();
                                    this.fillSNIBRow(cmpRow, snibRS);
                                    score = (int)Math.round((double)this.score(refRow, cmpRow) / (double)this.maxScore * 100.0);
                                    cmpRow[15] = score;
                                    this.regScore((String)cmpRow[14], score);
                                    snibRows.add(cmpRow);
                                }
                                snibRS.close();
                            }
                            this.tblWriter.println(String.format("<TR><TD colspan=\"%d\">&nbsp;</TD></TR>", 16));
                            Collections.sort(snibRows, comparator);
                            for (Object[] srow : snibRows) {
                                this.compareRowsForReports("ev", refRow, srow);
                            }
                            this.recycle(snibRows);
                            snibIdsHash.clear();
                            for (Integer gId : gbifIdsHash) {
                                gbifStmt.setInt(1, gId);
                                ResultSet gbifRS = gbifStmt.executeQuery();
                                if (gbifRS.next()) {
                                    cmpRow = this.getRow();
                                    this.fillGBIFRow(cmpRow, gbifRS);
                                    score = (int)Math.round((double)this.score(refRow, cmpRow) / (double)this.maxScore * 100.0);
                                    cmpRow[15] = score;
                                    this.regScore((String)cmpRow[14], score);
                                    gbifRows.add(cmpRow);
                                }
                                gbifRS.close();
                            }
                            this.tblWriter.println(String.format("<TR><TD colspan=\"%d\">&nbsp;</TD></TR>", 16));
                            Collections.sort(gbifRows, comparator);
                            for (Object[] grow : gbifRows) {
                                this.compareRowsForReports("od", refRow, grow);
                            }
                            this.recycle(gbifRows);
                            gbifIdsHash.clear();
                            if (prevRefId != null) {
                                this.tblWriter.endTable();
                                this.tblWriter.println("<BR><BR>");
                                this.tblWriter.startTable(100);
                                this.tblWriter.logHdr(this.titles);
                            }
                            prevRefId = refId;
                            refStmt.setInt(1, refId);
                            ResultSet refRS = refStmt.executeQuery();
                            if (!refRS.next()) {
                                refRS.close();
                                continue;
                            }
                            this.fillMichRow(refRow, refRS);
                            refRS.close();
                            this.writeRow("", refRow, null);
                        }
                        snibIdsHash.add(n);
                        gbifIdsHash.add(gbifId);
                        if (++procRecs % (long)reportRecsSize != 0L) continue;
                        System.out.println(procRecs);
                        title = String.format("%s %d - %d", dataDirName, procRecs, procRecs + (long)reportRecsSize);
                        fileName = String.format("%s_%d_%d.html", dataDirName, procRecs, procRecs + (long)reportRecsSize);
                        this.startNewDocument(fileName, title, true, 100);
                        long endTime = System.currentTimeMillis();
                        long elapsedTime = endTime - startTime;
                        double timePerRecord = elapsedTime / procRecs;
                        double hrsLeft = (double)(totalRecs - procRecs) * timePerRecord / 3600000.0;
                        int seconds = (int)((double)elapsedTime / 60000.0);
                        if (secsThreshold == seconds) continue;
                        secsThreshold = seconds;
                        String msg = String.format("Elapsed %8.2f hr.mn   Percent: %6.3f  Hours Left: %8.2f ", (double)elapsedTime / 3600000.0, 100.0 * ((double)procRecs / (double)totalRecs), hrsLeft);
                        System.out.println(msg);
                    }
                    rs.close();
                    for (Integer sId : snibIdsHash) {
                        snibStmt.setInt(1, sId);
                        ResultSet snibRS = snibStmt.executeQuery();
                        if (snibRS.next()) {
                            cmpRow = this.getRow();
                            this.fillSNIBRow(cmpRow, snibRS);
                            snibRows.add(cmpRow);
                        }
                        snibRS.close();
                    }
                    this.recycle(snibRows);
                    this.tblWriter.println(String.format("<TR><TD colspan=\"%d\">&nbsp;</TD></TR>", 16));
                    Collections.sort(snibRows, comparator);
                    for (Object[] srow : snibRows) {
                        this.compareRowsForReports("ev", refRow, srow);
                    }
                    this.tblWriter.println(String.format("<TR><TD colspan=\"%d\">&nbsp;</TD></TR>", 16));
                    Collections.sort(gbifRows, comparator);
                    for (Object[] grow : gbifRows) {
                        this.compareRowsForReports("od", refRow, grow);
                    }
                    this.recycle(gbifRows);
                    this.tblWriter.endTable();
                    Vector<Triple<String, Integer, Double>> instScores = new Vector<Triple<String, Integer, Double>>();
                    for (String string : this.instAverageScoresHashpMap.keySet()) {
                        Pair<Integer, Integer> p = this.instAverageScoresHashpMap.get(string);
                        if (p == null) continue;
                        double averageScore = (double)((Integer)p.second).intValue() / (double)((Integer)p.first).intValue();
                        Triple<String, Integer, Double> ip = new Triple<String, Integer, Double>(string, (Integer)p.first, averageScore);
                        instScores.add(ip);
                    }
                    Collections.sort(instScores, new Comparator<Triple<String, Integer, Double>>(){

                        @Override
                        public int compare(Triple<String, Integer, Double> o1, Triple<String, Integer, Double> o2) {
                            return ((Double)o2.third).compareTo((Double)o1.third);
                        }
                    });
                    this.startNewDocument("InstScores.html", "Average Institution Scores", false, 100);
                    this.tblWriter.startTable(100);
                    this.tblWriter.logHdr("Institution", "Average Matching Score", "Number Matches");
                    for (Triple triple : instScores) {
                        String scoreStr = String.format("%5.2f", triple.third);
                        this.tblWriter.logWithSpaces((String)triple.first, scoreStr, Integer.toString((Integer)triple.second));
                    }
                    this.tblWriter.endTable();
                    this.tblWriter.setHasLines();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        if (refStmt != null) {
                            refStmt.close();
                        }
                        if (snibStmt != null) {
                            snibStmt.close();
                        }
                        if (gbifStmt != null) {
                            gbifStmt.close();
                        }
                        break block36;
                    }
                    catch (Exception exception) {}
                    break block36;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (refStmt != null) {
                        refStmt.close();
                    }
                    if (snibStmt != null) {
                        snibStmt.close();
                    }
                    if (gbifStmt != null) {
                        gbifStmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (refStmt != null) {
                    refStmt.close();
                }
                if (snibStmt != null) {
                    snibStmt.close();
                }
                if (gbifStmt != null) {
                    gbifStmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.convLogger.closeAll();
        System.out.println("Done.");
    }

    public static void main(String[] args) {
        CreateReportForXRef xrefReport = new CreateReportForXRef();
        xrefReport.createDBConnection("localhost", "3306", "plants", "root", "root");
        xrefReport.createSrcDBConnection("localhost", "3306", "plants", "root", "root");
        xrefReport.createDestDBConnection("localhost", "3306", "plants", "root", "root");
        xrefReport.createLMDBConnection("localhost", "3306", "plants", "root", "root");
        xrefReport.process(0, 0);
        xrefReport.cleanup();
    }
}

