/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode.mexconabio;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class CopyPlantsFromGBIF {
    private static final double HRS = 3600000.0;
    private static final String TAXSEARCH_GNSP_SQL = "SELECT * FROM raw WHERE genus = ? AND species = ? LIMIT 0,1";
    private static final String TAXSEARCH_GN_SQL = "SELECT * FROM raw WHERE genus = ? LIMIT 0,1";
    private static final String pSQL = "INSERT INTO raw (old_id,data_provider_id,data_resource_id,resource_access_point_id, institution_code, collection_code, catalogue_number, scientific_name, author, rank, kingdom, phylum, class, order_rank, family, genus, species, subspecies, latitude, longitude,  lat_long_precision, max_altitude, min_altitude, altitude_precision, min_depth, max_depth, depth_precision, continent_ocean, country, state_province, county, collector_name, locality,year, month, day, basis_of_record, identifier_name, identification_date,unit_qualifier, created, modified, deleted, collector_num) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String gbifSQLBase = "SELECT old_id, data_provider_id,data_resource_id,resource_access_point_id, institution_code, collection_code, catalogue_number, scientific_name, author, rank, kingdom, phylum, class, order_rank, family, genus, species, subspecies, latitude, longitude,  lat_long_precision, max_altitude, min_altitude, altitude_precision, min_depth, max_depth, depth_precision, continent_ocean, country, state_province, county, collector_name, locality,year, month, day, basis_of_record, identifier_name, identification_date,unit_qualifier, created, modified, deleted, collector_num ";
    private Connection srcConn = null;
    private Connection dstConn = null;
    private Connection colConn = null;
    private PreparedStatement colStmtGNSP = null;
    private PreparedStatement colStmtGN = null;
    private PreparedStatement colDstStmtGNSP = null;
    private PreparedStatement colDstStmtGN = null;

    public void connectToDst(String server, String port, String dbName, String username, String pwd) throws SQLException {
        this.dstConn = this.connect(server, port, dbName, username, pwd);
        this.colDstStmtGNSP = this.dstConn.prepareStatement(TAXSEARCH_GNSP_SQL);
        this.colDstStmtGNSP.setFetchSize(Integer.MIN_VALUE);
        this.colDstStmtGN = this.dstConn.prepareStatement(TAXSEARCH_GN_SQL);
        this.colDstStmtGN.setFetchSize(Integer.MIN_VALUE);
    }

    public void connectToSrc(String server, String port, String dbName, String username, String pwd) {
        this.srcConn = this.connect(server, port, dbName, username, pwd);
    }

    public void connectToCOLTaxa(String server, String port, String dbName, String username, String pwd) throws SQLException {
        this.colConn = this.connect(server, port, dbName, username, pwd);
        this.colStmtGNSP = this.dstConn.prepareStatement(TAXSEARCH_GNSP_SQL);
        this.colStmtGNSP.setFetchSize(Integer.MIN_VALUE);
        this.colStmtGN = this.dstConn.prepareStatement(TAXSEARCH_GN_SQL);
        this.colStmtGN.setFetchSize(Integer.MIN_VALUE);
    }

    private Connection connect(String server, String port, String dbName, String username, String pwd) {
        String connStr = "jdbc:mysql://%s:%s/%s?characterEncoding=UTF-8&autoReconnect=true";
        try {
            return DriverManager.getConnection(String.format(connStr, server, port, dbName), username, pwd);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isPlant(PreparedStatement pStmtGN, PreparedStatement pStmtGNSP, String genus, String species) {
        ResultSet rs = null;
        try {
            PreparedStatement pStmt;
            if (species == null) {
                pStmt = pStmtGN;
            } else {
                pStmt = pStmtGNSP;
                pStmt.setString(2, species);
            }
            pStmt.setString(1, genus);
            rs = pStmt.executeQuery();
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            System.err.println(pStmtGN + "  " + pStmtGNSP + " " + genus + "  " + species);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void processNullKingdom() {
        PrintWriter pw;
        block23: {
            pw = null;
            try {
                pw = new PrintWriter("gbif_plants_from_null.log");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            System.out.println("----------------------- Searching NULL ----------------------- ");
            String gbifWhereStr = "FROM raw WHERE kingdom IS NULL";
            long startTime = System.currentTimeMillis();
            String cntGBIFSQL = "SELECT COUNT(*) " + gbifWhereStr;
            String gbifSQL = gbifSQLBase + gbifWhereStr;
            System.out.println(cntGBIFSQL);
            long totalRecs = BasicSQLUtils.getCount(this.srcConn, cntGBIFSQL).intValue();
            long procRecs = 0L;
            int secsThreshold = 0;
            String msg = String.format("Query: %8.2f secs", (double)(System.currentTimeMillis() - startTime) / 1000.0);
            System.out.println(msg);
            pw.println(msg);
            pw.flush();
            startTime = System.currentTimeMillis();
            Statement gStmt = null;
            Statement pStmt = null;
            try {
                try {
                    pw = new PrintWriter("gbif_plants_from_null.log");
                    pStmt = this.dstConn.prepareStatement(pSQL);
                    System.out.println("Total Records: " + totalRecs);
                    pw.println("Total Records: " + totalRecs);
                    gStmt = this.srcConn.createStatement(1003, 1007);
                    gStmt.setFetchSize(Integer.MIN_VALUE);
                    ResultSet rs = gStmt.executeQuery(gbifSQL);
                    ResultSetMetaData rsmd = rs.getMetaData();
                    while (rs.next()) {
                        String species;
                        String genus = rs.getString(16);
                        if (genus == null || !this.isPlant(this.colStmtGN, this.colStmtGNSP, genus, species = rs.getString(17)) && !this.isPlant(this.colDstStmtGN, this.colDstStmtGNSP, genus, species)) continue;
                        int i = 1;
                        while (i <= rsmd.getColumnCount()) {
                            Object obj = rs.getObject(i);
                            pStmt.setObject(i, obj);
                            ++i;
                        }
                        try {
                            pStmt.executeUpdate();
                        }
                        catch (Exception ex) {
                            System.err.println("For Old ID[" + rs.getObject(1) + "]");
                            ex.printStackTrace();
                            pw.print("For Old ID[" + rs.getObject(1) + "] " + ex.getMessage());
                            pw.flush();
                        }
                        if (++procRecs % 10000L != 0L) continue;
                        long endTime = System.currentTimeMillis();
                        long elapsedTime = endTime - startTime;
                        double avergeTime = (double)elapsedTime / (double)procRecs;
                        double hrsLeft = ((double)elapsedTime / (double)procRecs * (double)totalRecs - (double)procRecs) / 3600000.0;
                        int seconds = (int)((double)elapsedTime / 60000.0);
                        if (secsThreshold == seconds) continue;
                        secsThreshold = seconds;
                        msg = String.format("Elapsed %8.2f hr.mn   Ave Time: %5.2f    Percent: %6.3f  Hours Left: %8.2f ", (double)elapsedTime / 3600000.0, avergeTime, 100.0 * ((double)procRecs / (double)totalRecs), hrsLeft);
                        System.out.println(msg);
                        pw.println(msg);
                        pw.flush();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        if (gStmt != null) {
                            gStmt.close();
                        }
                        if (pStmt != null) {
                            pStmt.close();
                        }
                        pw.close();
                    }
                    catch (Exception exception) {}
                    break block23;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (gStmt != null) {
                        gStmt.close();
                    }
                    if (pStmt != null) {
                        pStmt.close();
                    }
                    pw.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (gStmt != null) {
                    gStmt.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
                pw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("Done transferring.");
        pw.println("Done transferring.");
    }

    public void processNonNullNonPlantKingdom() {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter("gbif_plants_from_nonnull.log");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        System.out.println("----------------------- Search non-Plantae ----------------------- ");
        String gbifWhereStr = "FROM raw WHERE kingdom = '%s'";
        Vector<String> nonPlantKingdoms = new Vector<String>();
        String sqlStr = "SELECT * FROM (select kingdom, count(kingdom) as cnt from plants.raw WHERE kingdom is not null AND NOT (lower(kingdom) like '%plant%') group by kingdom) T1 ORDER BY cnt desc;";
        for (Object[] obj : BasicSQLUtils.query(sqlStr)) {
            String kingdom = (String)obj[0];
            Integer count = (Integer)obj[1];
            System.out.println(String.valueOf(kingdom) + " " + count);
            pw.println(String.valueOf(kingdom) + " " + count);
            if (StringUtils.contains((String)kingdom.toLowerCase(), (String)"plant")) continue;
            nonPlantKingdoms.add(kingdom);
        }
        long startTime = System.currentTimeMillis();
        for (String kingdom : nonPlantKingdoms) {
            String where = String.format(gbifWhereStr, kingdom);
            String cntGBIFSQL = "SELECT COUNT(*) " + where;
            String gbifSQL = gbifSQLBase + where;
            System.out.println(cntGBIFSQL);
            long totalRecs = BasicSQLUtils.getCount(this.srcConn, cntGBIFSQL).intValue();
            long procRecs = 0L;
            int secsThreshold = 0;
            String msg = String.format("Query: %8.2f secs", (double)(System.currentTimeMillis() - startTime) / 1000.0);
            System.out.println(msg);
            pw.println(msg);
            pw.flush();
            startTime = System.currentTimeMillis();
            Statement gStmt = null;
            PreparedStatement pStmt = null;
            try {
                try {
                    pStmt = this.dstConn.prepareStatement(pSQL);
                    System.out.println("Total Records: " + totalRecs);
                    pw.println("Total Records: " + totalRecs);
                    pw.flush();
                    gStmt = this.srcConn.createStatement(1003, 1007);
                    gStmt.setFetchSize(Integer.MIN_VALUE);
                    ResultSet rs = gStmt.executeQuery(gbifSQL);
                    ResultSetMetaData rsmd = rs.getMetaData();
                    while (rs.next()) {
                        String species;
                        String genus = rs.getString(16);
                        if (genus == null || !this.isPlant(this.colStmtGN, this.colStmtGNSP, genus, species = rs.getString(17)) && !this.isPlant(this.colDstStmtGN, this.colDstStmtGNSP, genus, species)) continue;
                        int i = 1;
                        while (i <= rsmd.getColumnCount()) {
                            Object obj = rs.getObject(i);
                            pStmt.setObject(i, obj);
                            ++i;
                        }
                        try {
                            pStmt.executeUpdate();
                        }
                        catch (Exception ex) {
                            System.err.println("For Old ID[" + rs.getObject(1) + "]");
                            ex.printStackTrace();
                            pw.print("For Old ID[" + rs.getObject(1) + "] " + ex.getMessage());
                            pw.flush();
                        }
                        if (++procRecs % 10000L != 0L) continue;
                        long endTime = System.currentTimeMillis();
                        long elapsedTime = endTime - startTime;
                        double avergeTime = (double)elapsedTime / (double)procRecs;
                        double hrsLeft = ((double)elapsedTime / (double)procRecs * (double)totalRecs - (double)procRecs) / 3600000.0;
                        int seconds = (int)((double)elapsedTime / 60000.0);
                        if (secsThreshold == seconds) continue;
                        secsThreshold = seconds;
                        msg = String.format("Elapsed %8.2f hr.mn   Ave Time: %5.2f    Percent: %6.3f  Hours Left: %8.2f ", (double)elapsedTime / 3600000.0, avergeTime, 100.0 * ((double)procRecs / (double)totalRecs), hrsLeft);
                        System.out.println(msg);
                        pw.println(msg);
                        pw.flush();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        if (gStmt != null) {
                            gStmt.close();
                        }
                        if (pStmt != null) {
                            pStmt.close();
                        }
                        pw.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (gStmt != null) {
                        gStmt.close();
                    }
                    if (pStmt != null) {
                        pStmt.close();
                    }
                    pw.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (gStmt != null) {
                    gStmt.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
                pw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("Done transferring.");
        pw.println("Done transferring.");
    }

    public void cleanup() {
        try {
            if (this.colStmtGNSP != null) {
                this.colStmtGNSP.close();
            }
            if (this.colStmtGN != null) {
                this.colStmtGN.close();
            }
            if (this.colDstStmtGNSP != null) {
                this.colDstStmtGNSP.close();
            }
            if (this.colDstStmtGN != null) {
                this.colDstStmtGN.close();
            }
            if (this.colConn != null) {
                this.colConn.close();
            }
            if (this.dstConn != null) {
                this.dstConn.close();
            }
            if (this.srcConn != null) {
                this.srcConn.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        CopyPlantsFromGBIF app = new CopyPlantsFromGBIF();
        try {
            app.connectToSrc("localhost", "3306", "gbif", "root", "root");
            app.connectToDst("localhost", "3306", "plants", "root", "root");
            app.connectToCOLTaxa("localhost", "3306", "col_taxa", "root", "root");
            app.processNullKingdom();
            app.cleanup();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

