/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode.mexconabio;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class CopyFromGBIFToPlants {
    private Connection dbConn = null;
    private Connection dbConn2 = null;
    private Connection srcDBConn = null;
    protected File INDEX_DIR = new File("index-gbif");
    protected IndexReader reader;
    protected Searcher searcher;
    protected Analyzer analyzer;

    public void createDBConnection(String server, String port, String dbName, String username, String pwd) {
        String connStr = "jdbc:mysql://%s:%s/%s?characterEncoding=UTF-8&autoReconnect=true";
        try {
            this.dbConn = DriverManager.getConnection(String.format(connStr, server, port, dbName), username, pwd);
            this.dbConn2 = DriverManager.getConnection(String.format(connStr, server, port, dbName), username, pwd);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createSrcDBConnection(String server, String port, String dbName, String username, String pwd) {
        String connStr = "jdbc:mysql://%s:%s/%s?characterEncoding=UTF-8&autoReconnect=true";
        try {
            this.srcDBConn = DriverManager.getConnection(String.format(connStr, server, port, dbName), username, pwd);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void process() {
        PrintWriter pw;
        block31: {
            boolean doQueryForCollNum = true;
            String pSQL = "INSERT INTO raw (old_id,data_provider_id,data_resource_id,resource_access_point_id, institution_code, collection_code, catalogue_number, scientific_name, author, rank, kingdom, phylum, class, order_rank, family, genus, species, subspecies, latitude, longitude,  lat_long_precision, max_altitude, min_altitude, altitude_precision, min_depth, max_depth, depth_precision, continent_ocean, country, state_province, county, collector_name, locality,year, month, day, basis_of_record, identifier_name, identification_date,unit_qualifier, created, modified, deleted, collector_num) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            String gbifSQLBase = "SELECT r.id, r.data_provider_id, r.data_resource_id, r.resource_access_point_id, r.institution_code, r.collection_code, r.catalogue_number, r.scientific_name, r.author, r.rank, r.kingdom, r.phylum, r.class, r.order_rank, r.family, r.genus, r.species, r.subspecies, r.latitude, r.longitude, r.lat_long_precision, r.max_altitude, r.min_altitude, r.altitude_precision, r.min_depth, r.max_depth, r.depth_precision, r.continent_ocean, r.country, r.state_province, r.county, r.collector_name, r.locality, r.year, r.month, r.day, r.basis_of_record, r.identifier_name, r.identification_date, r.unit_qualifier, r.created, r.modified, r.deleted";
            String gbifSQL = doQueryForCollNum ? String.valueOf(gbifSQLBase) + " FROM raw_occurrence_record r" : String.valueOf(gbifSQLBase) + ", i.identifier FROM raw_occurrence_record r, identifier_record i WHERE r.id = i.occurrence_id AND i.identifier_type = 3";
            BasicSQLUtils.update(this.srcDBConn, "DELETE FROM raw WHERE id > 0");
            long totalRecs = BasicSQLUtils.getCount(this.dbConn, "SELECT COUNT(*) FROM raw_occurrence_record").intValue();
            long procRecs = 0L;
            long startTime = System.currentTimeMillis();
            int secsThreshold = 0;
            pw = null;
            double HRS = 3600000.0;
            Statement gStmt = null;
            Statement pStmt = null;
            Statement stmt = null;
            try {
                try {
                    pw = new PrintWriter("gbif.log");
                    pStmt = this.srcDBConn.prepareStatement(pSQL);
                    stmt = this.dbConn2.prepareStatement("SELECT identifier FROM identifier_record WHERE occurrence_id = ? AND identifier_type = 3");
                    System.out.println("Total Records: " + totalRecs);
                    pw.println("Total Records: " + totalRecs);
                    gStmt = this.dbConn.createStatement(1003, 1007);
                    gStmt.setFetchSize(Integer.MIN_VALUE);
                    String fullSQL = gbifSQL;
                    System.out.println(fullSQL);
                    ResultSet gRS = gStmt.executeQuery(fullSQL);
                    ResultSetMetaData rsmd = gRS.getMetaData();
                    int lastColInx = rsmd.getColumnCount() + (doQueryForCollNum ? 1 : 0);
                    while (gRS.next()) {
                        int id = gRS.getInt(1);
                        pStmt.setObject(1, id);
                        int i = 2;
                        while (i <= rsmd.getColumnCount()) {
                            Object obj = gRS.getObject(i);
                            pStmt.setObject(i, obj);
                            ++i;
                        }
                        String collNum = null;
                        if (doQueryForCollNum) {
                            stmt.setInt(1, id);
                            ResultSet rs = stmt.executeQuery();
                            if (rs.next()) {
                                collNum = rs.getString(1);
                            }
                            rs.close();
                        } else {
                            collNum = gRS.getString(lastColInx - 1);
                        }
                        if (StringUtils.isNotEmpty((String)collNum)) {
                            if (collNum.length() < 256) {
                                pStmt.setString(lastColInx, collNum);
                            } else {
                                pStmt.setString(lastColInx, collNum.substring(0, 255));
                            }
                        } else {
                            pStmt.setObject(lastColInx, null);
                        }
                        try {
                            pStmt.executeUpdate();
                        }
                        catch (Exception ex) {
                            System.err.println("For ID[" + gRS.getObject(1) + "]");
                            ex.printStackTrace();
                            pw.print("For ID[" + gRS.getObject(1) + "] " + ex.getMessage());
                            pw.flush();
                        }
                        if (++procRecs % 10000L != 0L) continue;
                        long endTime = System.currentTimeMillis();
                        long elapsedTime = endTime - startTime;
                        double avergeTime = (double)elapsedTime / (double)procRecs;
                        double hrsLeft = ((double)elapsedTime / (double)procRecs * (double)totalRecs - (double)procRecs) / 3600000.0;
                        int seconds = (int)((double)elapsedTime / 60000.0);
                        if (secsThreshold == seconds) continue;
                        secsThreshold = seconds;
                        String msg = String.format("Elapsed %8.2f hr.mn   Ave Time: %5.2f    Percent: %6.3f  Hours Left: %8.2f ", (double)elapsedTime / 3600000.0, avergeTime, 100.0 * ((double)procRecs / (double)totalRecs), hrsLeft);
                        System.out.println(msg);
                        pw.println(msg);
                        pw.flush();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        if (gStmt != null) {
                            gStmt.close();
                        }
                        if (pStmt != null) {
                            pStmt.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        pw.close();
                    }
                    catch (Exception exception) {}
                    break block31;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (gStmt != null) {
                        gStmt.close();
                    }
                    if (pStmt != null) {
                        pStmt.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    pw.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (gStmt != null) {
                    gStmt.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                pw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("Done transferring.");
        pw.println("Done transferring.");
    }

    public void processMissingGenusSpecies() {
        PrintWriter pw;
        block25: {
            String pSQL = "UPDATE raw SET genus=?, species=?, subspecies=? WHERE id = ?";
            String where = " WHERE genus IS NULL AND species IS NULL AND scientific_name IS NOT NULL";
            String gbifSQLBase = "SELECT id, scientific_name FROM raw" + where;
            long totalRecs = BasicSQLUtils.getCount(this.srcDBConn, "SELECT COUNT(*) FROM raw " + where).intValue();
            long procRecs = 0L;
            long startTime = System.currentTimeMillis();
            int secsThreshold = 0;
            pw = null;
            double HRS = 3600000.0;
            Statement gStmt = null;
            Statement pStmt = null;
            try {
                try {
                    pw = new PrintWriter("gbif.log");
                    pStmt = this.dbConn.prepareStatement(pSQL);
                    System.out.println("Total Records: " + totalRecs);
                    pw.println("Total Records: " + totalRecs);
                    gStmt = this.srcDBConn.createStatement(1003, 1007);
                    gStmt.setFetchSize(Integer.MIN_VALUE);
                    System.out.println(gbifSQLBase);
                    ResultSet gRS = gStmt.executeQuery(gbifSQLBase);
                    block17: while (gRS.next()) {
                        int id = gRS.getInt(1);
                        pStmt.setObject(4, id);
                        String[] gs = StringUtils.split((String)gRS.getString(2), (char)' ');
                        switch (gs.length) {
                            case 1: {
                                pStmt.setString(1, gs[0]);
                                pStmt.setString(2, null);
                                pStmt.setString(3, null);
                                break;
                            }
                            case 2: {
                                pStmt.setString(1, gs[0]);
                                pStmt.setString(2, gs[1]);
                                pStmt.setString(3, null);
                                break;
                            }
                            case 3: {
                                pStmt.setString(1, gs[0]);
                                pStmt.setString(2, gs[1]);
                                pStmt.setString(3, gs[2]);
                                break;
                            }
                            default: {
                                continue block17;
                            }
                        }
                        try {
                            pStmt.executeUpdate();
                        }
                        catch (Exception ex) {
                            System.err.println("For ID[" + gRS.getObject(1) + "][" + gRS.getObject(2) + "]");
                            ex.printStackTrace();
                            pw.print("For ID[" + gRS.getObject(1) + "] " + ex.getMessage());
                            pw.flush();
                        }
                        if (++procRecs % 10000L != 0L) continue;
                        long endTime = System.currentTimeMillis();
                        long elapsedTime = endTime - startTime;
                        double avergeTime = (double)elapsedTime / (double)procRecs;
                        double hrsLeft = ((double)elapsedTime / (double)procRecs * (double)totalRecs - (double)procRecs) / 3600000.0;
                        int seconds = (int)((double)elapsedTime / 60000.0);
                        if (secsThreshold == seconds) continue;
                        secsThreshold = seconds;
                        String msg = String.format("Elapsed %8.2f hr.mn   Ave Time: %5.2f    Percent: %6.3f  Hours Left: %8.2f ", (double)elapsedTime / 3600000.0, avergeTime, 100.0 * ((double)procRecs / (double)totalRecs), hrsLeft);
                        System.out.println(msg);
                        pw.println(msg);
                        pw.flush();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        if (gStmt != null) {
                            gStmt.close();
                        }
                        if (pStmt != null) {
                            pStmt.close();
                        }
                        pw.close();
                    }
                    catch (Exception exception) {}
                    break block25;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (gStmt != null) {
                        gStmt.close();
                    }
                    if (pStmt != null) {
                        pStmt.close();
                    }
                    pw.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (gStmt != null) {
                    gStmt.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
                pw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("Done transferring.");
        pw.println("Done transferring.");
    }

    public void cleanup() {
        try {
            if (this.dbConn != null) {
                this.dbConn.close();
            }
            if (this.dbConn2 != null) {
                this.dbConn2.close();
            }
            if (this.srcDBConn != null) {
                this.srcDBConn.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Connection getDBConn() {
        return this.dbConn;
    }

    public Connection getSrcDBConn() {
        return this.srcDBConn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void index() {
        IndexWriter writer = null;
        try {
            try {
                this.analyzer = new StandardAnalyzer(Version.LUCENE_20);
                FileUtils.deleteDirectory((File)this.INDEX_DIR);
                System.out.println("Indexing to directory '" + this.INDEX_DIR + "'...");
                long totalRecs = BasicSQLUtils.getCount(this.srcDBConn, "SELECT COUNT(*) FROM raw").intValue();
                long procRecs = 0L;
                long startTime = System.currentTimeMillis();
                int secsThreshold = 0;
                PrintWriter pw = null;
                double HRS = 3600000.0;
                Statement stmt = null;
                try {
                    try {
                        writer = new IndexWriter((Directory)FSDirectory.open((File)this.INDEX_DIR), this.analyzer, true, IndexWriter.MaxFieldLength.LIMITED);
                        pw = new PrintWriter("gbif.log");
                        System.out.println("Total Records: " + totalRecs);
                        pw.println("Total Records: " + totalRecs);
                        stmt = this.srcDBConn.createStatement(1003, 1007);
                        stmt.setFetchSize(Integer.MIN_VALUE);
                        ResultSet rs = stmt.executeQuery("SELECT id, catalogue_number, genus, species, collector_num, collector_name, year, month, day, state_province, county FROM raw");
                        ResultSetMetaData rsmd = rs.getMetaData();
                        StringBuilder sb = new StringBuilder();
                        while (rs.next()) {
                            String id = rs.getString(1);
                            Document doc = new Document();
                            doc.add((Fieldable)new Field("id", id.toString(), Field.Store.YES, Field.Index.NO));
                            sb.setLength(0);
                            int i = 2;
                            while (i <= rsmd.getColumnCount()) {
                                String val = rs.getString(i);
                                if (StringUtils.isNotEmpty((String)val)) {
                                    sb.append(val);
                                    sb.append(' ');
                                }
                                ++i;
                            }
                            doc.add((Fieldable)new Field("contents", sb.toString(), Field.Store.NO, Field.Index.ANALYZED));
                            writer.addDocument(doc);
                            if (++procRecs % 10000L != 0L) continue;
                            long endTime = System.currentTimeMillis();
                            long elapsedTime = endTime - startTime;
                            double timePerRecord = elapsedTime / procRecs;
                            double hrsLeft = (double)(totalRecs - procRecs) * timePerRecord / 3600000.0;
                            int seconds = (int)((double)elapsedTime / 60000.0);
                            if (secsThreshold == seconds) continue;
                            secsThreshold = seconds;
                            String msg = String.format("Elapsed %8.2f hr.mn   Percent: %6.3f  Hours Left: %8.2f ", (double)elapsedTime / 3600000.0, 100.0 * ((double)procRecs / (double)totalRecs), hrsLeft);
                            System.out.println(msg);
                            pw.println(msg);
                            pw.flush();
                        }
                        return;
                    }
                    catch (SQLException sqlex) {
                        sqlex.printStackTrace();
                        if (stmt == null) return;
                        try {
                            stmt.close();
                            return;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.out.println("IOException adding Lucene Document: " + e.getMessage());
                        if (stmt == null) return;
                        try {
                            stmt.close();
                            return;
                        }
                        catch (SQLException e2) {
                            e2.printStackTrace();
                        }
                        return;
                    }
                }
                finally {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println(" caught a " + e.getClass() + "\n with message: " + e.getMessage());
                this.analyzer.close();
                this.analyzer = null;
                if (writer == null) return;
                try {
                    System.out.println("Optimizing...");
                    writer.optimize();
                    writer.close();
                    System.out.println("Done Optimizing.");
                }
                catch (CorruptIndexException e3) {
                    e3.printStackTrace();
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
                writer = null;
            }
            return;
        }
        finally {
            this.analyzer.close();
            this.analyzer = null;
            if (writer != null) {
                try {
                    System.out.println("Optimizing...");
                    writer.optimize();
                    writer.close();
                    System.out.println("Done Optimizing.");
                }
                catch (CorruptIndexException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                writer = null;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testSearch() {
        Statement stmt = null;
        String querystr = "Andrew AND Bentley AND Apogon AND angustatus";
        String term = "contents";
        try {
            try {
                stmt = this.srcDBConn.createStatement(1003, 1007);
                if (this.analyzer == null) {
                    this.analyzer = new StandardAnalyzer(Version.LUCENE_30);
                }
                this.reader = IndexReader.open((Directory)FSDirectory.open((File)this.INDEX_DIR), (boolean)true);
                long startTime = System.currentTimeMillis();
                Query q = new QueryParser(Version.LUCENE_30, term, this.analyzer).parse(querystr);
                int hitsPerPage = 10;
                this.searcher = new IndexSearcher(this.reader);
                TopScoreDocCollector collector = TopScoreDocCollector.create((int)hitsPerPage, (boolean)true);
                this.searcher.search(q, (Collector)collector);
                ScoreDoc[] hits = collector.topDocs().scoreDocs;
                System.out.println("Found " + hits.length + " hits.");
                int i = 0;
                while (i < hits.length) {
                    int docId = hits[i].doc;
                    Document d = this.searcher.doc(docId);
                    System.out.println(String.valueOf(i + 1) + ". " + d.get("id"));
                    String id = d.get("id");
                    ResultSet rs = stmt.executeQuery("SELECT id, catalogue_number, genus, species, collector_num, collector_name, year, month, day FROM raw WHERE id = " + id);
                    ResultSetMetaData rsmd = rs.getMetaData();
                    while (rs.next()) {
                        int j = 1;
                        while (j <= rsmd.getColumnCount()) {
                            System.out.print(rs.getObject(j) + "\t");
                            ++j;
                        }
                        System.out.println();
                    }
                    rs.close();
                    ++i;
                }
                System.out.println(String.format("Time: %8.2f", (double)(System.currentTimeMillis() - startTime) / 1000.0));
                this.searcher.close();
                this.reader.close();
                this.analyzer.close();
                return;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (stmt == null) return;
                try {
                    stmt.close();
                    return;
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (stmt == null) return;
                try {
                    stmt.close();
                    return;
                }
                catch (SQLException e3) {
                    e3.printStackTrace();
                }
                return;
            }
            catch (ParseException e) {
                e.printStackTrace();
                if (stmt == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    stmt.close();
                    return;
                }
                catch (SQLException e4) {
                    e4.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        CopyFromGBIFToPlants awg = new CopyFromGBIFToPlants();
        boolean doBuild = false;
        if (doBuild) {
            awg.createDBConnection("lm2gbdb.nhm.ku.edu", "3399", "gbc20100726", "rods", "specify4us");
            awg.createSrcDBConnection("localhost", "3306", "gbif", "root", "root");
            awg.process();
            awg.cleanup();
        } else {
            awg.createDBConnection("localhost", "3306", "plants", "root", "root");
            awg.createSrcDBConnection("localhost", "3306", "plants_ref", "root", "root");
            awg.processMissingGenusSpecies();
            awg.index();
            awg.cleanup();
        }
    }
}

