/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode.mexconabio;

import com.thoughtworks.xstream.XStream;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.ConversionLogger;
import edu.ku.brc.specify.conversion.TableWriter;
import edu.ku.brc.specify.toycode.mexconabio.AnalysisBase;
import edu.ku.brc.specify.toycode.mexconabio.CollStatInfo;
import edu.ku.brc.specify.toycode.mexconabio.CollStatSQLDefs;
import edu.ku.brc.util.Pair;
import java.awt.Color;
import java.awt.Paint;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class CollectionStats
extends AnalysisBase {
    private boolean loadInstsFromDB = false;
    private Vector<CollStatInfo> institutions = new Vector();
    private HashMap<Integer, CollStatInfo> instHashMap = new HashMap();
    private HashMap<TableWriter, CollStatInfo> tblInstHash = new HashMap();
    private TableWriter sortByTblWriter = null;
    private PreparedStatement pLMStmt = null;

    public CollectionStats() {
        this.convLogger = new IndexedConvLogger();
    }

    public void discoverInstCodesAndTotals() {
        System.out.println("Getting Institutions");
        String sql = "SELECT * FROM (SELECT data_provider_id, COUNT(*) AS cnt FROM raw GROUP BY data_provider_id) T1 WHERE cnt > 1 ORDER BY cnt DESC";
        for (Object[] row : BasicSQLUtils.query(this.dbSrcConn, sql)) {
            CollStatInfo csi = new CollStatInfo();
            csi.setProviderId((Integer)row[0]);
            csi.setTotalNumRecords(((Long)row[1]).intValue());
            if (StringUtils.isEmpty((String)csi.getInstName())) {
                csi.setInstName(this.getProviderNameFromInstCode(csi.getProviderId()));
            }
            this.instHashMap.put(csi.getProviderId(), csi);
            this.institutions.add(csi);
        }
        System.out.println("Done Getting Institutions");
    }

    public List<CollStatInfo> loadInstCodesAndtotals() {
        XStream xstream = new XStream();
        CollStatInfo.config(xstream);
        String xml = "";
        try {
            xml = FileUtils.readFileToString((File)new File(XMLHelper.getConfigDirPath("../src/edu/ku/brc/specify/toycode/mexconabio/collstatinfo.xml")), (String)"UTF8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        List list = (List)xstream.fromXML(xml);
        for (CollStatInfo csi : list) {
            this.instHashMap.put(csi.getProviderId(), csi);
            this.institutions.add(csi);
        }
        return list;
    }

    protected void createChart(CollStatInfo csi, Vector<Pair<String, Integer>> list, String xTitle, String yTitle) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Pair<String, Integer> p : list) {
            dataset.addValue((Number)p.second, (Comparable)p.first, (Comparable)((Object)""));
        }
        JFreeChart chart = ChartFactory.createBarChart((String)csi.getTitle(), (String)xTitle, (String)yTitle, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)new Color(228, 243, 255));
        try {
            Integer hashCode = csi.hashCode();
            csi.setChartFileName(hashCode + ".png");
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(new File("reports/charts/" + csi.getChartFileName())));
            ChartUtilities.writeChartAsPNG((OutputStream)dos, (JFreeChart)chart, (int)700, (int)600);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected boolean generateChart(CollStatInfo csi, HashMap<CollStatSQLDefs.StatType, CollStatSQLDefs> statTypeHash) {
        System.out.println(csi.getTitle());
        int total = csi.getValue(CollStatSQLDefs.StatType.eTotalNumRecords);
        Vector<Pair<String, Integer>> pairs = new Vector<Pair<String, Integer>>();
        double totalPercent = 0.0;
        int cnt = 0;
        int goodCnt = 0;
        CollStatSQLDefs.StatType[] statTypeArray = CollStatSQLDefs.StatType.values();
        int n = statTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CollStatSQLDefs.StatType type = statTypeArray[n2];
            if (type != CollStatSQLDefs.StatType.eTotalNumRecords) {
                CollStatSQLDefs csqd = statTypeHash.get((Object)type);
                double dVal = csi.getValue(type);
                int val = (int)(dVal / (double)total * 100.0);
                if (val > 0) {
                    ++goodCnt;
                }
                pairs.add(new Pair<String, Integer>(csqd.getName(), val));
                if (type.ordinal() < CollStatSQLDefs.StatType.eHasYearOnly.ordinal()) {
                    totalPercent += (double)val;
                    ++cnt;
                }
            }
            ++n2;
        }
        totalPercent = Math.max(totalPercent, 0.0);
        pairs.add(new Pair<String, Integer>("Average", (int)totalPercent / cnt));
        if (goodCnt > 0) {
            this.createChart(csi, pairs, "Statistic", "Percent");
            return true;
        }
        return false;
    }

    public void createCharts() {
        this.loadInstCodesAndtotals();
        List<CollStatSQLDefs> statTypes = this.getStatSQL();
        HashMap<CollStatSQLDefs.StatType, CollStatSQLDefs> statTypeHash = new HashMap<CollStatSQLDefs.StatType, CollStatSQLDefs>();
        for (CollStatSQLDefs cs : statTypes) {
            statTypeHash.put(cs.getType(), cs);
        }
        CollStatInfo totals = new CollStatInfo(" Totals");
        for (CollStatInfo csi : this.institutions) {
            for (CollStatSQLDefs csqd : statTypes) {
                CollStatSQLDefs.StatType type = csqd.getType();
                int totVal = totals.getValue(type) + csi.getValue(type);
                totals.setValue(type, totVal);
            }
        }
        try {
            FileUtils.deleteDirectory((File)new File("reports/charts/"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Collections.sort(this.institutions, new Comparator<CollStatInfo>(){

            @Override
            public int compare(CollStatInfo o1, CollStatInfo o2) {
                return o1.getInstName().compareToIgnoreCase(o2.getInstName());
            }
        });
        this.institutions.insertElementAt(totals, 0);
        CollStatInfo clsi = totals;
        int i = 0;
        for (CollStatInfo csi : this.institutions) {
            if (StringUtils.isEmpty((String)csi.getInstName())) {
                csi.setInstName(this.getProviderNameFromInstCode(csi.getProviderId()));
            }
            String title = String.valueOf(csi.getTitle()) + " - " + csi.getTotalNumRecords();
            if (i == 0) {
                this.startLogging("reports", "charts", String.valueOf(clsi.hashCode()) + ".html", title, false);
                this.tblWriter.startTable();
                this.tblInstHash.put(this.tblWriter, csi);
            } else {
                this.tblWriter.endTable();
                this.startNewDocument(String.valueOf(csi.hashCode()) + ".html", title, false);
                this.tblInstHash.put(this.tblWriter, csi);
                this.tblWriter.startTable();
            }
            if (this.generateChart(csi, statTypeHash)) {
                int total = csi.getValue(CollStatSQLDefs.StatType.eTotalNumRecords);
                this.tblWriter.setHasLines();
                this.tblWriter.print("<TR><TD>");
                this.tblWriter.print(String.format("<img src=\"%s\">", csi.getChartFileName()));
                this.tblWriter.println("<BR><BR><BR><BR></TD><TD>");
                this.tblWriter.startTable();
                this.tblWriter.logHdr("Stat", "Percent");
                int rowCnt = 0;
                int cnt = 0;
                double totalPercent = 0.0;
                CollStatSQLDefs.StatType[] statTypeArray = CollStatSQLDefs.StatType.values();
                int n = statTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CollStatSQLDefs.StatType type = statTypeArray[n2];
                    if (type != CollStatSQLDefs.StatType.eTotalNumRecords) {
                        CollStatSQLDefs csqd = statTypeHash.get((Object)type);
                        double dVal = csi.getValue(type);
                        double val = dVal / (double)total * 100.0;
                        if (type.ordinal() < CollStatSQLDefs.StatType.eHasYearOnly.ordinal()) {
                            this.tblWriter.print(String.format("<TR class=\"%s\">", rowCnt % 2 == 0 ? "od" : "ev"));
                            totalPercent += val;
                            ++cnt;
                        } else {
                            this.tblWriter.print(String.format("<TR>", csqd.getName()));
                        }
                        this.tblWriter.println(String.format("<TD>%s</TD><TD style=\"text-align:right\">%6.2f</TD></TR>", csqd.getName(), val));
                        ++rowCnt;
                    }
                    ++n2;
                }
                totalPercent = Math.max(totalPercent, 0.0);
                double avePercent = totalPercent / (double)cnt;
                this.tblWriter.println(String.format("<TR><TD>Average</TD><TD style=\"text-align:right\">%6.2f</TD></TR>", avePercent));
                csi.setAveragePercent(avePercent);
                this.tblWriter.endTable();
                this.tblWriter.println("</TD></TR>");
            }
            ++i;
        }
        this.tblWriter.endTable();
        Vector<CollStatInfo> sortedByAvesList = new Vector<CollStatInfo>(this.institutions);
        Collections.sort(sortedByAvesList, new Comparator<CollStatInfo>(){

            @Override
            public int compare(CollStatInfo o1, CollStatInfo o2) {
                Double i1 = o1.getAveragePercent();
                Double i2 = o2.getAveragePercent();
                int rv = i2.compareTo(i1);
                if (rv == 0) {
                    Integer cnt1 = o1.getTotalNumRecords();
                    Integer cnt2 = o2.getTotalNumRecords();
                    return cnt2.compareTo(cnt1);
                }
                return rv;
            }
        });
        Integer rank = 0;
        String average = "";
        this.startNewDocument("SortedByAverages.html", " Sorted By Averages", false);
        this.sortByTblWriter = this.tblWriter;
        this.tblWriter.startTable();
        this.tblWriter.logHdr("Rank", "Institution", "Num of Records", "Percentage");
        for (CollStatInfo csi : sortedByAvesList) {
            String aveStr = String.format("%8.2f", csi.getAveragePercent());
            Integer cnt = csi.getTotalNumRecords();
            if (!aveStr.equals(average)) {
                rank = rank + 1;
                average = aveStr;
            }
            String fileName = StringUtils.replace((String)csi.getChartFileName(), (String)"png", (String)"html");
            String link = String.format("<a href=\"%s\">%s</>", fileName, csi.getTitle());
            this.tblWriter.log(rank.toString(), link, cnt.toString(), aveStr);
        }
        this.tblWriter.endTable();
        this.endLogging(true);
    }

    @Override
    public void process(int type, int options) {
        if (this.loadInstsFromDB) {
            this.discoverInstCodesAndTotals();
        } else {
            this.loadInstCodesAndtotals();
        }
        for (CollStatSQLDefs csqd : this.getStatSQL()) {
            if (csqd.getType() == CollStatSQLDefs.StatType.eTotalNumRecords) continue;
            System.out.println(csqd.getType().toString());
            for (Object[] row : BasicSQLUtils.query(this.dbSrcConn, csqd.getSQL())) {
                Integer providerId = (Integer)row[0];
                Long count = (Long)row[1];
                CollStatInfo csi = this.instHashMap.get(providerId);
                if (csi != null) {
                    csi.setValue(csqd.getType(), count.intValue());
                    continue;
                }
                System.err.println("Couldn't find institution[" + providerId + "]");
            }
        }
        for (CollStatInfo csi : this.institutions) {
            System.out.println("\n-------------------" + csi.getTitle() + "-------------------");
            for (CollStatSQLDefs csqd : this.getStatSQL()) {
                System.out.println(String.format("%15s %10d", csqd.getType().toString(), csi.getValue(csqd.getType())));
            }
        }
        this.saveInstitutions();
    }

    private void saveInstitutions() {
        XStream xstream = new XStream();
        CollStatInfo.config(xstream);
        File file = new File(XMLHelper.getConfigDirPath("../src/edu/ku/brc/specify/toycode/mexconabio/collstatinfo.xml"));
        System.out.println(file.getAbsolutePath());
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
            xstream.toXML(this.institutions, (Writer)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<CollStatSQLDefs> getStatSQL() {
        XStream xstream = new XStream();
        CollStatSQLDefs.config(xstream);
        String xml = "";
        try {
            xml = FileUtils.readFileToString((File)new File(XMLHelper.getConfigDirPath("../src/edu/ku/brc/specify/toycode/mexconabio/collstatsqldefs.xml")), (String)"UTF8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (List)xstream.fromXML(xml);
    }

    private String getProviderNameFromInstCode(int providerId) {
        if (this.dbLMConn != null) {
            if (this.pLMStmt == null) {
                String sql = "SELECT name FROM data_provider WHERE id = ?";
                try {
                    this.pLMStmt = this.dbLMConn.prepareStatement(sql);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            try {
                this.pLMStmt.setInt(1, providerId);
                ResultSet rs = this.pLMStmt.executeQuery();
                if (rs.next()) {
                    return rs.getString(1);
                }
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return "N/A";
    }

    @Override
    public void cleanup() {
        if (this.pLMStmt != null) {
            try {
                this.pLMStmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        super.cleanup();
    }

    public static void main(String[] args) {
        CollectionStats cs = new CollectionStats();
        cs.createLMDBConnection("lm2gbdb.nhm.ku.edu", "3399", "gbc20100726", "rods", "specify4us");
        cs.createSrcDBConnection("localhost", "3306", "plants", "root", "root");
        cs.createCharts();
        cs.cleanup();
    }

    class IndexedConvLogger
    extends ConversionLogger {
        @Override
        protected void writeIndex(TableWriter indexWriter, Vector<TableWriter> orderList) {
            orderList.remove(CollectionStats.this.sortByTblWriter);
            orderList.insertElementAt(CollectionStats.this.sortByTblWriter, 1);
            HashSet<String> alphaSet = new HashSet<String>();
            for (TableWriter tblWr : orderList) {
                String titleLetter = tblWr.getTitle().substring(0, 1).toUpperCase().trim();
                if (titleLetter.isEmpty()) continue;
                alphaSet.add(titleLetter);
            }
            Vector alphaList = new Vector(alphaSet);
            Collections.sort(alphaList);
            int i = 0;
            for (String alpha : alphaList) {
                if (StringUtils.isAlphanumeric((String)alpha)) {
                    if (i > 0) {
                        indexWriter.append(", ");
                    }
                    indexWriter.print("<a href=\"#" + alpha + "\">" + alpha + "</a>");
                }
                ++i;
            }
            indexWriter.println("<BR><BR>");
            String alphaAnchor = "";
            indexWriter.startTable();
            for (TableWriter tblWr : orderList) {
                System.out.println(tblWr.getTitle());
                String alpha = tblWr.getTitle().substring(0, 1).toUpperCase();
                if (!alpha.equals(" ") && !alpha.equals(alphaAnchor)) {
                    indexWriter.print("<a name=\"" + alpha + "\"></a><H3>" + alpha + "</H3>");
                    alphaAnchor = alpha;
                }
                try {
                    String title = tblWr == CollectionStats.this.sortByTblWriter ? "Rankings" : ((CollStatInfo)CollectionStats.this.tblInstHash.get(tblWr)).getTitle();
                    indexWriter.log("<A href=\"" + FilenameUtils.getName((String)tblWr.getFileName()) + "\">" + title + "</A>");
                    tblWr.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            indexWriter.endTable();
        }
    }
}

