/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode.mexconabio;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.toycode.mexconabio.AnalysisBase;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;

public class AnalysisWithSNIB
extends AnalysisBase {
    @Override
    public void process(int type, int options) {
        PrintWriter pw;
        block29: {
            this.calcMaxScore();
            String fromClause1 = "FROM angiospermas WHERE CollectorNumber = ? AND `Year` = ? AND Genus = ?";
            String fromClause2 = "FROM angiospermas WHERE CollectorNumber IS NULL AND `Year` = ? AND `Month` = ? AND Genus = ?";
            String michSQLFromClause = "FROM conabio ORDER BY CollNr";
            String gbifsnibInsert = "INSERT INTO snibmex (reltype, score, GBIFID, SNIBID) VALUES (?,?,?,?)";
            Statement stmt = null;
            Statement gStmt1 = null;
            Statement gStmt2 = null;
            PreparedStatement gsStmt = null;
            Object[] refRow = new Object[16];
            Object[] cmpRow = new Object[16];
            int SKIP_FIRST_NUM = -1;
            long totalRecs = BasicSQLUtils.getCount(this.dbSrcConn, "SELECT COUNT(*) FROM conabio").intValue();
            long procRecs = 0L;
            long startTime = System.currentTimeMillis();
            int secsThreshold = 0;
            pw = null;
            try {
                try {
                    pw = new PrintWriter("scoring_snib.log");
                    gStmt1 = this.dbGBIFConn.prepareStatement("SELECT IdSNIB, CatalogNumber, Genus, Species, Cataegoryinfraspecies, Latitude, Longitude, Country, LastNameFather, LastNameMother, FirstName, State, Locality, `Year`, `Month`, `Day`, CollectorNumber, InstitutionAcronym " + fromClause1);
                    gStmt2 = this.dbGBIFConn.prepareStatement("SELECT IdSNIB, CatalogNumber, Genus, Species, Cataegoryinfraspecies, Latitude, Longitude, Country, LastNameFather, LastNameMother, FirstName, State, Locality, `Year`, `Month`, `Day`, CollectorNumber, InstitutionAcronym " + fromClause2);
                    gsStmt = this.dbDstConn.prepareStatement(gbifsnibInsert);
                    stmt = this.dbSrcConn.createStatement(1004, 1007);
                    stmt.setFetchSize(Integer.MIN_VALUE);
                    this.thresholdScore = 0;
                    System.out.println("Starting Query... " + totalRecs);
                    pw.println("Starting Query... " + totalRecs);
                    HashSet<Integer> allMichIdsHash = new HashSet<Integer>();
                    ResultSet rsTmp = stmt.executeQuery("SELECT ID FROM conabio");
                    while (rsTmp.next()) {
                        if (procRecs < (long)SKIP_FIRST_NUM) {
                            ++procRecs;
                            continue;
                        }
                        allMichIdsHash.add(rsTmp.getInt(1));
                        ++procRecs;
                    }
                    rsTmp.close();
                    String msg = "Total Count Ids " + procRecs + " / " + allMichIdsHash.size();
                    System.out.println(msg);
                    pw.println(msg);
                    HashSet<Integer> idHash = new HashSet<Integer>();
                    int writeCnt = 0;
                    ResultSet rs = stmt.executeQuery("SELECT BarCD, CollNr, Collectoragent1, GenusName, SpeciesName, SubSpeciesName, LocalityName, Datecollstandrd, COUNTRY, STATE, ID " + michSQLFromClause);
                    System.out.println(String.format("Starting Processing... Total Records %d  Max Score: %d  Threshold: %d", totalRecs, this.maxScore, this.thresholdScore));
                    pw.println(String.format("Starting Processing... Total Records %d  Max Score: %d  Threshold: %d", totalRecs, this.maxScore, this.thresholdScore));
                    procRecs = 0L;
                    while (rs.next()) {
                        ResultSet gRS;
                        if (procRecs < (long)SKIP_FIRST_NUM) {
                            ++procRecs;
                            continue;
                        }
                        this.fillMichRow(refRow, rs);
                        int michId = rs.getInt(11);
                        boolean isRemoved = false;
                        gStmt1.setString(1, (String)refRow[0]);
                        gStmt1.setString(2, (String)refRow[9]);
                        gStmt1.setString(3, (String)refRow[2]);
                        idHash.clear();
                        if (refRow[0] != null) {
                            gRS = gStmt1.executeQuery();
                            while (gRS.next()) {
                                this.fillSNIBRow(cmpRow, gRS);
                                int score = this.score(refRow, cmpRow);
                                if (score <= this.thresholdScore) continue;
                                ++writeCnt;
                                int gbifID = gRS.getInt(1);
                                gsStmt.setInt(1, 1);
                                gsStmt.setInt(2, score);
                                gsStmt.setInt(3, gbifID);
                                gsStmt.setInt(4, michId);
                                gsStmt.executeUpdate();
                                idHash.add(gbifID);
                                if (isRemoved) continue;
                                allMichIdsHash.remove(michId);
                                isRemoved = true;
                            }
                            gRS.close();
                        }
                        gStmt2.setString(1, (String)refRow[9]);
                        gStmt2.setString(2, (String)refRow[10]);
                        gStmt2.setString(3, (String)refRow[2]);
                        gRS = gStmt2.executeQuery();
                        while (gRS.next()) {
                            int gbifID = gRS.getInt(1);
                            if (idHash.contains(gbifID)) continue;
                            this.fillSNIBRow(cmpRow, gRS);
                            int score = this.score(refRow, cmpRow);
                            if (score <= this.thresholdScore) continue;
                            ++writeCnt;
                            gsStmt.setInt(1, 2);
                            gsStmt.setInt(2, score);
                            gsStmt.setInt(3, gbifID);
                            gsStmt.setInt(4, michId);
                            gsStmt.executeUpdate();
                            if (isRemoved) continue;
                            allMichIdsHash.remove(michId);
                            isRemoved = true;
                        }
                        gRS.close();
                        if (++procRecs % 500L != 0L) continue;
                        long endTime = System.currentTimeMillis();
                        long elapsedTime = endTime - startTime;
                        double timePerRecord = elapsedTime / procRecs;
                        double hrsLeft = (double)(totalRecs - procRecs) * timePerRecord / 3600000.0;
                        int seconds = (int)((double)elapsedTime / 60000.0);
                        if (secsThreshold == seconds) continue;
                        secsThreshold = seconds;
                        msg = String.format("Elapsed %8.2f hr.mn   Percent: %6.3f  Hours Left: %8.2f ", (double)elapsedTime / 3600000.0, 100.0 * ((double)procRecs / (double)totalRecs), hrsLeft);
                        System.out.println(msg);
                        pw.println(msg);
                        pw.flush();
                    }
                    rs.close();
                    int reportRecsSize = 1000;
                    String dataDirName = "michsnib";
                    String title = String.format("%s %d - %d", dataDirName, 0, reportRecsSize);
                    String fileName = String.format("%s_%d_%d.html", dataDirName, 0, reportRecsSize);
                    this.startLogging("analysis", dataDirName, fileName, title, true, 100);
                    int cnt = 0;
                    PreparedStatement ps = this.dbSrcConn.prepareStatement("SELECT BarCD, CollNr, Collectoragent1, GenusName, SpeciesName, SubSpeciesName, LocalityName, Datecollstandrd, COUNTRY, STATE, ID  FROM conabio WHERE ID = ?");
                    for (Integer id : allMichIdsHash) {
                        ++cnt;
                        ps.setInt(1, id);
                        rs = ps.executeQuery();
                        while (rs.next()) {
                            this.fillMichRow(refRow, rs);
                            this.writeRow(cnt % 2 == 0 ? "ev" : "od", refRow, null);
                        }
                        rs.close();
                        if (cnt % reportRecsSize != 0) continue;
                        title = String.format("%s %d - %d", dataDirName, cnt, cnt + reportRecsSize);
                        fileName = String.format("%s_%d_%d.html", dataDirName, cnt, cnt + reportRecsSize);
                        this.startNewDocument(fileName, title, true, 100);
                    }
                    this.tblWriter.endTable();
                    this.tblWriter.close();
                    msg = "Final Count Ids " + procRecs + " / " + allMichIdsHash.size();
                    System.out.println(msg);
                    pw.println(msg);
                    System.out.println("Done.");
                    pw.println("Done.");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (gStmt1 != null) {
                            gStmt1.close();
                        }
                        if (gStmt2 != null) {
                            gStmt2.close();
                        }
                        break block29;
                    }
                    catch (Exception exception) {}
                    break block29;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (gStmt1 != null) {
                        gStmt1.close();
                    }
                    if (gStmt2 != null) {
                        gStmt2.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (gStmt1 != null) {
                    gStmt1.close();
                }
                if (gStmt2 != null) {
                    gStmt2.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("Done.");
        pw.println("Done.");
        pw.flush();
        pw.close();
    }

    public static void main(String[] args) {
        AnalysisWithSNIB awg = new AnalysisWithSNIB();
        awg.createDBConnection("localhost", "3306", "plants", "root", "root");
        awg.createSrcDBConnection("localhost", "3306", "plants", "root", "root");
        awg.createDestDBConnection("localhost", "3306", "plants", "root", "root");
        awg.process(1, 32383);
        awg.endLogging();
        awg.cleanup();
    }
}

